/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JSCommentMatchesSignatureInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSCommentMatchesSignatureInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSCommentMatchesSignatureInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            public void visitJSDocComment(@NotNull JSDocComment docComment) {
                JSFunction function;
                if (docComment == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((function = JSDocumentationUtils.findFunctionAppliedTo((JSDocComment)docComment)) != null) {
                    UpdateFunctionCommentQuickFix fix = null;
                    JSDocumentationUtils.JSDocParametersMappingToFunctionInfo info = JSDocumentationUtils.checkDocCommentMatchesFunctionSignature((JSDocComment)docComment, (JSFunction)function);
                    if (info != null && info.hasParamTag()) {
                        JSParameter[] parameters2;
                        List paramsToAdd = info.getParamsToAdd();
                        Map paramsToRemove = info.getParamsToRemove();
                        HashSet<Integer> paramsIndicesToRemove = new HashSet<Integer>(paramsToRemove.size());
                        fix = new UpdateFunctionCommentQuickFix(paramsIndicesToRemove, paramsToAdd);
                        JSDocTag[] tags = paramsToRemove.isEmpty() ? JSDocTag.EMPTY_ARRAY : docComment.getTags();
                        for (Map.Entry entry : paramsToRemove.entrySet()) {
                            JSDocTagType elementToHighlight;
                            int a = (Integer)entry.getKey();
                            String b = (String)entry.getValue();
                            paramsIndicesToRemove.add(a);
                            JSDocTag tag = tags[a];
                            JSDocTagType type2 = tag.getType();
                            Object object = elementToHighlight = type2 != null ? type2 : tag;
                            if (b != null) continue;
                            String message = JavaScriptBundle.message((String)"js.comment.matches.signature.inspection.problem2", (Object[])new Object[]{"without name"});
                            holder.registerProblem((PsiElement)elementToHighlight, message, new LocalQuickFix[]{fix});
                        }
                        JSParameter[] jSParameterArray = parameters2 = paramsToAdd.isEmpty() ? null : function.getParameterVariables();
                        if (parameters2 != null) {
                            HashMap<String, Integer> parameterIndexes = new HashMap<String, Integer>(parameters2.length);
                            for (int i = 0; i < parameters2.length; ++i) {
                                parameterIndexes.put(parameters2[i].getName(), i);
                            }
                            for (Pair entry : paramsToAdd) {
                                holder.registerProblem((PsiElement)parameters2[(Integer)parameterIndexes.get(entry.getSecond())], JavaScriptBundle.message((String)"js.comment.matches.signature.inspection.problem1", (Object[])new Object[]{entry.getSecond()}), new LocalQuickFix[]{fix});
                            }
                        }
                    }
                    for (JSDocTag tag : docComment.getTags()) {
                        JSDocTagNamepath namepath = tag.getNamepath();
                        if (namepath == null) continue;
                        for (PsiReference ref2 : namepath.getReferences()) {
                            if (!(ref2 instanceof JSDocParamReference) || !XmlHighlightVisitor.hasBadResolve((PsiReference)ref2, (boolean)false)) continue;
                            holder.registerProblem(ref2.getElement(), ref2.getRangeInElement(), ProblemsHolder.unresolvedReferenceMessage((PsiReference)ref2), LocalQuickFix.notNullElements((LocalQuickFix)fix));
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docComment", "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection$1", "visitJSDocComment"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UpdateFunctionCommentQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final Set<Integer> myParamsToRemove;
        private final List<Pair<Integer, String>> myParamsToAdd;

        UpdateFunctionCommentQuickFix(Set<Integer> paramsToRemove, List<Pair<Integer, String>> paramsToAdd) {
            this.myParamsToRemove = paramsToRemove;
            this.myParamsToAdd = paramsToAdd;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"js.comment.matches.signature.inspection.quickfix", (Object[])new Object[0]);
            if (string == null) {
                UpdateFunctionCommentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element2, @NotNull ModPsiUpdater updater) {
            JSFunction function;
            if (project == null) {
                UpdateFunctionCommentQuickFix.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                UpdateFunctionCommentQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                UpdateFunctionCommentQuickFix.$$$reportNull$$$0(3);
            }
            if (element2 instanceof JSParameter) {
                JSParameter parameter = (JSParameter)element2;
                function = parameter.getDeclaringFunction();
            } else {
                JSDocComment docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)element2, JSDocComment.class);
                JSFunction jSFunction = function = docComment != null ? JSDocumentationUtils.findFunctionAppliedTo((JSDocComment)docComment) : null;
            }
            if (function == null) {
                return;
            }
            ArrayList<Pair> tagsToAdd = new ArrayList<Pair>(this.myParamsToAdd.size());
            for (Pair<Integer, String> pair : this.myParamsToAdd) {
                tagsToAdd.add(Pair.create((Object)((Integer)pair.first), (Object)("param " + (String)pair.second)));
            }
            JSDocumentationUtils.createOrUpdateTagsWithInsertionIndexes((PsiElement)function, tagsToAdd, null, this.myParamsToRemove);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection$UpdateFunctionCommentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSCommentMatchesSignatureInspection$UpdateFunctionCommentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

