/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator;

import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.extractMethod.FunctionDeclarationType;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionSignatureGenerator {
    public StringBuilder getSignature(@NotNull JSFunctionSignatureInfo info, PsiElement context2) {
        if (info == null) {
            JSFunctionSignatureGenerator.$$$reportNull$$$0(0);
        }
        StringBuilder result2 = new StringBuilder();
        this.appendFunctionNameWithModifiers(info, result2, context2);
        this.appendFunctionParameters(info, result2);
        this.appendFunctionEnding(info, result2);
        return result2;
    }

    protected void appendFunctionNameWithModifiers(JSFunctionSignatureInfo info, StringBuilder result2, PsiElement context2) {
        FunctionDeclarationType declarationType = info.getDeclarationType();
        if (declarationType == FunctionDeclarationType.ARROW_FUNCTION) {
            JSFunctionSignatureGenerator.appendFunctionExpression(context2, info, result2);
        } else {
            if (info.isStatic()) {
                result2.append("static ");
            }
            if (info.isAsync()) {
                result2.append("async ");
            }
            if (info.getScope() != JSFunctionSignatureInfo.Scope.CLASS && info.getScope() != JSFunctionSignatureInfo.Scope.JS_OBJECT) {
                result2.append("function ");
            }
            if (info.isGetter()) {
                result2.append("get ");
            } else if (info.isSetter()) {
                result2.append("set ");
            }
            if (info.isGenerator()) {
                result2.append("*");
            }
            result2.append(info.getFunctionName());
        }
    }

    protected static void appendFunctionExpression(@Nullable PsiElement context2, JSFunctionSignatureInfo info, StringBuilder result2) {
        boolean isClassScope;
        boolean isObjectScope = info.getScope() == JSFunctionSignatureInfo.Scope.JS_OBJECT;
        boolean bl = isClassScope = info.getScope() == JSFunctionSignatureInfo.Scope.CLASS;
        if (!isObjectScope && !isClassScope) {
            result2.append(JSChangeUtil.getConstantPrefix((PsiElement)context2));
            result2.append(" ");
        }
        if (info.isStatic()) {
            result2.append("static ");
        }
        result2.append(info.getFunctionName()).append(isObjectScope ? ":" : " = ");
        if (info.isAsync()) {
            result2.append("async ");
        }
        if (info.isGenerator()) {
            result2.append("*");
        }
    }

    protected void appendFunctionParameters(JSFunctionSignatureInfo info, StringBuilder result2) {
        result2.append("(");
        result2.append(StringUtil.join(info.getParameters(), couple -> this.getFunctionParameter((Couple<String>)couple), (String)","));
        result2.append(")");
    }

    @NotNull
    protected String getFunctionParameter(Couple<String> parameterWithType) {
        String string = (String)parameterWithType.first;
        if (string == null) {
            JSFunctionSignatureGenerator.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void appendFunctionEnding(JSFunctionSignatureInfo info, StringBuilder result2) {
        if (info.getDeclarationType() == FunctionDeclarationType.ARROW_FUNCTION) {
            result2.append(" => ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

