/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ShortArrays;
import org.assertj.core.util.CheckReturnValue;

public abstract class AbstractShortArrayAssert<SELF extends AbstractShortArrayAssert<SELF>>
extends AbstractArrayAssert<SELF, short[], Short> {
    private ShortArrays arrays = ShortArrays.instance();

    protected AbstractShortArrayAssert(short[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (short[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (short[])this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (short[])this.actual);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (short[])this.actual, expected);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThan(int boundary) {
        this.arrays.assertHasSizeGreaterThan(this.info, (short[])this.actual, boundary);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(this.info, (short[])this.actual, boundary);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThan(int boundary) {
        this.arrays.assertHasSizeLessThan(this.info, (short[])this.actual, boundary);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(this.info, (short[])this.actual, boundary);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeBetween(int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(this.info, (short[])this.actual, lowerBoundary, higherBoundary);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (short[])this.actual, other);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF contains(short ... values) {
        this.arrays.assertContains(this.info, (short[])this.actual, values);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF contains(Short[] values) {
        AbstractShortArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContains(this.info, (short[])this.actual, AbstractShortArrayAssert.toPrimitiveShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF contains(int ... values) {
        this.arrays.assertContains(this.info, (short[])this.actual, AbstractShortArrayAssert.toShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsOnly(short ... values) {
        this.arrays.assertContainsOnly(this.info, (short[])this.actual, values);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsOnly(Short[] values) {
        AbstractShortArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsOnly(this.info, (short[])this.actual, AbstractShortArrayAssert.toPrimitiveShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsOnly(int ... values) {
        this.arrays.assertContainsOnly(this.info, (short[])this.actual, AbstractShortArrayAssert.toShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(short ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (short[])this.actual, values);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(Short[] values) {
        AbstractShortArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsOnlyOnce(this.info, (short[])this.actual, AbstractShortArrayAssert.toPrimitiveShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(int ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (short[])this.actual, AbstractShortArrayAssert.toShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsSequence(short ... sequence) {
        this.arrays.assertContainsSequence(this.info, (short[])this.actual, sequence);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsSequence(Short[] sequence) {
        AbstractShortArrayAssert.requireNonNullParameter(sequence, "sequence");
        this.arrays.assertContainsSequence(this.info, (short[])this.actual, AbstractShortArrayAssert.toPrimitiveShortArray(sequence));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsSequence(int ... sequence) {
        this.arrays.assertContainsSequence(this.info, (short[])this.actual, AbstractShortArrayAssert.toShortArray(sequence));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsSubsequence(short ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (short[])this.actual, subsequence);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsSubsequence(Short[] subsequence) {
        AbstractShortArrayAssert.requireNonNullParameter(subsequence, "subsequence");
        this.arrays.assertContainsSubsequence(this.info, (short[])this.actual, AbstractShortArrayAssert.toPrimitiveShortArray(subsequence));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsSubsequence(int ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (short[])this.actual, AbstractShortArrayAssert.toShortArray(subsequence));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF contains(short value, Index index) {
        this.arrays.assertContains(this.info, (short[])this.actual, value, index);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF contains(int value, Index index) {
        this.arrays.assertContains(this.info, (short[])this.actual, AbstractShortArrayAssert.toShort(value), index);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF doesNotContain(short ... values) {
        this.arrays.assertDoesNotContain(this.info, (short[])this.actual, values);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF doesNotContain(Short[] values) {
        AbstractShortArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertDoesNotContain(this.info, (short[])this.actual, AbstractShortArrayAssert.toPrimitiveShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF doesNotContain(int ... values) {
        this.arrays.assertDoesNotContain(this.info, (short[])this.actual, AbstractShortArrayAssert.toShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF doesNotContain(short value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (short[])this.actual, value, index);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF doesNotContain(int value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (short[])this.actual, AbstractShortArrayAssert.toShort(value), index);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (short[])this.actual);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF startsWith(short ... sequence) {
        this.arrays.assertStartsWith(this.info, (short[])this.actual, sequence);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF startsWith(Short[] sequence) {
        AbstractShortArrayAssert.requireNonNullParameter(sequence, "sequence");
        this.arrays.assertStartsWith(this.info, (short[])this.actual, AbstractShortArrayAssert.toPrimitiveShortArray(sequence));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF startsWith(int ... sequence) {
        this.arrays.assertStartsWith(this.info, (short[])this.actual, AbstractShortArrayAssert.toShortArray(sequence));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF endsWith(short ... sequence) {
        this.arrays.assertEndsWith(this.info, (short[])this.actual, sequence);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF endsWith(Short[] sequence) {
        AbstractShortArrayAssert.requireNonNullParameter(sequence, "sequence");
        this.arrays.assertEndsWith(this.info, (short[])this.actual, AbstractShortArrayAssert.toPrimitiveShortArray(sequence));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF endsWith(int ... sequence) {
        this.arrays.assertEndsWith(this.info, (short[])this.actual, AbstractShortArrayAssert.toShortArray(sequence));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public SELF isSorted() {
        this.arrays.assertIsSorted(this.info, (short[])this.actual);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    public SELF isSortedAccordingTo(Comparator<? super Short> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (short[])this.actual, comparator);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super Short> customComparator) {
        this.arrays = new ShortArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.arrays = ShortArrays.instance();
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsExactly(short ... values) {
        this.arrays.assertContainsExactly(this.info, (short[])this.actual, values);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsExactly(Short[] values) {
        AbstractShortArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsExactly(this.info, (short[])this.actual, AbstractShortArrayAssert.toPrimitiveShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsExactly(int ... values) {
        this.arrays.assertContainsExactly(this.info, (short[])this.actual, AbstractShortArrayAssert.toShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(short ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (short[])this.actual, values);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(Short[] values) {
        AbstractShortArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (short[])this.actual, AbstractShortArrayAssert.toPrimitiveShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(int ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (short[])this.actual, AbstractShortArrayAssert.toShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsAnyOf(short ... values) {
        this.arrays.assertContainsAnyOf(this.info, (short[])this.actual, values);
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsAnyOf(Short[] values) {
        AbstractShortArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsAnyOf(this.info, (short[])this.actual, AbstractShortArrayAssert.toPrimitiveShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    public SELF containsAnyOf(int ... values) {
        this.arrays.assertContainsAnyOf(this.info, (short[])this.actual, AbstractShortArrayAssert.toShortArray(values));
        return (SELF)((AbstractShortArrayAssert)this.myself);
    }

    private static short[] toShortArray(int[] ints) {
        if (ints == null) {
            return null;
        }
        short[] shorts = new short[ints.length];
        for (int i = 0; i < shorts.length; ++i) {
            shorts[i] = AbstractShortArrayAssert.toShort(ints[i]);
        }
        return shorts;
    }

    private static short toShort(int value) {
        return (short)value;
    }

    private static short[] toPrimitiveShortArray(Short[] values) {
        short[] shorts = new short[values.length];
        IntStream.range(0, values.length).forEach(i -> {
            shorts[i] = values[i];
        });
        return shorts;
    }
}

