/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.canvas;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.canvas.AwtCanvas;
import org.jetbrains.letsPlot.awt.canvas.AwtContext2d;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.Vec;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.Font;
import org.jetbrains.letsPlot.core.canvas.FontStyle;
import org.jetbrains.letsPlot.core.canvas.FontWeight;
import org.jetbrains.letsPlot.core.canvas.LineCap;
import org.jetbrains.letsPlot.core.canvas.LineJoin;
import org.jetbrains.letsPlot.core.canvas.TextAlign;
import org.jetbrains.letsPlot.core.canvas.TextBaseline;
import org.jetbrains.letsPlot.core.canvas.TextMetrics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 |2\u00020\u0001:\u0002|}B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J8\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016JH\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u000eH\u0016J\b\u0010&\u001a\u00020\u000eH\u0016J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)H\u0016J \u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J0\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u0010H\u0016JP\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00102\u0006\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u0010H\u0016JH\u00102\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u00103\u001a\u00020\u000eH\u0016J\b\u00104\u001a\u00020\u000eH\u0016J(\u00105\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0010H\u0016J \u00108\u001a\u00020\u000e2\u0006\u00109\u001a\u00020:2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010;\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020:H\u0016J\u0010\u0010?\u001a\u00020\u00102\u0006\u0010>\u001a\u00020:H\u0016J\u0018\u0010@\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J(\u0010A\u001a\u00020\u000e2\u0006\u00109\u001a\u00020:2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0016H\u0002J\b\u0010B\u001a\u00020\u000eH\u0016J\u0010\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020\u0010H\u0016J\b\u0010E\u001a\u00020\u000eH\u0016J\u0010\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u0010H\u0016J\u0018\u0010F\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0012\u0010H\u001a\u00020\u000e2\b\u0010I\u001a\u0004\u0018\u00010JH\u0016J\u0010\u0010K\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020\u000e2\u0006\u0010O\u001a\u00020\u0010H\u0016J\u0010\u0010P\u001a\u00020\u000e2\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\u000e2\u0006\u0010T\u001a\u00020UH\u0016J\u0010\u0010V\u001a\u00020\u000e2\u0006\u0010W\u001a\u00020\u0010H\u0016J\u0010\u0010X\u001a\u00020\u000e2\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\u000e2\u0006\u0010\\\u001a\u00020\u0010H\u0016J\u0010\u0010]\u001a\u00020\u000e2\u0006\u0010^\u001a\u00020\u0010H\u0016J\u0012\u0010_\u001a\u00020\u000e2\b\u0010I\u001a\u0004\u0018\u00010JH\u0016J\u0010\u0010`\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020bH\u0016J\u0010\u0010c\u001a\u00020\u000e2\u0006\u0010d\u001a\u00020eH\u0016J8\u0010f\u001a\u00020\u000e2\u0006\u0010g\u001a\u00020\u00102\u0006\u0010h\u001a\u00020\u00102\u0006\u0010i\u001a\u00020\u00102\u0006\u0010j\u001a\u00020\u00102\u0006\u0010k\u001a\u00020\u00102\u0006\u0010l\u001a\u00020\u0010H\u0016J\b\u0010m\u001a\u00020\u000eH\u0016J(\u0010n\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0010H\u0016J \u0010o\u001a\u00020\u000e2\u0006\u00109\u001a\u00020:2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J \u0010p\u001a\u00020q2\u0006\u0010r\u001a\u00020s2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J8\u0010t\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u00102\u0006\u0010u\u001a\u00020\u00102\u0006\u0010v\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00102\u0006\u0010w\u001a\u00020\u00102\u0006\u0010x\u001a\u00020\u0010H\u0016J\u0018\u0010y\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u001c\u0010z\u001a\u00020{*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0014\u0010r\u001a\u00020s*\u00020\u00032\u0006\u0010>\u001a\u00020:H\u0002R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0006j\b\u0012\u0004\u0012\u00020\u000b`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006~"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtContext2d;", "Lorg/jetbrains/letsPlot/core/canvas/Context2d;", "graphics", "Ljava/awt/Graphics2D;", "(Ljava/awt/Graphics2D;)V", "clipStack", "Ljava/util/ArrayList;", "Ljava/awt/geom/GeneralPath;", "Lkotlin/collections/ArrayList;", "currentPath", "state", "Lorg/jetbrains/letsPlot/awt/canvas/AwtContext2d$ContextState;", "stateStack", "arc", "", "x", "", "y", "radius", "startAngle", "endAngle", "anticlockwise", "", "beginPath", "bezierCurveTo", "cp1x", "cp1y", "cp2x", "cp2y", "buildArc", "Ljava/awt/geom/Path2D$Double;", "radiusX", "radiusY", "rotation", "clearRect", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "clip", "closePath", "drawImage", "snapshot", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "dw", "dh", "sx", "sy", "sw", "sh", "dx", "dy", "ellipse", "fill", "fillEvenOdd", "fillRect", "w", "h", "fillText", "text", "", "lineTo", "measureText", "Lorg/jetbrains/letsPlot/core/canvas/TextMetrics;", "str", "measureTextWidth", "moveTo", "paintText", "restore", "rotate", "angle", "save", "scale", "xy", "setFillStyle", "color", "Lorg/jetbrains/letsPlot/commons/values/Color;", "setFont", "f", "Lorg/jetbrains/letsPlot/core/canvas/Font;", "setGlobalAlpha", "alpha", "setLineCap", "lineCap", "Lorg/jetbrains/letsPlot/core/canvas/LineCap;", "setLineDash", "lineDash", "", "setLineDashOffset", "lineDashOffset", "setLineJoin", "lineJoin", "Lorg/jetbrains/letsPlot/core/canvas/LineJoin;", "setLineWidth", "lineWidth", "setStrokeMiterLimit", "miterLimit", "setStrokeStyle", "setTextAlign", "align", "Lorg/jetbrains/letsPlot/core/canvas/TextAlign;", "setTextBaseline", "baseline", "Lorg/jetbrains/letsPlot/core/canvas/TextBaseline;", "setTransform", "m00", "m10", "m01", "m11", "m02", "m12", "stroke", "strokeRect", "strokeText", "textPosition", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "glyphVector", "Ljava/awt/font/GlyphVector;", "transform", "ry", "rx", "tx", "ty", "translate", "applyTransform", "Ljava/awt/geom/Point2D;", "Companion", "ContextState", "platf-awt"})
@SourceDebugExtension(value={"SMAP\nAwtContext2d.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwtContext2d.kt\norg/jetbrains/letsPlot/awt/canvas/AwtContext2d\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,492:1\n1#2:493\n11125#3:494\n11460#3,3:495\n*S KotlinDebug\n*F\n+ 1 AwtContext2d.kt\norg/jetbrains/letsPlot/awt/canvas/AwtContext2d\n*L\n409#1:494\n409#1:495,3\n*E\n"})
public final class AwtContext2d
implements Context2d {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Graphics2D graphics;
    @NotNull
    private GeneralPath currentPath;
    @NotNull
    private ContextState state;
    @NotNull
    private final ArrayList<ContextState> stateStack;
    @NotNull
    private ArrayList<GeneralPath> clipStack;

    public AwtContext2d(@NotNull Graphics2D graphics) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        this.graphics = graphics;
        this.currentPath = new GeneralPath();
        this.state = new ContextState(0, null, null, null, null, null, null, 0.0f, null, 511, null);
        this.stateStack = new ArrayList();
        this.clipStack = new ArrayList();
        Object object = new Pair[]{TuplesKt.to((Object)RenderingHints.KEY_ANTIALIASING, (Object)RenderingHints.VALUE_ANTIALIAS_ON), TuplesKt.to((Object)RenderingHints.KEY_FRACTIONALMETRICS, (Object)RenderingHints.VALUE_FRACTIONALMETRICS_ON), TuplesKt.to((Object)RenderingHints.KEY_STROKE_CONTROL, (Object)RenderingHints.VALUE_STROKE_PURE)};
        object = new RenderingHints(MapsKt.mapOf((Pair[])object));
        Graphics2D graphics2D = this.graphics;
        Map p0 = (Map)object;
        boolean bl = false;
        graphics2D.setRenderingHints(p0);
        this.graphics.setBackground(AwtContext2d.Companion.toAwtColor(org.jetbrains.letsPlot.commons.values.Color.Companion.getTRANSPARENT()));
        this.setLineCap(LineCap.BUTT);
    }

    private final Point2D applyTransform(ContextState $this$applyTransform, double x2, double y2) {
        Point2D point2D = $this$applyTransform.getTransform().transform(new Point2D.Double(x2, y2), null);
        Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"transform(...)");
        return point2D;
    }

    private final GlyphVector glyphVector(Graphics2D $this$glyphVector, String str) {
        GlyphVector glyphVector = $this$glyphVector.getFont().createGlyphVector($this$glyphVector.getFontRenderContext(), str);
        Intrinsics.checkNotNullExpressionValue((Object)glyphVector, (String)"createGlyphVector(...)");
        return glyphVector;
    }

    private final void paintText(String text2, double x2, double y2, boolean fill2) {
        GlyphVector gv = this.glyphVector(this.graphics, text2);
        DoubleVector position = this.textPosition(gv, x2, y2);
        AffineTransform savedTransform = this.graphics.getTransform();
        this.graphics.translate(position.getX(), position.getY());
        if (fill2) {
            this.graphics.setColor(this.state.getFillColor());
            this.graphics.fill(gv.getOutline());
        } else {
            this.graphics.setColor(this.state.getStrokeColor());
            this.graphics.draw(gv.getOutline());
        }
        this.graphics.setTransform(savedTransform);
    }

    private final DoubleVector textPosition(GlyphVector glyphVector, double x2, double y2) {
        double d;
        double d2;
        Rectangle2D rectangle2D = glyphVector.getVisualBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"getVisualBounds(...)");
        Rectangle2D box = rectangle2D;
        FontMetrics fm = this.graphics.getFontMetrics();
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.getTextAlign().ordinal()]) {
            case 1: {
                d2 = x2;
                break;
            }
            case 2: {
                d2 = x2 - box.getWidth() / (double)2;
                break;
            }
            case 3: {
                d2 = x2 - box.getWidth();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double offsetX = d2;
        switch (WhenMappings.$EnumSwitchMapping$1[this.state.getTextBaseline().ordinal()]) {
            case 1: {
                d = y2;
                break;
            }
            case 2: {
                d = y2 - (double)fm.getDescent();
                break;
            }
            case 3: {
                d = y2 + (double)((fm.getLeading() + fm.getAscent() - fm.getDescent()) / 2);
                break;
            }
            case 4: {
                d = y2 + (double)fm.getLeading() + (double)fm.getAscent();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        double offsetY = d;
        return new DoubleVector(offsetX, offsetY);
    }

    public void clearRect(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        this.graphics.clearRect((int)rect2.getLeft(), (int)rect2.getTop(), (int)rect2.getWidth(), (int)rect2.getHeight());
    }

    public void drawImage(@NotNull Canvas.Snapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.drawImage(snapshot, 0.0, 0.0);
    }

    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        AwtCanvas.AwtSnapshot awtSnapshot = (AwtCanvas.AwtSnapshot)snapshot;
        this.graphics.drawImage((Image)awtSnapshot.getImage(), (int)x2, (int)y2, null);
    }

    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x2, double y2, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        AwtCanvas.AwtSnapshot awtSnapshot = (AwtCanvas.AwtSnapshot)snapshot;
        this.graphics.drawImage(awtSnapshot.getImage(), (int)x2, (int)y2, (int)dw, (int)dh, null);
    }

    public void drawImage(@NotNull Canvas.Snapshot snapshot, double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        AwtCanvas.AwtSnapshot awtSnapshot = (AwtCanvas.AwtSnapshot)snapshot;
        this.graphics.drawImage(awtSnapshot.getImage(), (int)dx, (int)dy, (int)dw + (int)dx, (int)dh + (int)dy, (int)sx, (int)sy, (int)sw + (int)sx, (int)sh + (int)sy, null);
    }

    public void beginPath() {
        this.currentPath = new GeneralPath();
    }

    public void closePath() {
        this.currentPath.closePath();
    }

    public void clip() {
        this.clipStack.add(this.currentPath);
        this.state.setNumClipPath(this.clipStack.size());
        AffineTransform currentTransform = this.graphics.getTransform();
        this.graphics.setTransform(new AffineTransform());
        this.graphics.setClip(this.currentPath);
        this.graphics.setTransform(currentTransform);
    }

    public void stroke() {
        this.graphics.setColor(this.state.getStrokeColor());
        AwtContext2d.Companion.paintPath(this.graphics, this.currentPath, (Function2<? super Graphics2D, ? super Shape, Unit>)stroke.1.INSTANCE);
    }

    public void fill() {
        this.graphics.setColor(this.state.getFillColor());
        AwtContext2d.Companion.paintPath(this.graphics, this.currentPath, (Function2<? super Graphics2D, ? super Shape, Unit>)fill.1.INSTANCE);
    }

    public void fillEvenOdd() {
        this.currentPath.setWindingRule(0);
        this.graphics.setColor(this.state.getFillColor());
        AwtContext2d.Companion.paintPath(this.graphics, this.currentPath, (Function2<? super Graphics2D, ? super Shape, Unit>)fillEvenOdd.1.INSTANCE);
    }

    public void fillRect(double x2, double y2, double w, double h) {
        this.graphics.setColor(this.state.getFillColor());
        Rectangle2D.Double rect2 = new Rectangle2D.Double(x2, y2, w, h);
        this.graphics.fill(rect2);
    }

    public void moveTo(double x2, double y2) {
        Point2D p = this.applyTransform(this.state, x2, y2);
        this.currentPath.moveTo(p.getX(), p.getY());
    }

    public void lineTo(double x2, double y2) {
        Point2D p = this.applyTransform(this.state, x2, y2);
        this.currentPath.lineTo(p.getX(), p.getY());
    }

    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x2, double y2) {
        double trCp1x = 0.0;
        double trCp1y = 0.0;
        Point2D it = this.applyTransform(this.state, cp1x, cp1y);
        boolean bl = false;
        trCp1x = it.getX();
        trCp1y = it.getY();
        double trCp2x = 0.0;
        double trCp2y = 0.0;
        Point2D it2 = this.applyTransform(this.state, cp2x, cp2y);
        boolean bl2 = false;
        trCp2x = it2.getX();
        trCp2y = it2.getY();
        double trX = 0.0;
        double trY = 0.0;
        Point2D it3 = this.applyTransform(this.state, x2, y2);
        boolean bl3 = false;
        trX = it3.getX();
        trY = it3.getY();
        this.currentPath.curveTo(trCp1x, trCp1y, trCp2x, trCp2y, trX, trY);
    }

    public void arc(double x2, double y2, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        Path2D.Double path2 = this.buildArc(x2, y2, radius, radius, 0.0, MathKt.toDegrees(startAngle), MathKt.toDegrees(endAngle), anticlockwise);
        this.currentPath.append(path2, true);
    }

    public void ellipse(double x2, double y2, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
        Path2D.Double path2 = this.buildArc(x2, y2, radiusX, radiusY, MathKt.toDegrees(rotation), MathKt.toDegrees(startAngle), MathKt.toDegrees(endAngle), anticlockwise);
        this.currentPath.append(path2, true);
    }

    private final Path2D.Double buildArc(double x2, double y2, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
        boolean fullCircle;
        double start2 = startAngle % (double)360;
        double end = endAngle % (double)360;
        boolean bl = start2 == end && !(startAngle == endAngle) ? true : (fullCircle = false);
        if (!anticlockwise && start2 > end) {
            start2 -= 360.0;
        }
        if (anticlockwise && start2 < end) {
            end -= 360.0;
        }
        double length = end - start2;
        if (anticlockwise) {
            length = -Math.abs(length);
        }
        Path2D.Double path2 = new Path2D.Double();
        if (fullCircle) {
            AwtContext2d.buildArc$appendArcSegment(x2, radiusX, y2, radiusY, path2, start2, 180.0);
            AwtContext2d.buildArc$appendArcSegment(x2, radiusX, y2, radiusY, path2, start2 + 180.0, 180.0);
        } else {
            AwtContext2d.buildArc$appendArcSegment(x2, radiusX, y2, radiusY, path2, start2, length);
        }
        if (!(rotation == 0.0)) {
            path2.transform(AffineTransform.getRotateInstance(Math.toRadians(rotation), x2, y2));
        }
        path2.transform(this.graphics.getTransform());
        return path2;
    }

    public void save() {
        this.stateStack.add(ContextState.copy$default(this.state, 0, null, null, null, null, null, null, 0.0f, null, 511, null));
    }

    public void restore() {
        block1: {
            ContextState contextState = (ContextState)CollectionsKt.lastOrNull((List)this.stateStack);
            if (contextState == null) break block1;
            ContextState it = contextState;
            boolean bl = false;
            this.state = it;
            if (this.state.getNumClipPath() < this.clipStack.size()) {
                this.clipStack.subList(this.state.getNumClipPath(), this.clipStack.size()).clear();
            }
            this.graphics.setTransform(new AffineTransform());
            this.graphics.setClip((Shape)CollectionsKt.lastOrNull((List)this.clipStack));
            this.graphics.setTransform(this.state.getTransform());
            this.graphics.setStroke(this.state.getStroke());
            this.graphics.setFont(this.state.getFont());
            this.graphics.setComposite(AlphaComposite.getInstance(3, this.state.getGlobalAlpha()));
            this.stateStack.remove(CollectionsKt.getLastIndex((List)this.stateStack));
        }
    }

    public void setFillStyle(@Nullable org.jetbrains.letsPlot.commons.values.Color color) {
        Object object = color;
        if (object == null || (object = AwtContext2d.Companion.toAwtColor((org.jetbrains.letsPlot.commons.values.Color)object)) == null) {
            Color color2 = Color.BLACK;
            object = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"BLACK");
        }
        this.state.setFillColor((Color)object);
    }

    public void setStrokeStyle(@Nullable org.jetbrains.letsPlot.commons.values.Color color) {
        Object object = color;
        if (object == null || (object = AwtContext2d.Companion.toAwtColor((org.jetbrains.letsPlot.commons.values.Color)object)) == null) {
            Color color2 = Color.BLACK;
            object = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"BLACK");
        }
        this.state.setStrokeColor((Color)object);
    }

    public void setGlobalAlpha(double alpha) {
        this.state.setGlobalAlpha((float)alpha);
        this.graphics.setComposite(AlphaComposite.getInstance(3, this.state.getGlobalAlpha()));
    }

    public void setFont(@NotNull Font f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.state.setFont(AwtContext2d.Companion.toAwtFont(f));
        this.graphics.setFont(this.state.getFont());
    }

    public void setLineWidth(double lineWidth) {
        this.state.setStroke(org.jetbrains.letsPlot.awt.canvas.AwtContext2d$Companion.copy$default(Companion, this.state.getStroke(), (float)lineWidth, 0, 0, 0.0f, null, 0.0f, 62, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    public void strokeRect(double x2, double y2, double w, double h) {
        this.graphics.setColor(this.state.getStrokeColor());
        Rectangle2D.Double rect2 = new Rectangle2D.Double(x2, y2, w, h);
        this.graphics.draw(rect2);
    }

    public void strokeText(@NotNull String text2, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.paintText(text2, x2, y2, false);
    }

    public void fillText(@NotNull String text2, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.paintText(text2, x2, y2, true);
    }

    public void scale(double xy2) {
        this.scale(xy2, xy2);
    }

    public void scale(double x2, double y2) {
        this.graphics.scale(x2, y2);
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
        this.state.setTransform(affineTransform);
    }

    public void rotate(double angle) {
        this.graphics.rotate(angle);
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
        this.state.setTransform(affineTransform);
    }

    public void translate(double x2, double y2) {
        this.graphics.translate(x2, y2);
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
        this.state.setTransform(affineTransform);
    }

    public void transform(double sx, double ry, double rx, double sy, double tx, double ty) {
        AffineTransform t = new AffineTransform(sx, ry, rx, sy, tx, ty);
        this.graphics.transform(t);
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
        this.state.setTransform(affineTransform);
    }

    public void setLineJoin(@NotNull LineJoin lineJoin) {
        Intrinsics.checkNotNullParameter((Object)lineJoin, (String)"lineJoin");
        this.state.setStroke(org.jetbrains.letsPlot.awt.canvas.AwtContext2d$Companion.copy$default(Companion, this.state.getStroke(), 0.0f, AwtContext2d.Companion.convertLineJoin(lineJoin), 0, 0.0f, null, 0.0f, 61, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    public void setLineCap(@NotNull LineCap lineCap) {
        Intrinsics.checkNotNullParameter((Object)lineCap, (String)"lineCap");
        this.state.setStroke(org.jetbrains.letsPlot.awt.canvas.AwtContext2d$Companion.copy$default(Companion, this.state.getStroke(), 0.0f, 0, AwtContext2d.Companion.convertLineCap(lineCap), 0.0f, null, 0.0f, 59, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    public void setStrokeMiterLimit(double miterLimit) {
        this.state.setStroke(org.jetbrains.letsPlot.awt.canvas.AwtContext2d$Companion.copy$default(Companion, this.state.getStroke(), 0.0f, 0, 0, (float)miterLimit, null, 0.0f, 55, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    public void setTextBaseline(@NotNull TextBaseline baseline) {
        Intrinsics.checkNotNullParameter((Object)baseline, (String)"baseline");
        this.state.setTextBaseline(baseline);
    }

    public void setTextAlign(@NotNull TextAlign align) {
        Intrinsics.checkNotNullParameter((Object)align, (String)"align");
        this.state.setTextAlign(align);
    }

    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.graphics.setTransform(new AffineTransform(m00, m10, m01, m11, m02, m12));
        AffineTransform affineTransform = this.graphics.getTransform();
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
        this.state.setTransform(affineTransform);
    }

    /*
     * WARNING - void declaration
     */
    public void setLineDash(@NotNull double[] lineDash) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)lineDash, (String)"lineDash");
        ContextState contextState = this.state;
        Companion companion = Companion;
        BasicStroke basicStroke = this.state.getStroke();
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        float f2 = 0.0f;
        if (lineDash.length == 0) {
            fArray = null;
        } else {
            Collection<Float> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            double[] dArray = lineDash;
            float f3 = f2;
            int n3 = n2;
            int n4 = n;
            float f4 = f;
            BasicStroke basicStroke2 = basicStroke;
            Companion companion2 = companion;
            ContextState contextState2 = contextState;
            boolean $i$f$map = false;
            void var4_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n5 = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n5; ++i) {
                void p0;
                void item$iv$iv;
                void var11_17 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Float.valueOf((float)p0));
            }
            collection = (List)destination$iv$iv;
            contextState = contextState2;
            companion = companion2;
            basicStroke = basicStroke2;
            f = f4;
            n = n4;
            n2 = n3;
            f2 = f3;
            fArray = CollectionsKt.toFloatArray((Collection)collection);
        }
        contextState.setStroke(org.jetbrains.letsPlot.awt.canvas.AwtContext2d$Companion.copy$default(companion, basicStroke, f, n, n2, f2, fArray, 0.0f, 47, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    public void setLineDashOffset(double lineDashOffset) {
        this.state.setStroke(org.jetbrains.letsPlot.awt.canvas.AwtContext2d$Companion.copy$default(Companion, this.state.getStroke(), 0.0f, 0, 0, 0.0f, null, (float)lineDashOffset, 31, null));
        this.graphics.setStroke(this.state.getStroke());
    }

    public double measureTextWidth(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return this.glyphVector(this.graphics, str).getVisualBounds().getWidth();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TextMetrics measureText(@NotNull String str) {
        void it;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Rectangle2D rectangle2D = this.glyphVector(this.graphics, str).getLogicalBounds();
        double d = this.graphics.getFontMetrics().getDescent();
        double d2 = this.graphics.getFontMetrics().getAscent();
        boolean bl = false;
        DoubleRectangle doubleRectangle = DoubleRectangle.Companion.XYWH(it.getX(), it.getY(), it.getWidth(), it.getHeight());
        DoubleRectangle doubleRectangle2 = doubleRectangle;
        double d3 = d;
        double d4 = d2;
        return new TextMetrics(d4, d3, doubleRectangle2);
    }

    public void drawBezierCurve(@NotNull List<? extends Vec<?>> points2) {
        Context2d.DefaultImpls.drawBezierCurve((Context2d)this, points2);
    }

    private static final void buildArc$appendArcSegment(double $x, double $radiusX, double $y, double $radiusY, Path2D.Double path2, double startDeg, double extentDeg) {
        Arc2D.Double arc = new Arc2D.Double($x - $radiusX, $y - $radiusY, $radiusX * (double)2, $radiusY * (double)2, -startDeg, -extentDeg, 0);
        path2.append(arc, true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002JJ\u0010\n\u001a\u00020\u000b*\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\r2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\rH\u0002J.\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00150\u001aH\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001eH\u0002J\f\u0010\u001f\u001a\u00020 *\u00020!H\u0002\u00a8\u0006\""}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtContext2d$Companion;", "", "()V", "convertLineCap", "", "lineCap", "Lorg/jetbrains/letsPlot/core/canvas/LineCap;", "convertLineJoin", "lineJoin", "Lorg/jetbrains/letsPlot/core/canvas/LineJoin;", "copy", "Ljava/awt/BasicStroke;", "width", "", "join", "cap", "miterlimit", "dash", "", "dashPhase", "paintPath", "", "Ljava/awt/Graphics2D;", "path", "Ljava/awt/geom/Path2D;", "painter", "Lkotlin/Function2;", "Ljava/awt/Shape;", "toAwtColor", "Ljava/awt/Color;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "toAwtFont", "Ljava/awt/Font;", "Lorg/jetbrains/letsPlot/core/canvas/Font;", "platf-awt"})
    private static final class Companion {
        private Companion() {
        }

        private final void paintPath(Graphics2D $this$paintPath, Path2D path2, Function2<? super Graphics2D, ? super Shape, Unit> painter) {
            AffineTransform currentTransform = $this$paintPath.getTransform();
            $this$paintPath.setTransform(new AffineTransform());
            painter.invoke((Object)$this$paintPath, (Object)path2);
            $this$paintPath.setTransform(currentTransform);
        }

        private final Color toAwtColor(org.jetbrains.letsPlot.commons.values.Color $this$toAwtColor) {
            return new Color($this$toAwtColor.getRed(), $this$toAwtColor.getGreen(), $this$toAwtColor.getBlue(), $this$toAwtColor.getAlpha());
        }

        private final java.awt.Font toAwtFont(Font $this$toAwtFont) {
            int n;
            int n2;
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toAwtFont.getFontWeight().ordinal()]) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 2: {
                    n2 = 1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int weight = n2;
            switch (WhenMappings.$EnumSwitchMapping$1[$this$toAwtFont.getFontStyle().ordinal()]) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 2;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int style = n;
            return new java.awt.Font($this$toAwtFont.getFontFamily(), weight | style, (int)$this$toAwtFont.getFontSize());
        }

        private final int convertLineJoin(LineJoin lineJoin) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$2[lineJoin.ordinal()]) {
                case 1: {
                    n = 2;
                    break;
                }
                case 2: {
                    n = 0;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        private final int convertLineCap(LineCap lineCap) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$3[lineCap.ordinal()]) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return n;
        }

        private final BasicStroke copy(BasicStroke $this$copy, float width2, int join, int cap, float miterlimit, float[] dash, float dashPhase) {
            return new BasicStroke(width2, cap, join, Math.max(1.0f, miterlimit), dash, dashPhase);
        }

        static /* synthetic */ BasicStroke copy$default(Companion companion, BasicStroke basicStroke, float f, int n, int n2, float f2, float[] fArray, float f3, int n3, Object object) {
            if ((n3 & 1) != 0) {
                f = basicStroke.getLineWidth();
            }
            if ((n3 & 2) != 0) {
                n = basicStroke.getLineJoin();
            }
            if ((n3 & 4) != 0) {
                n2 = basicStroke.getEndCap();
            }
            if ((n3 & 8) != 0) {
                f2 = basicStroke.getMiterLimit();
            }
            if ((n3 & 0x10) != 0) {
                fArray = basicStroke.getDashArray();
            }
            if ((n3 & 0x20) != 0) {
                f3 = basicStroke.getDashPhase();
            }
            return companion.copy(basicStroke, f, n, n2, f2, fArray, f3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;
            public static final /* synthetic */ int[] $EnumSwitchMapping$2;
            public static final /* synthetic */ int[] $EnumSwitchMapping$3;

            static {
                int[] nArray = new int[FontWeight.values().length];
                try {
                    nArray[FontWeight.NORMAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FontWeight.BOLD.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[FontStyle.values().length];
                try {
                    nArray[FontStyle.NORMAL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FontStyle.ITALIC.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
                nArray = new int[LineJoin.values().length];
                try {
                    nArray[LineJoin.BEVEL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LineJoin.MITER.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LineJoin.ROUND.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$2 = nArray;
                nArray = new int[LineCap.values().length];
                try {
                    nArray[LineCap.BUTT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LineCap.ROUND.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LineCap.SQUARE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$3 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b.\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B_\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\t\u00106\u001a\u00020\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\u0005H\u00c6\u0003J\t\u00108\u001a\u00020\u0005H\u00c6\u0003J\t\u00109\u001a\u00020\bH\u00c6\u0003J\t\u0010:\u001a\u00020\nH\u00c6\u0003J\t\u0010;\u001a\u00020\fH\u00c6\u0003J\t\u0010<\u001a\u00020\u000eH\u00c6\u0003J\t\u0010=\u001a\u00020\u0010H\u00c6\u0003J\t\u0010>\u001a\u00020\u0012H\u00c6\u0003Jc\u0010?\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u00c6\u0001J\u0013\u0010@\u001a\u00020A2\b\u0010B\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010C\u001a\u00020\u0003H\u00d6\u0001J\t\u0010D\u001a\u00020EH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0015\"\u0004\b)\u0010\u0017R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105\u00a8\u0006F"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtContext2d$ContextState;", "", "numClipPath", "", "strokeColor", "Ljava/awt/Color;", "fillColor", "stroke", "Ljava/awt/BasicStroke;", "textBaseline", "Lorg/jetbrains/letsPlot/core/canvas/TextBaseline;", "textAlign", "Lorg/jetbrains/letsPlot/core/canvas/TextAlign;", "font", "Ljava/awt/Font;", "globalAlpha", "", "transform", "Ljava/awt/geom/AffineTransform;", "(ILjava/awt/Color;Ljava/awt/Color;Ljava/awt/BasicStroke;Lorg/jetbrains/letsPlot/core/canvas/TextBaseline;Lorg/jetbrains/letsPlot/core/canvas/TextAlign;Ljava/awt/Font;FLjava/awt/geom/AffineTransform;)V", "getFillColor", "()Ljava/awt/Color;", "setFillColor", "(Ljava/awt/Color;)V", "getFont", "()Ljava/awt/Font;", "setFont", "(Ljava/awt/Font;)V", "getGlobalAlpha", "()F", "setGlobalAlpha", "(F)V", "getNumClipPath", "()I", "setNumClipPath", "(I)V", "getStroke", "()Ljava/awt/BasicStroke;", "setStroke", "(Ljava/awt/BasicStroke;)V", "getStrokeColor", "setStrokeColor", "getTextAlign", "()Lorg/jetbrains/letsPlot/core/canvas/TextAlign;", "setTextAlign", "(Lorg/jetbrains/letsPlot/core/canvas/TextAlign;)V", "getTextBaseline", "()Lorg/jetbrains/letsPlot/core/canvas/TextBaseline;", "setTextBaseline", "(Lorg/jetbrains/letsPlot/core/canvas/TextBaseline;)V", "getTransform", "()Ljava/awt/geom/AffineTransform;", "setTransform", "(Ljava/awt/geom/AffineTransform;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "", "platf-awt"})
    public static final class ContextState {
        private int numClipPath;
        @NotNull
        private Color strokeColor;
        @NotNull
        private Color fillColor;
        @NotNull
        private BasicStroke stroke;
        @NotNull
        private TextBaseline textBaseline;
        @NotNull
        private TextAlign textAlign;
        @NotNull
        private java.awt.Font font;
        private float globalAlpha;
        @NotNull
        private AffineTransform transform;

        public ContextState(int numClipPath, @NotNull Color strokeColor, @NotNull Color fillColor, @NotNull BasicStroke stroke2, @NotNull TextBaseline textBaseline, @NotNull TextAlign textAlign, @NotNull java.awt.Font font, float globalAlpha, @NotNull AffineTransform transform2) {
            Intrinsics.checkNotNullParameter((Object)strokeColor, (String)"strokeColor");
            Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
            Intrinsics.checkNotNullParameter((Object)stroke2, (String)"stroke");
            Intrinsics.checkNotNullParameter((Object)textBaseline, (String)"textBaseline");
            Intrinsics.checkNotNullParameter((Object)textAlign, (String)"textAlign");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            this.numClipPath = numClipPath;
            this.strokeColor = strokeColor;
            this.fillColor = fillColor;
            this.stroke = stroke2;
            this.textBaseline = textBaseline;
            this.textAlign = textAlign;
            this.font = font;
            this.globalAlpha = globalAlpha;
            this.transform = transform2;
        }

        public /* synthetic */ ContextState(int n, Color color, Color color2, BasicStroke basicStroke, TextBaseline textBaseline, TextAlign textAlign, java.awt.Font font, float f, AffineTransform affineTransform, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 0;
            }
            if ((n2 & 2) != 0) {
                Color color3 = Color.BLACK;
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"BLACK");
                color = color3;
            }
            if ((n2 & 4) != 0) {
                Color color4 = Color.BLACK;
                Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"BLACK");
                color2 = color4;
            }
            if ((n2 & 8) != 0) {
                basicStroke = new BasicStroke();
            }
            if ((n2 & 0x10) != 0) {
                textBaseline = TextBaseline.ALPHABETIC;
            }
            if ((n2 & 0x20) != 0) {
                textAlign = TextAlign.START;
            }
            if ((n2 & 0x40) != 0) {
                font = new java.awt.Font("Serif", 0, 10);
            }
            if ((n2 & 0x80) != 0) {
                f = 1.0f;
            }
            if ((n2 & 0x100) != 0) {
                affineTransform = new AffineTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            }
            this(n, color, color2, basicStroke, textBaseline, textAlign, font, f, affineTransform);
        }

        public final int getNumClipPath() {
            return this.numClipPath;
        }

        public final void setNumClipPath(int n) {
            this.numClipPath = n;
        }

        @NotNull
        public final Color getStrokeColor() {
            return this.strokeColor;
        }

        public final void setStrokeColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
            this.strokeColor = color;
        }

        @NotNull
        public final Color getFillColor() {
            return this.fillColor;
        }

        public final void setFillColor(@NotNull Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
            this.fillColor = color;
        }

        @NotNull
        public final BasicStroke getStroke() {
            return this.stroke;
        }

        public final void setStroke(@NotNull BasicStroke basicStroke) {
            Intrinsics.checkNotNullParameter((Object)basicStroke, (String)"<set-?>");
            this.stroke = basicStroke;
        }

        @NotNull
        public final TextBaseline getTextBaseline() {
            return this.textBaseline;
        }

        public final void setTextBaseline(@NotNull TextBaseline textBaseline) {
            Intrinsics.checkNotNullParameter((Object)textBaseline, (String)"<set-?>");
            this.textBaseline = textBaseline;
        }

        @NotNull
        public final TextAlign getTextAlign() {
            return this.textAlign;
        }

        public final void setTextAlign(@NotNull TextAlign textAlign) {
            Intrinsics.checkNotNullParameter((Object)textAlign, (String)"<set-?>");
            this.textAlign = textAlign;
        }

        @NotNull
        public final java.awt.Font getFont() {
            return this.font;
        }

        public final void setFont(@NotNull java.awt.Font font) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"<set-?>");
            this.font = font;
        }

        public final float getGlobalAlpha() {
            return this.globalAlpha;
        }

        public final void setGlobalAlpha(float f) {
            this.globalAlpha = f;
        }

        @NotNull
        public final AffineTransform getTransform() {
            return this.transform;
        }

        public final void setTransform(@NotNull AffineTransform affineTransform) {
            Intrinsics.checkNotNullParameter((Object)affineTransform, (String)"<set-?>");
            this.transform = affineTransform;
        }

        public final int component1() {
            return this.numClipPath;
        }

        @NotNull
        public final Color component2() {
            return this.strokeColor;
        }

        @NotNull
        public final Color component3() {
            return this.fillColor;
        }

        @NotNull
        public final BasicStroke component4() {
            return this.stroke;
        }

        @NotNull
        public final TextBaseline component5() {
            return this.textBaseline;
        }

        @NotNull
        public final TextAlign component6() {
            return this.textAlign;
        }

        @NotNull
        public final java.awt.Font component7() {
            return this.font;
        }

        public final float component8() {
            return this.globalAlpha;
        }

        @NotNull
        public final AffineTransform component9() {
            return this.transform;
        }

        @NotNull
        public final ContextState copy(int numClipPath, @NotNull Color strokeColor, @NotNull Color fillColor, @NotNull BasicStroke stroke2, @NotNull TextBaseline textBaseline, @NotNull TextAlign textAlign, @NotNull java.awt.Font font, float globalAlpha, @NotNull AffineTransform transform2) {
            Intrinsics.checkNotNullParameter((Object)strokeColor, (String)"strokeColor");
            Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
            Intrinsics.checkNotNullParameter((Object)stroke2, (String)"stroke");
            Intrinsics.checkNotNullParameter((Object)textBaseline, (String)"textBaseline");
            Intrinsics.checkNotNullParameter((Object)textAlign, (String)"textAlign");
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Intrinsics.checkNotNullParameter((Object)transform2, (String)"transform");
            return new ContextState(numClipPath, strokeColor, fillColor, stroke2, textBaseline, textAlign, font, globalAlpha, transform2);
        }

        public static /* synthetic */ ContextState copy$default(ContextState contextState, int n, Color color, Color color2, BasicStroke basicStroke, TextBaseline textBaseline, TextAlign textAlign, java.awt.Font font, float f, AffineTransform affineTransform, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = contextState.numClipPath;
            }
            if ((n2 & 2) != 0) {
                color = contextState.strokeColor;
            }
            if ((n2 & 4) != 0) {
                color2 = contextState.fillColor;
            }
            if ((n2 & 8) != 0) {
                basicStroke = contextState.stroke;
            }
            if ((n2 & 0x10) != 0) {
                textBaseline = contextState.textBaseline;
            }
            if ((n2 & 0x20) != 0) {
                textAlign = contextState.textAlign;
            }
            if ((n2 & 0x40) != 0) {
                font = contextState.font;
            }
            if ((n2 & 0x80) != 0) {
                f = contextState.globalAlpha;
            }
            if ((n2 & 0x100) != 0) {
                affineTransform = contextState.transform;
            }
            return contextState.copy(n, color, color2, basicStroke, textBaseline, textAlign, font, f, affineTransform);
        }

        @NotNull
        public String toString() {
            return "ContextState(numClipPath=" + this.numClipPath + ", strokeColor=" + this.strokeColor + ", fillColor=" + this.fillColor + ", stroke=" + this.stroke + ", textBaseline=" + this.textBaseline + ", textAlign=" + this.textAlign + ", font=" + this.font + ", globalAlpha=" + this.globalAlpha + ", transform=" + this.transform + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.numClipPath);
            result2 = result2 * 31 + this.strokeColor.hashCode();
            result2 = result2 * 31 + this.fillColor.hashCode();
            result2 = result2 * 31 + this.stroke.hashCode();
            result2 = result2 * 31 + this.textBaseline.hashCode();
            result2 = result2 * 31 + this.textAlign.hashCode();
            result2 = result2 * 31 + this.font.hashCode();
            result2 = result2 * 31 + Float.hashCode(this.globalAlpha);
            result2 = result2 * 31 + this.transform.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContextState)) {
                return false;
            }
            ContextState contextState = (ContextState)other;
            if (this.numClipPath != contextState.numClipPath) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.strokeColor, (Object)contextState.strokeColor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fillColor, (Object)contextState.fillColor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stroke, (Object)contextState.stroke)) {
                return false;
            }
            if (this.textBaseline != contextState.textBaseline) {
                return false;
            }
            if (this.textAlign != contextState.textAlign) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.font, (Object)contextState.font)) {
                return false;
            }
            if (Float.compare(this.globalAlpha, contextState.globalAlpha) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.transform, (Object)contextState.transform);
        }

        public ContextState() {
            this(0, null, null, null, null, null, null, 0.0f, null, 511, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TextAlign.values().length];
            try {
                nArray[TextAlign.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlign.END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TextBaseline.values().length];
            try {
                nArray[TextBaseline.ALPHABETIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextBaseline.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextBaseline.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextBaseline.TOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

