/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.stat.DensityStat;
import org.jetbrains.letsPlot.core.plot.base.stat.DensityStatUtil;
import org.jetbrains.letsPlot.core.plot.base.stat.FiveNumberSummary;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\tJ\u00bd\u0001\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\u000b2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\b\u0002\u0010\u001d\u001a\u00020\f2\b\b\u0002\u0010\u001e\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001fJ=\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0000\u00a2\u0006\u0002\b#Jc\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040)2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u00042\u000e\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t\u00a2\u0006\u0002\u0010,J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018Ja\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040)2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u00100\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0018H\u0000\u00a2\u0006\u0004\b1\u00102JY\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040)2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040)2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b5JY\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040)2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040)2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b7JU\u00108\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\u000b2\u0018\u00109\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\u000b2\u0006\u0010:\u001a\u00020\f2\u0006\u0010;\u001a\u00020\f2\n\b\u0002\u0010<\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b=Jb\u0010>\u001a\u00020?2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\t2*\u0010@\u001a&\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t\u0012\u0004\u0012\u00020?0AJ\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040)2\u0006\u0010(\u001a\u00020\u0016J.\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040)2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00040\tJ\u0016\u0010E\u001a\u00020\u00042\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0002J\u000e\u0010G\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020HJ\u000e\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020HJG\u0010K\u001a\u00020\u001b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010LR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityStatUtil;", "", "()V", "DEF_STEP_SIZE", "", "bandWidth", "bw", "Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$BandWidthMethod;", "valuesX", "", "binnedStat", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "bins", "values", "weights", "trim", "", "tailsCutoff", "bandWidthMethod", "adjust", "kernel", "Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$Kernel;", "n", "", "fullScanMax", "overallValuesRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "quantiles", "binVarName", "valueVarName", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLjava/lang/Double;Ljava/lang/Double;Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$BandWidthMethod;DLorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$Kernel;IILorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;)Ljava/util/Map;", "calculateStatQuantile", "statSample", "statDensity", "calculateStatQuantile$plot_base", "createRawMatrix", "", "", "list", "ker", "Lkotlin/Function1;", "ad", "weight", "(Ljava/util/List;Ljava/util/List;Lkotlin/jvm/functions/Function1;DDLjava/util/List;)[[D", "createStepValues", "range", "densityFunction", "bwMethod", "densityFunction$plot_base", "(Ljava/util/List;Ljava/util/List;Ljava/lang/Double;Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$BandWidthMethod;DLorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$Kernel;I)Lkotlin/jvm/functions/Function1;", "densityFunctionFast", "xs", "densityFunctionFast$plot_base", "densityFunctionFullScan", "densityFunctionFullScan$plot_base", "expandByGroupEnds", "statData", "axisVar", "groupVar", "binVar", "expandByGroupEnds$plot_base", "handleBinnedData", "", "binHandler", "Lkotlin/Function3;", "pwLinInterp", "x", "y", "stdDev", "data", "toBandWidthMethod", "", "toKernel", "method", "trimValueRange", "(Ljava/util/List;ZLjava/lang/Double;Ljava/lang/Double;Lorg/jetbrains/letsPlot/core/plot/base/stat/DensityStat$BandWidthMethod;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;)Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "plot-base"})
@SourceDebugExtension(value={"SMAP\nDensityStatUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DensityStatUtil.kt\norg/jetbrains/letsPlot/core/plot/base/stat/DensityStatUtil\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,373:1\n1003#2:374\n1037#2,3:375\n1040#2,3:385\n372#3,7:378\n453#3:388\n403#3:389\n453#3:421\n403#3:422\n1238#4,4:390\n1045#4:394\n766#4:395\n857#4,2:396\n2898#4,4:399\n2902#4,5:404\n1549#4:409\n1620#4,3:410\n1549#4:413\n1620#4,3:414\n1549#4:417\n1620#4,3:418\n1238#4,4:423\n1855#4,2:427\n1855#4,2:429\n1#5:398\n1#5:403\n*S KotlinDebug\n*F\n+ 1 DensityStatUtil.kt\norg/jetbrains/letsPlot/core/plot/base/stat/DensityStatUtil\n*L\n94#1:374\n94#1:375,3\n94#1:385,3\n94#1:378,7\n95#1:388\n95#1:389\n205#1:421\n205#1:422\n95#1:390,4\n99#1:394\n130#1:395\n130#1:396,2\n165#1:399,4\n165#1:404,5\n165#1:409\n165#1:410,3\n168#1:413\n168#1:414,3\n199#1:417\n199#1:418,3\n205#1:423,4\n219#1:427,2\n227#1:429,2\n165#1:403\n*E\n"})
public final class DensityStatUtil {
    @NotNull
    public static final DensityStatUtil INSTANCE = new DensityStatUtil();
    private static final double DEF_STEP_SIZE = 0.5;

    private DensityStatUtil() {
    }

    private final double stdDev(List<Double> data) {
        double sum2 = 0.0;
        double counter = 0.0;
        Iterator<Double> iterator2 = data.iterator();
        while (iterator2.hasNext()) {
            double i = ((Number)iterator2.next()).doubleValue();
            sum2 += i;
        }
        double mean2 = sum2 / (double)data.size();
        Iterator<Double> iterator3 = data.iterator();
        while (iterator3.hasNext()) {
            double i = ((Number)iterator3.next()).doubleValue();
            counter += Math.pow(i - mean2, 2.0);
        }
        return Math.sqrt(counter / (double)data.size());
    }

    @NotNull
    public final Map<DataFrame.Variable, List<Double>> binnedStat(@NotNull List<Double> bins, @NotNull List<Double> values2, @NotNull List<Double> weights, boolean trim, @Nullable Double tailsCutoff, @Nullable Double bandWidth, @NotNull DensityStat.BandWidthMethod bandWidthMethod, double adjust, @NotNull DensityStat.Kernel kernel2, int n, int fullScanMax, @NotNull DoubleSpan overallValuesRange, @NotNull List<Double> quantiles, @NotNull DataFrame.Variable binVarName, @NotNull DataFrame.Variable valueVarName) {
        Intrinsics.checkNotNullParameter(bins, (String)"bins");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter((Object)((Object)bandWidthMethod), (String)"bandWidthMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)kernel2), (String)"kernel");
        Intrinsics.checkNotNullParameter((Object)overallValuesRange, (String)"overallValuesRange");
        Intrinsics.checkNotNullParameter(quantiles, (String)"quantiles");
        Intrinsics.checkNotNullParameter((Object)binVarName, (String)"binVarName");
        Intrinsics.checkNotNullParameter((Object)valueVarName, (String)"valueVarName");
        ArrayList<Double> statBin2 = new ArrayList<Double>();
        ArrayList<Double> statValue = new ArrayList<Double>();
        ArrayList<Double> statDensity2 = new ArrayList<Double>();
        ArrayList<Double> statCount2 = new ArrayList<Double>();
        ArrayList<Double> statScaled = new ArrayList<Double>();
        ArrayList<Double> statQuantile = new ArrayList<Double>();
        this.handleBinnedData(bins, values2, weights, (Function3<? super Double, ? super List<Double>, ? super List<Double>, Unit>)((Function3)new Function3<Double, List<? extends Double>, List<? extends Double>, Unit>(trim, tailsCutoff, bandWidth, bandWidthMethod, overallValuesRange, n, adjust, kernel2, fullScanMax, statBin2, statValue, statDensity2, statCount2, statScaled, statQuantile, quantiles){
            final /* synthetic */ boolean $trim;
            final /* synthetic */ Double $tailsCutoff;
            final /* synthetic */ Double $bandWidth;
            final /* synthetic */ DensityStat.BandWidthMethod $bandWidthMethod;
            final /* synthetic */ DoubleSpan $overallValuesRange;
            final /* synthetic */ int $n;
            final /* synthetic */ double $adjust;
            final /* synthetic */ DensityStat.Kernel $kernel;
            final /* synthetic */ int $fullScanMax;
            final /* synthetic */ ArrayList<Double> $statBin;
            final /* synthetic */ ArrayList<Double> $statValue;
            final /* synthetic */ ArrayList<Double> $statDensity;
            final /* synthetic */ ArrayList<Double> $statCount;
            final /* synthetic */ ArrayList<Double> $statScaled;
            final /* synthetic */ ArrayList<Double> $statQuantile;
            final /* synthetic */ List<Double> $quantiles;
            {
                this.$trim = $trim;
                this.$tailsCutoff = $tailsCutoff;
                this.$bandWidth = $bandWidth;
                this.$bandWidthMethod = $bandWidthMethod;
                this.$overallValuesRange = $overallValuesRange;
                this.$n = $n;
                this.$adjust = $adjust;
                this.$kernel = $kernel;
                this.$fullScanMax = $fullScanMax;
                this.$statBin = $statBin;
                this.$statValue = $statValue;
                this.$statDensity = $statDensity;
                this.$statCount = $statCount;
                this.$statScaled = $statScaled;
                this.$statQuantile = $statQuantile;
                this.$quantiles = $quantiles;
                super(3);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(double bin2, @NotNull List<Double> binValue, @NotNull List<Double> binWeight) {
                double it;
                Iterable $this$mapTo$iv$iv;
                int n;
                Collection<Object> collection;
                Object item$iv$iv2;
                void $this$mapTo$iv$iv2;
                Intrinsics.checkNotNullParameter(binValue, (String)"binValue");
                Intrinsics.checkNotNullParameter(binWeight, (String)"binWeight");
                DoubleSpan valueRange = DensityStatUtil.access$trimValueRange(DensityStatUtil.INSTANCE, binValue, this.$trim, this.$tailsCutoff, this.$bandWidth, this.$bandWidthMethod, this.$overallValuesRange);
                List<Double> binStatValue = DensityStatUtil.INSTANCE.createStepValues(valueRange, this.$n);
                Function1<Double, Double> densityFunction = DensityStatUtil.INSTANCE.densityFunction$plot_base(binValue, binWeight, this.$bandWidth, this.$bandWidthMethod, this.$adjust, this.$kernel, this.$fullScanMax);
                Iterable $this$map$iv = binStatValue;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it22;
                    double d = ((Number)item$iv$iv2).doubleValue();
                    collection = destination$iv$iv;
                    n = 0;
                    collection.add(((Number)densityFunction.invoke((Object)((double)it22))).doubleValue());
                }
                List binStatCount = (List)destination$iv$iv;
                double weightsSum = CollectionsKt.sumOfDouble((Iterable)binWeight);
                Double d = CollectionsKt.maxOrNull((Iterable)binStatCount);
                Intrinsics.checkNotNull((Object)d);
                double maxBinCount = d;
                Collection collection2 = this.$statBin;
                int n2 = binStatValue.size();
                item$iv$iv2 = new ArrayList<E>(n2);
                int it22 = 0;
                while (it22 < n2) {
                    int n3;
                    n = n3 = it22++;
                    collection = item$iv$iv2;
                    boolean bl = false;
                    ((ArrayList)collection).add(bin2);
                }
                Iterable iterable2 = (List)item$iv$iv2;
                CollectionsKt.addAll((Collection)collection2, (Iterable)iterable2);
                CollectionsKt.addAll((Collection)this.$statValue, (Iterable)binStatValue);
                collection2 = this.$statDensity;
                Iterable $this$map$iv2 = binStatCount;
                boolean $i$f$map2 = false;
                Iterable it22 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (T item$iv$iv3 : $this$mapTo$iv$iv) {
                    double d2 = ((Number)item$iv$iv3).doubleValue();
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add((double)(it / weightsSum));
                }
                $this$map$iv2 = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)collection2, (Iterable)$this$map$iv2);
                CollectionsKt.addAll((Collection)this.$statCount, (Iterable)binStatCount);
                collection2 = this.$statScaled;
                $this$map$iv2 = binStatCount;
                $i$f$map2 = false;
                $this$mapTo$iv$iv = $this$map$iv2;
                destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                $i$f$mapTo2 = false;
                for (T item$iv$iv3 : $this$mapTo$iv$iv) {
                    it = ((Number)item$iv$iv3).doubleValue();
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(it / maxBinCount);
                }
                iterable2 = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)collection2, (Iterable)iterable2);
                CollectionsKt.addAll((Collection)this.$statQuantile, (Iterable)DensityStatUtil.INSTANCE.calculateStatQuantile$plot_base(binStatValue, binStatCount, this.$quantiles));
            }
        }));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)binVarName, (Object)CollectionsKt.toList((Iterable)statBin2)), TuplesKt.to((Object)valueVarName, (Object)CollectionsKt.toList((Iterable)statValue)), TuplesKt.to((Object)Stats.INSTANCE.getDENSITY(), (Object)CollectionsKt.toList((Iterable)statDensity2)), TuplesKt.to((Object)Stats.INSTANCE.getCOUNT(), (Object)CollectionsKt.toList((Iterable)statCount2)), TuplesKt.to((Object)Stats.INSTANCE.getSCALED(), (Object)CollectionsKt.toList((Iterable)statScaled)), TuplesKt.to((Object)Stats.INSTANCE.getQUANTILE(), (Object)CollectionsKt.toList((Iterable)statQuantile))};
        Map statData = MapsKt.mapOf((Pair[])pairArray);
        return this.expandByGroupEnds$plot_base(statData, valueVarName, Stats.INSTANCE.getQUANTILE(), binVarName);
    }

    public static /* synthetic */ Map binnedStat$default(DensityStatUtil densityStatUtil, List list2, List list3, List list4, boolean bl, Double d, Double d2, DensityStat.BandWidthMethod bandWidthMethod, double d3, DensityStat.Kernel kernel2, int n, int n2, DoubleSpan doubleSpan, List list5, DataFrame.Variable variable, DataFrame.Variable variable2, int n3, Object object) {
        if ((n3 & 0x1000) != 0) {
            list5 = CollectionsKt.emptyList();
        }
        if ((n3 & 0x2000) != 0) {
            variable = Stats.INSTANCE.getX();
        }
        if ((n3 & 0x4000) != 0) {
            variable2 = Stats.INSTANCE.getY();
        }
        return densityStatUtil.binnedStat(list2, list3, list4, bl, d, d2, bandWidthMethod, d3, kernel2, n, n2, doubleSpan, list5, variable, variable2);
    }

    /*
     * WARNING - void declaration
     */
    public final void handleBinnedData(@NotNull List<Double> bins, @NotNull List<Double> values2, @NotNull List<Double> weights, @NotNull Function3<? super Double, ? super List<Double>, ? super List<Double>, Unit> binHandler) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        List list2;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Intrinsics.checkNotNullParameter(bins, (String)"bins");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter(binHandler, (String)"binHandler");
        Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)bins), (Sequence)SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)values2), (Sequence)CollectionsKt.asSequence((Iterable)weights))), (Function1)handleBinnedData.binnedData.1.INSTANCE);
        boolean bl = false;
        void var8_9 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Double bin2;
            Pair pair2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-DensityStatUtil$handleBinnedData$binnedData$432 = false;
            Double d = bin2 = (Double)pair2.component1();
            Intrinsics.checkNotNull((Object)d);
            key$iv$iv = (double)d;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-DensityStatUtil$handleBinnedData$binnedData$432 = (Pair)element$iv$iv;
            list2 = list$iv$iv;
            boolean bl3 = false;
            Pair binValues = (Pair)$i$a$-groupBy-DensityStatUtil$handleBinnedData$binnedData$432.component2();
            list2.add(binValues);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean entry = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry bl3 = (Map.Entry)element$iv$iv$iv;
            key$iv$iv = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            list2 = key$iv$iv;
            boolean bl32 = false;
            List binData = (List)entry2.getValue();
            Pair pair3 = CollectionsKt.unzip((Iterable)binData);
            list2.put(k, pair3);
        }
        Map binnedData2 = destination$iv$iv;
        for (Map.Entry entry3 : binnedData2.entrySet()) {
            double bin3 = ((Number)entry3.getKey()).doubleValue();
            Pair binData = (Pair)entry3.getValue();
            List<List<Double>> list3 = SeriesUtil.INSTANCE.filterFinite((List)binData.getFirst(), (List)binData.getSecond());
            List binValue = (List)list3.get(0);
            List binWeight = (List)list3.get(1);
            if (binValue.isEmpty()) continue;
            Iterable $this$sortedBy$iv = (Iterable)CollectionsKt.getIndices((Collection)binValue);
            boolean $i$f$sortedBy = false;
            List sortingIndices = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(binValue){
                final /* synthetic */ List $binValue$inlined;
                {
                    this.$binValue$inlined = list2;
                }

                public final int compare(T a2, T b2) {
                    int it = ((Number)a2).intValue();
                    boolean bl = false;
                    Comparable comparable = (Double)this.$binValue$inlined.get(it);
                    it = ((Number)b2).intValue();
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)this.$binValue$inlined.get(it)));
                }
            });
            binHandler.invoke((Object)bin3, (Object)CollectionsKt.slice((List)binValue, (Iterable)sortingIndices), (Object)CollectionsKt.slice((List)binWeight, (Iterable)sortingIndices));
        }
    }

    private final DoubleSpan trimValueRange(List<Double> values2, boolean trim, Double tailsCutoff, Double bandWidth, DensityStat.BandWidthMethod bandWidthMethod, DoubleSpan overallValuesRange) {
        DoubleSpan doubleSpan;
        double bw;
        FiveNumberSummary valueSummary = new FiveNumberSummary(values2);
        Double d = bandWidth;
        double d2 = bw = d != null ? d.doubleValue() : this.bandWidth(bandWidthMethod, values2);
        if (trim) {
            doubleSpan = new DoubleSpan(valueSummary.getMin(), valueSummary.getMax());
        } else if (tailsCutoff == null) {
            doubleSpan = overallValuesRange;
        } else {
            double extend = tailsCutoff * bw;
            doubleSpan = new DoubleSpan(valueSummary.getMin() - extend, valueSummary.getMax() + extend);
        }
        return doubleSpan;
    }

    /*
     * WARNING - void declaration
     */
    public final double bandWidth(@NotNull DensityStat.BandWidthMethod bw, @NotNull List<Double> valuesX) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)bw), (String)"bw");
        Intrinsics.checkNotNullParameter(valuesX, (String)"valuesX");
        int mySize = valuesX.size();
        Iterable $this$filter$iv = valuesX;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Double it = (Double)element$iv$iv;
            boolean bl = false;
            if (!SeriesUtil.INSTANCE.isFinite(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List valuesXFinite = (List)destination$iv$iv;
        FiveNumberSummary dataSummary = new FiveNumberSummary(valuesXFinite);
        double myIQR = dataSummary.getThirdQuartile() - dataSummary.getFirstQuartile();
        double myStdD = this.stdDev(valuesXFinite);
        switch (WhenMappings.$EnumSwitchMapping$0[bw.ordinal()]) {
            case 1: {
                if (myIQR > 0.0) {
                    return 0.9 * Math.min(myStdD, myIQR / 1.34) * Math.pow(mySize, -0.2);
                }
                if (!(myStdD > 0.0)) break;
                return 0.9 * myStdD * Math.pow(mySize, -0.2);
            }
            case 2: {
                if (myIQR > 0.0) {
                    return 1.06 * Math.min(myStdD, myIQR / 1.34) * Math.pow(mySize, -0.2);
                }
                if (!(myStdD > 0.0)) break;
                return 1.06 * myStdD * Math.pow(mySize, -0.2);
            }
        }
        return 1.0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Double> calculateStatQuantile$plot_base(@NotNull List<Double> statSample, @NotNull List<Double> statDensity2, @NotNull List<Double> quantiles) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        List list2;
        Intrinsics.checkNotNullParameter(statSample, (String)"statSample");
        Intrinsics.checkNotNullParameter(statDensity2, (String)"statDensity");
        Intrinsics.checkNotNullParameter(quantiles, (String)"quantiles");
        if (statSample.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        double quantileMaxValue = 1.0;
        if (quantiles.isEmpty()) {
            int n = statSample.size();
            ArrayList<Double> arrayList = new ArrayList<Double>(n);
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Double> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(quantileMaxValue);
            }
            return arrayList;
        }
        double densityValuesSum = CollectionsKt.sumOfDouble((Iterable)statDensity2);
        Iterable $this$runningReduce$iv = statDensity2;
        boolean $i$f$runningReduce = false;
        Iterator iterator$iv = $this$runningReduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list2 = CollectionsKt.emptyList();
        } else {
            Double accumulator$iv = null;
            accumulator$iv = (Double)iterator$iv.next();
            ArrayList<Double> arrayList = new ArrayList<Double>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$runningReduce$iv, (int)10));
            ArrayList<Double> $this$runningReduce_u24lambda_u2420$iv = arrayList;
            boolean bl = false;
            $this$runningReduce_u24lambda_u2420$iv.add(accumulator$iv);
            ArrayList<Double> result$iv = arrayList;
            while (iterator$iv.hasNext()) {
                void elem;
                double d = ((Number)iterator$iv.next()).doubleValue();
                double cumSum = ((Number)accumulator$iv).doubleValue();
                boolean bl2 = false;
                accumulator$iv = cumSum + elem;
                result$iv.add(accumulator$iv);
            }
            list2 = result$iv;
        }
        $this$runningReduce$iv = list2;
        boolean $i$f$map = false;
        iterator$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            double result$iv = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((double)(it / densityValuesSum));
        }
        List dens = (List)destination$iv$iv;
        List sortedQuantiles = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)quantiles));
        int i = 0;
        Iterable $this$map$iv2 = statSample;
        boolean $i$f$map2 = false;
        Iterable $i$f$mapTo22 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sampleValue;
            double bl = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(sampleValue <= ((Number)INSTANCE.pwLinInterp(dens, statSample).invoke(sortedQuantiles.get(i))).doubleValue() ? ((Number)sortedQuantiles.get(i)).doubleValue() : (i < CollectionsKt.getLastIndex((List)sortedQuantiles) ? ((Number)sortedQuantiles.get(++i)).doubleValue() : quantileMaxValue));
        }
        return (List)destination$iv$iv2;
    }

    @NotNull
    public final Function1<Double, Double> pwLinInterp(@NotNull List<Double> x2, @NotNull List<Double> y2) {
        Intrinsics.checkNotNullParameter(x2, (String)"x");
        Intrinsics.checkNotNullParameter(y2, (String)"y");
        return (Function1)new Function1<Double, Double>(x2, y2){
            final /* synthetic */ List<Double> $x;
            final /* synthetic */ List<Double> $y;
            {
                this.$x = $x;
                this.$y = $y;
                super(1);
            }

            @NotNull
            public final Double invoke(double t) {
                int i;
                block4: {
                    int n;
                    List<Double> $this$indexOfFirst$iv = this.$x;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    for (Double item$iv : $this$indexOfFirst$iv) {
                        double it = ((Number)item$iv).doubleValue();
                        boolean bl = false;
                        if (it >= t) {
                            n = index$iv;
                            break block4;
                        }
                        ++index$iv;
                    }
                    n = i = -1;
                }
                if (i == 0) {
                    return (Double)CollectionsKt.first(this.$y);
                }
                if (i == -1) {
                    return (Double)CollectionsKt.last(this.$y);
                }
                double a2 = (((Number)this.$y.get(i)).doubleValue() - ((Number)this.$y.get(i - 1)).doubleValue()) / (((Number)this.$x.get(i)).doubleValue() - ((Number)this.$x.get(i - 1)).doubleValue());
                double b2 = ((Number)this.$y.get(i - 1)).doubleValue() - a2 * ((Number)this.$x.get(i - 1)).doubleValue();
                return a2 * t + b2;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<DataFrame.Variable, List<Double>> expandByGroupEnds$plot_base(@NotNull Map<DataFrame.Variable, ? extends List<Double>> statData, @NotNull DataFrame.Variable axisVar, @NotNull DataFrame.Variable groupVar, @Nullable DataFrame.Variable binVar) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(statData, (String)"statData");
        Intrinsics.checkNotNullParameter((Object)axisVar, (String)"axisVar");
        Intrinsics.checkNotNullParameter((Object)groupVar, (String)"groupVar");
        Iterable $this$map$iv = statData.values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list2 = (List)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.size());
        }
        if (!(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).size() == 1)) {
            boolean $i$a$-require-DensityStatUtil$expandByGroupEnds$82 = false;
            String $i$a$-require-DensityStatUtil$expandByGroupEnds$82 = "All data series in stat data must have equal size";
            throw new IllegalArgumentException($i$a$-require-DensityStatUtil$expandByGroupEnds$82.toString());
        }
        if (!statData.keySet().contains(axisVar)) {
            boolean $i$a$-require-DensityStatUtil$expandByGroupEnds$92 = false;
            String $i$a$-require-DensityStatUtil$expandByGroupEnds$92 = "Stat data should contain variable " + axisVar;
            throw new IllegalArgumentException($i$a$-require-DensityStatUtil$expandByGroupEnds$92.toString());
        }
        if (!statData.keySet().contains(groupVar)) {
            boolean $i$a$-require-DensityStatUtil$expandByGroupEnds$102 = false;
            String $i$a$-require-DensityStatUtil$expandByGroupEnds$102 = "Stat data should contain variable " + groupVar;
            throw new IllegalArgumentException($i$a$-require-DensityStatUtil$expandByGroupEnds$102.toString());
        }
        if (binVar != null && !statData.keySet().contains(binVar)) {
            boolean $i$a$-require-DensityStatUtil$expandByGroupEnds$112 = false;
            String $i$a$-require-DensityStatUtil$expandByGroupEnds$112 = "Stat data should contain variable " + binVar;
            throw new IllegalArgumentException($i$a$-require-DensityStatUtil$expandByGroupEnds$112.toString());
        }
        Map<DataFrame.Variable, ? extends List<Double>> $this$mapValues$iv = statData;
        boolean $i$f$mapValues = false;
        destination$iv$iv = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map2;
            boolean bl2 = false;
            List list3 = new ArrayList();
            object.put(k, list3);
        }
        Map expandedStatData = destination$iv$iv2;
        int n = ((List)MapsKt.getValue(statData, (Object)axisVar)).size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                DataFrame.Variable variable = binVar;
                double prevBin = variable == null ? 0.0 : ((Number)((List)MapsKt.getValue(statData, (Object)variable)).get(i - 1)).doubleValue();
                DataFrame.Variable variable2 = binVar;
                double currBin = variable2 == null ? 0.0 : ((Number)((List)MapsKt.getValue(statData, (Object)variable2)).get(i)).doubleValue();
                double prevGroup = ((Number)((List)MapsKt.getValue(statData, (Object)groupVar)).get(i - 1)).doubleValue();
                double currGroup = ((Number)((List)MapsKt.getValue(statData, (Object)groupVar)).get(i)).doubleValue();
                double prevAxis = ((Number)((List)MapsKt.getValue(statData, (Object)axisVar)).get(i - 1)).doubleValue();
                double currAxis = ((Number)((List)MapsKt.getValue(statData, (Object)axisVar)).get(i)).doubleValue();
                if (prevBin == currBin && !(prevAxis <= currAxis)) {
                    boolean $i$a$-require-DensityStatUtil$expandByGroupEnds$122 = false;
                    String $i$a$-require-DensityStatUtil$expandByGroupEnds$122 = "Data series " + axisVar + " should be ordered";
                    throw new IllegalArgumentException($i$a$-require-DensityStatUtil$expandByGroupEnds$122.toString());
                }
                if (prevBin == currBin && !(prevGroup == currGroup)) {
                    if (prevBin == currBin && !(prevGroup <= currGroup)) {
                        boolean $i$a$-require-DensityStatUtil$expandByGroupEnds$132 = false;
                        String $i$a$-require-DensityStatUtil$expandByGroupEnds$132 = "Data series " + groupVar + " should be ordered";
                        throw new IllegalArgumentException($i$a$-require-DensityStatUtil$expandByGroupEnds$132.toString());
                    }
                    Iterable $this$forEach$iv = statData.keySet();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        DataFrame.Variable it = (DataFrame.Variable)element$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual((Object)it, (Object)groupVar)) {
                            Object v = expandedStatData.get(it);
                            Intrinsics.checkNotNull(v);
                            ((List)v).add(((List)MapsKt.getValue(statData, (Object)it)).get(i));
                            continue;
                        }
                        Object v = expandedStatData.get(it);
                        Intrinsics.checkNotNull(v);
                        ((List)v).add(((List)MapsKt.getValue(statData, (Object)it)).get(i - 1));
                    }
                }
            }
            Iterable $this$forEach$iv = statData.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DataFrame.Variable it = (DataFrame.Variable)element$iv;
                boolean bl = false;
                Object v = expandedStatData.get(it);
                Intrinsics.checkNotNull(v);
                ((List)v).add(((List)MapsKt.getValue(statData, (Object)it)).get(i));
            }
        }
        return expandedStatData;
    }

    public static /* synthetic */ Map expandByGroupEnds$plot_base$default(DensityStatUtil densityStatUtil, Map map2, DataFrame.Variable variable, DataFrame.Variable variable2, DataFrame.Variable variable3, int n, Object object) {
        if ((n & 8) != 0) {
            variable3 = null;
        }
        return densityStatUtil.expandByGroupEnds$plot_base(map2, variable, variable2, variable3);
    }

    @NotNull
    public final Function1<Double, Double> kernel(@NotNull DensityStat.Kernel ker) {
        Function1 function1;
        Intrinsics.checkNotNullParameter((Object)((Object)ker), (String)"ker");
        switch (WhenMappings.$EnumSwitchMapping$1[ker.ordinal()]) {
            case 1: {
                function1 = kernel.1.INSTANCE;
                break;
            }
            case 2: {
                function1 = kernel.2.INSTANCE;
                break;
            }
            case 3: {
                function1 = kernel.3.INSTANCE;
                break;
            }
            case 4: {
                function1 = kernel.4.INSTANCE;
                break;
            }
            case 5: {
                function1 = kernel.5.INSTANCE;
                break;
            }
            case 6: {
                function1 = kernel.6.INSTANCE;
                break;
            }
            default: {
                function1 = kernel.7.INSTANCE;
            }
        }
        return function1;
    }

    @NotNull
    public final Function1<Double, Double> densityFunction$plot_base(@NotNull List<Double> values2, @NotNull List<Double> weights, @Nullable Double bw, @NotNull DensityStat.BandWidthMethod bwMethod, double ad, @NotNull DensityStat.Kernel ker, int fullScanMax) {
        Function1<Double, Double> function1;
        boolean bl;
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter((Object)((Object)bwMethod), (String)"bwMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)ker), (String)"ker");
        Double d = bw;
        double bandWidth = d != null ? d.doubleValue() : this.bandWidth(bwMethod, values2);
        Function1<Double, Double> kernelFun = this.kernel(ker);
        boolean bl2 = bl = values2.size() <= fullScanMax;
        if (bl) {
            function1 = this.densityFunctionFullScan$plot_base(values2, weights, kernelFun, bandWidth, ad);
        } else if (!bl) {
            function1 = this.densityFunctionFast$plot_base(values2, weights, kernelFun, bandWidth, ad);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return function1;
    }

    @NotNull
    public final Function1<Double, Double> densityFunctionFullScan$plot_base(@NotNull List<Double> xs, @NotNull List<Double> weights, @NotNull Function1<? super Double, Double> ker, double bw, double ad) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter(ker, (String)"ker");
        double h = bw * ad;
        return (Function1)new Function1<Double, Double>(xs, ker, h, weights){
            final /* synthetic */ List<Double> $xs;
            final /* synthetic */ Function1<Double, Double> $ker;
            final /* synthetic */ double $h;
            final /* synthetic */ List<Double> $weights;
            {
                this.$xs = $xs;
                this.$ker = $ker;
                this.$h = $h;
                this.$weights = $weights;
                super(1);
            }

            @NotNull
            public final Double invoke(double x2) {
                double sum2 = 0.0;
                int n = this.$xs.size();
                for (int i = 0; i < n; ++i) {
                    sum2 += ((Number)this.$ker.invoke((Object)((x2 - ((Number)this.$xs.get(i)).doubleValue()) / this.$h))).doubleValue() * ((Number)this.$weights.get(i)).doubleValue();
                }
                return sum2 / this.$h;
            }
        };
    }

    @NotNull
    public final Function1<Double, Double> densityFunctionFast$plot_base(@NotNull List<Double> xs, @NotNull List<Double> weights, @NotNull Function1<? super Double, Double> ker, double bw, double ad) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        Intrinsics.checkNotNullParameter(ker, (String)"ker");
        double h = bw * ad;
        double cutoff = h * (double)5;
        return (Function1)new Function1<Double, Double>(xs, cutoff, ker, h, weights){
            final /* synthetic */ List<Double> $xs;
            final /* synthetic */ double $cutoff;
            final /* synthetic */ Function1<Double, Double> $ker;
            final /* synthetic */ double $h;
            final /* synthetic */ List<Double> $weights;
            {
                this.$xs = $xs;
                this.$cutoff = $cutoff;
                this.$ker = $ker;
                this.$h = $h;
                this.$weights = $weights;
                super(1);
            }

            @NotNull
            public final Double invoke(double x2) {
                int to;
                double sum2 = 0.0;
                int from2 = CollectionsKt.binarySearch$default(this.$xs, (Comparable)Double.valueOf(x2 - this.$cutoff), (int)0, (int)0, (int)6, null);
                if (from2 < 0) {
                    from2 = -from2 - 1;
                }
                if ((to = CollectionsKt.binarySearch$default(this.$xs, (Comparable)Double.valueOf(x2 + this.$cutoff), (int)0, (int)0, (int)6, null)) < 0) {
                    to = -to - 1;
                }
                int n = to;
                for (int i = from2; i < n; ++i) {
                    sum2 += ((Number)this.$ker.invoke((Object)((x2 - ((Number)this.$xs.get(i)).doubleValue()) / this.$h))).doubleValue() * ((Number)this.$weights.get(i)).doubleValue();
                }
                return sum2 / this.$h;
            }
        };
    }

    @NotNull
    public final List<Double> createStepValues(@NotNull DoubleSpan range, int n) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        ArrayList<Double> x2 = new ArrayList<Double>();
        double min = range.getLowerEnd();
        double max = range.getUpperEnd();
        double step2 = 0.0;
        if (max == min) {
            max += 0.5;
            min -= 0.5;
        }
        step2 = (max - min) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            x2.add(min + step2 * (double)i);
        }
        return x2;
    }

    @NotNull
    public final DensityStat.Kernel toKernel(@NotNull String method) {
        DensityStat.Kernel kernel2;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        switch (method) {
            case "gaussian": {
                kernel2 = DensityStat.Kernel.GAUSSIAN;
                break;
            }
            case "uniform": 
            case "rectangular": {
                kernel2 = DensityStat.Kernel.RECTANGULAR;
                break;
            }
            case "triangular": {
                kernel2 = DensityStat.Kernel.TRIANGULAR;
                break;
            }
            case "quartic": 
            case "biweight": {
                kernel2 = DensityStat.Kernel.BIWEIGHT;
                break;
            }
            case "epanechikov": 
            case "parabolic": {
                kernel2 = DensityStat.Kernel.EPANECHNIKOV;
                break;
            }
            case "optcosine": {
                kernel2 = DensityStat.Kernel.OPTCOSINE;
                break;
            }
            case "cosine": {
                kernel2 = DensityStat.Kernel.COSINE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported kernel method: '" + method + "'.\nUse one of: gaussian, rectangular, triangular, biweight, epanechikov, optcosine, cos.");
            }
        }
        return kernel2;
    }

    @NotNull
    public final DensityStat.BandWidthMethod toBandWidthMethod(@NotNull String bw) {
        DensityStat.BandWidthMethod bandWidthMethod;
        Intrinsics.checkNotNullParameter((Object)bw, (String)"bw");
        String string = bw;
        if (Intrinsics.areEqual((Object)string, (Object)"nrd0")) {
            bandWidthMethod = DensityStat.BandWidthMethod.NRD0;
        } else if (Intrinsics.areEqual((Object)string, (Object)"nrd")) {
            bandWidthMethod = DensityStat.BandWidthMethod.NRD;
        } else {
            throw new IllegalArgumentException("Unsupported bandwidth method: '" + bw + "'.\nUse one of: nrd0, nrd.");
        }
        return bandWidthMethod;
    }

    @NotNull
    public final double[][] createRawMatrix(@NotNull List<Double> values2, @NotNull List<Double> list2, @NotNull Function1<? super Double, Double> ker, double bw, double ad, @NotNull List<Double> weight) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Intrinsics.checkNotNullParameter(ker, (String)"ker");
        Intrinsics.checkNotNullParameter(weight, (String)"weight");
        double a2 = bw * ad;
        int n = values2.size();
        int x2 = list2.size();
        int n2 = 0;
        double[][] dArrayArray = new double[x2][];
        while (n2 < x2) {
            int n3 = n2++;
            dArrayArray[n3] = new double[n];
        }
        double[][] result2 = dArrayArray;
        for (int row = 0; row < x2; ++row) {
            for (int col = 0; col < n; ++col) {
                double[] dArray = result2[row];
                double d = ((Number)list2.get(row)).doubleValue();
                Double d2 = values2.get(col);
                Intrinsics.checkNotNull((Object)d2);
                double d3 = ((Number)ker.invoke((Object)((d - ((Number)d2).doubleValue()) / a2))).doubleValue();
                Double d4 = weight.get(col);
                Intrinsics.checkNotNull((Object)d4);
                dArray[col] = d3 * Math.sqrt(((Number)d4).doubleValue()) / a2;
            }
        }
        return result2;
    }

    public static final /* synthetic */ DoubleSpan access$trimValueRange(DensityStatUtil $this, List values2, boolean trim, Double tailsCutoff, Double bandWidth, DensityStat.BandWidthMethod bandWidthMethod, DoubleSpan overallValuesRange) {
        return $this.trimValueRange(values2, trim, tailsCutoff, bandWidth, bandWidthMethod, overallValuesRange);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DensityStat.BandWidthMethod.values().length];
            try {
                nArray[DensityStat.BandWidthMethod.NRD0.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DensityStat.BandWidthMethod.NRD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DensityStat.Kernel.values().length];
            try {
                nArray[DensityStat.Kernel.GAUSSIAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DensityStat.Kernel.RECTANGULAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DensityStat.Kernel.TRIANGULAR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DensityStat.Kernel.BIWEIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DensityStat.Kernel.EPANECHNIKOV.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DensityStat.Kernel.OPTCOSINE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

