/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.completion.cloud.kit.universal;

import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.llm.completion.cloud.CloudCompletionRequest;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/completion/cloud/kit/universal/MellumRouting;", "", "<init>", "()V", "knownLanguages", "", "", "getKnownLanguages", "()Ljava/util/Set;", "knownLanguages$delegate", "Lkotlin/Lazy;", "mellumWebLanguages", "getMellumWebLanguages", "mellumWebLanguages$delegate", "classLoader", "Ljava/lang/ClassLoader;", "getClassLoader", "()Ljava/lang/ClassLoader;", "isLanguageKnown", "", "request", "Lcom/intellij/ml/llm/completion/cloud/CloudCompletionRequest;", "getWebLanguages", "loadKnownLanguages", "loadMellumWebLanguages", "intellij.ml.llm.completion"})
@SourceDebugExtension(value={"SMAP\nMellumRouting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MellumRouting.kt\ncom/intellij/ml/llm/completion/cloud/kit/universal/MellumRouting\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,56:1\n1#2:57\n50#3:58\n50#3:60\n13#4:59\n13#4:61\n*S KotlinDebug\n*F\n+ 1 MellumRouting.kt\ncom/intellij/ml/llm/completion/cloud/kit/universal/MellumRouting\n*L\n39#1:58\n51#1:60\n39#1:59\n51#1:61\n*E\n"})
public final class MellumRouting {
    @NotNull
    private final Lazy knownLanguages$delegate = LazyKt.lazy(() -> MellumRouting.knownLanguages_delegate$lambda$0(this));
    @NotNull
    private final Lazy mellumWebLanguages$delegate = LazyKt.lazy(() -> MellumRouting.mellumWebLanguages_delegate$lambda$0(this));

    private final Set<String> getKnownLanguages() {
        Lazy lazy = this.knownLanguages$delegate;
        return (Set)lazy.getValue();
    }

    private final Set<String> getMellumWebLanguages() {
        Lazy lazy = this.mellumWebLanguages$delegate;
        return (Set)lazy.getValue();
    }

    private final ClassLoader getClassLoader() {
        ClassLoader classLoader = MellumRouting.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return classLoader;
    }

    public final boolean isLanguageKnown(@NotNull CloudCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = request.getParameters().getEditor().getVirtualFile();
        if (object == null || (object = object.getExtension()) == null) {
            return false;
        }
        Object fileExtension = object;
        return this.getKnownLanguages().contains(fileExtension);
    }

    @NotNull
    public final Set<String> getWebLanguages() {
        return this.getMellumWebLanguages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Set<String> loadKnownLanguages() {
        try {
            Object object;
            InputStream inputStream = this.getClassLoader().getResourceAsStream("known_languages.txt");
            if (inputStream != null) {
                Object it;
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    it = (InputStream)closeable;
                    boolean bl = false;
                    List<String> list = new BufferedReader(new InputStreamReader((InputStream)it)).lines().toList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
                    it = CollectionsKt.toSet((Iterable)list);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Object object2 = it;
                if (object2 != null) {
                    object = object2;
                    return object;
                }
            }
            object = SetsKt.emptySet();
            return object;
        }
        catch (Exception e) {
            MellumRouting $this$thisMLCompletionLogger$iv = this;
            boolean $i$f$thisMLCompletionLogger = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(MellumRouting.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            MLCompletionLogger.box-impl(MLCompletionLogger.constructor-impl(logger)).error(e);
            return SetsKt.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Set<String> loadMellumWebLanguages() {
        try {
            Object object;
            InputStream inputStream = this.getClassLoader().getResourceAsStream("mellum-web-extensions.txt");
            if (inputStream != null) {
                Object it;
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    it = (InputStream)closeable;
                    boolean bl = false;
                    List<String> list = new BufferedReader(new InputStreamReader((InputStream)it)).lines().toList();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
                    it = CollectionsKt.toSet((Iterable)list);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Object object2 = it;
                if (object2 != null) {
                    object = object2;
                    return object;
                }
            }
            object = SetsKt.emptySet();
            return object;
        }
        catch (Exception e) {
            MellumRouting $this$thisMLCompletionLogger$iv = this;
            boolean $i$f$thisMLCompletionLogger = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(MellumRouting.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            MLCompletionLogger.box-impl(MLCompletionLogger.constructor-impl(logger)).error(e);
            return SetsKt.emptySet();
        }
    }

    private static final Set knownLanguages_delegate$lambda$0(MellumRouting this$0) {
        return this$0.loadKnownLanguages();
    }

    private static final Set mellumWebLanguages_delegate$lambda$0(MellumRouting this$0) {
        return this$0.loadMellumWebLanguages();
    }
}

