/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.properties.completion.pipeline;

import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.postprocessing.transformer.ProposalTransformer;
import com.intellij.ml.llm.properties.completion.util.PropertiesSecretKeyDetector;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u001e\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0015\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b\u001aJ\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u0015\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0013H\u0001\u00a2\u0006\u0002\b\u001fJ\u001d\u0010 \u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010#\u001a\u00020$X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020$X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/ml/llm/properties/completion/pipeline/PropertiesSecretsTransformer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/ProposalTransformer;", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "<init>", "(Lcom/intellij/psi/PsiFile;I)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getOffset", "()I", "transformRaw", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "proposal", "getSuggestedPropertyStart", "isSuggestionInsideComment", "", "propertyText", "", "processSuggestion", "suggestion", "extractPropertyKeyValue", "Lkotlin/Pair;", "hasTemplate", "value", "hasTemplate$intellij_ml_llm_properties_completion", "transformSuggestionWithTemplate", "suggestionPropertyText", "fullValue", "hasTemplateWithDefaultValue", "hasTemplateWithDefaultValue$intellij_ml_llm_properties_completion", "trimTemplateWithDefaultValue", "suggestionStartOffset", "trimTemplateWithDefaultValue$intellij_ml_llm_properties_completion", "PROPERTIES_COMMENT_PREFIX_HASH", "", "PROPERTIES_COMMENT_PREFIX_EXCLAMATION", "PROPERTY_SPLITTING_PATTERN", "Lkotlin/text/Regex;", "PROPERTIES_TEMPLATE_PATTERN", "PROPERTIES_TEMPLATE_WITH_DEFAULT_VALUE_PATTERN", "intellij.ml.llm.properties.completion"})
public final class PropertiesSecretsTransformer
implements ProposalTransformer {
    @NotNull
    private final PsiFile file;
    private final int offset;
    private final char PROPERTIES_COMMENT_PREFIX_HASH;
    private final char PROPERTIES_COMMENT_PREFIX_EXCLAMATION;
    @NotNull
    private final Regex PROPERTY_SPLITTING_PATTERN;
    @NotNull
    private final Regex PROPERTIES_TEMPLATE_PATTERN;
    @NotNull
    private final Regex PROPERTIES_TEMPLATE_WITH_DEFAULT_VALUE_PATTERN;

    public PropertiesSecretsTransformer(@NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.offset = offset;
        this.PROPERTIES_COMMENT_PREFIX_HASH = (char)35;
        this.PROPERTIES_COMMENT_PREFIX_EXCLAMATION = (char)33;
        this.PROPERTY_SPLITTING_PATTERN = new Regex("^((?:[^=:\\s]|\\s+(?![=:]))*?)(\\s*[=:]\\s*|\\s+)(.*)$", RegexOption.DOT_MATCHES_ALL);
        this.PROPERTIES_TEMPLATE_PATTERN = new Regex("\\$\\{[^}]+}");
        this.PROPERTIES_TEMPLATE_WITH_DEFAULT_VALUE_PATTERN = new Regex("\\$\\{([^:}]+):[^}]*}");
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    public final int getOffset() {
        return this.offset;
    }

    @Override
    @NotNull
    public RawMLCompletionProposal transformRaw(@NotNull RawMLCompletionProposal proposal) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)proposal, (String)"proposal");
        int suggestedPropertyStart = this.getSuggestedPropertyStart();
        StringBuilder $this$transformRaw_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String string = this.file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = this.offset;
        String string3 = string2.substring(suggestedPropertyStart, n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        $this$transformRaw_u24lambda_u240.append(string3);
        $this$transformRaw_u24lambda_u240.append(proposal.getSuggestion());
        String propertyText = stringBuilder.toString();
        if (this.isSuggestionInsideComment(propertyText)) {
            return proposal;
        }
        String processedSuggestion = this.processSuggestion(propertyText, proposal.getSuggestion());
        return proposal.withSuggestion(processedSuggestion);
    }

    private final int getSuggestedPropertyStart() {
        String string = this.file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.lastIndexOf$default((CharSequence)string, (char)'\n', (int)(this.offset - 1), (boolean)false, (int)4, null) + 1;
    }

    private final boolean isSuggestionInsideComment(String propertyText) {
        return StringsKt.startsWith$default((CharSequence)propertyText, (char)this.PROPERTIES_COMMENT_PREFIX_HASH, (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)propertyText, (char)this.PROPERTIES_COMMENT_PREFIX_EXCLAMATION, (boolean)false, (int)2, null);
    }

    private final String processSuggestion(String propertyText, String suggestion2) {
        Pair<String, String> pair = this.extractPropertyKeyValue(propertyText);
        if (pair == null) {
            return suggestion2;
        }
        Pair<String, String> pair2 = pair;
        String key = (String)pair2.component1();
        String value = (String)pair2.component2();
        if (((CharSequence)value).length() == 0 || !PropertiesSecretKeyDetector.INSTANCE.isSecretKey(key)) {
            return suggestion2;
        }
        if (!this.hasTemplate$intellij_ml_llm_properties_completion(value)) {
            return StringsKt.dropLast((String)((Object)StringsKt.trimEnd((CharSequence)suggestion2)).toString(), (int)value.length());
        }
        return this.transformSuggestionWithTemplate(suggestion2, value);
    }

    private final Pair<String, String> extractPropertyKeyValue(String propertyText) {
        Object object;
        Object key;
        String trimmedPropertyText = ((Object)StringsKt.trim((CharSequence)propertyText)).toString();
        if (((CharSequence)trimmedPropertyText).length() == 0) {
            return null;
        }
        MatchResult matchResult = this.PROPERTY_SPLITTING_PATTERN.matchEntire((CharSequence)trimmedPropertyText);
        Object object2 = matchResult;
        if (object2 == null || (object2 = object2.getGroups().get(1)) == null || (object2 = object2.getValue()) == null) {
            object2 = key = trimmedPropertyText;
        }
        if ((object = matchResult) == null || (object = object.getGroups().get(3)) == null || (object = object.getValue()) == null) {
            object = "";
        }
        Object value = object;
        return new Pair((Object)((Object)StringsKt.trim((CharSequence)((CharSequence)key))).toString(), (Object)((Object)StringsKt.trim((CharSequence)((CharSequence)value))).toString());
    }

    @VisibleForTesting
    public final boolean hasTemplate$intellij_ml_llm_properties_completion(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.PROPERTIES_TEMPLATE_PATTERN.containsMatchIn((CharSequence)value);
    }

    private final String transformSuggestionWithTemplate(String suggestionPropertyText, String fullValue) {
        if (!this.hasTemplateWithDefaultValue$intellij_ml_llm_properties_completion(fullValue)) {
            return suggestionPropertyText;
        }
        if (StringsKt.contains$default((CharSequence)suggestionPropertyText, (CharSequence)fullValue, (boolean)false, (int)2, null)) {
            String trimmedFullValue = this.trimTemplateWithDefaultValue$intellij_ml_llm_properties_completion(fullValue, 0);
            return StringsKt.replace$default((String)suggestionPropertyText, (String)fullValue, (String)trimmedFullValue, (boolean)false, (int)4, null);
        }
        return this.trimTemplateWithDefaultValue$intellij_ml_llm_properties_completion(fullValue, fullValue.length() - suggestionPropertyText.length());
    }

    @VisibleForTesting
    public final boolean hasTemplateWithDefaultValue$intellij_ml_llm_properties_completion(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.PROPERTIES_TEMPLATE_WITH_DEFAULT_VALUE_PATTERN.containsMatchIn((CharSequence)value);
    }

    @VisibleForTesting
    @NotNull
    public final String trimTemplateWithDefaultValue$intellij_ml_llm_properties_completion(@NotNull String value, int suggestionStartOffset) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence charSequence = value;
        Regex regex = this.PROPERTIES_TEMPLATE_WITH_DEFAULT_VALUE_PATTERN;
        Function1 function1 = PropertiesSecretsTransformer::trimTemplateWithDefaultValue$lambda$0;
        String trimmedValue = regex.replace(charSequence, function1);
        return suggestionStartOffset > 0 ? StringsKt.drop((String)trimmedValue, (int)suggestionStartOffset) : trimmedValue;
    }

    private static final CharSequence trimTemplateWithDefaultValue$lambda$0(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        return "${" + matchResult.getGroupValues().get(1) + "}";
    }
}

