/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.zmq.protocol;

import java.io.Closeable;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImpl;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImplKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.JsonExtensionsKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.HMAC;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.JupyterZmqSocket;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.JupyterZmqSocketImpl;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.JupyterZmqSocketImplKt;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.ZmqSocketWithCancellationImpl;
import org.slf4j.Logger;
import org.zeromq.ZMQ;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\n\u0010 \u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010!\u001a\u00020\u001eH\u0002J\b\u0010\"\u001a\u00020\u001cH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqSocketImpl;", "Ljava/io/Closeable;", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqSocket;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;", "name", "", "socket", "Lorg/zeromq/ZMQ$Socket;", "address", "hmac", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/HMAC;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;Ljava/lang/String;Lorg/zeromq/ZMQ$Socket;Ljava/lang/String;Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/HMAC;)V", "getName", "()Ljava/lang/String;", "logger", "Lorg/slf4j/Logger;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "zmqSocket", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketWithCancellationImpl;", "getZmqSocket", "()Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketWithCancellationImpl;", "bind", "", "connect", "sendRawMessage", "", "msg", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "doSendRawMessage", "receiveRawMessage", "doReceiveRawMessage", "close", "zmq-protocol"})
@SourceDebugExtension(value={"SMAP\nJupyterZmqSocketImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterZmqSocketImpl.kt\norg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqSocketImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,157:1\n1869#2,2:158\n1563#2:160\n1634#2,2:161\n1636#2:165\n1#3:163\n205#4:164\n222#4:166\n*S KotlinDebug\n*F\n+ 1 JupyterZmqSocketImpl.kt\norg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqSocketImpl\n*L\n60#1:158,2\n65#1:160\n65#1:161,2\n65#1:165\n66#1:164\n108#1:166\n*E\n"})
public final class JupyterZmqSocketImpl
implements Closeable,
JupyterZmqSocket {
    @NotNull
    private final String name;
    @NotNull
    private final String address;
    @NotNull
    private final HMAC hmac;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final ZmqSocketWithCancellationImpl zmqSocket;

    public JupyterZmqSocketImpl(@NotNull KernelLoggerFactory loggerFactory, @NotNull String name, @NotNull ZMQ.Socket socket, @NotNull String address, @NotNull HMAC hmac) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)hmac, (String)"hmac");
        this.name = name;
        this.address = address;
        this.hmac = hmac;
        this.logger = KernelLoggerFactoryKt.getLogger(loggerFactory, Reflection.getOrCreateKotlinClass(this.getClass()));
        this.lock = new ReentrantLock();
        this.zmqSocket = new ZmqSocketWithCancellationImpl(socket);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public ZmqSocketWithCancellationImpl getZmqSocket() {
        return this.zmqSocket;
    }

    @Override
    public boolean bind() {
        boolean res = this.getZmqSocket().bind$zmq_protocol(this.address);
        this.logger.debug("[" + this.name + "] listen: " + this.address);
        return res;
    }

    @Override
    public boolean connect() {
        boolean res = this.getZmqSocket().connect$zmq_protocol(this.address);
        this.logger.debug("[" + this.name + "] connected: " + this.address);
        return res;
    }

    @Override
    public void sendRawMessage(@NotNull RawMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.logger.debug("[{}] snd>: {}", (Object)this.name, (Object)msg);
        this.doSendRawMessage(msg);
    }

    /*
     * WARNING - void declaration
     */
    private final void doSendRawMessage(RawMessage msg) {
        void $this$mapTo$iv$iv;
        Object it;
        this.getZmqSocket().assertNotCancelled$zmq_protocol();
        Iterable $this$forEach$iv = msg.getId();
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (byte[])element$iv;
            boolean bl = false;
            this.getZmqSocket().sendMore((byte[])it);
        }
        this.getZmqSocket().sendMore(JupyterZmqSocketImplKt.access$getMESSAGE_DELIMITER$p());
        Object[] $i$f$forEach22 = new KProperty1[]{doSendRawMessage.properties.1.INSTANCE, doSendRawMessage.properties.2.INSTANCE, doSendRawMessage.properties.3.INSTANCE, doSendRawMessage.properties.4.INSTANCE};
        List properties2 = CollectionsKt.listOf((Object[])$i$f$forEach22);
        Iterable $this$map$iv = properties2;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            Collection collection;
            block6: {
                block5: {
                    void this_$iv;
                    void prop;
                    KProperty1 kProperty1 = (KProperty1)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    object = (JsonElement)prop.get((Object)msg);
                    if (object == null) break block5;
                    JsonElement it2 = object;
                    boolean bl2 = false;
                    Json json = RawMessageImplKt.getMessageFormat();
                    JsonElement value$iv = it2;
                    boolean $i$f$encodeToString = false;
                    this_$iv.getSerializersModule();
                    String string = this_$iv.encodeToString((SerializationStrategy)JsonElement.Companion.serializer(), (Object)value$iv);
                    object = string;
                    if (string == null) break block5;
                    byte[] byArray = object.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    object = byArray;
                    if (byArray != null) break block6;
                }
                object = JupyterZmqSocketImplKt.access$getEmptyJsonObjectStringBytes$p();
            }
            collection.add(object);
        }
        List signableMsg = (List)destination$iv$iv;
        this.getZmqSocket().sendMore(this.hmac.invoke(signableMsg));
        int n = signableMsg.size() - 1;
        for (int i = 0; i < n; ++i) {
            this.getZmqSocket().sendMore((byte[])signableMsg.get(i));
        }
        this.getZmqSocket().send((byte[])CollectionsKt.last((List)signableMsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RawMessage receiveRawMessage() throws InterruptedException {
        RawMessage rawMessage;
        try {
            RawMessage rawMessage2;
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                rawMessage2 = this.doReceiveRawMessage();
            }
            finally {
                lock.unlock();
            }
            RawMessage msg = rawMessage2;
            this.logger.debug("[{}] >rcv: {}", (Object)this.name, (Object)msg);
        }
        catch (SignatureException e) {
            this.logger.error("[" + this.name + "] " + e.getMessage());
            rawMessage = null;
        }
        return rawMessage;
    }

    private final RawMessage doReceiveRawMessage() throws InterruptedException {
        this.getZmqSocket().assertNotCancelled$zmq_protocol();
        List ids = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.getZmqSocket().recv()), (Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence(() -> JupyterZmqSocketImpl.doReceiveRawMessage$lambda$0(this)), JupyterZmqSocketImpl::doReceiveRawMessage$lambda$1));
        String string = this.getZmqSocket().recvString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String sig = string;
        byte[] header = this.getZmqSocket().recv();
        byte[] parentHeader = this.getZmqSocket().recv();
        byte[] metadata = this.getZmqSocket().recv();
        byte[] content = this.getZmqSocket().recv();
        byte[][] byArrayArray = new byte[][]{header, parentHeader, metadata, content};
        String calculatedSig = this.hmac.invoke(byArrayArray);
        if (!Intrinsics.areEqual((Object)sig, (Object)calculatedSig)) {
            throw new SignatureException("Invalid signature: expected " + calculatedSig + ", received " + sig + " - " + ids);
        }
        JsonElement jsonElement = JupyterZmqSocketImpl.doReceiveRawMessage$parseJson(header);
        Intrinsics.checkNotNull((Object)jsonElement);
        JsonElement jsonElement2 = JupyterZmqSocketImpl.doReceiveRawMessage$parseJson(parentHeader);
        JsonElement jsonElement3 = JupyterZmqSocketImpl.doReceiveRawMessage$parseJson(metadata);
        return new RawMessageImpl(ids, JsonElementKt.getJsonObject((JsonElement)jsonElement), (JsonObject)(jsonElement2 != null ? JsonElementKt.getJsonObject((JsonElement)jsonElement2) : null), (JsonObject)(jsonElement3 != null ? JsonElementKt.getJsonObject((JsonElement)jsonElement3) : null), JupyterZmqSocketImpl.doReceiveRawMessage$orEmptyObject(JupyterZmqSocketImpl.doReceiveRawMessage$parseJson(content)));
    }

    @Override
    public void close() {
        this.getZmqSocket().close();
    }

    private static final byte[] doReceiveRawMessage$lambda$0(JupyterZmqSocketImpl this$0) {
        return this$0.getZmqSocket().recv();
    }

    private static final boolean doReceiveRawMessage$lambda$1(byte[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Arrays.equals(it, JupyterZmqSocketImplKt.access$getMESSAGE_DELIMITER$p());
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonElement doReceiveRawMessage$parseJson(byte[] $this$doReceiveRawMessage_u24parseJson) {
        void this_$iv;
        Json json = (Json)Json.Default;
        String string$iv = new String($this$doReceiveRawMessage_u24parseJson, Charsets.UTF_8);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        JsonElement json2 = (JsonElement)this_$iv.decodeFromString((DeserializationStrategy)JsonElement.Companion.serializer(), string$iv);
        return json2 instanceof JsonObject && ((JsonObject)json2).isEmpty() ? null : json2;
    }

    private static final JsonElement doReceiveRawMessage$orEmptyObject(JsonElement $this$doReceiveRawMessage_u24orEmptyObject) {
        JsonElement jsonElement = $this$doReceiveRawMessage_u24orEmptyObject;
        if (jsonElement == null) {
            jsonElement = (JsonElement)JsonExtensionsKt.getEMPTY((Json)Json.Default);
        }
        return jsonElement;
    }
}

