/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.idea.AppModeAssertions;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.terminal.frontend.view.impl.TerminalOutputModelController;
import com.intellij.terminal.frontend.view.impl.TerminalTypeAhead;
import com.intellij.terminal.frontend.view.impl.TerminalTypeAheadOutputModelControllerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.MutableTerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.MutableTerminalOutputModelKt;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModelImplKt;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.session.TerminalContentUpdatedEvent;
import org.jetbrains.plugins.terminal.session.TerminalCursorPositionChangedEvent;
import org.jetbrains.plugins.terminal.session.TerminalOutputBlock;
import org.jetbrains.plugins.terminal.session.TerminalOutputEvent;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0012H\u0016J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\b\u0010$\u001a\u00020\u0012H\u0002J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170&H\u0002J\u0016\u0010(\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00170&H\u0002J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0017H\u0002J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalTypeAheadOutputModelController;", "Lcom/intellij/terminal/frontend/view/impl/TerminalOutputModelController;", "Lcom/intellij/terminal/frontend/view/impl/TerminalTypeAhead;", "project", "Lcom/intellij/openapi/project/Project;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModel;", "blocksModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;Lkotlinx/coroutines/CoroutineScope;)V", "model", "getModel", "()Lorg/jetbrains/plugins/terminal/block/reworked/MutableTerminalOutputModel;", "delayedUpdateRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "backendEventsDelayed", "", "delayedEvents", "", "Lorg/jetbrains/plugins/terminal/session/TerminalOutputEvent;", "isTypeAheadEnabled", "type", "string", "", "backspace", "updateContent", "event", "Lorg/jetbrains/plugins/terminal/session/TerminalContentUpdatedEvent;", "updateCursorPosition", "Lorg/jetbrains/plugins/terminal/session/TerminalCursorPositionChangedEvent;", "applyPendingUpdates", "handleBackendEvent", "delayUpdatesFromBackend", "mergeOutputEvents", "", "events", "doApplyDelayedEvents", "applyOutputEvent", "updateOutputModel", "update", "Ljava/lang/Runnable;", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalTypeAheadOutputModelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTypeAheadOutputModelController.kt\ncom/intellij/terminal/frontend/view/impl/TerminalTypeAheadOutputModelController\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n67#2,4:239\n67#2,4:243\n13#2:264\n543#3,6:247\n808#3,11:253\n*S KotlinDebug\n*F\n+ 1 TerminalTypeAheadOutputModelController.kt\ncom/intellij/terminal/frontend/view/impl/TerminalTypeAheadOutputModelController\n*L\n69#1:239,4\n88#1:243,4\n193#1:264\n137#1:247,6\n139#1:253,11\n*E\n"})
public final class TerminalTypeAheadOutputModelController
implements TerminalOutputModelController,
TerminalTypeAhead {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MutableTerminalOutputModel outputModel;
    @NotNull
    private final TerminalBlocksModel blocksModel;
    @NotNull
    private final MutableTerminalOutputModel model;
    @NotNull
    private final MutableSharedFlow<Unit> delayedUpdateRequests;
    private boolean backendEventsDelayed;
    @NotNull
    private List<TerminalOutputEvent> delayedEvents;
    @NotNull
    private static final Logger LOG;
    private static final long BACKEND_EVENTS_DELAY_MILLIS;

    public TerminalTypeAheadOutputModelController(@NotNull Project project, @NotNull MutableTerminalOutputModel outputModel, @NotNull TerminalBlocksModel blocksModel, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)blocksModel, (String)"blocksModel");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.outputModel = outputModel;
        this.blocksModel = blocksModel;
        this.model = this.outputModel;
        this.delayedUpdateRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.delayedEvents = new ArrayList();
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalTypeAheadOutputModelController this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.debounce((Flow)((Flow)this.this$0.delayedUpdateRequests), (long)BACKEND_EVENTS_DELAY_MILLIS).collect(new FlowCollector(){

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                this$0.applyPendingUpdates();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    @NotNull
    public MutableTerminalOutputModel getModel() {
        return this.model;
    }

    private final boolean isTypeAheadEnabled() {
        return Registry.Companion.is("terminal.type.ahead", false) && TerminalBlocksModelImplKt.isCommandTypingMode(this.blocksModel);
    }

    @Override
    public void type(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (!this.isTypeAheadEnabled()) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)TerminalTypeAheadOutputModelControllerKt.access$getTextAfterCursor(this.outputModel))) {
            this.updateOutputModel(() -> TerminalTypeAheadOutputModelController.type$lambda$0(this, string));
            this.delayUpdatesFromBackend();
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("String typed prediction inserted: '" + string + "'");
            }
        }
    }

    @Override
    public void backspace() {
        TerminalOffset commandStartOffset;
        if (!this.isTypeAheadEnabled()) {
            return;
        }
        TerminalOutputBlock lastBlock = (TerminalOutputBlock)CollectionsKt.lastOrNull(this.blocksModel.getBlocks());
        TerminalOffset cursorOffset = this.outputModel.getCursorOffset();
        TerminalOutputBlock terminalOutputBlock = lastBlock;
        TerminalOffset terminalOffset = commandStartOffset = terminalOutputBlock != null ? terminalOutputBlock.getCommandStartOffset() : null;
        if (lastBlock == null || commandStartOffset != null && cursorOffset.compareTo(commandStartOffset) <= 0 || Intrinsics.areEqual((Object)cursorOffset, (Object)this.outputModel.getStartOffset())) {
            return;
        }
        if (StringsKt.isBlank((CharSequence)TerminalTypeAheadOutputModelControllerKt.access$getTextAfterCursor(this.outputModel))) {
            this.updateOutputModel(() -> TerminalTypeAheadOutputModelController.backspace$lambda$0(this));
            this.delayUpdatesFromBackend();
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Backspace prediction applied");
            }
        }
    }

    @Override
    public void updateContent(@NotNull TerminalContentUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.handleBackendEvent(event);
    }

    @Override
    public void updateCursorPosition(@NotNull TerminalCursorPositionChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.handleBackendEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyPendingUpdates() {
        if (!this.backendEventsDelayed) {
            return;
        }
        try {
            List<TerminalOutputEvent> merged = this.mergeOutputEvents(this.delayedEvents);
            this.doApplyDelayedEvents(merged);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error applying delayed events", (Throwable)e);
        }
        finally {
            this.delayedEvents.clear();
            this.backendEventsDelayed = false;
        }
    }

    private final void handleBackendEvent(TerminalOutputEvent event) {
        if (this.backendEventsDelayed) {
            this.delayedEvents.add(event);
        } else {
            this.updateOutputModel(() -> TerminalTypeAheadOutputModelController.handleBackendEvent$lambda$0(this, event));
        }
    }

    private final void delayUpdatesFromBackend() {
        this.backendEventsDelayed = true;
        if (!this.delayedUpdateRequests.tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<TerminalOutputEvent> mergeOutputEvents(List<? extends TerminalOutputEvent> events) {
        void $this$filterIsInstanceTo$iv$iv;
        Object object;
        Object element$iv;
        block5: {
            List<? extends TerminalOutputEvent> $this$lastOrNull$iv = events;
            boolean $i$f$lastOrNull = false;
            ListIterator<? extends TerminalOutputEvent> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                element$iv = iterator$iv.previous();
                TerminalOutputEvent it = element$iv;
                boolean bl = false;
                if (!(it instanceof TerminalCursorPositionChangedEvent)) continue;
                object = element$iv;
                break block5;
            }
            object = null;
        }
        TerminalOutputEvent lastCursorUpdate = (TerminalOutputEvent)object;
        Iterable $this$filterIsInstance$iv = events;
        boolean $i$f$filterIsInstance = false;
        element$iv = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TerminalContentUpdatedEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List contentEvents = (List)destination$iv$iv;
        if (contentEvents.isEmpty()) {
            return CollectionsKt.listOfNotNull((Object)lastCursorUpdate);
        }
        List result2 = new ArrayList();
        int curIndex = 0;
        while (curIndex < contentEvents.size()) {
            long curLine = ((TerminalContentUpdatedEvent)contentEvents.get(curIndex)).getStartLineLogicalIndex();
            while (curIndex < contentEvents.size() && ((TerminalContentUpdatedEvent)contentEvents.get(curIndex)).getStartLineLogicalIndex() == curLine) {
                ++curIndex;
            }
            result2.add(contentEvents.get(curIndex - 1));
        }
        return lastCursorUpdate != null ? CollectionsKt.plus((Collection)result2, (Object)lastCursorUpdate) : result2;
    }

    private final void doApplyDelayedEvents(List<? extends TerminalOutputEvent> events) {
        this.updateOutputModel(() -> TerminalTypeAheadOutputModelController.doApplyDelayedEvents$lambda$0(events, this));
    }

    private final void applyOutputEvent(TerminalOutputEvent event) {
        TerminalOutputEvent terminalOutputEvent = event;
        if (terminalOutputEvent instanceof TerminalContentUpdatedEvent) {
            MutableTerminalOutputModelKt.updateContent(this.outputModel, (TerminalContentUpdatedEvent)event);
        } else if (terminalOutputEvent instanceof TerminalCursorPositionChangedEvent) {
            this.outputModel.updateCursorPosition(((TerminalCursorPositionChangedEvent)event).getLogicalLineIndex(), ((TerminalCursorPositionChangedEvent)event).getColumnIndex());
        } else {
            throw new IllegalStateException(("Unexpected event type: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName()).toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void updateOutputModel(Runnable update) {
        LookupEx lookup = LookupManager.getInstance((Project)this.project).getActiveLookup();
        if (lookup != null) {
            Editor editor = lookup.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            if (TerminalDataContextUtils.INSTANCE.isReworkedTerminalEditor(editor)) {
                lookup.performGuardedChange(update);
                return;
            }
        }
        update.run();
    }

    private static final void type$lambda$0(TerminalTypeAheadOutputModelController this$0, String $string) {
        TerminalTypeAheadOutputModelControllerKt.access$insertAtCursor(this$0.outputModel, $string);
    }

    private static final void backspace$lambda$0(TerminalTypeAheadOutputModelController this$0) {
        TerminalTypeAheadOutputModelControllerKt.access$backspace(this$0.outputModel);
    }

    private static final void handleBackendEvent$lambda$0(TerminalTypeAheadOutputModelController this$0, TerminalOutputEvent $event) {
        this$0.applyOutputEvent($event);
    }

    private static final void doApplyDelayedEvents$lambda$0(List $events, TerminalTypeAheadOutputModelController this$0) {
        for (TerminalOutputEvent event : $events) {
            this$0.applyOutputEvent(event);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalTypeAheadOutputModelController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        BACKEND_EVENTS_DELAY_MILLIS = AppModeAssertions.isMonolith() ? 100L : 500L;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalTypeAheadOutputModelController$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "BACKEND_EVENTS_DELAY_MILLIS", "", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

