/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.util.Key;
import com.intellij.terminal.frontend.view.impl.TerminalHeuristicsBasedCommandFinishTracker;
import com.intellij.terminal.frontend.view.impl.TerminalSessionController;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalShellIntegrationEventsListener;
import org.jetbrains.plugins.terminal.session.TerminalState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalVfsSynchronizer;", "", "sessionController", "Lcom/intellij/terminal/frontend/view/impl/TerminalSessionController;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "terminalComponent", "Ljavax/swing/JComponent;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/terminal/frontend/view/impl/TerminalSessionController;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Ljavax/swing/JComponent;Lkotlinx/coroutines/CoroutineScope;)V", "heuristicBasedRefresherScope", "heuristicBasedRefresher", "Lcom/intellij/terminal/frontend/view/impl/TerminalHeuristicsBasedCommandFinishTracker;", "handleKeyPressed", "", "e", "Ljava/awt/event/KeyEvent;", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalVfsSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalVfsSynchronizer.kt\ncom/intellij/terminal/frontend/view/impl/TerminalVfsSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n60#2,5:102\n13#2:107\n*S KotlinDebug\n*F\n+ 1 TerminalVfsSynchronizer.kt\ncom/intellij/terminal/frontend/view/impl/TerminalVfsSynchronizer\n*L\n41#1:102,5\n99#1:107\n*E\n"})
public final class TerminalVfsSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope heuristicBasedRefresherScope;
    @NotNull
    private final TerminalHeuristicsBasedCommandFinishTracker heuristicBasedRefresher;
    @NotNull
    private static final Key<TerminalVfsSynchronizer> KEY;
    @NotNull
    private static final Logger LOG;

    public TerminalVfsSynchronizer(@NotNull TerminalSessionController sessionController, @NotNull TerminalOutputModel outputModel, @NotNull TerminalSessionModel sessionModel, @NotNull JComponent terminalComponent, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)sessionController, (String)"sessionController");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)terminalComponent, (String)"terminalComponent");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.heuristicBasedRefresherScope = com.intellij.platform.util.coroutines.CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"Heuristic based VFS refresher", null, (boolean)false, (int)6, null);
        this.heuristicBasedRefresher = new TerminalHeuristicsBasedCommandFinishTracker(outputModel, this.heuristicBasedRefresherScope, (Function0<Unit>)((Function0)TerminalVfsSynchronizer::heuristicBasedRefresher$lambda$0));
        Disposable disposable = CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope);
        sessionController.addShellIntegrationListener(disposable, new TerminalShellIntegrationEventsListener(){

            @Override
            public void commandFinished(String command2, int exitCode, String currentDirectory) {
                Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
                Intrinsics.checkNotNullParameter((Object)currentDirectory, (String)"currentDirectory");
                SaveAndSyncHandler.Companion.getInstance().scheduleRefresh();
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Command finished, schedule VFS refresh.", e$iv);
                }
            }
        });
        RevertOnDisposeUtilKt.addFocusListener((Component)terminalComponent, (Disposable)disposable, (FocusListener)new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (GeneralSettings.Companion.getInstance().isSaveOnFrameDeactivation()) {
                    WriteIntentReadAction.run(2::focusGained$lambda$0);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (GeneralSettings.Companion.getInstance().isSyncOnFrameActivation()) {
                    SaveAndSyncHandler.Companion.getInstance().scheduleRefresh();
                    Logger $this$debug_u24default$iv = LOG;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl = false;
                        logger.debug("Focus lost, schedule VFS refresh.", e$iv);
                    }
                }
            }

            private static final void focusGained$lambda$0() {
                FileDocumentManager.getInstance().saveAllDocuments();
                Logger $this$debug_u24default$iv = LOG;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Focus gained, save all documents to VFS.", e$iv);
                }
            }
        });
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sessionModel, this, null){
            Object L$0;
            int label;
            final /* synthetic */ TerminalSessionModel $sessionModel;
            final /* synthetic */ TerminalVfsSynchronizer this$0;
            {
                this.$sessionModel = $sessionModel;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        final Ref.BooleanRef shellIntegrationEnabled = new Ref.BooleanRef();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)shellIntegrationEnabled);
                        this.label = 1;
                        Object object2 = this.$sessionModel.getTerminalState().collect(new FlowCollector(){

                            public final Object emit(TerminalState state, Continuation<? super Unit> $completion) {
                                if (state.isShellIntegrationEnabled() != shellIntegrationEnabled.element) {
                                    shellIntegrationEnabled.element = state.isShellIntegrationEnabled();
                                    kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this$0.heuristicBasedRefresherScope, null, (int)1, null);
                                    Logger $this$debug_u24default$iv = LOG;
                                    Throwable e$iv = null;
                                    boolean $i$f$debug = false;
                                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                                        Logger logger = $this$debug_u24default$iv;
                                        boolean bl = false;
                                        logger.debug("Shell integration initialized, cancel heuristic-based VFS refresher.", e$iv);
                                    }
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        Ref.BooleanRef shellIntegrationEnabled = (Ref.BooleanRef)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @RequiresEdt
    public final void handleKeyPressed(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (JobKt.isActive((CoroutineContext)this.heuristicBasedRefresherScope.getCoroutineContext())) {
            this.heuristicBasedRefresher.handleKeyPressed(e);
        }
    }

    private static final Unit heuristicBasedRefresher$lambda$0() {
        SaveAndSyncHandler.Companion.getInstance().scheduleRefresh();
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Command finished, schedule VFS refresh.", e$iv);
        }
        return Unit.INSTANCE;
    }

    static {
        Key key = Key.create((String)"TerminalVfsSynchronizer");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalVfsSynchronizer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalVfsSynchronizer$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/terminal/frontend/view/impl/TerminalVfsSynchronizer;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<TerminalVfsSynchronizer> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

