/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.jetbrains.python.requirements.PackageUtilsKt;
import com.jetbrains.python.requirements.RequirementsCompletionUtilKt;
import com.jetbrains.python.requirements.RequirementsFile;
import com.jetbrains.python.requirements.psi.NameReq;
import com.jetbrains.python.requirements.psi.RequirementsTypes;
import com.jetbrains.python.requirements.psi.VersionStmt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/requirements/RequirementsVersionCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "getNameByParent", "", "parent", "Lcom/intellij/psi/PsiElement;", "getNameBySiblings", "position", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nRequirementsVersionCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequirementsVersionCompletionContributor.kt\ncom/jetbrains/python/requirements/RequirementsVersionCompletionContributor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,44:1\n183#2,2:45\n*S KotlinDebug\n*F\n+ 1 RequirementsVersionCompletionContributor.kt\ncom/jetbrains/python/requirements/RequirementsVersionCompletionContributor\n*L\n40#1:45,2\n*E\n"})
public final class RequirementsVersionCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (!(parameters.getOriginalFile() instanceof RequirementsFile)) {
            return;
        }
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        PsiElement parent = position.getParent();
        Project project = parameters.getEditor().getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = this.getNameBySiblings(position);
        if (string == null && (string = this.getNameByParent(parent)) == null) {
            return;
        }
        String packageName = string;
        PsiFile psiFile = parameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        Sdk sdk2 = PackageUtilsKt.getPythonSdk(psiFile);
        if (sdk2 == null) {
            return;
        }
        Sdk sdk3 = sdk2;
        RequirementsCompletionUtilKt.completeVersions(packageName, project2, sdk3, result2, false);
    }

    private final String getNameByParent(PsiElement parent) {
        if (!(parent instanceof VersionStmt)) {
            return null;
        }
        Object object = (NameReq)PsiTreeUtil.getParentOfType((PsiElement)parent, NameReq.class);
        return object != null && (object = object.getName()) != null ? object.getText() : null;
    }

    private final String getNameBySiblings(PsiElement position) {
        PsiElement identifier;
        Object v1;
        block2: {
            LeafPsiElement leafPsiElement = position instanceof LeafPsiElement ? (LeafPsiElement)position : null;
            if (!Intrinsics.areEqual((Object)(leafPsiElement != null ? leafPsiElement.getElementType() : null), (Object)RequirementsTypes.VERSION)) {
                return null;
            }
            Sequence $this$firstOrNull$iv = PsiTreeUtilKt.getPrevLeafs((PsiElement)position);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)RequirementsTypes.IDENTIFIER)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        PsiElement psiElement = identifier = (PsiElement)v1;
        return psiElement != null ? psiElement.getText() : null;
    }
}

