/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.core;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.station.comms.common.ServicesServerHostApplication;
import com.intellij.station.comms.common.api.StationServiceRequestHandler;
import com.intellij.station.comms.common.utils.StationConstants;
import com.intellij.station.core.services.ServiceImplementationBean;
import java.net.UnixDomainSocketAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\u001a\u0010\u000f\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u001a\u0010\u0011\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/station/core/IdeServicesHostApplication;", "Lcom/intellij/station/comms/common/ServicesServerHostApplication;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "ideId", "", "getIdeId", "()Ljava/lang/String;", "getKnownEndpoints", "", "serviceCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/station/comms/common/api/StationServiceRequestHandler;", "getServiceForEndpoint", "endpoint", "getServiceForEndpointImpl", "getBindAddress", "Ljava/net/UnixDomainSocketAddress;", "Companion", "intellij.station.core"})
@SourceDebugExtension(value={"SMAP\nIdeServicesHostApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeServicesHostApplication.kt\ncom/intellij/station/core/IdeServicesHostApplication\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1563#2:59\n1634#2,3:60\n1#3:63\n*S KotlinDebug\n*F\n+ 1 IdeServicesHostApplication.kt\ncom/intellij/station/core/IdeServicesHostApplication\n*L\n27#1:59\n27#1:60,3\n*E\n"})
public class IdeServicesHostApplication
implements ServicesServerHostApplication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String ideId;
    @NotNull
    private final ConcurrentHashMap<String, StationServiceRequestHandler<?, ?>> serviceCache;
    @NotNull
    private static final ExtensionPointName<ServiceImplementationBean<StationServiceRequestHandler<?, ?>>> EP_NAME = new ExtensionPointName("com.intellij.station.core.handler");

    public IdeServicesHostApplication(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.ideId = string;
        EP_NAME.addExtensionPointListener(scope, new ExtensionPointListener<ServiceImplementationBean<StationServiceRequestHandler<?, ?>>>(){

            public void extensionRemoved(ServiceImplementationBean<StationServiceRequestHandler<?, ?>> extension, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter(extension, (String)"extension");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                serviceCache.remove(extension.getEndpoint());
            }
        });
        this.serviceCache = new ConcurrentHashMap();
    }

    @NotNull
    public final String getIdeId() {
        return this.ideId;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getKnownEndpoints() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = EP_NAME.getExtensionList();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServiceImplementationBean serviceImplementationBean = (ServiceImplementationBean)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEndpoint());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public StationServiceRequestHandler<?, ?> getServiceForEndpoint(@NotNull String endpoint) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return this.serviceCache.computeIfAbsent(endpoint, arg_0 -> IdeServicesHostApplication.getServiceForEndpoint$lambda$0((Function1)new Function1<String, StationServiceRequestHandler<?, ?>>(this){

            public final StationServiceRequestHandler<?, ?> invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return IdeServicesHostApplication.access$getServiceForEndpointImpl((IdeServicesHostApplication)this.receiver, p0);
            }
        }, arg_0));
    }

    private final StationServiceRequestHandler<?, ?> getServiceForEndpointImpl(String endpoint) {
        StationServiceRequestHandler rawHandler;
        ServiceImplementationBean serviceImplementationBean = (ServiceImplementationBean)((Object)EP_NAME.findFirstSafe(arg_0 -> IdeServicesHostApplication.getServiceForEndpointImpl$lambda$1(arg_0 -> IdeServicesHostApplication.getServiceForEndpointImpl$lambda$0(endpoint, arg_0), arg_0)));
        StationServiceRequestHandler stationServiceRequestHandler = rawHandler = serviceImplementationBean != null ? (StationServiceRequestHandler)serviceImplementationBean.getInstance() : null;
        if (rawHandler != null) {
            boolean bl = Intrinsics.areEqual((Object)rawHandler.getMetaInfo().getEndpoint(), (Object)endpoint);
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Handled endpoint mismatch: declared " + endpoint + ", actual " + rawHandler.getMetaInfo().getEndpoint();
                throw new AssertionError((Object)string);
            }
        }
        return rawHandler;
    }

    @Override
    @NotNull
    public UnixDomainSocketAddress getBindAddress() {
        long processId = ProcessHandle.current().pid();
        String tempDir = StationConstants.INSTANCE.getIdeBaseDirectory();
        String[] stringArray = new String[]{"jb.station.ij." + processId + ".sock"};
        UnixDomainSocketAddress unixDomainSocketAddress = UnixDomainSocketAddress.of(Path.of(tempDir, stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)unixDomainSocketAddress, (String)"of(...)");
        return unixDomainSocketAddress;
    }

    private static final StationServiceRequestHandler getServiceForEndpoint$lambda$0(Function1 $tmp0, Object p0) {
        return (StationServiceRequestHandler)$tmp0.invoke(p0);
    }

    private static final boolean getServiceForEndpointImpl$lambda$0(String $endpoint, ServiceImplementationBean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return Intrinsics.areEqual((Object)it.getEndpoint(), (Object)$endpoint);
    }

    private static final boolean getServiceForEndpointImpl$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ StationServiceRequestHandler access$getServiceForEndpointImpl(IdeServicesHostApplication $this, String endpoint) {
        return $this.getServiceForEndpointImpl(endpoint);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR%\u0010\u0004\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/station/core/IdeServicesHostApplication$Companion;", "", "<init>", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/station/core/services/ServiceImplementationBean;", "Lcom/intellij/station/comms/common/api/StationServiceRequestHandler;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "getInstance", "Lcom/intellij/station/core/IdeServicesHostApplication;", "intellij.station.core"})
    @SourceDebugExtension(value={"SMAP\nIdeServicesHostApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeServicesHostApplication.kt\ncom/intellij/station/core/IdeServicesHostApplication$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,58:1\n42#2,3:59\n*S KotlinDebug\n*F\n+ 1 IdeServicesHostApplication.kt\ncom/intellij/station/core/IdeServicesHostApplication$Companion\n*L\n21#1:59,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtensionPointName<ServiceImplementationBean<StationServiceRequestHandler<?, ?>>> getEP_NAME() {
            return EP_NAME;
        }

        @NotNull
        public final IdeServicesHostApplication getInstance() {
            boolean $i$f$service = false;
            Class<IdeServicesHostApplication> serviceClass$iv = IdeServicesHostApplication.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (IdeServicesHostApplication)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

