/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.microservices;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.microservices.RestClientRequestNavigatorBase;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.run.RunHttpExecutionAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

public class RestClientRequestRunnerNavigator
extends RestClientRequestNavigatorBase {
    @NotNull
    public String getId() {
        return "RestClientRequestRunnerNavigator";
    }

    @Override
    protected void performNavigation(@NotNull NavigatablePsiElement psiElement) {
        if (psiElement == null) {
            RestClientRequestRunnerNavigator.$$$reportNull$$$0(0);
        }
        HttpRequest httpRequest = null;
        if (psiElement instanceof HttpRequest) {
            httpRequest = (HttpRequest)psiElement;
        } else if (psiElement instanceof HttpRequestBlock) {
            httpRequest = ((HttpRequestBlock)psiElement).getRequest();
        }
        if (httpRequest != null) {
            HttpRequest request = httpRequest;
            Promise promise = DataManager.getInstance().getDataContextFromFocusAsync();
            promise.onSuccess(dataContext -> {
                DataContext wrapper = CustomizedDataContext.withSnapshot((DataContext)dataContext, sink -> {
                    sink.lazy(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY, () -> new PsiElement[]{request});
                    sink.setNull(CommonDataKeys.EDITOR);
                });
                HttpRequestBlock parent = (HttpRequestBlock)PsiTreeUtil.getParentOfType((PsiElement)psiElement, HttpRequestBlock.class);
                new RunHttpExecutionAction.RunExecutionWithDefaultEnvAction(parent).actionPerformed(AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)wrapper));
            });
            promise.onError(error -> {
                LOG.info("Failed to run HTTP request", error);
                psiElement.navigate(true);
            });
        } else {
            LOG.info("Failed to run HTTP request: request not found in " + String.valueOf(psiElement.getContainingFile()));
            psiElement.navigate(true);
        }
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Actions.Execute;
        if (icon == null) {
            RestClientRequestRunnerNavigator.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayText() {
        String string = RestClientBundle.message("http.request.navigator.rest.client.display.text", new Object[0]);
        if (string == null) {
            RestClientRequestRunnerNavigator.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/microservices/RestClientRequestRunnerNavigator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/microservices/RestClientRequestRunnerNavigator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performNavigation";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

