/*
 * Decompiled with CFR 0.152.
 */
package de.javawi.jstun.test.demo.ice;

import de.javawi.jstun.attribute.MessageAttributeException;
import de.javawi.jstun.header.MessageHeaderParsingException;
import de.javawi.jstun.test.DiscoveryInfo;
import de.javawi.jstun.test.DiscoveryTest;
import de.javawi.jstun.test.demo.ice.Candidate;
import de.javawi.jstun.util.Address;
import de.javawi.jstun.util.UtilityException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ICENegotiator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ICENegotiator.class);
    private static final int LOCAL_PREFERENCE = 0;
    private static final int SERVER_REFLEXIVE_PREFERENCE = 42;
    private static final int PEER_REFLEXIVE_PREFERENCE = 84;
    private static final int RELAYED_PREFERENCE = 126;
    private short componentId;
    private String stunServer = "jstun.javawi.de";
    private int stunPort = 3478;
    HashSet<Candidate> candidates;

    public ICENegotiator(short componentId) {
        this.componentId = componentId;
        this.candidates = new HashSet();
    }

    public ICENegotiator(String stunServer, int stunPort, short componentId) {
        this.stunServer = stunServer;
        this.stunPort = stunPort;
        this.componentId = componentId;
        this.candidates = new HashSet();
    }

    public void gatherCandidateAddresses() {
        try {
            this.candidates = new HashSet();
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> iaddresses = iface.getInetAddresses();
                while (iaddresses.hasMoreElements()) {
                    InetAddress iaddress = iaddresses.nextElement();
                    if (iaddress.isLoopbackAddress() || iaddress.isLinkLocalAddress()) continue;
                    try {
                        Candidate local = new Candidate(new Address(iaddress.getAddress()), this.componentId);
                        this.candidates.add(local);
                        DiscoveryTest test = new DiscoveryTest(iaddress, 0, this.stunServer, this.stunPort);
                        DiscoveryInfo di = test.test();
                        if (di.getPublicIP() == null) continue;
                        Candidate cand = new Candidate(new Address(di.getPublicIP().getAddress()), Candidate.CandidateType.ServerReflexive, this.componentId, local);
                        cand.setComponentId(this.componentId);
                        this.candidates.add(cand);
                    }
                    catch (MessageHeaderParsingException mhpe) {
                        LOGGER.debug("MessageHeaderParsingException while gathering candidate addresses.");
                    }
                    catch (MessageAttributeException mae) {
                        LOGGER.debug("MessageAttributeException while gathering candidate addresses.");
                    }
                    catch (UtilityException ue) {
                        LOGGER.debug("UtilityException while gathering candidate addresses.");
                    }
                    catch (UnknownHostException uhe) {
                        LOGGER.debug("MessageHeaderParsingException while gathering candidate addresses.");
                    }
                    catch (SocketException se) {
                        LOGGER.debug("SocketException while gathering candidate addresses.");
                    }
                    catch (IOException ioe) {
                        LOGGER.debug("IOException while gathering candidate addresses.");
                    }
                }
            }
        }
        catch (SocketException se) {
            LOGGER.debug("SocketException while enumatering over the network cards.");
        }
    }

    public void prioritizeCandidates() {
        int numberLocal = 0;
        int numberServerReflexive = 0;
        int numberPeerReflexive = 0;
        int numberRelayed = 0;
        for (Candidate cand : this.candidates) {
            Candidate.CandidateType type = cand.getCandidateType();
            if (type == Candidate.CandidateType.Local) {
                ++numberLocal;
                continue;
            }
            if (type == Candidate.CandidateType.ServerReflexive) {
                ++numberServerReflexive;
                continue;
            }
            if (type == Candidate.CandidateType.PeerReflexive) {
                ++numberPeerReflexive;
                continue;
            }
            if (type != Candidate.CandidateType.Relayed) continue;
            ++numberRelayed;
        }
        Iterator<Candidate> iterCandidates = this.candidates.iterator();
        while (iterCandidates.hasNext()) {
            int typeValue = 0;
            int localValue = 0;
            short componentValue = 0;
            Candidate cand = iterCandidates.next();
            Candidate.CandidateType type = cand.getCandidateType();
            if (type == Candidate.CandidateType.Local) {
                typeValue = 0;
                localValue = numberLocal--;
            } else if (type == Candidate.CandidateType.ServerReflexive) {
                typeValue = 42;
                localValue = numberServerReflexive--;
            } else if (type == Candidate.CandidateType.PeerReflexive) {
                typeValue = 84;
                localValue = numberPeerReflexive--;
            } else if (type == Candidate.CandidateType.Relayed) {
                typeValue = 126;
                localValue = numberRelayed--;
            }
            componentValue = cand.getComponentId();
            int priority = 26 * typeValue + 10 * localValue + componentValue;
            cand.setPriority(priority);
        }
    }

    public List<Candidate> getSortedCandidates() {
        Vector<Candidate> sortedCandidates = new Vector<Candidate>(this.candidates);
        Collections.sort(sortedCandidates);
        return sortedCandidates;
    }

    public static void main(String[] args) {
        ICENegotiator cc = new ICENegotiator(1);
        cc.gatherCandidateAddresses();
        cc.prioritizeCandidates();
        List<Candidate> sortedCandidates = cc.getSortedCandidates();
    }
}

