/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlExpressionBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlLeafBlock;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlOperatorExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0014J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0014J\b\u0010\u001a\u001a\u00020\fH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/sql/formatter/model/SqlBinaryExpressionBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "Lcom/intellij/sql/formatter/model/SqlExpressionBlock;", "<init>", "()V", "operationType", "Lcom/intellij/psi/tree/IElementType;", "operationText", "", "prepareForNode", "", "whetherToFlatten", "", "node", "Lcom/intellij/lang/ASTNode;", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "whetherBlockIsSymbol", "block", "getDebugNameSuffix", "tailFormed", "getNewLineIndent", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlExpressionBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlExpressionBlock.kt\ncom/intellij/sql/formatter/model/SqlBinaryExpressionBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,369:1\n1869#2,2:370\n1869#2,2:372\n*S KotlinDebug\n*F\n+ 1 SqlExpressionBlock.kt\ncom/intellij/sql/formatter/model/SqlBinaryExpressionBlock\n*L\n55#1:370,2\n63#1:372,2\n*E\n"})
public final class SqlBinaryExpressionBlock
extends SqlNodeBlock
implements SqlExpressionBlock {
    @Nullable
    private IElementType operationType;
    @Nullable
    private String operationText;

    @Override
    protected void prepareForNode() {
        super.prepareForNode();
        PsiElement psiElement = this.getNode().getPsi();
        SqlOperatorExpression sqlOperatorExpression = psiElement instanceof SqlOperatorExpression ? (SqlOperatorExpression)psiElement : null;
        PsiElement operatorSignElement = sqlOperatorExpression != null ? sqlOperatorExpression.getOpSignElement() : null;
        this.operationType = PsiTreeUtilKt.getElementType((PsiElement)operatorSignElement);
        PsiElement psiElement2 = operatorSignElement;
        this.operationText = psiElement2 != null ? psiElement2.getText() : null;
    }

    @Override
    protected boolean whetherToFlatten(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.operationType == null) {
            return false;
        }
        PsiElement element = node.getPsi();
        return element instanceof SqlBinaryExpression && Intrinsics.areEqual((Object)((SqlBinaryExpression)element).getOpSign(), (Object)this.operationType);
    }

    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.getElementType() == this.operationType ? BlockRole.DELIMITER : (node instanceof SqlExpression ? BlockRole.ELEMENT : super.determineRole(node));
    }

    @Override
    protected void configureFormattingAttributes() {
        Wrap w = null;
        if (this.getContext().getSql().EXPR_BINARY_OP_ALIGN) {
            w = this.makeCascadeWrap(WrapType.NORMAL, false);
            Alignment a = SqlFormattingModelFun.makeLeftAlignment();
            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlBlock it = (SqlBlock)element$iv;
                boolean bl = false;
                it.setMyWrap(w);
                it.setMyAlign(a);
            }
        } else {
            w = SqlFlowBlock.makeCascadeWrap$default(this, WrapType.NORMAL, false, 2, null);
            Indent i = Indent.getContinuationIndent();
            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFun.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlBlock it = (SqlBlock)element$iv;
                boolean bl = false;
                it.setMyWrap(w);
                it.setMyIndent(i);
            }
        }
        this.setInnerWrap(w);
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        int toSpace = this.getContext().getSql().EXPR_SPACE_AROUND_OPERATOR;
        BlockRole r1 = block1.getRole();
        BlockRole r2 = block2.getRole();
        return r1 == BlockRole.DELIMITER && r2 == BlockRole.ELEMENT ? (toSpace == 1 ? SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null) : (toSpace == 0 || !this.whetherBlockIsSymbol(block1) ? SqlFormattingContext.makeSafeSpacing$default(this.getContext(), false, 1, null) : SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null))) : (r1 == BlockRole.ELEMENT && r2 == BlockRole.DELIMITER ? (toSpace == 1 ? SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null) : (toSpace == 0 || !this.whetherBlockIsSymbol(block2) ? SqlFormattingContext.makeSafeSpacing$default(this.getContext(), false, 1, null) : SqlFormattingContext.makeNoSpace$default(this.getContext(), false, 1, null))) : super.decideSpacing(block1, block2));
    }

    private final boolean whetherBlockIsSymbol(SqlBlock block) {
        return block instanceof SqlLeafBlock && SqlUtilFun.isSymbol(((SqlLeafBlock)block).getNode());
    }

    @Override
    @Nullable
    protected String getDebugNameSuffix() {
        return this.operationText;
    }

    @Override
    public boolean tailFormed() {
        if (this.operationType == null) {
            return false;
        }
        SqlBlock sqlBlock = this.getLastNestedSqlBlock();
        if (sqlBlock == null) {
            return false;
        }
        SqlBlock lb = sqlBlock;
        return lb.getRole() == BlockRole.ELEMENT;
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        String string;
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        boolean align = this.getContext().getSql().EXPR_BINARY_OP_ALIGN;
        BlockRole r1 = blocks.getRole1();
        BlockRole r2 = blocks.getRole2();
        if (r1 == BlockRole.DELIMITER && (r2 == BlockRole.ELEMENT || r2 == BlockRole.NOTHING)) {
            string = SqlFormattingContext.currIndentOf$default(this.getContext(), this, align, false, false, 12, null);
        } else if (r1 == BlockRole.ELEMENT && (r2 == BlockRole.DELIMITER || r2 == BlockRole.NOTHING)) {
            string = SqlFormattingContext.currIndentOf$default(this.getContext(), this, align, true, false, 8, null);
        } else {
            return null;
        }
        return string;
    }
}

