/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.spatial;

import androidx.collection.IntObjectMap;
import androidx.collection.IntObjectMapKt;
import androidx.collection.MutableObjectList;
import androidx.collection.ObjectList;
import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Actual_jvmKt;
import androidx.compose.ui.Actuals_skikoKt;
import androidx.compose.ui.ComposeUiFlags;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.focus.FocusTargetModifierNode;
import androidx.compose.ui.focus.FocusTargetNode;
import androidx.compose.ui.geometry.MutableRect;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.MatrixKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.node.DelegatableNode;
import androidx.compose.ui.node.DelegatableNodeKt;
import androidx.compose.ui.node.DelegatingNode;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LayoutNodeKt;
import androidx.compose.ui.node.MeasurePassDelegate;
import androidx.compose.ui.node.NodeChain;
import androidx.compose.ui.node.NodeCoordinator;
import androidx.compose.ui.node.NodeKind;
import androidx.compose.ui.node.OwnedLayer;
import androidx.compose.ui.semantics.SemanticsInfo;
import androidx.compose.ui.spatial.RectList;
import androidx.compose.ui.spatial.RectManagerKt;
import androidx.compose.ui.spatial.RelativeLayoutBounds;
import androidx.compose.ui.spatial.ThrottledCallbacks;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntOffsetKt;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0019\u001a\u00020\u0010J5\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J\u0006\u0010%\u001a\u00020\u0010J\u000e\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0012J\u0016\u0010(\u001a\u0004\u0018\u00010\u00012\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ:\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u0002002\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001001J:\u00103\u001a\u00020+2\u0006\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u0002002\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020\u001001J\u0010\u00104\u001a\u00020\u00102\b\u00105\u001a\u0004\u0018\u00010\u0001J\u000e\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0004J\u001e\u00108\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u0012J\u000e\u0010;\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0004J\u0016\u0010<\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0012J\u0010\u0010>\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0004H\u0002J\u0010\u0010?\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0004H\u0002J\u0018\u0010B\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0012H\u0002J8\u0010C\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u00122\u0006\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u00020!2\u0006\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u00020!H\u0002J\u0014\u0010H\u001a\u00020\u0010*\u00020I2\u0006\u0010J\u001a\u00020AH\u0002J\u0013\u0010K\u001a\u00020\u001c*\u00020\u0004H\u0002\u00a2\u0006\u0004\bL\u0010MJ\u000e\u0010N\u001a\u00020\u00102\u0006\u00107\u001a\u00020\u0004J\u001d\u0010O\u001a\u00020\u00122\u0006\u0010P\u001a\u00020!2\u0006\u0010Q\u001a\u00020!H\u0000\u00a2\u0006\u0002\bRJ7\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010U\u001a\u00020!2\u0006\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020!2\u0006\u0010X\u001a\u00020!2\u0006\u0010Y\u001a\u00020!H\u0000\u00a2\u0006\u0002\bZJ1\u0010[\u001a\u00020\u0012*\u0002002\u0006\u0010U\u001a\u00020!2\u0006\u0010V\u001a\u00020!2\u0006\u0010W\u001a\u00020!2\u0006\u0010X\u001a\u00020!H\u0000\u00a2\u0006\u0002\b\\J\u0019\u0010]\u001a\u00020\u0012*\u00020\u00042\u0006\u0010^\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b_R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Landroidx/compose/ui/spatial/RectManager;", "", "layoutNodes", "Landroidx/collection/IntObjectMap;", "Landroidx/compose/ui/node/LayoutNode;", "<init>", "(Landroidx/collection/IntObjectMap;)V", "rects", "Landroidx/compose/ui/spatial/RectList;", "getRects", "()Landroidx/compose/ui/spatial/RectList;", "throttledCallbacks", "Landroidx/compose/ui/spatial/ThrottledCallbacks;", "callbacks", "Landroidx/collection/MutableObjectList;", "Lkotlin/Function0;", "", "isDirty", "", "isScreenOrWindowDirty", "isFragmented", "dispatchToken", "scheduledDispatchDeadline", "", "dispatchLambda", "invalidate", "updateOffsets", "screenOffset", "Landroidx/compose/ui/unit/IntOffset;", "windowOffset", "viewToWindowMatrix", "Landroidx/compose/ui/graphics/Matrix;", "windowWidth", "", "windowHeight", "updateOffsets-gTq6Wqs", "(JJ[FII)V", "dispatchCallbacks", "scheduleDebounceCallback", "ensureSomethingScheduled", "registerOnChangedCallback", "callback", "registerOnRectChangedCallback", "Landroidx/compose/ui/node/DelegatableNode$RegistrationHandle;", "id", "throttleMillis", "debounceMillis", "node", "Landroidx/compose/ui/node/DelegatableNode;", "Lkotlin/Function1;", "Landroidx/compose/ui/spatial/RelativeLayoutBounds;", "registerOnGlobalLayoutCallback", "unregisterOnChangedCallback", "token", "invalidateCallbacksFor", "layoutNode", "updateFlagsFor", "focusable", "gesturable", "onLayoutLayerPositionalPropertiesChanged", "onLayoutPositionChanged", "firstPlacement", "recalculateOffsetFromRoot", "insertOrUpdateTransformedNodeSubhierarchy", "cachedRect", "Landroidx/compose/ui/geometry/MutableRect;", "insertOrUpdateTransformedNode", "insertOrUpdate", "l", "t", "r", "b", "boundingRectInRoot", "Landroidx/compose/ui/node/NodeCoordinator;", "rect", "outerToInnerOffset", "outerToInnerOffset-Bjo55l4", "(Landroidx/compose/ui/node/LayoutNode;)J", "remove", "isTargetDrawnFirst", "targetId", "otherId", "isTargetDrawnFirst$ui", "findFocusableNodeFromRect", "Landroidx/compose/ui/focus/FocusTargetModifierNode;", "left", "top", "right", "bottom", "containerId", "findFocusableNodeFromRect$ui", "intersects", "intersects$ui", "isDescendantOf", "container", "isDescendantOf$ui", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nRectManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RectManager.kt\nandroidx/compose/ui/spatial/RectManager\n+ 2 ObjectList.kt\nandroidx/collection/ObjectListKt\n+ 3 RectManager.kt\nandroidx/compose/ui/spatial/RectManagerKt\n+ 4 ObjectList.kt\nandroidx/collection/ObjectList\n+ 5 RectList.kt\nandroidx/compose/ui/spatial/RectList\n+ 6 RectList.kt\nandroidx/compose/ui/spatial/RectListKt\n+ 7 ThrottledCallbacks.kt\nandroidx/compose/ui/spatial/ThrottledCallbacks\n+ 8 IntObjectMap.kt\nandroidx/collection/IntObjectMap\n+ 9 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 10 LayoutNode.kt\nandroidx/compose/ui/node/LayoutNode\n+ 11 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 12 IntSize.kt\nandroidx/compose/ui/unit/IntSize\n+ 13 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 14 IntSize.kt\nandroidx/compose/ui/unit/IntSizeKt\n+ 15 NodeKind.kt\nandroidx/compose/ui/node/Nodes\n+ 16 IntOffset.kt\nandroidx/compose/ui/unit/IntOffsetKt\n+ 17 Offset.kt\nandroidx/compose/ui/geometry/OffsetKt\n+ 18 NodeChain.kt\nandroidx/compose/ui/node/NodeChain\n+ 19 DelegatableNode.kt\nandroidx/compose/ui/node/DelegatableNodeKt\n+ 20 Modifier.kt\nandroidx/compose/ui/Modifier$Node\n+ 21 DelegatingNode.kt\nandroidx/compose/ui/node/DelegatingNode\n+ 22 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 23 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 24 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n+ 25 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 26 Trace.desktop.kt\nandroidx/compose/ui/util/Trace_jbKt__Trace_desktopKt\n*L\n1#1,642:1\n1516#2:643\n639#3:644\n635#3:732\n639#3:733\n287#4,6:645\n805#5,7:651\n812#5,3:659\n816#5,3:663\n546#5:734\n547#5,8:736\n555#5,4:745\n559#5:751\n562#5,3:818\n917#6:658\n886#6:662\n863#6:735\n913#6:744\n942#6,2:749\n886#6:752\n191#7:666\n192#7,8:683\n200#7:698\n397#8,3:667\n354#8,6:670\n364#8,3:677\n367#8,2:681\n370#8,6:691\n400#8:697\n1399#9:676\n1270#9:680\n208#10:699\n208#10:714\n424#11,8:700\n424#11,8:715\n54#12:708\n59#12:710\n54#12:829\n59#12:838\n85#13:709\n90#13:711\n80#13:713\n53#13,3:729\n60#13:823\n85#13:830\n70#13:832\n90#13:839\n30#14:712\n118#15:723\n94#15:724\n118#15:725\n94#15:726\n118#15:753\n118#15:821\n159#16:727\n30#17:728\n698#18:754\n633#18,6:755\n654#18,3:761\n639#18,2:764\n699#18:771\n642#18,2:810\n657#18,3:812\n644#18:815\n634#18:816\n701#18:817\n493#19,5:766\n498#19:772\n503#19,2:774\n505#19,8:779\n513#19,9:790\n522#19,8:802\n247#20:773\n240#21,3:776\n243#21,3:799\n1107#22:787\n1085#22,2:788\n65#23:822\n69#23:831\n22#24,5:824\n22#24,5:833\n1#25:840\n23#26:841\n*S KotlinDebug\n*F\n+ 1 RectManager.kt\nandroidx/compose/ui/spatial/RectManager\n*L\n56#1:643\n83#1:644\n410#1:732\n411#1:733\n100#1:645,6\n101#1:651,7\n101#1:659,3\n101#1:663,3\n525#1:734\n525#1:736,8\n525#1:745,4\n525#1:751\n525#1:818,3\n101#1:658\n101#1:662\n525#1:735\n525#1:744\n525#1:749,2\n525#1:752\n104#1:666\n104#1:683,8\n104#1:698\n104#1:667,3\n104#1:670,6\n104#1:677,3\n104#1:681,2\n104#1:691,6\n104#1:697\n104#1:676\n104#1:680\n221#1:699\n315#1:714\n221#1:700,8\n315#1:715,8\n250#1:708\n251#1:710\n573#1:829\n575#1:838\n250#1:709\n251#1:711\n263#1:713\n387#1:729,3\n572#1:823\n573#1:830\n574#1:832\n575#1:839\n263#1:712\n350#1:723\n351#1:724\n375#1:725\n376#1:726\n534#1:753\n557#1:821\n387#1:727\n387#1:728\n534#1:754\n534#1:755,6\n534#1:761,3\n534#1:764,2\n534#1:771\n534#1:810,2\n534#1:812,3\n534#1:815\n534#1:816\n534#1:817\n534#1:766,5\n534#1:772\n534#1:774,2\n534#1:779,8\n534#1:790,9\n534#1:802,8\n534#1:773\n534#1:776,3\n534#1:799,3\n534#1:787\n534#1:788,2\n572#1:822\n574#1:831\n572#1:824,5\n574#1:833,5\n64#1:841\n*E\n"})
public final class RectManager {
    @NotNull
    private final IntObjectMap<LayoutNode> layoutNodes;
    @NotNull
    private final RectList rects;
    @NotNull
    private final ThrottledCallbacks throttledCallbacks;
    @NotNull
    private final MutableObjectList<Function0<Unit>> callbacks;
    private boolean isDirty;
    private boolean isScreenOrWindowDirty;
    private boolean isFragmented;
    @Nullable
    private Object dispatchToken;
    private long scheduledDispatchDeadline;
    @NotNull
    private final Function0<Unit> dispatchLambda;
    @NotNull
    private final MutableRect cachedRect;
    public static final int $stable = 8;

    public RectManager(@NotNull IntObjectMap<LayoutNode> layoutNodes) {
        Intrinsics.checkNotNullParameter(layoutNodes, (String)"layoutNodes");
        this.layoutNodes = layoutNodes;
        this.rects = new RectList();
        this.throttledCallbacks = new ThrottledCallbacks();
        boolean $i$f$mutableObjectListOf = false;
        this.callbacks = new MutableObjectList(0, 1, null);
        this.scheduledDispatchDeadline = -1L;
        this.dispatchLambda = () -> RectManager.dispatchLambda$lambda$1(this);
        this.cachedRect = new MutableRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public /* synthetic */ RectManager(IntObjectMap intObjectMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            intObjectMap = IntObjectMapKt.intObjectMapOf();
        }
        this(intObjectMap);
    }

    @NotNull
    public final RectList getRects() {
        return this.rects;
    }

    public final void invalidate() {
        this.isDirty = true;
    }

    public final void updateOffsets-gTq6Wqs(long screenOffset, long windowOffset, @NotNull float[] viewToWindowMatrix, int windowWidth, int windowHeight) {
        int analysis;
        Intrinsics.checkNotNullParameter((Object)viewToWindowMatrix, (String)"viewToWindowMatrix");
        int $this$hasNonTranslationComponents$iv = analysis = RectManagerKt.access$analyzeComponents-58bKbWc(viewToWindowMatrix);
        boolean $i$f$getHasNonTranslationComponents = false;
        this.isScreenOrWindowDirty = this.throttledCallbacks.updateOffsets-LDcG7Xg(screenOffset, windowOffset, (float[])(($this$hasNonTranslationComponents$iv & 2) == 0 ? viewToWindowMatrix : null), windowWidth, windowHeight) || this.isScreenOrWindowDirty;
    }

    /*
     * WARNING - void declaration
     */
    public final void dispatchCallbacks() {
        boolean isDispatchGlobalCallbacks;
        long currentTime = Actual_jvmKt.currentTimeMillis();
        boolean bl = isDispatchGlobalCallbacks = this.isDirty || this.isScreenOrWindowDirty;
        if (this.isDirty) {
            this.isDirty = false;
            Object this_$iv = this.callbacks;
            boolean $i$f$forEach = false;
            Object[] content$iv = ((ObjectList)this_$iv).content;
            int n = ((ObjectList)this_$iv)._size;
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                Function0 it = (Function0)content$iv[i$iv];
                boolean bl2 = false;
                it.invoke();
            }
            this_$iv = this.rects;
            boolean $i$f$forEachUpdatedRect = false;
            long[] items$iv = ((RectList)this_$iv).items;
            int size$iv = ((RectList)this_$iv).itemsSize;
            for (int i$iv = 0; i$iv < items$iv.length - 2 && i$iv < size$iv; i$iv += 3) {
                void bottomRight;
                void topLeft;
                long meta$iv;
                long meta$iv$iv = meta$iv = items$iv[i$iv + 2];
                boolean $i$f$unpackMetaUpdated = false;
                if (((int)(meta$iv$iv >> 61) & 1) == 0) continue;
                long topLeft$iv = items$iv[i$iv + 0];
                long bottomRight$iv = items$iv[i$iv + 1];
                long meta$iv$iv2 = meta$iv;
                boolean $i$f$unpackMetaValue = false;
                long l = bottomRight$iv;
                long l2 = topLeft$iv;
                int id = (int)meta$iv$iv2 & 0x3FFFFFF;
                boolean bl3 = false;
                this.throttledCallbacks.fireOnUpdatedRect(id, (long)topLeft, (long)bottomRight, currentTime);
            }
            this_$iv = this.throttledCallbacks;
            boolean $i$f$forEachNewCallbackNeverInvoked = false;
            IntObjectMap this_$iv$iv = ((ThrottledCallbacks)this_$iv).getRectChangedMap();
            boolean $i$f$forEachValue = false;
            Object[] v$iv$iv = this_$iv$iv.values;
            IntObjectMap this_$iv$iv$iv = this_$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int i$iv$iv$iv = 0;
            long[] m$iv$iv$iv = this_$iv$iv$iv.metadata;
            int lastIndex$iv$iv$iv = m$iv$iv$iv.length - 2;
            if (i$iv$iv$iv <= lastIndex$iv$iv$iv) {
                while (true) {
                    long slot$iv$iv$iv;
                    long $this$maskEmptyOrDeleted$iv$iv$iv$iv = slot$iv$iv$iv = m$iv$iv$iv[i$iv$iv$iv];
                    boolean $i$f$maskEmptyOrDeleted = false;
                    if (($this$maskEmptyOrDeleted$iv$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                        int bitCount$iv$iv$iv = 8 - (~(i$iv$iv$iv - lastIndex$iv$iv$iv) >>> 31);
                        for (int j$iv$iv$iv = 0; j$iv$iv$iv < bitCount$iv$iv$iv; ++j$iv$iv$iv) {
                            long value$iv$iv$iv$iv = slot$iv$iv$iv & 0xFFL;
                            boolean $i$f$isFull = false;
                            if (value$iv$iv$iv$iv < 128L) {
                                int index$iv$iv$iv;
                                int index$iv$iv = index$iv$iv$iv = (i$iv$iv$iv << 3) + j$iv$iv$iv;
                                boolean bl4 = false;
                                ThrottledCallbacks.Entry entry$iv = (ThrottledCallbacks.Entry)v$iv$iv[index$iv$iv];
                                boolean bl5 = false;
                                for (ThrottledCallbacks.Entry next$iv = entry$iv; next$iv != null; next$iv = next$iv.getNext()) {
                                    if (entry$iv.getLastInvokeMillis() != Long.MIN_VALUE) continue;
                                    ThrottledCallbacks.Entry entry = entry$iv;
                                    boolean bl6 = false;
                                    this.rects.withTopLeftBottomRight(entry.getId(), (Function2<? super Long, ? super Long, Unit>)((Function2)(arg_0, arg_1) -> RectManager.dispatchCallbacks$lambda$5$lambda$4(this, entry, currentTime, arg_0, arg_1)));
                                }
                            }
                            slot$iv$iv$iv >>= 8;
                        }
                        if (bitCount$iv$iv$iv != 8) break;
                    }
                    if (i$iv$iv$iv == lastIndex$iv$iv$iv) break;
                    ++i$iv$iv$iv;
                }
            }
            this.rects.clearUpdated();
        }
        if (this.isScreenOrWindowDirty) {
            this.isScreenOrWindowDirty = false;
            this.throttledCallbacks.fireOnRectChangedEntries(currentTime);
        }
        if (isDispatchGlobalCallbacks) {
            this.throttledCallbacks.fireGlobalChangeEntries(currentTime);
        }
        if (this.isFragmented) {
            this.isFragmented = false;
            this.rects.defragment();
        }
        this.throttledCallbacks.triggerDebounced(currentTime);
    }

    public final void scheduleDebounceCallback(boolean ensureSomethingScheduled) {
        long deadline;
        boolean canExitEarly = !ensureSomethingScheduled || this.dispatchToken != null;
        long nextDeadline = this.throttledCallbacks.getMinDebounceDeadline();
        if (nextDeadline < 0L && canExitEarly) {
            return;
        }
        long currentScheduledDeadline = this.scheduledDispatchDeadline;
        if (currentScheduledDeadline == nextDeadline && canExitEarly) {
            return;
        }
        if (this.dispatchToken != null) {
            Actuals_skikoKt.removePost(this.dispatchToken);
        }
        long currentTime = Actual_jvmKt.currentTimeMillis();
        long nextFrameIsh = currentTime + (long)16;
        this.scheduledDispatchDeadline = deadline = Math.max(nextDeadline, nextFrameIsh);
        long delay = deadline - currentTime;
        this.dispatchToken = Actuals_skikoKt.postDelayed(delay, this.dispatchLambda);
    }

    @Nullable
    public final Object registerOnChangedCallback(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callbacks.add(callback);
        return callback;
    }

    @NotNull
    public final DelegatableNode.RegistrationHandle registerOnRectChangedCallback(int id, long throttleMillis, long debounceMillis, @NotNull DelegatableNode node2, @NotNull Function1<? super RelativeLayoutBounds, Unit> callback) {
        DelegatableNode.RegistrationHandle registrationHandle;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        DelegatableNode.RegistrationHandle it = registrationHandle = this.throttledCallbacks.registerOnRectChanged(id, throttleMillis, debounceMillis, node2, callback);
        boolean bl = false;
        this.invalidate();
        this.scheduleDebounceCallback(true);
        return registrationHandle;
    }

    @NotNull
    public final DelegatableNode.RegistrationHandle registerOnGlobalLayoutCallback(int id, long throttleMillis, long debounceMillis, @NotNull DelegatableNode node2, @NotNull Function1<? super RelativeLayoutBounds, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return this.throttledCallbacks.registerOnGlobalChange(id, throttleMillis, debounceMillis, node2, callback);
    }

    public final void unregisterOnChangedCallback(@Nullable Object token) {
        if ((TypeIntrinsics.isFunctionOfArity((Object)token, (int)0) ? (Function0)token : null) == null) {
            return;
        }
        this.callbacks.remove((Function0<Unit>)token);
    }

    public final void invalidateCallbacksFor(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        this.isDirty = true;
        this.rects.markUpdated(layoutNode.getSemanticsId());
        this.scheduleDebounceCallback(true);
    }

    public final void updateFlagsFor(@NotNull LayoutNode layoutNode, boolean focusable, boolean gesturable) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (layoutNode.isAttached()) {
            this.rects.updateFlagsFor(layoutNode.getSemanticsId(), focusable, gesturable);
        }
    }

    public final void onLayoutLayerPositionalPropertiesChanged(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (!ComposeUiFlags.isRectTrackingEnabled) {
            return;
        }
        long outerToInnerOffset = this.outerToInnerOffset-Bjo55l4(layoutNode);
        if (RectManagerKt.access$isSet--gyyYBs(outerToInnerOffset)) {
            layoutNode.setOuterToInnerOffset--gyyYBs$ui(outerToInnerOffset);
            layoutNode.setOuterToInnerOffsetDirty$ui(false);
            LayoutNode this_$iv = layoutNode;
            boolean $i$f$forEachChild = false;
            MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
            boolean $i$f$forEach = false;
            Object[] content$iv$iv = this_$iv$iv.content;
            int size$iv$iv = this_$iv$iv.getSize();
            for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
                LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
                boolean bl = false;
                this.onLayoutPositionChanged(it, false);
            }
            this.invalidateCallbacksFor(layoutNode);
        } else {
            this.insertOrUpdateTransformedNodeSubhierarchy(layoutNode);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void onLayoutPositionChanged(@NotNull LayoutNode layoutNode, boolean firstPlacement) {
        void val1$iv$iv;
        void width$iv;
        long lastSize;
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        if (!ComposeUiFlags.isRectTrackingEnabled) {
            return;
        }
        MeasurePassDelegate delegate = layoutNode.getMeasurePassDelegate$ui();
        int width = delegate.getMeasuredWidth();
        int height = delegate.getMeasuredHeight();
        long lastOffset = layoutNode.getOffsetFromRoot-nOcc-ac$ui();
        long arg0$iv = lastSize = layoutNode.getLastSize-YbymL2g$ui();
        boolean bl = false;
        long value$iv$iv = arg0$iv;
        boolean $i$f$unpackInt1 = false;
        int lastWidth = (int)(value$iv$iv >> 32);
        long arg0$iv2 = lastSize;
        int n = 0;
        long value$iv$iv2 = arg0$iv2;
        boolean $i$f$unpackInt2 = false;
        int lastHeight = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        this.recalculateOffsetFromRoot(layoutNode);
        long offset = layoutNode.getOffsetFromRoot-nOcc-ac$ui();
        if (!RectManagerKt.access$isSet--gyyYBs(offset)) {
            this.insertOrUpdateTransformedNode(layoutNode, firstPlacement);
            return;
        }
        n = width;
        int height$iv = height;
        boolean $i$f$IntSize = false;
        $i$f$unpackInt2 = width$iv;
        int val2$iv$iv = height$iv;
        boolean $i$f$packInts = false;
        layoutNode.setLastSize-ozmzZPI$ui(IntSize.constructor-impl((long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL));
        int l = IntOffset.getX-impl(offset);
        int t = IntOffset.getY-impl(offset);
        int r = l + width;
        int b = t + height;
        if (!firstPlacement && IntOffset.equals-impl0(offset, lastOffset) && lastWidth == width && lastHeight == height) {
            return;
        }
        this.insertOrUpdate(layoutNode, firstPlacement, l, t, r, b);
    }

    private final void recalculateOffsetFromRoot(LayoutNode layoutNode) {
        long l;
        long position = layoutNode.getOuterCoordinator$ui().getPosition-nOcc-ac();
        LayoutNode parent = layoutNode.getParent$ui();
        if (parent != null) {
            long parentOffset;
            if (!RectManagerKt.access$isSet--gyyYBs(parent.getOffsetFromRoot-nOcc-ac$ui())) {
                this.recalculateOffsetFromRoot(parent);
            }
            if (!RectManagerKt.access$isSet--gyyYBs(parentOffset = parent.getOffsetFromRoot-nOcc-ac$ui())) {
                l = IntOffset.Companion.getMax-nOcc-ac();
            } else {
                long parentOuterInnerOffset;
                long l2;
                if (parent.getOuterToInnerOffsetDirty$ui()) {
                    long it = this.outerToInnerOffset-Bjo55l4(parent);
                    parent.setOuterToInnerOffset--gyyYBs$ui(it);
                    parent.setOuterToInnerOffsetDirty$ui(false);
                    l2 = it;
                } else {
                    l2 = parentOuterInnerOffset = parent.getOuterToInnerOffset-nOcc-ac$ui();
                }
                l = !RectManagerKt.access$isSet--gyyYBs(parentOuterInnerOffset) ? IntOffset.Companion.getMax-nOcc-ac() : IntOffset.plus-qkQi6aY(IntOffset.plus-qkQi6aY(parentOffset, parentOuterInnerOffset), position);
            }
        } else {
            l = position;
        }
        layoutNode.setOffsetFromRoot--gyyYBs$ui(l);
    }

    private final void insertOrUpdateTransformedNodeSubhierarchy(LayoutNode layoutNode) {
        LayoutNode this_$iv = layoutNode;
        boolean $i$f$forEachChild = false;
        MutableVector<LayoutNode> this_$iv$iv = this_$iv.get_children$ui();
        boolean $i$f$forEach = false;
        Object[] content$iv$iv = this_$iv$iv.content;
        int size$iv$iv = this_$iv$iv.getSize();
        for (int i$iv$iv = 0; i$iv$iv < size$iv$iv; ++i$iv$iv) {
            LayoutNode it = (LayoutNode)content$iv$iv[i$iv$iv];
            boolean bl = false;
            this.insertOrUpdateTransformedNode(it, false);
            this.insertOrUpdateTransformedNodeSubhierarchy(it);
        }
    }

    private final void insertOrUpdateTransformedNode(LayoutNode layoutNode, boolean firstPlacement) {
        NodeCoordinator coord = layoutNode.getOuterCoordinator$ui();
        MeasurePassDelegate delegate = layoutNode.getMeasurePassDelegate$ui();
        int width = delegate.getMeasuredWidth();
        int height = delegate.getMeasuredHeight();
        MutableRect rect = this.cachedRect;
        rect.set(0.0f, 0.0f, width, height);
        this.boundingRectInRoot(coord, rect);
        int l = (int)rect.getLeft();
        int t = (int)rect.getTop();
        int r = (int)rect.getRight();
        int b = (int)rect.getBottom();
        int id = layoutNode.getSemanticsId();
        if (firstPlacement || !this.rects.update(id, l, t, r, b)) {
            LayoutNode layoutNode2 = layoutNode.getParent$ui();
            int parentId = layoutNode2 != null ? layoutNode2.getSemanticsId() : -1;
            boolean bl = false;
            boolean bl2 = false;
            this.rects.insert(id, l, t, r, b, parentId, layoutNode.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(1024)), layoutNode.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(16)));
        }
        this.invalidate();
    }

    private final void insertOrUpdate(LayoutNode layoutNode, boolean firstPlacement, int l, int t, int r, int b) {
        int id = layoutNode.getSemanticsId();
        if (firstPlacement || !this.rects.move(id, l, t, r, b)) {
            LayoutNode layoutNode2 = layoutNode.getParent$ui();
            int parentId = layoutNode2 != null ? layoutNode2.getSemanticsId() : -1;
            boolean bl = false;
            boolean bl2 = false;
            this.rects.insert(id, l, t, r, b, parentId, layoutNode.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(1024)), layoutNode.getNodes$ui().has-H91voCI$ui(NodeKind.constructor-impl(16)));
        }
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    private final void boundingRectInRoot(NodeCoordinator $this$boundingRectInRoot, MutableRect rect) {
        for (NodeCoordinator coordinator = $this$boundingRectInRoot; coordinator != null; coordinator = coordinator.getWrappedBy$ui()) {
            float[] matrix;
            void val1$iv$iv$iv;
            void x$iv$iv;
            OwnedLayer layer = coordinator.getLayer();
            long $this$toOffset_u2d_u2dgyyYBs$iv = coordinator.getPosition-nOcc-ac();
            boolean bl = false;
            float f = IntOffset.getX-impl($this$toOffset_u2d_u2dgyyYBs$iv);
            float y$iv$iv = IntOffset.getY-impl($this$toOffset_u2d_u2dgyyYBs$iv);
            boolean $i$f$Offset = false;
            void var11_11 = x$iv$iv;
            float val2$iv$iv$iv = y$iv$iv;
            boolean $i$f$packFloats = false;
            long v1$iv$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv$iv);
            long v2$iv$iv$iv = Float.floatToRawIntBits(val2$iv$iv$iv);
            rect.translate-k-4lQ0M(Offset.constructor-impl(v1$iv$iv$iv << 32 | v2$iv$iv$iv & 0xFFFFFFFFL));
            if (layer == null || MatrixKt.isIdentity-58bKbWc(matrix = layer.getUnderlyingMatrix-sQKQjiQ())) continue;
            Matrix.map-impl(matrix, rect);
        }
    }

    private final long outerToInnerOffset-Bjo55l4(LayoutNode $this$outerToInnerOffset_u2dBjo55l4) {
        NodeCoordinator terminator = $this$outerToInnerOffset_u2dBjo55l4.getOuterCoordinator$ui();
        long position = Offset.Companion.getZero-F1C5BW0();
        for (NodeCoordinator coordinator = $this$outerToInnerOffset_u2dBjo55l4.getInnerCoordinator$ui(); coordinator != null && coordinator != terminator; coordinator = coordinator.getWrappedBy$ui()) {
            int analysis;
            OwnedLayer layer = coordinator.getLayer();
            position = IntOffsetKt.plus-Nv-tHpc(position, coordinator.getPosition-nOcc-ac());
            if (layer == null) continue;
            float[] matrix = layer.getUnderlyingMatrix-sQKQjiQ();
            int $this$isIdentity$iv = analysis = RectManagerKt.access$analyzeComponents-58bKbWc(matrix);
            boolean $i$f$isIdentity = false;
            if ($this$isIdentity$iv == 3) continue;
            int $this$hasNonTranslationComponents$iv = analysis;
            boolean $i$f$getHasNonTranslationComponents = false;
            if (($this$hasNonTranslationComponents$iv & 2) == 0) {
                return IntOffset.Companion.getMax-nOcc-ac();
            }
            position = Matrix.map-MK-Hz9U(matrix, position);
        }
        return IntOffsetKt.round-k-4lQ0M(position);
    }

    public final void remove(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"layoutNode");
        this.rects.remove(layoutNode.getSemanticsId());
        this.invalidate();
        this.isFragmented = true;
    }

    public final boolean isTargetDrawnFirst$ui(int targetId, int otherId) {
        LayoutNode layoutNode = this.layoutNodes.get(targetId);
        if (layoutNode == null) {
            return false;
        }
        LayoutNode nodeA = layoutNode;
        LayoutNode layoutNode2 = this.layoutNodes.get(otherId);
        if (layoutNode2 == null) {
            return false;
        }
        LayoutNode nodeB = layoutNode2;
        if (nodeA.getDepth$ui() == 0 || nodeB.getDepth$ui() == 0) {
            return false;
        }
        while (nodeA.getDepth$ui() > nodeB.getDepth$ui()) {
            if (nodeA.getParent$ui() != null) continue;
            return false;
        }
        if (nodeA == nodeB) {
            return false;
        }
        while (nodeB.getDepth$ui() > nodeA.getDepth$ui()) {
            if (nodeB.getParent$ui() != null) continue;
            return false;
        }
        if (nodeA == nodeB) {
            return false;
        }
        LayoutNode lastParentA = nodeA;
        LayoutNode lastParentB = nodeB;
        while (nodeA != nodeB) {
            lastParentA = nodeA;
            lastParentB = nodeB;
            if (nodeA.getParent$ui() == null) {
                return false;
            }
            if (nodeB.getParent$ui() != null) continue;
            return false;
        }
        if (lastParentA.getMeasurePassDelegate$ui().getZIndex$ui() == lastParentB.getMeasurePassDelegate$ui().getZIndex$ui()) {
            return lastParentA.getPlaceOrder$ui() < lastParentB.getPlaceOrder$ui();
        }
        return lastParentA.getMeasurePassDelegate$ui().getZIndex$ui() < lastParentB.getMeasurePassDelegate$ui().getZIndex$ui();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FocusTargetModifierNode findFocusableNodeFromRect$ui(int left, int top, int right, int bottom, int containerId) {
        void this_$iv;
        void x$iv$iv;
        void r$iv;
        void x$iv$iv2;
        void t$iv;
        void l$iv;
        SemanticsInfo semanticsInfo;
        LayoutNode layoutNode = this.layoutNodes.get(containerId);
        if (layoutNode == null) {
            return null;
        }
        LayoutNode container2 = layoutNode;
        FocusTargetNode focusTargetNode2 = LayoutNodeKt.requireOwner(container2).getFocusOwner().getActiveFocusTargetNode();
        int currentlyFocusedId = focusTargetNode2 != null && (semanticsInfo = DelegatableNodeKt.requireSemanticsInfo(focusTargetNode2)) != null ? semanticsInfo.getSemanticsId() : -1;
        FocusTargetNode bestTarget = null;
        int bestDepth = 0;
        bestDepth = Integer.MAX_VALUE;
        RectList rectList = this.rects;
        int n = left;
        int n2 = top;
        int n3 = right;
        int b$iv = bottom;
        boolean $i$f$forEachFocusableIntersection = false;
        void var16_17 = l$iv;
        void y$iv$iv = t$iv;
        boolean $i$f$packXY = false;
        long destTopLeft$iv = (long)x$iv$iv2 << 32 | (long)y$iv$iv & 0xFFFFFFFFL;
        $i$f$packXY = r$iv;
        int y$iv$iv2 = b$iv;
        boolean $i$f$packXY2 = false;
        long destBottomRight$iv = (long)x$iv$iv << 32 | (long)y$iv$iv2 & 0xFFFFFFFFL;
        long[] items$iv = this_$iv.items;
        int size$iv = this_$iv.itemsSize;
        for (int i$iv = 0; i$iv < items$iv.length - 2 && i$iv < size$iv; i$iv += 3) {
            Modifier.Node node2;
            LayoutNode node3;
            block14: {
                void this_$iv$iv$iv;
                void this_$iv$iv;
                void type$iv;
                void this_$iv2;
                void destLT$iv$iv;
                void srcRB$iv$iv;
                void srcLT$iv$iv;
                long meta$iv$iv = items$iv[i$iv + 2];
                boolean $i$f$unpackMetaFocusable = false;
                if (((int)(meta$iv$iv >> 62) & 1) == 0) continue;
                long topLeft$iv = items$iv[i$iv + 0];
                long bottomRight$iv = items$iv[i$iv + 1];
                long l = topLeft$iv;
                long l2 = bottomRight$iv;
                long l3 = destTopLeft$iv;
                long destRB$iv$iv = destBottomRight$iv;
                boolean $i$f$rectIntersectsRect = false;
                long a$iv$iv = destRB$iv$iv - srcLT$iv$iv - 0x100000001L | srcRB$iv$iv - destLT$iv$iv - 0x100000001L;
                if (!((a$iv$iv & 0x8000000080000000L) == 0L)) continue;
                long meta$iv$iv2 = items$iv[i$iv + 2];
                boolean $i$f$unpackMetaValue = false;
                int semanticsId = (int)meta$iv$iv2 & 0x3FFFFFF;
                boolean bl = false;
                node3 = this.layoutNodes.get(semanticsId);
                if (node3 == null) continue;
                if (currentlyFocusedId == semanticsId && currentlyFocusedId != -1) {
                    return null;
                }
                if (node3.getDepth$ui() >= bestDepth || !this.isDescendantOf$ui(node3, container2)) continue;
                NodeChain nodeChain = node3.getNodes$ui();
                int n4 = 0;
                n4 = NodeKind.constructor-impl(1024);
                boolean bl2 = false;
                void var48_41 = this_$iv2;
                void type$iv$iv = type$iv;
                boolean bl3 = false;
                void var51_44 = this_$iv$iv;
                void mask$iv$iv$iv = type$iv$iv;
                boolean $i$f$headToTail$ui = false;
                if ((NodeChain.access$getAggregateChildKindSet((NodeChain)this_$iv$iv$iv) & mask$iv$iv$iv) != 0) {
                    void this_$iv$iv$iv$iv = this_$iv$iv$iv;
                    boolean $i$f$headToTail$ui2 = false;
                    for (Modifier.Node node$iv$iv$iv$iv = this_$iv$iv$iv$iv.getHead$ui(); node$iv$iv$iv$iv != null; node$iv$iv$iv$iv = node$iv$iv$iv$iv.getChild$ui()) {
                        Modifier.Node it$iv$iv$iv = node$iv$iv$iv$iv;
                        boolean bl4 = false;
                        if ((it$iv$iv$iv.getKindSet$ui() & mask$iv$iv$iv) != 0) {
                            void $this$dispatchForKind_u2d6rFNWt0$iv$iv$iv;
                            Modifier.Node it$iv$iv = it$iv$iv$iv;
                            boolean bl5 = false;
                            Modifier.Node node4 = it$iv$iv;
                            void kind$iv$iv$iv = type$iv$iv;
                            boolean bl6 = false;
                            MutableVector stack$iv$iv$iv = null;
                            Modifier.Node node$iv$iv$iv = null;
                            node$iv$iv$iv = $this$dispatchForKind_u2d6rFNWt0$iv$iv$iv;
                            while (node$iv$iv$iv != null) {
                                void this_$iv$iv$iv$iv2;
                                if (node$iv$iv$iv instanceof FocusTargetNode) {
                                    Modifier.Node it$iv = node$iv$iv$iv;
                                    boolean bl7 = false;
                                    node2 = it$iv;
                                    break block14;
                                }
                                Modifier.Node node5 = node$iv$iv$iv;
                                void kind$iv$iv$iv$iv = kind$iv$iv$iv;
                                boolean bl8 = false;
                                if ((this_$iv$iv$iv$iv2.getKindSet$ui() & kind$iv$iv$iv$iv) != 0 && node$iv$iv$iv instanceof DelegatingNode) {
                                    int count$iv$iv$iv = 0;
                                    DelegatingNode this_$iv$iv$iv$iv3 = (DelegatingNode)node$iv$iv$iv;
                                    boolean $i$f$forEachImmediateDelegate$ui = false;
                                    for (Modifier.Node node$iv$iv$iv$iv2 = this_$iv$iv$iv$iv3.getDelegate$ui(); node$iv$iv$iv$iv2 != null; node$iv$iv$iv$iv2 = node$iv$iv$iv$iv2.getChild$ui()) {
                                        void this_$iv$iv$iv$iv4;
                                        Modifier.Node next$iv$iv$iv = node$iv$iv$iv$iv2;
                                        boolean bl9 = false;
                                        Modifier.Node node6 = next$iv$iv$iv;
                                        void kind$iv$iv$iv$iv2 = kind$iv$iv$iv;
                                        $i$f$isKind-H91voCI$ui = false;
                                        if (!((this_$iv$iv$iv$iv4.getKindSet$ui() & kind$iv$iv$iv$iv2) != 0)) continue;
                                        if (++count$iv$iv$iv == 1) {
                                            node$iv$iv$iv = next$iv$iv$iv;
                                            continue;
                                        }
                                        MutableVector mutableVector = stack$iv$iv$iv;
                                        if (mutableVector == null) {
                                            boolean $i$f$mutableVectorOf = false;
                                            int capacity$iv$iv$iv$iv$iv = 16;
                                            boolean $i$f$MutableVector = false;
                                            mutableVector = new MutableVector((Object[])new Modifier.Node[capacity$iv$iv$iv$iv$iv], 0);
                                        }
                                        stack$iv$iv$iv = mutableVector;
                                        Modifier.Node theNode$iv$iv$iv = node$iv$iv$iv;
                                        if (theNode$iv$iv$iv != null) {
                                            MutableVector mutableVector2 = stack$iv$iv$iv;
                                            if (mutableVector2 != null) {
                                                mutableVector2.add((Object)theNode$iv$iv$iv);
                                            }
                                            node$iv$iv$iv = null;
                                        }
                                        MutableVector mutableVector3 = stack$iv$iv$iv;
                                        if (mutableVector3 == null) continue;
                                        mutableVector3.add((Object)next$iv$iv$iv);
                                    }
                                    if (count$iv$iv$iv == 1) continue;
                                }
                                node$iv$iv$iv = DelegatableNodeKt.access$pop(stack$iv$iv$iv);
                            }
                        }
                        if ((it$iv$iv$iv.getAggregateChildKindSet$ui() & mask$iv$iv$iv) == 0) break;
                    }
                }
                node2 = null;
            }
            FocusTargetNode target = (FocusTargetNode)node2;
            if (target == null || !this.intersects$ui(target, left, top, right, bottom)) continue;
            bestTarget = target;
            bestDepth = node3.getDepth$ui();
        }
        return bestTarget;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean intersects$ui(@NotNull DelegatableNode $this$intersects, int left, int top, int right, int bottom) {
        void $this$fastRoundToInt$iv;
        void $this$fastRoundToInt$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$intersects, (String)"<this>");
        boolean bl = false;
        NodeCoordinator coordinator = DelegatableNodeKt.requireCoordinator-64DMado($this$intersects, NodeKind.constructor-impl(1024));
        LayoutNode layout2 = coordinator.getLayoutNode();
        if (Intrinsics.areEqual((Object)coordinator, (Object)layout2.getOuterCoordinator$ui())) {
            return true;
        }
        long localTopLeft = LayoutCoordinates.localPositionOf-S_NoaFU$default(layout2.getOuterCoordinator$ui(), coordinator, 0L, false, 6, null);
        long topLeft = layout2.getOuterCoordinator$ui().localToRoot-MK-Hz9U(localTopLeft);
        long size = coordinator.getSize-YbymL2g();
        long arg0$iv22 = topLeft;
        boolean bl2 = false;
        long value$iv$iv = arg0$iv22;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float arg0$iv22 = Float.intBitsToFloat(bits$iv$iv$iv);
        boolean $i$f$fastRoundToInt = false;
        int containerLeft = Math.round((float)$this$fastRoundToInt$iv2);
        long arg0$iv = size;
        boolean bl3 = false;
        long value$iv$iv2 = arg0$iv;
        boolean $i$f$unpackInt1 = false;
        int containerRight = containerLeft + (int)(value$iv$iv2 >> 32);
        long arg0$iv32 = topLeft;
        boolean bl4 = false;
        long value$iv$iv3 = arg0$iv32;
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv3 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        float arg0$iv32 = Float.intBitsToFloat(bits$iv$iv$iv2);
        boolean $i$f$fastRoundToInt2 = false;
        int containerTop = Math.round((float)$this$fastRoundToInt$iv);
        long arg0$iv4 = size;
        boolean bl5 = false;
        long value$iv$iv4 = arg0$iv4;
        boolean $i$f$unpackInt2 = false;
        int containerBottom = containerTop + (int)(value$iv$iv4 & 0xFFFFFFFFL);
        return left < containerRight && right > containerLeft && top < containerBottom && bottom > containerTop;
    }

    public final boolean isDescendantOf$ui(@NotNull LayoutNode $this$isDescendantOf, @NotNull LayoutNode container2) {
        Intrinsics.checkNotNullParameter((Object)$this$isDescendantOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        int ups = $this$isDescendantOf.getDepth$ui() - container2.getDepth$ui();
        if (ups <= 0) {
            return false;
        }
        LayoutNode node2 = null;
        node2 = $this$isDescendantOf;
        int n = 0;
        while (n < ups) {
            int it = n++;
            boolean bl = false;
            if (node2.getParent$ui() != null) continue;
            return false;
        }
        return node2 == container2;
    }

    private static final Unit dispatchLambda$lambda$1(RectManager this$0) {
        this$0.dispatchToken = null;
        String sectionName$iv = "OnPositionedDispatch";
        boolean $i$f$trace = false;
        boolean bl = false;
        this$0.dispatchCallbacks();
        return Unit.INSTANCE;
    }

    private static final Unit dispatchCallbacks$lambda$5$lambda$4(RectManager this$0, ThrottledCallbacks.Entry $entry, long $currentTime, long topLeft, long bottomRight) {
        this$0.throttledCallbacks.fireWithUpdatedRect$ui($entry, topLeft, bottomRight, $currentTime);
        return Unit.INSTANCE;
    }

    public RectManager() {
        this(null, 1, null);
    }
}

