/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.RestrictTo;
import androidx.lifecycle.ClassesInfoCache;
import androidx.lifecycle.CompositeGeneratedAdaptersObserver;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.DefaultLifecycleObserverAdapter;
import androidx.lifecycle.GeneratedAdapter;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.ReflectiveGenericLifecycleObserver;
import androidx.lifecycle.SingleGeneratedAdapterObserver;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0007J \u0010\u0011\u001a\u00020\r2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002J\u001e\u0010\u0013\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\f2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0014\u0010\u0015\u001a\u00020\u00052\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0014\u0010\u0016\u001a\u00020\u00052\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a \u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\r0\f0\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/lifecycle/Lifecycling;", "", "<init>", "()V", "REFLECTIVE_CALLBACK", "", "GENERATED_CALLBACK", "callbackCache", "", "Ljava/lang/Class;", "classToAdapters", "", "Ljava/lang/reflect/Constructor;", "Landroidx/lifecycle/GeneratedAdapter;", "lifecycleEventObserver", "Landroidx/lifecycle/LifecycleEventObserver;", "object", "createGeneratedAdapter", "constructor", "generatedConstructor", "klass", "getObserverConstructorType", "resolveObserverCallbackType", "isLifecycleParent", "", "getAdapterName", "", "className", "lifecycle-common"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class Lifecycling {
    @NotNull
    public static final Lifecycling INSTANCE = new Lifecycling();
    private static final int REFLECTIVE_CALLBACK = 1;
    private static final int GENERATED_CALLBACK = 2;
    @NotNull
    private static final Map<Class<?>, Integer> callbackCache = new HashMap();
    @NotNull
    private static final Map<Class<?>, List<Constructor<? extends GeneratedAdapter>>> classToAdapters = new HashMap();

    private Lifecycling() {
    }

    @JvmStatic
    @NotNull
    public static final LifecycleEventObserver lifecycleEventObserver(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        boolean isLifecycleEventObserver = object instanceof LifecycleEventObserver;
        boolean isDefaultLifecycleObserver = object instanceof DefaultLifecycleObserver;
        if (isLifecycleEventObserver && isDefaultLifecycleObserver) {
            return new DefaultLifecycleObserverAdapter((DefaultLifecycleObserver)object, (LifecycleEventObserver)object);
        }
        if (isDefaultLifecycleObserver) {
            return new DefaultLifecycleObserverAdapter((DefaultLifecycleObserver)object, null);
        }
        if (isLifecycleEventObserver) {
            return (LifecycleEventObserver)object;
        }
        Class<?> klass = object.getClass();
        int type2 = INSTANCE.getObserverConstructorType(klass);
        if (type2 == 2) {
            List<Constructor<? extends GeneratedAdapter>> list = classToAdapters.get(klass);
            Intrinsics.checkNotNull(list);
            List<Constructor<? extends GeneratedAdapter>> constructors = list;
            if (constructors.size() == 1) {
                GeneratedAdapter generatedAdapter = INSTANCE.createGeneratedAdapter(constructors.get(0), object);
                return new SingleGeneratedAdapterObserver(generatedAdapter);
            }
            int n = 0;
            int n2 = constructors.size();
            GeneratedAdapter[] generatedAdapterArray = new GeneratedAdapter[n2];
            while (n < n2) {
                int n3 = n++;
                generatedAdapterArray[n3] = INSTANCE.createGeneratedAdapter(constructors.get(n3), object);
            }
            GeneratedAdapter[] adapters = generatedAdapterArray;
            return new CompositeGeneratedAdaptersObserver(adapters);
        }
        return new ReflectiveGenericLifecycleObserver(object);
    }

    private final GeneratedAdapter createGeneratedAdapter(Constructor<? extends GeneratedAdapter> constructor, Object object) {
        GeneratedAdapter generatedAdapter;
        try {
            Object[] objectArray = new Object[]{object};
            generatedAdapter = constructor.newInstance(objectArray);
            Intrinsics.checkNotNull((Object)generatedAdapter);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return generatedAdapter;
    }

    private final Constructor<? extends GeneratedAdapter> generatedConstructor(Class<?> klass) {
        Constructor<?> constructor;
        try {
            String string;
            Package aPackage = klass.getPackage();
            String name = klass.getCanonicalName();
            Package package_ = aPackage;
            String fullPackage = package_ != null ? package_.getName() : "";
            Intrinsics.checkNotNull((Object)fullPackage);
            if (((CharSequence)fullPackage).length() == 0) {
                string = name;
            } else {
                Intrinsics.checkNotNull((Object)name);
                String string2 = name.substring(fullPackage.length() + 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            String string3 = string;
            Intrinsics.checkNotNull((Object)string3);
            String adapterName = Lifecycling.getAdapterName(string3);
            Class<?> clazz = Class.forName(((CharSequence)fullPackage).length() == 0 ? adapterName : fullPackage + '.' + adapterName);
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<out androidx.lifecycle.GeneratedAdapter>");
            Class<?> aClass = clazz;
            Class[] classArray = new Class[]{klass};
            Constructor<?> constructor2 = aClass.getDeclaredConstructor(classArray);
            if (!constructor2.isAccessible()) {
                constructor2.setAccessible(true);
            }
            constructor = constructor2;
        }
        catch (ClassNotFoundException e) {
            constructor = null;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return constructor;
    }

    private final int getObserverConstructorType(Class<?> klass) {
        Integer callbackCache = Lifecycling.callbackCache.get(klass);
        if (callbackCache != null) {
            return callbackCache;
        }
        int type2 = this.resolveObserverCallbackType(klass);
        Lifecycling.callbackCache.put(klass, type2);
        return type2;
    }

    private final int resolveObserverCallbackType(Class<?> klass) {
        if (klass.getCanonicalName() == null) {
            return 1;
        }
        Constructor<? extends GeneratedAdapter> constructor = this.generatedConstructor(klass);
        if (constructor != null) {
            classToAdapters.put(klass, CollectionsKt.listOf(constructor));
            return 2;
        }
        boolean hasLifecycleMethods = ClassesInfoCache.sInstance.hasLifecycleMethods(klass);
        if (hasLifecycleMethods) {
            return 1;
        }
        Class<?> superclass = klass.getSuperclass();
        List adapterConstructors = null;
        if (this.isLifecycleParent(superclass)) {
            Intrinsics.checkNotNull(superclass);
            if (this.getObserverConstructorType(superclass) == 1) {
                return 1;
            }
            List<Constructor<? extends GeneratedAdapter>> list = classToAdapters.get(superclass);
            Intrinsics.checkNotNull(list);
            adapterConstructors = new ArrayList(list);
        }
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])klass.getInterfaces());
        while (iterator2.hasNext()) {
            Class intrface = (Class)iterator2.next();
            if (!this.isLifecycleParent(intrface)) continue;
            Intrinsics.checkNotNull((Object)intrface);
            if (this.getObserverConstructorType(intrface) == 1) {
                return 1;
            }
            if (adapterConstructors == null) {
                adapterConstructors = new ArrayList();
            }
            List<Constructor<? extends GeneratedAdapter>> list = classToAdapters.get(intrface);
            Intrinsics.checkNotNull(list);
            adapterConstructors.addAll((Collection)list);
        }
        if (adapterConstructors != null) {
            classToAdapters.put(klass, adapterConstructors);
            return 2;
        }
        return 1;
    }

    private final boolean isLifecycleParent(Class<?> klass) {
        return klass != null && LifecycleObserver.class.isAssignableFrom(klass);
    }

    @JvmStatic
    @NotNull
    public static final String getAdapterName(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return StringsKt.replace$default((String)className, (String)".", (String)"_", (boolean)false, (int)4, null) + "_LifecycleAdapter";
    }
}

