/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.OpenConfigurationAction;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\r\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fH\u0016J\u001f\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e2\u0006\u0010\b\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\n\u0010\u0012\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0015\u0010\u0016\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u001b\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/prettierjs/codeStyle/PrettierCodeStyleStatusBarUIContributor;", "Lcom/intellij/psi/codeStyle/modifier/CodeStyleStatusBarUIContributor;", "<init>", "()V", "myIndentOptionsForFileInEditor", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "areActionsAvailable", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getActionGroupTitle", "", "Lcom/intellij/openapi/util/NlsContexts$PopupTitle;", "getActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getTooltip", "createDisableAction", "project", "Lcom/intellij/openapi/project/Project;", "getStatusText", "Lcom/intellij/openapi/util/NlsContexts$StatusBarText;", "psiFile", "createNavigationActions", "createDisableCodeStyleModifierAction", "ReEnableAction", "OpenSettingsDialogAction", "intellij.prettierJS"})
@SourceDebugExtension(value={"SMAP\nPrettierCodeStyleStatusBarUIContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierCodeStyleStatusBarUIContributor.kt\ncom/intellij/prettierjs/codeStyle/PrettierCodeStyleStatusBarUIContributor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,97:1\n37#2,2:98\n*S KotlinDebug\n*F\n+ 1 PrettierCodeStyleStatusBarUIContributor.kt\ncom/intellij/prettierjs/codeStyle/PrettierCodeStyleStatusBarUIContributor\n*L\n58#1:98,2\n*E\n"})
public final class PrettierCodeStyleStatusBarUIContributor
implements CodeStyleStatusBarUIContributor {
    @Nullable
    private CommonCodeStyleSettings.IndentOptions myIndentOptionsForFileInEditor;

    public boolean areActionsAvailable(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    @NotNull
    public String getActionGroupTitle() {
        String string = PrettierBundle.message("prettier.code.style.status.bar.action.group.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public AnAction[] getActions(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.createNavigationActions(file);
    }

    @Nullable
    public String getTooltip() {
        CommonCodeStyleSettings.IndentOptions optionsForFileInEditor = this.myIndentOptionsForFileInEditor;
        if (optionsForFileInEditor == null) {
            return null;
        }
        return IndentStatusBarUIContributor.createTooltip((String)IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)optionsForFileInEditor), (String)this.getActionGroupTitle());
    }

    @NotNull
    public AnAction createDisableAction(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.createDisableCodeStyleModifierAction(project);
    }

    @NotNull
    public String getStatusText(@NotNull PsiFile psiFile) {
        CommonCodeStyleSettings.IndentOptions optionsForFileInEditor;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getSettings((PsiFile)psiFile).getIndentOptions(psiFile.getFileType());
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
        this.myIndentOptionsForFileInEditor = optionsForFileInEditor = indentOptions;
        String string = IndentStatusBarUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)optionsForFileInEditor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIndentInfo(...)");
        return string;
    }

    private final AnAction[] createNavigationActions(PsiFile file) {
        List list;
        List $this$createNavigationActions_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        $this$createNavigationActions_u24lambda_u240.add(new OpenConfigurationAction(project, virtualFile, null, 4, null));
        $this$createNavigationActions_u24lambda_u240.add(new OpenSettingsDialogAction());
        Collection $this$toTypedArray$iv = CollectionsKt.build((List)list);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AnAction[0]);
    }

    private final AnAction createDisableCodeStyleModifierAction(Project project) {
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)PrettierBundle.message("prettier.action.disable.for.project.label", new Object[0]), arg_0 -> PrettierCodeStyleStatusBarUIContributor.createDisableCodeStyleModifierAction$lambda$1(arg_0 -> PrettierCodeStyleStatusBarUIContributor.createDisableCodeStyleModifierAction$lambda$0(project, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        return (AnAction)dumbAwareAction;
    }

    private static final Unit createDisableCodeStyleModifierAction$lambda$0(Project $project, AnActionEvent anActionEvent) {
        Notification notification;
        PrettierConfiguration.getInstance((Project)$project).getState().codeStyleSettingsModifierEnabled = false;
        CodeStyleSettingsManager.getInstance((Project)$project).notifyCodeStyleSettingsChanged();
        String string = PrettierBundle.message("prettier.formatter.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = PrettierBundle.message("prettier.notification.content.code.style.settings.modifier.has.been.disabled", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Notification $this$createDisableCodeStyleModifierAction_u24lambda_u240_u240 = notification = JSLinterGuesser.NOTIFICATION_GROUP.createNotification(string, string2, NotificationType.INFORMATION);
        boolean bl = false;
        Object[] objectArray = new DumbAwareAction[]{new ReEnableAction($project, $this$createDisableCodeStyleModifierAction_u24lambda_u240_u240), new OpenSettingsDialogAction()};
        $this$createDisableCodeStyleModifierAction_u24lambda_u240_u240.addActions((Collection)CollectionsKt.listOf((Object[])objectArray));
        $this$createDisableCodeStyleModifierAction_u24lambda_u240_u240.notify($project);
        return Unit.INSTANCE;
    }

    private static final void createDisableCodeStyleModifierAction$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/prettierjs/codeStyle/PrettierCodeStyleStatusBarUIContributor$OpenSettingsDialogAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.prettierJS"})
    private static final class OpenSettingsDialogAction
    extends DumbAwareAction {
        public OpenSettingsDialogAction() {
            super(PrettierBundle.message("prettier.action.open.settings.label", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            ShowSettingsUtilImpl.Companion.showSettingsDialog(e.getProject(), "settings.javascript.prettier", "Prettier");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/prettierjs/codeStyle/PrettierCodeStyleStatusBarUIContributor$ReEnableAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "project", "Lcom/intellij/openapi/project/Project;", "notification", "Lcom/intellij/notification/Notification;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/notification/Notification;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.prettierJS"})
    private static final class ReEnableAction
    extends DumbAwareAction {
        @NotNull
        private final Project project;
        @NotNull
        private final Notification notification;

        public ReEnableAction(@NotNull Project project, @NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            super(PrettierBundle.message("prettier.action.reenable.label", new Object[0]));
            this.project = project;
            this.notification = notification;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PrettierConfiguration.getInstance((Project)this.project).getState().codeStyleSettingsModifierEnabled = true;
            CodeStyleSettingsManager.getInstance((Project)this.project).notifyCodeStyleSettingsChanged();
            this.notification.expire();
        }
    }
}

