/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.config.ApplyJschBasedOpenSshConfig;
import com.intellij.ssh.config.OpenSshConfigViaToolService;
import com.intellij.ssh.config.SshConfigParseException;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigKt;
import com.intellij.ssh.config.SshConnectionConfigService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/ssh/config/ProductionSshConnectionConfigDelegate;", "Lcom/intellij/ssh/config/SshConnectionConfigService$Delegate;", "ProductionSshConnectionConfigDelegate", "()V", "get", "Lcom/intellij/ssh/config/SshConnectionConfig;", "host", "", "useOpenSshConfig", "", "P", "M", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshConnectionConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshConnectionConfigService.kt\ncom/intellij/ssh/config/ProductionSshConnectionConfigDelegate\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,317:1\n13#2:318\n*S KotlinDebug\n*F\n+ 1 SshConnectionConfigService.kt\ncom/intellij/ssh/config/ProductionSshConnectionConfigDelegate\n*L\n284#1:318\n*E\n"})
public final class ProductionSshConnectionConfigDelegate
implements SshConnectionConfigService.Delegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    @NotNull
    public SshConnectionConfig get(@NotNull String host, boolean useOpenSshConfig) throws SshConfigParseException {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return switch (WhenMappings.$EnumSwitchMapping$0[SshConnectionConfigService.Companion.getInstance().getKind().ordinal()]) {
            case 1 -> this.P(host, useOpenSshConfig);
            case 2 -> this.M(host, useOpenSshConfig);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final SshConnectionConfig P(String string, boolean bl) {
        List list;
        Object object = new SshConnectionConfig(string);
        if (bl) {
            Path[] pathArray = new Path[]{SystemInfo.isUnix ? Paths.get("/etc/ssh/ssh_config", new String[0]) : null, Ssh.getHomeSshDirectory().resolve("config")};
            list = CollectionsKt.listOfNotNull((Object[])pathArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        List list2 = list;
        for (Path path2 : list2) {
            Object object2;
            try {
                object2 = PathsKt.readText$default((Path)path2, null, (int)1, null);
            }
            catch (IOException iOException) {
                if (iOException instanceof FileNotFoundException || iOException instanceof NoSuchFileException) {
                    LOG.debug(path2 + " was not found.");
                    continue;
                }
                LOG.warn("Failed to read " + path2, (Throwable)iOException);
                continue;
            }
            String string2 = object2;
            object2 = ApplyJschBasedOpenSshConfig.applyJschBasedOpenSshConfig((SshConnectionConfig)object, string2);
            if (LOG.isDebugEnabled()) {
                String string3 = CollectionsKt.joinToString$default((Iterable)SshConnectionConfigKt.sshConnectionConfigDiff((SshConnectionConfig)object, (SshConnectionConfig)object2), (CharSequence)"\n", null, null, (int)0, null, ProductionSshConnectionConfigDelegate::P, (int)30, null);
                if (((CharSequence)string3).length() > 0) {
                    LOG.debug("Found specific settings in " + path2 + " for host " + string + ":\n" + string3);
                } else {
                    LOG.debug("Found no specific settings in " + path2 + " for host " + string);
                }
            }
            object = object2;
        }
        return ApplyJschBasedOpenSshConfig.addDefaultPrivateKeysIfNeeded((SshConnectionConfig)object);
    }

    private final SshConnectionConfig M(String string, boolean bl) throws SshConfigParseException {
        if (bl) {
            try {
                return OpenSshConfigViaToolService.Companion.getInstance().get(string);
            }
            catch (ProcessNotCreatedException processNotCreatedException) {
                LOG.warn("Failed to retrieve SSH configuration via OpenSSH. Falling back to the legacy parser. Error: " + processNotCreatedException);
            }
        }
        return ApplyJschBasedOpenSshConfig.addDefaultPrivateKeysIfNeeded(new SshConnectionConfig(string));
    }

    private static final CharSequence P(Triple triple) {
        Intrinsics.checkNotNullParameter((Object)triple, (String)"<destruct>");
        String string = (String)triple.component1();
        Object object = triple.component3();
        return "  " + string + ": " + object;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(ProductionSshConnectionConfigDelegate.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ssh/config/ProductionSshConnectionConfigDelegate$Companion;", "", "ProductionSshConnectionConfigDelegate$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ssh"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SshConnectionConfigService.Kind.values().length];
            try {
                nArray[SshConnectionConfigService.Kind.LEGACY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigService.Kind.OPENSSH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

