/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsonpath.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jsonpath.JsonPathBundle;
import com.intellij.jsonpath.JsonPathConstants;
import com.intellij.jsonpath.psi.JsonPathBinaryConditionalOperator;
import com.intellij.jsonpath.psi.JsonPathTypes;
import com.intellij.jsonpath.psi.JsonPathVisitor;
import com.intellij.jsonpath.ui.JsonPathEvaluateManager;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class JsonPathUnknownOperatorInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JsonPathUnknownOperatorInspection.$$$reportNull$$$0(0);
        }
        return new JsonPathVisitor(this){

            @Override
            public void visitBinaryConditionalOperator(@NotNull JsonPathBinaryConditionalOperator operator) {
                if (operator == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitBinaryConditionalOperator(operator);
                ASTNode namedOp = operator.getNode().findChildByType(JsonPathTypes.NAMED_OP);
                if (namedOp == null) {
                    return;
                }
                String operatorName = namedOp.getText();
                if (!JsonPathConstants.STANDARD_NAMED_OPERATORS.contains(operatorName)) {
                    boolean isEvaluateExpr = Boolean.TRUE.equals(holder.getFile().getUserData(JsonPathEvaluateManager.JSON_PATH_EVALUATE_EXPRESSION_KEY));
                    if (isEvaluateExpr) {
                        holder.registerProblem((PsiElement)operator, JsonPathBundle.message("inspection.message.jsonpath.unsupported.jayway.operator", operatorName), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                    } else {
                        holder.registerProblem((PsiElement)operator, null, JsonPathBundle.message("inspection.message.jsonpath.unknown.operator.name", operatorName), new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "com/intellij/jsonpath/inspections/JsonPathUnknownOperatorInspection$1", "visitBinaryConditionalOperator"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/jsonpath/inspections/JsonPathUnknownOperatorInspection", "buildVisitor"));
    }
}

