/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.conflicts.MergeTransferOperation;
import com.jetbrains.plugins.webDeployment.conflicts.RemoteChangeNotifier;
import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;

public enum DeploymentMode {
    SAFE{

        @Override
        public void sourceNotExist(FileObject target, ExecutionContext context, List<TransferOperation> result, boolean reCheck) throws CustomFileSystemException {
            DeploymentMode.deleteWithCheck(target, context, result, FileType.FILE);
        }

        @Override
        public void sourceIsFile(FileObject source, FileObject target, ExecutionContext context, List<TransferOperation> result) throws FileSystemException {
            try {
                FileObject local = context.isServerSideModification() ? source : target;
                DeploymentRevisionTracker.Revision revision = context.getRevisionTracker().getBaseRevision(DeploymentPathUtils.getLocalPath(local), context.getServer());
                if (revision == null && !target.exists()) {
                    result.add(new TransferOperation.Copy(source, target));
                } else if (RemoteChangeNotifier.isFileChanged(source, revision, context.getConfig().getPromptOnRemoteOverwrite(), context.getProgressIndicator())) {
                    result.add(new MergeTransferOperation(source, target, revision));
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                throw new CustomFileSystemException(WDBundle.message("failed.to.check.remote.file.0", source));
            }
        }

        @Override
        public boolean isDeleteMissingItemsPossible(ExecutionContext context) {
            return true;
        }
    }
    ,
    CUSTOM{

        @Override
        public void sourceNotExist(FileObject target, ExecutionContext context, List<TransferOperation> result, boolean reCheck) throws FileSystemException {
            if (!reCheck || context.getConfig().isDeleteMissingItems() && target.exists()) {
                result.add(context.getConfig().isConfirmBeforeDeletion() ? new TransferOperation.UserConfirmedDelete(target, target.getType()) : new TransferOperation.Delete(target, target.getType() == FileType.FOLDER, true));
            }
        }

        @Override
        public void sourceIsFile(FileObject source, FileObject target, ExecutionContext context, List<TransferOperation> result) throws FileSystemException {
            if (context.getServer().isUseRsync()) {
                result.add(new TransferOperation.RsyncCopy(source, target));
            } else {
                result.add(new TransferOperation.Copy(source, target));
            }
        }

        @Override
        public boolean isDeleteMissingItemsPossible(ExecutionContext context) {
            return context.getConfig().isDeleteMissingItems();
        }
    };

    private static final Logger LOG;

    public abstract void sourceNotExist(FileObject var1, ExecutionContext var2, List<TransferOperation> var3, boolean var4) throws FileSystemException;

    public abstract void sourceIsFile(FileObject var1, FileObject var2, ExecutionContext var3, List<TransferOperation> var4) throws FileSystemException;

    public abstract boolean isDeleteMissingItemsPossible(ExecutionContext var1);

    private static void deleteWithCheck(FileObject target, ExecutionContext context, List<TransferOperation> result, FileType fileType) throws CustomFileSystemException {
        DeploymentRevisionTracker.Revision revision;
        Pair<DeploymentPathMapping, Boolean> mappingPair;
        FileObject localFile = target;
        if (context.isServerSideModification() && (mappingPair = context.getConfig().getNearestMappingDeploy2Local(target, false, (Mappable)context.getServer())).getFirst() != null) {
            try {
                localFile = ((DeploymentPathMapping)mappingPair.getFirst()).mapToLocalFile(target, context.getServer());
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                throw new CustomFileSystemException("Failed to map remote file ''" + context.getServer().getPresentablePath(target) + "''");
            }
        }
        DeploymentRevisionTracker.Revision revision2 = revision = localFile == null ? null : context.getRevisionTracker().getBaseRevision(DeploymentPathUtils.getLocalPath(localFile), context.getServer());
        if (revision != null) {
            try {
                if (RemoteChangeNotifier.isFileEqualToRevision(target, revision, context)) {
                    result.add(new TransferOperation.Delete(target, fileType == FileType.FOLDER, true));
                } else {
                    result.add(new TransferOperation.UserConfirmedDelete(target, fileType));
                }
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                throw new CustomFileSystemException(WDBundle.message("failed.to.load.local.file.0.content", target.getName().getPath()));
            }
        }
    }

    static {
        LOG = Logger.getInstance(DeploymentMode.class);
    }
}

