/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.gherkin;

import com.google.common.collect.Sets;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.gherkin.PyBDDCreationTools;
import com.intellij.python.gherkin.PyBDDFramework;
import com.intellij.python.gherkin.PyBDDPackageInfo;
import com.intellij.python.gherkin.PyBDDStepDefinitionCreator;
import com.intellij.python.gherkin.PyStepDefinition;
import com.intellij.python.gherkin.api.PyGherkinApi;
import com.intellij.python.gherkin.matchers.PyBDDMatcher;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.stubs.PyDecoratorStubIndex;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.OptionalStepDefinitionExtensionPoint;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.steps.AbstractCucumberExtension;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public abstract class PyCucumberJvmExtensionPoint
extends AbstractCucumberExtension
implements PyBDDFramework,
OptionalStepDefinitionExtensionPoint {
    @NotNull
    private final PyBDDPackageInfo myPackageInfo;
    @NotNull
    private final List<String> myStepDecoratorNames;
    private final Pair<String, String> @NotNull [] myStepDefinitionParams;

    protected PyCucumberJvmExtensionPoint(@NotNull PyBDDPackageInfo packageInfo, @NotNull Iterable<String> stepDecoratorNames, Pair<String, String> ... stepDefinitionParams) {
        if (packageInfo == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(0);
        }
        if (stepDecoratorNames == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(1);
        }
        if (stepDefinitionParams == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(2);
        }
        this.myStepDecoratorNames = new ArrayList<String>();
        this.myPackageInfo = packageInfo;
        this.myStepDecoratorNames.addAll(Sets.newHashSet(stepDecoratorNames));
        this.myStepDefinitionParams = (Pair[])stepDefinitionParams.clone();
    }

    public final boolean isStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        PyFile file;
        if (child == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(4);
        }
        if ((file = (PyFile)PyUtil.as((Object)child, PyFile.class)) == null) {
            return false;
        }
        TypeEvalContext context = TypeEvalContext.deepCodeInsight((Project)child.getProject());
        return this.isFrameworkStepDefinition(file, context);
    }

    public final boolean isWritableStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        PyFile file;
        if (child == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(6);
        }
        if ((file = (PyFile)PyUtil.as((Object)child, PyFile.class)) == null) {
            return false;
        }
        TypeEvalContext context = TypeEvalContext.deepCodeInsight((Project)child.getProject());
        return this.isFileMayBeStepDefinition(file, context);
    }

    @Override
    public boolean isFrameworkStepDefinition(@NotNull PyFile file, @NotNull TypeEvalContext evalContext) {
        if (file == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(7);
        }
        if (evalContext == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(8);
        }
        return !this.findStepDefDecorators(file.getProject(), GlobalSearchScope.fileScope((PsiFile)file), evalContext).isEmpty();
    }

    @NotNull
    public final StepDefinitionCreator getStepDefinitionCreator() {
        return new PyBDDStepDefinitionCreator(this);
    }

    @NotNull
    public final List<AbstractStepDefinition> loadStepsFor(@Nullable PsiFile featureFile, @NotNull Module module) {
        if (module == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(9);
        }
        if (this.isExplicitlyNotRecommended(module)) {
            List<AbstractStepDefinition> list = Collections.emptyList();
            if (list == null) {
                PyCucumberJvmExtensionPoint.$$$reportNull$$$0(10);
            }
            return list;
        }
        TypeEvalContext context = TypeEvalContext.deepCodeInsight((Project)module.getProject());
        if (featureFile == null) {
            return PyCucumberJvmExtensionPoint.loadStepsForInternal(module, this, context);
        }
        List list = (List)PyUtil.getParameterizedCachedValue((PsiElement)featureFile, (Object)this, dom -> PyCucumberJvmExtensionPoint.loadStepsForInternal(module, dom, context));
        if (list == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    private static List<AbstractStepDefinition> loadStepsForInternal(@NotNull Module module, @NotNull PyCucumberJvmExtensionPoint point, @NotNull TypeEvalContext context) {
        if (module == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(12);
        }
        if (point == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(14);
        }
        ArrayList<AbstractStepDefinition> result = new ArrayList<AbstractStepDefinition>();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module).uniteWith(GlobalSearchScope.moduleWithDependentsScope((Module)module));
        for (PyDecorator decorator : point.findStepDefDecorators(module.getProject(), scope, context)) {
            result.add(point.createStepDefinition(decorator, context));
        }
        ArrayList<AbstractStepDefinition> arrayList = result;
        if (arrayList == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public PyStepDefinition createStepDefinition(@NotNull PyDecorator decorator, @NotNull TypeEvalContext context) {
        if (decorator == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(16);
        }
        if (context == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(17);
        }
        return new PyStepDefinition(decorator, context);
    }

    @NotNull
    public final Collection<? extends PsiFile> getStepDefinitionContainers(@NotNull GherkinFile file) {
        Module module;
        if (file == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(18);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PyCucumberJvmExtensionPoint.$$$reportNull$$$0(19);
            }
            return list;
        }
        TypeEvalContext context = TypeEvalContext.deepCodeInsight((Project)module.getProject());
        HashSet<PsiFile> result = new HashSet<PsiFile>();
        for (PyDecorator decorator : this.findStepDefDecorators(file.getProject(), GlobalSearchScope.moduleWithDependentsScope((Module)module), context)) {
            result.add(decorator.getContainingFile());
        }
        HashSet<PsiFile> hashSet = result;
        if (hashSet == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public String getFrameworkName() {
        String string = this.myPackageInfo.getSetupToolsName();
        if (string == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    public boolean isStepDefinition(@NotNull PyDecorator possibleStepDefinition, boolean ensureRegexpCouldBeUsed, @NotNull TypeEvalContext context) {
        PyFile file;
        if (possibleStepDefinition == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(23);
        }
        if ((file = (PyFile)PyUtil.as((Object)possibleStepDefinition.getContainingFile(), PyFile.class)) == null || !this.isFileMayBeStepDefinition(file, context)) {
            return false;
        }
        QualifiedName qualifiedName = possibleStepDefinition.getQualifiedName();
        if (qualifiedName != null) {
            return this.myStepDecoratorNames.contains(qualifiedName.toString());
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<PyDecorator> findStepDefDecorators(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull TypeEvalContext context) {
        if (project == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(25);
        }
        if (context == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(26);
        }
        ArrayList<PyDecorator> result = new ArrayList<PyDecorator>();
        for (String decoratorName2 : this.myStepDecoratorNames) {
            Collection decoratorsFromIndex = StubIndex.getElements((StubIndexKey)PyDecoratorStubIndex.KEY, (Object)decoratorName2, (Project)project, (GlobalSearchScope)scope, PyDecorator.class);
            for (PyDecorator decorator : decoratorsFromIndex) {
                PyFile fileWithDecorator = (PyFile)PyUtil.as((Object)decorator.getContainingFile(), PyFile.class);
                if (fileWithDecorator == null || !this.isFileMayBeStepDefinition(fileWithDecorator, context)) continue;
                result.add(decorator);
            }
        }
        ArrayList<PyDecorator> arrayList = result;
        if (arrayList == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @Override
    public boolean isFileMayBeStepDefinition(@NotNull PyFile file, @NotNull TypeEvalContext context) {
        if (file == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(28);
        }
        if (context == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(29);
        }
        return this.isFileContainsAppropriateImports(file, context);
    }

    @NotNull
    public BDDFrameworkType getStepFileType() {
        return new BDDFrameworkType((FileType)PythonFileType.INSTANCE, this.getFrameworkName());
    }

    public boolean participateInStepDefinitionCreation(@NotNull PsiElement anchor) {
        Module module;
        if (anchor == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(30);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)anchor)) == null) {
            return false;
        }
        PyGherkinApi api = new PyGherkinApi(module);
        if (api.getPreferedFramework() == null) {
            TypeEvalContext context = TypeEvalContext.deepCodeInsight((Project)anchor.getProject());
            PyCucumberJvmExtensionPoint.tryToSetPreferedFramework(api, context);
        }
        return !this.isExplicitlyNotRecommended(module);
    }

    @Override
    public boolean isExplicitlyNotRecommended(@NotNull Module module) {
        PyBDDFramework recommendedFramework;
        if (module == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(31);
        }
        return (recommendedFramework = new PyGherkinApi(module).getPreferedFramework()) != null && !this.equals(recommendedFramework);
    }

    private boolean isFileContainsAppropriateImports(@NotNull PyFile pyFile, @NotNull TypeEvalContext context) {
        if (pyFile == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(32);
        }
        if (context == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(33);
        }
        QualifiedName packageQName = QualifiedName.fromComponents((String[])new String[]{this.myPackageInfo.getPythonPackageName()});
        for (PyFromImportStatement importStatement : pyFile.getFromImports()) {
            if (!packageQName.equals((Object)importStatement.getImportSourceQName())) continue;
            return true;
        }
        if (!context.maySwitchToAST((PsiElement)pyFile)) {
            return false;
        }
        for (PyImportElement importElement : pyFile.getImportTargets()) {
            PyReferenceExpression referenceExpression;
            if (!packageQName.equals((Object)importElement.getImportedQName()) || (referenceExpression = importElement.getImportReferenceExpression()) == null || referenceExpression.getReference().resolve() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void createStepDefinition(@NotNull GherkinStep step, @NotNull PsiFile file) {
        if (step == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(34);
        }
        if (file == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(35);
        }
        PyBDDCreationTools.addStepDefinition(file, this.getDecoratorName(step), step, this.getBDDMatcherByFile(file), this.myStepDefinitionParams);
    }

    @Nullable
    protected PyBDDMatcher getBDDMatcherByFile(@NotNull PsiFile file) {
        if (file == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(36);
        }
        return PyBDDMatcher.RE;
    }

    @Override
    @NotNull
    public List<Pair<String, String>> getStepDefinitionRequiredParams() {
        List<Pair<String, String>> list = Arrays.asList(this.myStepDefinitionParams);
        if (list == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(37);
        }
        return list;
    }

    @NotNull
    protected abstract String getDecoratorName(@NotNull GherkinStep var1);

    private static void tryToSetPreferedFramework(@NotNull PyGherkinApi api, @NotNull TypeEvalContext context) {
        Collection<PyBDDFramework> frameworksWithStepDefinitions;
        if (api == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(38);
        }
        if (context == null) {
            PyCucumberJvmExtensionPoint.$$$reportNull$$$0(39);
        }
        if ((frameworksWithStepDefinitions = api.whichFrameworksHaveStepDefinitions(context)).size() == 1) {
            api.setPreferedFramework(frameworksWithStepDefinitions.iterator().next());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 15, 19, 20, 21, 27, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDecoratorNames";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stepDefinitionParams";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: 
            case 18: 
            case 28: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evalContext";
                break;
            }
            case 9: 
            case 12: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/gherkin/PyCucumberJvmExtensionPoint";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 14: 
            case 17: 
            case 23: 
            case 26: 
            case 29: 
            case 33: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleStepDefinition";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFile";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "api";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/gherkin/PyCucumberJvmExtensionPoint";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadStepsFor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadStepsForInternal";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionContainers";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkName";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findStepDefDecorators";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getStepDefinitionRequiredParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isStepLikeFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isWritableStepLikeFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFrameworkStepDefinition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadStepsFor";
                break;
            }
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 37: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadStepsForInternal";
                break;
            }
            case 16: 
            case 17: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createStepDefinition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getStepDefinitionContainers";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isStepDefinition";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findStepDefDecorators";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isFileMayBeStepDefinition";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "participateInStepDefinitionCreation";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isExplicitlyNotRecommended";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isFileContainsAppropriateImports";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getBDDMatcherByFile";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "tryToSetPreferedFramework";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 15, 19, 20, 21, 27, 37 -> new IllegalStateException(string);
        };
    }
}

