/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.profiler;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.python.profiler.FunctionSample;
import com.intellij.python.profiler.ProfilerLogKt;
import com.intellij.python.profiler.Sample;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aJ\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u000226\u0010\u0003\u001a2\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00020\t0\u0004\u001aE\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002\"\u000e\b\u0001\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0\f2!\u0010\r\u001a\u001d\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u0002H\u000b0\u000e\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0007\u001a\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u001a\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0011\u00a8\u0006\u0019"}, d2={"nullableComparator", "Ljava/util/Comparator;", "T", "compareFunc", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "o1", "o2", "", "fieldComparator", "V", "", "getComparableField", "Lkotlin/Function1;", "o", "percent", "", "value", "total", "formatPercent", "percentValue", "", "parseVmProfSampleName", "Lcom/intellij/python/profiler/Sample;", "intellij.python.profiler"})
public final class UtilsKt {
    @NotNull
    public static final <T> Comparator<T> nullableComparator(@NotNull Function2<? super T, ? super T, Integer> compareFunc) {
        Intrinsics.checkNotNullParameter(compareFunc, (String)"compareFunc");
        return (arg_0, arg_1) -> UtilsKt.nullableComparator$lambda$0(compareFunc, arg_0, arg_1);
    }

    @NotNull
    public static final <T, V extends Comparable<? super V>> Comparator<T> fieldComparator(@NotNull Function1<? super T, ? extends V> getComparableField) {
        Intrinsics.checkNotNullParameter(getComparableField, (String)"getComparableField");
        return (arg_0, arg_1) -> UtilsKt.fieldComparator$lambda$0(getComparableField, arg_0, arg_1);
    }

    @NlsSafe
    @NotNull
    public static final String percent(int value2, int total) {
        return UtilsKt.formatPercent((double)value2 / (double)total);
    }

    @NlsSafe
    @NotNull
    public static final String formatPercent(double percentValue) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumFractionDigits(1);
        String string = numberFormat.format(percentValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    @NotNull
    public static final Sample parseVmProfSampleName(@NotNull String name) {
        String funname;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String[] stringArray = new String[]{":"};
        List parts = StringsKt.split$default((CharSequence)name, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() == 1) {
            funname = (String)parts.get(0);
            return new FunctionSample(funname, null, null);
        }
        if (parts.size() >= 4) {
            funname = (String)parts.get(1);
            int funline = Integer.parseInt((String)parts.get(2));
            String filename = parts.size() == 5 ? "" + parts.get(3) + parts.get(4) : (String)parts.get(3);
            return new FunctionSample(funname, funline, filename);
        }
        ProfilerLogKt.getLOG().warn("Unrecognized node with name '" + name + "'");
        return new FunctionSample(null, null, name);
    }

    private static final int nullableComparator$lambda$0(Function2 $compareFunc, Object o1, Object o2) {
        return o1 != null && o2 != null ? ((Number)$compareFunc.invoke(o1, o2)).intValue() : (o1 != null ? 1 : -1);
    }

    private static final int fieldComparator$lambda$0(Function1 $getComparableField, Object o1, Object o2) {
        return o1 != null && o2 != null ? ((Comparable)$getComparableField.invoke(o1)).compareTo($getComparableField.invoke(o2)) : (o1 != null ? 1 : -1);
    }
}

