/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.inspections.utils;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.icons.AllIcons;
import com.intellij.scientific.py.tables.PyTablesBundle;
import com.intellij.scientific.py.tables.inspections.InspectionsController;
import com.intellij.scientific.py.tables.inspections.api.InspectionsExecutionState;
import com.intellij.scientific.py.tables.inspections.utils.TableInspectionSupportService;
import com.intellij.scientific.tables.panel.DSTableImpl;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import java.awt.Component;
import java.awt.Point;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0005J\u0013\u0010\u0011\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00122\u0006\u0010\n\u001a\u00020\u0005J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/scientific/py/tables/inspections/utils/TableInspectionActionUtils;", "", "<init>", "()V", "determineActionState", "Lcom/intellij/scientific/py/tables/inspections/api/InspectionsExecutionState;", "table", "Lcom/intellij/scientific/tables/panel/DSTableImpl;", "isVisibleToolbarAction", "", "state", "isEnabledToolbarAction", "isVisibleInMoreAction", "getIconAndText", "Lkotlin/Pair;", "Ljavax/swing/Icon;", "", "getDescription", "Lcom/intellij/openapi/util/NlsSafe;", "computeRelativePoint", "Lcom/intellij/ui/awt/RelativePoint;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "popup", "Lcom/intellij/ui/popup/AbstractPopup;", "DEFAULT_HEIGHT_DELTA", "", "intellij.scientific.py.tables"})
public final class TableInspectionActionUtils {
    @NotNull
    public static final TableInspectionActionUtils INSTANCE = new TableInspectionActionUtils();
    private static final int DEFAULT_HEIGHT_DELTA = 15;

    private TableInspectionActionUtils() {
    }

    @NotNull
    public final InspectionsExecutionState determineActionState(@NotNull DSTableImpl table) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if (TableInspectionSupportService.INSTANCE.canRunInspection(table)) {
            object = InspectionsController.Companion.findInspectionsController(table);
            if (object == null || (object = ((InspectionsController)object).getExecutionState()) == null) {
                object = InspectionsExecutionState.ReadyToRun.INSTANCE;
            }
        } else {
            object = InspectionsExecutionState.SwitchedOff.INSTANCE;
        }
        return object;
    }

    public final boolean isVisibleToolbarAction(@NotNull InspectionsExecutionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return !(state instanceof InspectionsExecutionState.SwitchedOff) && !(state instanceof InspectionsExecutionState.ReadyToRun);
    }

    public final boolean isEnabledToolbarAction(@NotNull InspectionsExecutionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return !(state instanceof InspectionsExecutionState.Completed) || ((InspectionsExecutionState.Completed)state).getIssueCount() != 0;
    }

    public final boolean isVisibleInMoreAction(@NotNull InspectionsExecutionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return state instanceof InspectionsExecutionState.ReadyToRun;
    }

    @Nullable
    public final Pair<Icon, String> getIconAndText(@NotNull InspectionsExecutionState state) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        InspectionsExecutionState inspectionsExecutionState = state;
        if (inspectionsExecutionState instanceof InspectionsExecutionState.SwitchedOff) {
            pair = null;
        } else if (inspectionsExecutionState instanceof InspectionsExecutionState.ReadyToRun) {
            pair = new Pair((Object)AllIcons.General.ShowWarning, (Object)PyTablesBundle.message("popup.inspections.ready.to.run.text", new Object[0]));
        } else if (inspectionsExecutionState instanceof InspectionsExecutionState.Running) {
            Object[] objectArray = new Object[]{((InspectionsExecutionState.Running)state).getIssueCount()};
            Pair pair2 = new Pair((Object)AnimatedIcon.Default.INSTANCE, (Object)PyTablesBundle.message("popup.inspections.icons.issues.number", objectArray));
            pair = pair2;
        } else if (inspectionsExecutionState instanceof InspectionsExecutionState.Completed) {
            if (((InspectionsExecutionState.Completed)state).getIssueCount() == 0) {
                pair = new Pair((Object)AllIcons.General.GreenCheckmark, (Object)"");
            } else {
                Object[] objectArray = new Object[]{((InspectionsExecutionState.Completed)state).getIssueCount()};
                Pair pair3 = new Pair((Object)AllIcons.General.BalloonWarning, (Object)PyTablesBundle.message("popup.inspections.icons.issues.number", objectArray));
                pair = pair3;
            }
        } else {
            if (inspectionsExecutionState instanceof InspectionsExecutionState.Failed) {
                throw new NotImplementedError(null, 1, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    @NotNull
    public final String getDescription(@NotNull InspectionsExecutionState state) {
        String string;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        InspectionsExecutionState inspectionsExecutionState = state;
        if (inspectionsExecutionState instanceof InspectionsExecutionState.SwitchedOff) {
            string = PyTablesBundle.message("popup.inspections.switched.off.description", new Object[0]);
        } else if (inspectionsExecutionState instanceof InspectionsExecutionState.ReadyToRun) {
            string = PyTablesBundle.message("popup.inspections.ready.to.run.description", new Object[0]);
        } else if (inspectionsExecutionState instanceof InspectionsExecutionState.Running) {
            string = PyTablesBundle.message("popup.inspections.running.description", new Object[0]);
        } else if (inspectionsExecutionState instanceof InspectionsExecutionState.Completed) {
            if (((InspectionsExecutionState.Completed)state).getIssueCount() == 0) {
                string = PyTablesBundle.message("popup.inspections.finished.no.issues.description", new Object[0]);
            } else {
                Object[] objectArray = new Object[]{((InspectionsExecutionState.Completed)state).getIssueCount()};
                string = PyTablesBundle.message("popup.inspections.finished.has.issues.description", objectArray);
            }
        } else {
            if (inspectionsExecutionState instanceof InspectionsExecutionState.Failed) {
                throw new NotImplementedError(null, 1, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public final RelativePoint computeRelativePoint(@NotNull DataGrid grid, @NotNull DSTableImpl table, @NotNull AbstractPopup popup) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)popup, (String)"popup");
        Component component = grid.getPanel().getTopComponent();
        int heightDelta = component != null ? component.getHeight() : 15;
        int widthDelta = Math.max(popup.getPreferredContentSize().width, popup.getMinimumSize().width);
        Point relativePointCoordinates = new Point(table.getComponent().getSize().width - widthDelta, heightDelta);
        return new RelativePoint((Component)table.getComponent(), relativePointCoordinates);
    }
}

