/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.lux;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/lux/ImageDiff;", "", "x", "", "y", "content", "Ljava/awt/image/BufferedImage;", "<init>", "(IILjava/awt/image/BufferedImage;)V", "getX", "()I", "getY", "getContent", "()Ljava/awt/image/BufferedImage;", "applyTo", "image", "Companion", "intellij.platform.split"})
final class ImageDiff {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x;
    private final int y;
    @Nullable
    private final BufferedImage content;
    @NotNull
    private static final ImageDiff NO_DIFF = new ImageDiff(0, 0, null);

    public ImageDiff(int x, int y, @Nullable BufferedImage content) {
        this.x = x;
        this.y = y;
        this.content = content;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    @Nullable
    public final BufferedImage getContent() {
        return this.content;
    }

    @NotNull
    public final BufferedImage applyTo(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (this.content == null) {
            return image;
        }
        BufferedImage result2 = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics2D g = result2.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage((Image)image, 0, 0, null);
        g.drawImage((Image)this.content, this.x, this.y, null);
        g.dispose();
        return result2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0011\u001a\u00020\n*\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/lux/ImageDiff$Companion;", "", "<init>", "()V", "NO_DIFF", "Lcom/jetbrains/rd/platform/codeWithMe/lux/ImageDiff;", "getNO_DIFF", "()Lcom/jetbrains/rd/platform/codeWithMe/lux/ImageDiff;", "changedAll", "to", "Ljava/awt/image/BufferedImage;", "createFor", "from", "maxDiffFraction", "", "findChangedRegion", "Ljava/awt/Rectangle;", "copyRegion", "region", "intellij.platform.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ImageDiff getNO_DIFF() {
            return NO_DIFF;
        }

        private final ImageDiff changedAll(BufferedImage to) {
            return new ImageDiff(0, 0, to);
        }

        @NotNull
        public final ImageDiff createFor(@NotNull BufferedImage from, @NotNull BufferedImage to, double maxDiffFraction) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            Rectangle changedRegion = this.findChangedRegion(from, to);
            if (changedRegion == null) {
                return this.getNO_DIFF();
            }
            double changedFraction = (double)changedRegion.width * (double)changedRegion.height / (double)to.getWidth() / (double)to.getHeight();
            if (changedFraction > maxDiffFraction) {
                return this.changedAll(to);
            }
            BufferedImage changedContent = this.copyRegion(to, changedRegion);
            return new ImageDiff(changedRegion.x, changedRegion.y, changedContent);
        }

        @Nullable
        public final Rectangle findChangedRegion(@NotNull BufferedImage from, @NotNull BufferedImage to) {
            boolean bl;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            int width = from.getWidth();
            boolean bl3 = bl2 = width == to.getWidth();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            int height = from.getHeight();
            boolean bl4 = bl = height == to.getHeight();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            int size = width * height;
            DataBuffer dataBuffer = from.getRaster().getDataBuffer();
            Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
            int[] fromData = ((DataBufferInt)dataBuffer).getData();
            DataBuffer dataBuffer2 = to.getRaster().getDataBuffer();
            Intrinsics.checkNotNull((Object)dataBuffer2, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
            int[] toData = ((DataBufferInt)dataBuffer2).getData();
            int top = -1;
            for (int topIndex = 0; topIndex < size; ++topIndex) {
                if (fromData[topIndex] == toData[topIndex]) continue;
                top = topIndex / width;
                break;
            }
            if (top < 0) {
                return null;
            }
            int bottom = -1;
            for (int bottomIndex = size - 1; -1 < bottomIndex; --bottomIndex) {
                if (fromData[bottomIndex] == toData[bottomIndex]) continue;
                bottom = bottomIndex / width;
                break;
            }
            if (bottom < 0) {
                return null;
            }
            int changedHeight = bottom - top + 1;
            int topShift = top * width;
            int left = 0;
            left = -1;
            block2: for (int x = 0; x < width; ++x) {
                int leftIndex = 0;
                leftIndex = x + topShift;
                int n = 0;
                while (n < changedHeight) {
                    int it = n++;
                    boolean bl5 = false;
                    if (fromData[leftIndex] != toData[leftIndex]) {
                        left = x;
                        break block2;
                    }
                    leftIndex += width;
                }
            }
            if (left < 0) {
                return null;
            }
            int right = 0;
            right = -1;
            block4: for (int x = width - 1; -1 < x; --x) {
                int rightIndex = 0;
                rightIndex = x + topShift;
                int n = 0;
                while (n < changedHeight) {
                    int it = n++;
                    boolean bl6 = false;
                    if (fromData[rightIndex] != toData[rightIndex]) {
                        right = x;
                        break block4;
                    }
                    rightIndex += width;
                }
            }
            if (right < 0) {
                return null;
            }
            int changedWidth = right - left + 1;
            return new Rectangle(left, top, changedWidth, changedHeight);
        }

        private final BufferedImage copyRegion(BufferedImage $this$copyRegion, Rectangle region) {
            BufferedImage result2 = new BufferedImage(region.width, region.height, $this$copyRegion.getType());
            $this$copyRegion.getSubimage(region.x, region.y, region.width, region.height).copyData(result2.getRaster());
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

