/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization;

import com.google.common.collect.ImmutableList;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.serialization.ExportException;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationVersions;
import com.intellij.database.model.serialization.MutableNameAndValue;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBTreeTraverser;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModelExporter {
    private static final Logger LOG = Logger.getInstance(ModelExporter.class);
    public boolean persistent;
    public Int2ObjectMap<Couple<Version>> versions;

    public void saveModel(@NotNull BasicModel model, @NotNull HierarchicalStreamWriter writer, @Nullable TreePattern scope) throws ExportException {
        if (model == null) {
            ModelExporter.$$$reportNull$$$0(0);
        }
        if (writer == null) {
            ModelExporter.$$$reportNull$$$0(1);
        }
        ModelMem modelMem = model.read(r -> this.exportModel((BasicModel)r, scope));
        this.serializeModel(modelMem, writer);
    }

    public ModelMem exportModel(@NotNull BasicModel model, @Nullable TreePattern scope) {
        if (model == null) {
            ModelExporter.$$$reportNull$$$0(2);
        }
        ModelMem mm = new ModelMem();
        mm.setDbms(model.getDbms());
        mm.setVersion(ModelSerializationVersions.CURRENT_VERSION);
        Map<BasicElement, Integer> nodes = ModelExporter.orderNodes(model.getRoot(), scope);
        for (BasicElement node : nodes.keySet()) {
            ModelElementMem om = this.exportElement(node, nodes);
            mm.getNodes().add(om);
        }
        return mm;
    }

    private static Map<BasicElement, Integer> orderNodes(BasicRoot root, @Nullable TreePattern scope) {
        int counter = 0;
        JBTreeTraverser<BasicElement> traverser = ModelExporter.traverser(root, scope);
        LinkedHashMap<BasicElement, Integer> nodes = new LinkedHashMap<BasicElement, Integer>();
        for (BasicElement object : traverser.bfsTraversal()) {
            Integer id = ++counter;
            nodes.put(object, id);
        }
        return nodes;
    }

    @NotNull
    private static JBTreeTraverser<BasicElement> traverser(BasicRoot root, @Nullable TreePattern scope) {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(e -> e.getChildren()).withRoot((Object)root)).expand(e -> DataSourceSchemaMapping.isIntrospected(scope, e));
        if (jBTreeTraverser == null) {
            ModelExporter.$$$reportNull$$$0(3);
        }
        return jBTreeTraverser;
    }

    private ModelElementMem exportElement(BasicElement element, Map<BasicElement, Integer> nodes) {
        Integer parentId;
        Integer id = nodes.get(element);
        assert (id != null) : "Each node must be counted and ordered before exporting";
        BasicElement parentElement = element.getParent();
        Integer n = parentId = parentElement != null ? nodes.get(parentElement) : null;
        assert (element instanceof BasicRoot == (parentElement == null));
        ImmutableList<MutableNameAndValue> properties = this.exportElementProperties(element);
        String elementName = element instanceof BasicNamedElement ? element.getRealName() : null;
        return new ModelElementMem(id, parentId, element.getKind().code(), elementName, (List<MutableNameAndValue>)properties);
    }

    public ImmutableList<MutableNameAndValue> exportElementProperties(BasicElement element) {
        ImmutableList.Builder b = new ImmutableList.Builder();
        element.exportProperties((name, value) -> {
            if (value != null) {
                if (this.acceptsProperty(element, name) && !name.equalsIgnoreCase("name")) {
                    b.add((Object)new MutableNameAndValue(name, (String)value));
                }
            } else {
                LOG.warn("Attempted to export null property " + name + " when exporting element " + element.identity());
            }
        });
        return b.build();
    }

    protected boolean acceptsProperty(BasicElement element, String name) {
        return true;
    }

    protected void serializeModel(@NotNull ModelMem mem, @NotNull HierarchicalStreamWriter writer) {
        if (mem == null) {
            ModelExporter.$$$reportNull$$$0(4);
        }
        if (writer == null) {
            ModelExporter.$$$reportNull$$$0(5);
        }
        writer.startNode("database-model");
        writer.addAttribute("serializer", "dbm");
        writer.addAttribute("dbms", mem.getDbms().getName());
        writer.addAttribute("family-id", mem.getDbms().getName());
        if (!this.persistent) {
            writer.addAttribute("format-version", ModelSerializationVersions.CURRENT_VERSION.toString());
        }
        for (Map.Entry<String, String> property : mem.getProperties().entrySet()) {
            writer.addAttribute(property.getKey(), property.getValue());
        }
        if (!this.persistent) {
            for (ModelElementMem object : mem.getNodes()) {
                this.serializeNode(object, writer, null);
            }
        } else {
            List[] index = new List[mem.getNodes().size() + 1];
            for (ModelElementMem node : mem.getNodes()) {
                int idx = (Integer)ObjectUtils.notNull((Object)node.getParentId(), (Object)0);
                ArrayList<ModelElementMem> children = index[idx];
                if (children == null) {
                    children = index[idx] = new ArrayList<ModelElementMem>();
                }
                children.add(node);
            }
            for (ModelElementMem root : ModelExporter.children(index, null)) {
                this.serializeNode(root, writer, (Function<ModelElementMem, Iterable<ModelElementMem>>)((Function)n -> ModelExporter.children(index, n)));
            }
        }
        writer.endNode();
    }

    private static Iterable<ModelElementMem> children(List<ModelElementMem>[] index, ModelElementMem obj) {
        int idx = obj == null ? 0 : Objects.requireNonNull(obj.getId());
        return (Iterable)ObjectUtils.notNull(index[idx], Collections.emptyList());
    }

    private void serializeNode(ModelElementMem node, HierarchicalStreamWriter writer, Function<ModelElementMem, Iterable<ModelElementMem>> children) {
        writer.startNode(node.getKind());
        if (!this.persistent) {
            writer.addAttribute("id", Integer.toString(Objects.requireNonNull(node.getId())));
            Integer parentId = node.getParentId();
            if (parentId != null) {
                writer.addAttribute("parent", Integer.toString(parentId));
            }
        } else {
            Couple parentVersions;
            Couple versions = this.versions == null ? null : (Couple)this.versions.get(Objects.requireNonNullElse(node.getId(), 0).intValue());
            Couple couple = parentVersions = this.versions == null ? null : (Couple)this.versions.get(Objects.requireNonNullElse(node.getParentId(), 0).intValue());
            if (Objects.equals(versions, parentVersions)) {
                versions = null;
            }
            if (versions != null && !((Version)versions.first).equals((Object)Version.ZERO)) {
                writer.addAttribute("from-version", ((Version)versions.first).toString());
            }
            if (versions != null && !((Version)versions.second).equals((Object)Version.INFINITY)) {
                writer.addAttribute("to-version", ((Version)versions.second).toString());
            }
        }
        if (node.getName() != null) {
            writer.addAttribute("name", node.getName());
        }
        for (MutableNameAndValue property : node.getProperties()) {
            if (property.getName().equalsIgnoreCase("name")) continue;
            ModelExporter.serializeProperty(property, writer);
        }
        if (this.persistent && children != null) {
            for (ModelElementMem child : (Iterable)children.fun((Object)node)) {
                this.serializeNode(child, writer, children);
            }
        }
        writer.endNode();
    }

    private static void serializeProperty(MutableNameAndValue property, HierarchicalStreamWriter writer) {
        writer.startNode(property.getName());
        writer.setValue(property.getValue());
        writer.endNode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/serialization/ModelExporter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/serialization/ModelExporter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "traverser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "exportModel";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serializeModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

