/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.mssql.MsDialect;
import com.intellij.database.dialects.mssql.model.MsTable;
import com.intellij.database.dialects.mssql.model.MsTableColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class Ms05ImportManager
extends ImportManager {
    public Ms05ImportManager(Dbms dbms) {
        this(dbms, "TEXT");
    }

    protected Ms05ImportManager(Dbms dbms, @NotNull String textType) {
        if (textType == null) {
            Ms05ImportManager.$$$reportNull$$$0(0);
        }
        super(dbms, textType, 1, true, true, false, true, new TypeMerger[]{new TypeMerger.IntegerMerger("INT"), new TypeMerger.DoubleMerger("FLOAT")});
    }

    @NotNull
    public List<String> getFastModeOnQueries(@NotNull ImportInfo info) {
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(1);
        }
        ArrayList<String> result = new ArrayList<String>(this.getQueries(info, true));
        Ms05ImportManager.alterIndices(info, result, false);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            Ms05ImportManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    public List<String> getFastModeOffQueries(@NotNull ImportInfo info) {
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(3);
        }
        ArrayList<String> result = new ArrayList<String>(this.getQueries(info, false));
        Ms05ImportManager.alterIndices(info, result, true);
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            Ms05ImportManager.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public @Unmodifiable List<// Could not load outer class - annotation placement on inner may be incorrect
    ImportManager.ConnectionStateSwitch> getConnectionStateSwitches(@NotNull ImportInfo info) {
        MsTable table;
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(5);
        }
        if ((table = (MsTable)ObjectUtils.tryCast((Object)info.cache().getBasicTable(), MsTable.class)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                Ms05ImportManager.$$$reportNull$$$0(6);
            }
            return list;
        }
        List columnsForInsert = info.getConsumersForInsert();
        ModPositioningNamingFamily<? extends MsTableColumn> columns = table.getColumns();
        for (AutoValueDescriptor descriptor : columnsForInsert) {
            MsTableColumn column = (MsTableColumn)columns.get(descriptor.getName());
            if (column == null || column.getSequenceIdentity() == null && !StringUtil.endsWithIgnoreCase((String)column.getDasType().getSpecification(), (String)" identity")) continue;
            List<ImportManager.ConnectionStateSwitch> list = Collections.singletonList(new IdentityInsertsSwitch((BasicTable)table, this));
            if (list == null) {
                Ms05ImportManager.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            Ms05ImportManager.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static void alterIndices(@NotNull ImportInfo info, @NotNull List<String> result, boolean enable) {
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(9);
        }
        if (result == null) {
            Ms05ImportManager.$$$reportNull$$$0(10);
        }
        DasTable table = info.cache().getBasicTable();
        for (DasIndex index : table.getDasChildren(ObjectKind.INDEX).filter(DasIndex.class)) {
            result.add(Ms05ImportManager.alterIndex(info, index, enable));
        }
    }

    private static String alterIndex(@NotNull ImportInfo info, @NotNull DasIndex index, boolean enable) {
        if (info == null) {
            Ms05ImportManager.$$$reportNull$$$0(11);
        }
        if (index == null) {
            Ms05ImportManager.$$$reportNull$$$0(12);
        }
        return Ms05ImportManager.createBuilder((ImportEditorContext)info.getContext()).keyword("ALTER").space().keyword("INDEX").space().ref((DasObject)index, index.getName()).space().keyword("ON").space().qualifiedRef((DasObject)Objects.requireNonNull(index.getTable())).space().keyword(enable ? "REBUILD" : "DISABLE").getStatement();
    }

    public boolean isSuitable(@Nullable Version productVersion) {
        return productVersion == null || !MsDialect.isMsSql2008(productVersion);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textType";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mssql/Ms05ImportManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mssql/Ms05ImportManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOnQueries";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFastModeOffQueries";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionStateSwitches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOnQueries";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFastModeOffQueries";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionStateSwitches";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "alterIndices";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "alterIndex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private static class IdentityInsertsSwitch
    implements ImportManager.ConnectionStateSwitch {
        private final BasicTable myTable;
        private final ImportManager myManager;
        private boolean myResult;

        IdentityInsertsSwitch(@NotNull BasicTable table, @NotNull ImportManager manager) {
            if (table == null) {
                IdentityInsertsSwitch.$$$reportNull$$$0(0);
            }
            if (manager == null) {
                IdentityInsertsSwitch.$$$reportNull$$$0(1);
            }
            this.myTable = table;
            this.myManager = manager;
        }

        public void turnOn(@NotNull DatabaseConnectionCore connection) {
            if (connection == null) {
                IdentityInsertsSwitch.$$$reportNull$$$0(2);
            }
            String statement = this.generateStatement(true);
            this.myResult = SmartStatementFactoryService.getInstance().poweredBy(connection).simple(Configuration.sourced((SmartStatementSource)SmartStatementSource.SYSTEM)).barren().quiet().execute((Object)statement).isRight();
        }

        public void turnOff(@NotNull DatabaseConnectionCore connection) {
            if (connection == null) {
                IdentityInsertsSwitch.$$$reportNull$$$0(3);
            }
            if (!this.myResult) {
                return;
            }
            String statement = this.generateStatement(false);
            SimpleSmartStatement ss = SmartStatementFactoryService.getInstance().poweredBy(connection).simple(Configuration.sourced((SmartStatementSource)SmartStatementSource.SYSTEM));
            ss.barren().quiet().execute((Object)statement);
        }

        @NotNull
        private String generateStatement(boolean on) {
            DdlBuilder builder = DbImplUtilCore.createBuilderForUIExec((DatabaseDialectEx)DbImplUtilCore.getDatabaseDialect((Dbms)this.myManager.getDbms()), (DasObject)this.myTable);
            builder.keywords(new String[]{"SET", "IDENTITY_INSERT"}).space().qualifiedRef((DasObject)this.myTable).space().keyword(on ? "ON" : "OFF");
            String string = builder.getStatement();
            if (string == null) {
                IdentityInsertsSwitch.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/mssql/Ms05ImportManager$IdentityInsertsSwitch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/mssql/Ms05ImportManager$IdentityInsertsSwitch";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generateStatement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "turnOn";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "turnOff";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

