/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.Example;
import ai.grazie.rules.LTRuleInfo;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.NodeRuleMatch;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.AsciiApproximations;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.common.FormattingIssues;
import ai.grazie.rules.common.KnownPhrases;
import ai.grazie.rules.common.MultiWordSpelling;
import ai.grazie.rules.common.SentenceCapitalizationRule;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.common.ZeroWidthSpaceRule;
import ai.grazie.rules.en.Ableism;
import ai.grazie.rules.en.Adjectives;
import ai.grazie.rules.en.AdverbAdjectiveConfusion;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.AuxMainVerbForm;
import ai.grazie.rules.en.ClausalComplements;
import ai.grazie.rules.en.ComparativeSuperlative;
import ai.grazie.rules.en.DoubleNegation;
import ai.grazie.rules.en.EnglishDateChecker;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.GenderBias;
import ai.grazie.rules.en.GrammarRules;
import ai.grazie.rules.en.HyphenVsDash;
import ai.grazie.rules.en.Inclusivity;
import ai.grazie.rules.en.LemmaRepetitionRule;
import ai.grazie.rules.en.LongSentenceRule;
import ai.grazie.rules.en.MissingVerb;
import ai.grazie.rules.en.PassiveToActive;
import ai.grazie.rules.en.PluralsInCompounds;
import ai.grazie.rules.en.PolarityItemViolations;
import ai.grazie.rules.en.PrepositionIssues;
import ai.grazie.rules.en.PronounForm;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.en.QuantifierNounCompatibility;
import ai.grazie.rules.en.SemanticRules;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SerialComma;
import ai.grazie.rules.en.SpellingOutNumbers;
import ai.grazie.rules.en.SpellingRules;
import ai.grazie.rules.en.StyleRules;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.en.TagQuestions;
import ai.grazie.rules.en.Tautology;
import ai.grazie.rules.en.TenseAdverbials;
import ai.grazie.rules.en.ToggleContraction;
import ai.grazie.rules.en.TypographyRules;
import ai.grazie.rules.en.UnexpectedVerb;
import ai.grazie.rules.en.VariantDifferences;
import ai.grazie.rules.en.WordConfusion;
import ai.grazie.rules.en.WordOrder;
import ai.grazie.rules.en.WordSeparation;
import ai.grazie.rules.en.Wordiness;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class EnglishRules {
    EnglishRules() {
    }

    static List<Rule> rules() {
        return StreamEx.of((Object)new ZeroWidthSpaceRule("Zero-width space", "Find and remove Unicode zero-width space characters in words.", "https://en.wikipedia.org/wiki/Zero-width_space", "This word contains invisible zero-width space characters, remove them?", "Very <b>eas\u200by</b> to use.")).append(EnglishRules.spellingRules()).append(EnglishRules.grammarRules()).append(EnglishRules.punctuationRules()).append(EnglishRules.semanticRules()).append(EnglishRules.typographyRules()).append(EnglishRules.styleRules()).toList();
    }

    static List<Rule> spellingRules() {
        return List.of(new Rule.PatternRule("Spelling.LATIN_CYRILLIC_CONFUSION", "Confusion of cyrillic and latin letters", "A letter belongs to another alphabet.", null, () -> CommonPatterns.latinCyrillicConfusion("Latin", "Cyrillic", " letter '%s' in '%s'", "[\u0430-\u044f\u0451\u0456\u0457]", null), new Example("I <b>h\u0430v\u0435</b> a cat.", "I <b>have</b> a cat.")).enableInFlatTrees(), new Rule.PatternRule("Spelling.MISSING_DIACRITICS", "Add diacritics", "Some words, phrases, and geographical names borrowed from other languages are usually written with accents or other diacritical marks.", "https://en.wikipedia.org/wiki/Glossary_of_French_words_and_expressions_in_English", () -> NodePattern.or(SpellingRules.geoDiacritics(), SpellingRules.missingDiacritic()), new Example[]{new Example("I love <b>cafe</b> au lait.", "I love <b>caf\u00e9</b> au lait."), new Example("<b>Cr\u00e8me brulee</b> is my favourite way to start the day.", "<b>Cr\u00e8me br\u00fbl\u00e9e</b> is my favourite way to start the day."), new Example("I dream of travelling to <b>Moravsky Zizkov</b>, a serene village in Europe.", "I dream of travelling to <b>Moravsk\u00fd \u017di\u017ekov</b>, a serene village in Europe.")}){

            @Override
            public boolean isEnabledByDefault(RuleClient client) {
                return client.suggestDiacriticsByDefault();
            }
        }.coveringLTRules("CAFE_DIACRITIC", "A_LA_DIACRITIC", "EN_DIACRITICS_REPLACE_ORTHOGRAPHY", "POKEMON"), new Rule.PatternRule("Spelling.MULTI_WORD", "Check multi-word spelling and capitalization", "Find case mistakes, missing diacritics, and typos in various phrases and names consisting of several words.", null, () -> NodePattern.or(SpellingRules.misspelledColloquial(), new MultiWordSpelling(KnownPhrases.forLanguage(Language.ENGLISH)).skipTypoFixes(MultiWordSpelling.DEFAULT_SKIP_TYPO_FIXES.noForm("untied|state|ice|traveler|forest|gray|get|fed|som|unite|who|humans|barrack|regan|studios").andNot(NodePattern.N.inFormSequence(1, 2, "whom?", "it", "ma?y")).andNot(EnglishTreePatterns.startsWithApostrophe.noSpaceBefore())).pattern("Did you mean '%s'?", "The standard spelling is '%s'").andNot(NodePattern.N.inFormSequence(0, "intellij", "ideal", "plugin")).andNot(NodePattern.N.inFormSequence(0, "london", EnglishTreePatterns.apostropheS.getFormRegex(), "underground").withNeighbor(3, NodePattern.N.pos("NN.*"))).andNot(NodePattern.N.inFormSequence(0, "Google", "and")).noFormCaseSensitive("[Uu]s").andNot(NodePattern.N.inFormSequence(0, "open", "office").andOr(NodePattern.N.inFlatTree().after(NodePattern.N.pos("DT")), NodePattern.N.withNeighbor(1, NodePattern.N.withDependent("det(:poss)?")), NodePattern.N.withNeighbor(2, NodePattern.N.pos("NNS?").noLemma("program(me)?|software|tool|file|project|template|format|document|download|plugin|(present|install)ation|calc|draw|writer|online|portable|alternative|(spread)?sheet")))).noForm("macs|gota").andNot(NodePattern.N.inFormSequence(0, "you", "track").andNot(CommonPatterns.capitalizedMiddle))), new Example("I live in <b>Stratford upon Avon</b>.", "I live in <b>Stratford-upon-Avon</b>.")).enableInFlatTrees(), new Rule.PatternRule("Spelling.PROPER_NAMES", "Proper name spelling and capitalization", "Person, product, and geographical names are usually capitalized.", "https://www.aje.com/arc/editing-tip-capitalization-proper-and-common-nouns/", () -> SpellingRules.properNames(), new Example("Have you tried <b>grazie</b>?", "Have you tried <b>Grazie</b>?"), new Example("I started with <b>windows</b> 3.11.", "I started with <b>Windows</b> 3.11."), new Example("You need to install <b>opera</b>.", "You need to install <b>Opera</b>."), new Example("Do you like <b>apple</b> products?", "Do you like <b>Apple</b> products?")).enableInFlatTrees(), new Rule.PatternRule("Spelling.COMMON_TYPOS", "Common typos", "Find and correct common typos which result in unknown words or where letters are mistyped with non-letter symbols.", null, () -> SpellingRules.commonTypos(), new Example("Have you tried <b>a[ples</b>?", "Have you tried <b>apples</b>?")).enableInFlatTrees(), new Rule.PatternRule("Spelling.SIMILAR_WORD_CONFUSION", "Similar word confusion", "Find typos resulting in correct words yet inapplicable in specific contexts.", null, () -> WordConfusion.similarWordConfusion(), new Example("The form is now closed and <b>in principal</b> we cannot accept more requests.", "The form is now closed and <b>in principle</b> we cannot accept more requests."), new Example("I\u2019m <b>loosing</b> my mind.", "I\u2019m <b>losing</b> my mind."), new Example("I\u2019ll restore the list of lost <b>staff</b>.", "I\u2019ll restore the list of lost <b>stuff</b>."), new Example("Anyway, <b>i </b>stay.", "Anyway, <b>I</b> stay."), new Example("He phoned me just a <b>but</b> ago.", "He phoned me just a <b>bit</b> ago.")), new Rule.PatternRule("Spelling.MISPLACED_SPACE", "Misplaced space", "A space between words is unnecessary or in a wrong position.", null, () -> CommonPatterns.misplacedSpace("Did you mean '%s'?", NodePattern.or(NodePattern.N.directlyBefore(NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.N.form("="))), NodePattern.N.directlyAfter(NodePattern.PUNCT).directlyBefore(NodePattern.N.directlyBefore(NodePattern.PUNCT)), NodePattern.N.inFormSequence(0, ".", ".").and(node -> {
            String twoLetterWord = node.form() + node.neighbor(1).form();
            return node.tree().treeSupport().tagToken(twoLetterWord).tokenReadings().stream().allMatch(r -> r.pos() == null) || twoLetterWord.toLowerCase(Locale.ROOT).matches("((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])");
        }))), new Example("Isn\u2019t <b>tha tspace</b> incorrect?", "Isn\u2019t <b>that space</b> incorrect?")).enableInFlatTrees(), new Rule.PatternRule("Spelling.NUMBER_ENDING", "Number ending", "Ordinal numbers should end with the right suffix, which should be placed immediately after the number without spaces.", "https://langster.org/en/grammar/english/a1/ordinal-numbers/", () -> SpellingRules.numberEnding(), new Example("I have the <b>1rd</b> edition of this book.", "I have the <b>1st</b> edition of this book.")), new Rule.PatternRule("Spelling.WORD_SEPARATION", "Joining words or separating words with a hyphen or space", "Check whether two words should be written together or separated by a hyphen or a space.", "https://www.informit.com/articles/article.aspx?p=1912563&seqNum=5", () -> WordSeparation.pattern(), new Example("Beauty is a very <b>short lived</b> tyranny.", "Beauty is a very <b>short-lived</b> tyranny."), new Example("You should <b>backup</b> the database.", "You should <b>back up</b> the database.")));
    }

    static List<Rule.PatternRule> grammarRules() {
        return StreamEx.of((Object[])new Rule.PatternRule[]{new Rule.PatternRule("Grammar.WORD_REPETITION", "Word or phrase repetition", "Reports two consecutive same words or phrases, which is likely a mistake.", null, () -> GrammarRules.repetition(), new Example("I wonder if this <b>repetition repetition</b> is fine.", "I wonder if this <b>repetition</b> is fine."), new Example("No, it <b>is not is not</b>.", "No, it <b>is not</b>.")), new Rule.PatternRule("Grammar.POSSESSIVE_ISSUES", "Possessive apostrophe issues", "Check missing or incorrect possessive apostrophe.", "https://en.wikipedia.org/wiki/English_possessive", () -> GrammarRules.possessiveIssues(), new Example("We reduced the number of <b>index\u2019</b> operations", "We reduced the number of <b>index</b> operations", "We reduced the number of <b>index\u2019s</b> operations")).honorCrazyParses(), new Rule.PatternRule("Grammar.QUANTIFIER_NOUN_COMPATIBILITY", "Quantifier-noun compatibility", "Use 'few'/'many' with countable nouns, 'little'/'much' with uncountable nouns, plural after 'a lot of' and alike.", "https://www.oxfordlearnersdictionaries.com/grammar/online-grammar/quantifiers-more-less-and-fewer", () -> QuantifierNounCompatibility.pattern(), new Example("I have read <b>much</b> books since last month", "I have read <b>many</b> books since last month"), new Example("The <b>fewest</b> number of people from 56 to 65 years old works in technology.", "The <b>lowest</b> number of people from 56 to 65 years old works in technology.")).honorCrazyParses(), new Rule.PatternRule("Grammar.CLAUSE_NEGATION", "Incorrect sentence negation", "Sentences are commonly negated by putting 'not' after the first auxiliary or modal verb.", "https://dictionary.cambridge.org/grammar/british-grammar/negation_2", () -> GrammarRules.clauseNegation(), new Example("The <b>entity not exists</b>", "The entity <b>does not exist</b>", "The entity <b>doesn\u2019t exist</b>")), new Rule.PatternRule("Grammar.AUX_MAIN_VERB_FORM", "Auxiliary+main verb form compatibility", "Some auxiliary verbs (e.g. 'do') expect infinitives, others expect participles (e.g. 'is walking' or 'has finished').", "https://grammar.collinsdictionary.com/easy-learning/what-is-an-auxiliary-verb-in-english", () -> AuxMainVerbForm.pattern(), new Example("It should <b>been</b> approved.", "It should <b>be</b> approved."), new Example("I <b>am go</b> there.", "I am <b>going</b> there.", "I <b>go</b> there.")).honorCrazyParses(), new Rule.PatternRule("Grammar.SUBJECT_VERB_AGREEMENT", "Subject-verb agreement", "The subject should agree with the predicate in number and person.", "https://writing.wisc.edu/handbook/grammarpunct/subjectverb/", () -> SubjectVerbAgreement.errorPattern, new Example("<b>This feature take</b> months to develop.", "<b>This feature takes</b> months to develop.", "<b>These features take</b> months to develop.")).honorCrazyParses()}).append((Object[])new Rule.PatternRule[]{new Rule.PatternRule("Grammar.SUBJECT_VERB_INVERSION", "Subject-verb inversion", "In top-level questions, the verb should be placed before the subject.\nIn embedded questions, the subject goes before the verb.\nUsing 'have' as the main verb in questions might seem too formal.\n", "https://en.wikipedia.org/wiki/Subject\u2013auxiliary_inversion", () -> WordOrder.inversion(), new Example("I don\u2019t quite understand what <b>does it mean</b>", "I don\u2019t quite understand what <b>it means</b>"), new Example("<b>Have you</b> a cat?", "<b>Do</b> you have a cat?", "Have you <b>got</b> a cat?")).honorCrazyParses(), new Rule.PatternRule("Grammar.ADVERB_WORD_ORDER", "Adverb placed incorrectly", "Report some adverbs and adverbial phrases placed incorrectly in the sentence.", "https://faculty.washington.edu/marynell/grammar/AdverbPl.html", () -> WordOrder.adverbWordOrder(), new Example("Isn\u2019t he happy <b>always</b>?", "Isn\u2019t he <b>always</b> happy?"), new Example("Fix <b>a bit</b> rendering.", "Fix rendering <b>a bit</b>.", "Fix <b>a bit of</b> rendering.")).honorCrazyParses(), new Rule.PatternRule("Grammar.UNEXPECTED_WORD_ORDER", "Word order issues", "Report cases of unusual or non-standard word order.", "https://langeek.co/en/grammar/course/262/word-order", () -> WordOrder.unexpectedWordOrder(), new Example("Are <b>ready they</b>?", "Are <b>they ready</b>?"), new Example("I\u2019ve decided to throw <b>out them</b>.", "I\u2019ve decided to throw <b>them out</b>.")).honorCrazyParses(), new Rule.PatternRule("Grammar.TO_FINITE", "Non-infinitive verbs after 'to'", "'to' requires the base verb form after it.", null, () -> ClausalComplements.toFinite(), new Example("To <b>made</b> mistakes is human.", "To <b>make</b> mistakes is human.")).honorCrazyParses(), new Rule.PatternRule("Grammar.GERUND_VS_INFINITIVE", "Gerund vs. infinitive", "Some verbs (for example, 'allow' or 'recommend') require that the following verb is in the -ing form (gerund);\nsome others (for example, 'remind') need the base verb form (infinitive).\n", "https://www.grammaring.com/to-infinitive-or-gerund-advise-recommend-allow-permit-forbid-require", () -> ClausalComplements.gerundVsInfinitive(), new Example("We proceed to <b>implementing</b> a global search", "We proceed to <b>implement</b> a global search"), new Example("I would suggest <b>go</b> there.", "I would suggest <b>going</b> there.")).honorCrazyParses(), new Rule.PatternRule("Grammar.ADVERB_ADJECTIVE_CONFUSION", "Adverb/adjective confusion", "Adverbs modify verbs and sentences, while adjectives modify nouns.", "https://www.niu.edu/writingtutorial/grammar/adjective-or-adverb.shtml", () -> AdverbAdjectiveConfusion.pattern(), new Example("Health issues can be <b>dramatically</b>.", "Health issues can be <b>dramatic</b>."), new Example("It <b>gradual</b> declined.", "It <b>gradually</b> declined.")).honorCrazyParses(), new Rule.PatternRule("Grammar.POLARITY", "Polarity item violations", "Check that polarity items like 'at all' or 'yet' are used in correct contexts (negative or positive).", "https://en.wikipedia.org/wiki/Polarity_item", () -> PolarityItemViolations.pattern(), new Example("The city loses its appearance <b>at all</b>.", "The city loses its appearance <b>completely</b>."), new Example("I <b>believe</b> in the government <i>anymore</i>.", "I <b>don\u2019t believe</b> in the government anymore.", "I <b>do not believe</b> in the government anymore."), new Example("She doesn\u2019t like it <b>too</b>.", "She doesn\u2019t like it <b>either</b>."), new Example("John <b>is</b> here <b>yet</b>.", List.of("John <b>isn\u2019t</b> here <b>yet</b>.", "John <b>is already</b> here."), Map.of(EnglishParameters.CONTRACTION_USE, "always")), new Example("Mary <b>slept a wink</b> yesterday.", "Mary <b>didn\u2019t sleep a wink</b> yesterday.", "Mary <b>did not sleep a wink</b> yesterday.")).honorCrazyParses(), new Rule.PatternRule("Grammar.PLURALS_IN_COMPOUNDS", "Plurals in compound nouns", "Check that modifying nouns in compounds are singular by default.", "https://simonhoddinott.medium.com/why-can-we-say-mice-eater-but-not-rats-eater-english-compounds-70fbc96bae55", () -> PluralsInCompounds.pattern(), new Example("The <b>dogs house</b> is nice", "The <b>dog house</b> is nice", "The <b>dogs\u2019</b> house is nice", "The <b>dog\u2019s</b> house is nice")).honorCrazyParses(), new Rule.PatternRule("Grammar.TENSE_ADVERBIALS", "Markers requiring specific tense", "Check that sentences containing particular temporal markers (for example, <i>last year</i>, <i>tomorrow</i>) are in the appropriate tense.", "https://blog.harwardcommunications.com/2018/02/26/common-mistakes-with-the-present-perfect-tense/", () -> TenseAdverbials.pattern(), new Example("I <b>have done</b> it <i>last year</i>.", "I <b>did</b> it last year."), new Example("<b>I call</b> you <i>tomorrow</i> at 2 pm.", "<b>I will call</b> you tomorrow at 2 pm.", "<b>I\u2019ll call</b> you tomorrow at 2 pm.")), new Rule.PatternRule("Grammar.SINCE_X_TO_Y", "'Since' used for time intervals", "<i>Since</i> used for time intervals instead of <i>from</i>.", "https://blog.harwardcommunications.com/2017/09/21/how-to-use-since/", () -> GrammarRules.sinceCDtoCD(), new Example("The diagram demonstrates how the situation changed <b>since</b> 1998 to 1999.", "The diagram demonstrates how the situation changed <b>from</b> 1998 to 1999.")), new Rule.PatternRule("Grammar.LETS_CONFUSION", "Let\u2019s vs. Lets", "Checks whether <i>let\u2019s</i> is confused with <i>lets</i>.", "https://www.sarahtownsendeditorial.co.uk/2019/02/lets-vs-lets-simple-tips-to-remember-the-difference/", () -> GrammarRules.letsConfusion(), new Example("<b>Lets</b> discuss it further", "<b>Let\u2019s</b> discuss it further")), new Rule.PatternRule("Grammar.MISSING_SUBJECT", "Missing subject", "Check whether the sentence subject is missing.", "http://guidetogrammar.org/grammar/subjects.htm", () -> GrammarRules.missingSubject(), new Example("<b>Seems</b> that everything\u2019s fine", "<b>It seems</b> that everything\u2019s fine")), new Rule.PatternRule("Grammar.UNEXPECTED_ADJECTIVE", "Unexpected adjective", "Report adjectives used instead of nouns.", null, () -> Adjectives.unexpectedAdj(), new Example("She gave <b>a serious</b> of lectures at the University.", "She gave <b>a series</b> of lectures at the University.")), new Rule.PatternRule("Grammar.COMPARATIVE_SUPERLATIVE", "Comparative and superlative forms", "Adjectives and adverbs can have comparative or superlative forms.\nComparative forms are used to show change or make comparisons.\nSuperlative forms describe an object which is at the upper or lower limit of a quality.\n<p>\nShort adjectives form comparative and superlative forms by inflection (e.g., adding '-er').\nLong adjectives do that by adding modifiers like <i>more</i> or <i>most</i>.\nSuch modifiers should not be combined with inflectional comparative and superlative forms.", "https://www.ef.com/wwen/english-resources/english-grammar/comparative-and-superlative/", () -> ComparativeSuperlative.pattern(), new Example("Kyoto is a <b>more</b> older city", "Kyoto is an<b> </b>older city", "Kyoto is a <b>much</b> older city")).honorCrazyParses(), new Rule.PatternRule("Grammar.ARTICLE_ISSUES", "Incorrect article usage", "Report incorrect or excessive articles.", "https://owl.purdue.edu/owl/general_writing/grammar/using_articles.html", () -> Articles.incorrectArticlePattern(), new Example("Some text with <b>an </b>mistake.", "Some text with <b>a </b>mistake."), new Example("Turn to <b>the </b>page 42.", "Turn to <b>page</b> 42."), new Example("It\u2019s <b>a </b>two-edged.", "It\u2019s <b>two-edged</b>."), new Example("I\u2019ve met <b>a my</b> friend.", "I\u2019ve met <b>my</b> friend.", "I\u2019ve met <b>a</b> friend.")).honorCrazyParses(), new Rule.PatternRule("Grammar.MISSING_ARTICLE", "Missing articles", "Report missing articles.", "https://owl.purdue.edu/owl/general_writing/grammar/using_articles.html", () -> Articles.missingArticlePattern(), new Example("I am <b>actor</b>.", "I am <b>an actor</b>.", "I am <b>the actor</b>."), new Example("The king and I used to be <b>best</b> friends.", "The king and I used to be <b>the best</b> friends."), new Example("Relations between Japan and <b>United States</b>.", "Relations between Japan and <b>the United States</b>.")).honorCrazyParses().coveringLTRules("DETERMINER_GEOGRAPHICAL_WORD", "THE_SUPERLATIVE", "THE_MOST", "THE_BEST_WAY", "NODT_DOZEN", "MISSING_ARTICLE", "MOST_SOME_OF_NNS", "ALL_MOST_SOME_OF_NOUN", "HAVE_FOLLOWING_NN", "IN_1990s"), UnexpectedVerb.rule(), new Rule.PatternRule("Grammar.TAG_QUESTION_ISSUES", "Tag question issues", "Tag questions should be formed correctly, shouldn\u2019t they? The verb and the pronoun should agree with the preceding text, positive statements should go with negative tags and vice versa.", "https://www.englishclub.com/grammar/tag-questions.htm", () -> TagQuestions.pattern(), new Example("You\u2019re going there, <b>don\u2019t</b> you?", "You\u2019re going there, <b>aren\u2019t</b> you?")).honorCrazyParses(), new Rule.PatternRule("Grammar.PREPOSITION_ISSUES", "Preposition issues", "Some expressions are typically used with certain prepositions or without any.", null, () -> PrepositionIssues.grammarRule(), new Example("They were not included <b>into</b> the invitation.", "They were not included <b>in</b> the invitation."), new Example("They fell in love <b>from</b> first sight.", "They fell in love <b>at</b> first sight."), new Example("<b>In</b> the end of July I moved to Corfu.", "<b>At</b> the end of July I moved to Corfu.")).honorCrazyParses(), new Rule.PatternRule("Grammar.QUESTION_WORD_CONFUSION", "Question word confusion", "<i>Which of</i> should be used instead of <i>what of</i> when choosing from a limited number of options.\n<p>\nUse <i>How does he look?</i> if a general adjective is expected\nand <i>What does it look like?</i> if a more precise description is necessary.\n", "https://www.learnenglish.de/mistakes/whichvswhat.html", () -> NodePattern.or(GrammarRules.whatOfConfusion(), GrammarRules.howWhatLookLikeConfusion()), new Example("<b>What</b> of these functions is unused?", "<b>Which</b> of these functions is unused?"), new Example("<b>How</b> does this process look <b>like</b>?", "<b>What</b> does this process look like?", "<b>How</b> does this process look?")), new Rule.PatternRule("Grammar.CONDITIONAL_ISSUES", "Conditional issues", "'will' and 'would' should not be used in 'if' clauses.", "https://www.englishclub.com/grammar/verbs-conditional.htm", () -> GrammarRules.conditional(), new Example("If it <b>will rain</b>, mushrooms grow faster.", "If it <b>rains</b>, mushrooms grow faster."), new Example("If it <b>will rain</b> tomorrow, we won\u2019t go swimming.", "If it <b>rains</b> tomorrow, we won\u2019t go swimming."), new Example("If I <b>would win</b> a lottery, I would buy a car.", "If I <b>won</b> a lottery, I would buy a car."), new Example("If it <b>would have</b> rained yesterday, I would have stayed at home", "If it <b>had</b> rained yesterday, I would have stayed at home")).honorCrazyParses(), new Rule.PatternRule("Grammar.TENSE_IN_DEPENDENT_CLAUSES", "Tense issues in dependent clauses", "Make sure that the tense in the dependent clause aligns with the tense used in the main clause.", "https://byjus.com/english/sequence-of-tenses/", () -> NodePattern.or(GrammarRules.temporalClauses(), GrammarRules.universalRelativeClause(), GrammarRules.sequenceOfTenses()), new Example("I will call you when dinner <b>will be</b> ready.", "I will call you when dinner <b>is</b> ready."), new Example("I will call you as soon as I <b>will get</b> to the office.", "I will call you as soon as I <b>get</b> to the office."), new Example("They <i>were</i> both well aware of <b>what\u2019s</b> going on in the family.", "They <i>were</i> both well aware of <b>what was</b> going on in the family.")).honorCrazyParses(), new Rule.PatternRule("Grammar.UNEXPECTED_TENSE", "Verb tense issues", "Various cases when verb tense doesn\u2019t fit the context.", null, () -> GrammarRules.isBorn(), new Example("I <b>am</b> <i>born</i> in Dresden.", "I <b>was</b> born in Dresden.")).honorCrazyParses(), new Rule.PatternRule("Grammar.MISSING_INFINITIVE_TO", "Missing 'to' before infinitive", "Check that the infinitive after some verbs like <i>want</i> or <i>ask</i> is preceded by <i>to</i>.", "https://www.ef.com/wwen/english-resources/english-grammar/verbs-followed-infinitives/", () -> ClausalComplements.missingInfinitiveTo(), new Example("Can we <b>try help</b> him?", "Can we try <b>to help</b> him?", "Can we try <b>helping</b> him?")).honorCrazyParses(), new Rule.PatternRule("Grammar.MISSING_VERB", "Missing sentence verb", "Report sentences which seem to lack 'is/are' verb.", null, () -> MissingVerb.pattern(), new Example("<b>They more</b> visible.", "They <b>are</b> more visible.")).honorCrazyParses(), new Rule.PatternRule("Grammar.MISSING_OBJECT", "Missing object", "Some verbs (called transitive) require a direct object: a pronoun or a noun phrase after them.", "http://guidetogrammar.org/grammar/objects.htm", () -> GrammarRules.missingObject(), new Example("We plan to <b>use</b> for other languages as well.", "We plan to use <b>it</b> for other languages as well.", "We plan to <b>use other</b> languages as well.")).honorCrazyParses(), new Rule.PatternRule("Grammar.ADJECTIVE_POSITION", "Adjective position issues", "Most adjectives can be used both before the noun and after a linking verb, but there are some that are only used in one position or the other.", "https://langeek.co/en/grammar/course/695/attributive-and-predicative-adjectives", () -> Adjectives.adjectivePosition(), new Example("She is a very <b>well</b> singer.", "She is a very <b>good</b> singer."), new Example("That sailor was <b>drunken</b>.", new String[0])).honorCrazyParses(), new Rule.PatternRule("Grammar.RELATIVE_PRONOUN_CONFUSION", "Incorrect relative pronoun choice", "<i>What</i> should not be used as a relative pronoun when the modified noun is present. Unlike <i>which</i>, one cannot use 'that' as a relative pronoun when a preposition immediately precedes it.", "https://learnenglish.britishcouncil.org/grammar/english-grammar-reference/relative-pronouns-relative-clauses", () -> NodePattern.or(GrammarRules.whatThat(), GrammarRules.thatWithPreposition()), new Example("This is <i>all </i><b>what</b> you need to know.", "This is <b>all</b> you need to know.", "This is <b>all that</b> you need to know."), new Example("The building <b>in that</b><i> I live</i> is very old.", "The building <b>that</b><i> I live</i> in is very old.", "The building <b>in which</b><i> I live<i> is very old.")).honorCrazyParses(), new Rule.PatternRule("Grammar.PRONOUN_FORM", "Incorrect pronoun form", "Make sure the pronoun matches its grammatical function in a sentence.\nUse object pronouns (like 'me', 'her', 'them', 'whom') when the pronoun is the object of a verb or preposition.\nUse subject pronouns ('I', 'she', 'they', 'who') when the pronoun is the sentence\u2019s subject.\nUse possessive pronouns ('mine', 'hers', 'theirs') instead of possessive determiners ('my', 'her', 'their') when the pronoun stands on its own and there is no noun following it.\n", "https://schooltutoring.com/help/iheshe-vs-mehimher-and-who-vs-whom/", () -> PronounForm.grammarRulePattern(), new Example("Will you watch a movie with Fran and <b>I?</b>", "Will you watch a movie with Fran and <b>me</b>?"), new Example("<b>Whom</b> shall I say is calling?", "<b>Who</b> shall I say is calling?"), new Example("This bike is <b>my</b>.", "This bike is <b>mine</b>."), new Example("I like this idea of <b>your</b>.", "I like this idea of <b>yours</b>.")).honorCrazyParses()}).toList();
    }

    static List<Rule.PatternRule> punctuationRules() {
        return StreamEx.of((Object[])new Rule.PatternRule[]{new Rule.PatternRule("Punctuation.RELATIVE_CLAUSE_COMMA", "Commas around relative clauses", "Restrictive (or defining) relative clauses give essential information about the object they refer to.\nSuch clauses don\u2019t need commas around them.\nThe word \"that\" can only introduce a restrictive clause, so commas are unnecessary.\n<p>\nNon-restrictive (or non-defining) clauses provide additional, comment-like information about something.\nRemoving them from a sentence does not change who or what is being referred to.\nLike other similar optional elements in the sentence, non-restrictive clauses are surrounded by commas.\nSuch commas are called <i>bracketing commas</i>.\n<p>\nRelative clauses on proper names are almost never restrictive (with some exceptions, e.g. 'the' determiner),\nso they should be surrounded by commas.\n", "https://dictionary.cambridge.org/grammar/british-grammar/relative-clauses-defining-and-non-defining", () -> NodePattern.or(PunctuationRules.relativeClauseComma_That(), PunctuationRules.relativeClauseComma_ProperNoun(), PunctuationRules.relativeClauseComma_Which()), new Example("Russell struck up a surprising friendship with <b>Lawrence</b><i> whose strange ideas seemed to fascinate him</i>.", "Russell struck up a surprising friendship with Lawrence<b>, whose</b> strange ideas seemed to fascinate him.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.ADVERBIAL_COMMA", "Commas around linking phrases", "Sentence-linking phrases like 'for example' or 'according to' should be surrounded by commas in many cases.", "https://www.englishessaywritingtips.com/2012/08/transition-words-punctuation/", () -> PunctuationRules.adverbialComma(), new Example("<i>As I was </i><b>requested</b> I chose two activities from the list.", "As I was <b>requested,</b> I chose two activities from the list."), new Example("<b>However</b> this is not the only reason", "<b>However,</b> this is not the only reason"), new Example("He tries to solve a problem, <b>however,</b> difficult it may seem.", "He tries to solve a problem, <b>however</b> difficult it may seem.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.ETC_COMMA", "Check for comma before 'etc.'", "A comma is necessary before <i>etc.</i> right after the last element on a list.\n", "https://linguaholic.com/linguablog/comma-before-etc/", () -> PunctuationRules.etcComma(), new Example("I like apples, <b>pears etc</b>.", "I like apples, <b>pears, etc</b>.")), new Rule.PatternRule("Punctuation.ABBREVIATION_DOTS", "Abbreviation dots", "Missing or extra periods with abbreviations.", "https://www.e-education.psu.edu/styleforstudents/c3_p28.html", () -> PunctuationRules.abbreviationDots(), new Example("Holmlund <b>et al</b> report similar results.", "Holmlund <b>et al.</b> report similar results.")).honorCrazyParses().coveringLTRules("ET_AL").coveringLTRules(new LTRuleInfo("ETC_PERIOD", EnglishParameters.VARIANT, "US")), new Rule.PatternRule("Punctuation.COMMA_SPLICING", "Joining sentences with comma", "Comma splice: independent sentences should not be joined with a comma. There should be either connecting words or a semicolon.<p>In some cases, such commas are acceptable. For example, when sentences are closely connected or have neither internal commas nor subordinate clauses. Therefore, this rule only reports complex sentences where commas aren\u2019t advised by any style guide.", "https://en.wikipedia.org/wiki/Comma_splice", () -> PunctuationRules.commaSplicing, new Example("Saturn was long thought to be the only ringed <b>planet, however</b>, this is now known not to be the case.", "Saturn was long thought to be the only ringed <b>planet; however</b>, this is now known not to be the case.", "Saturn was long thought to be the only ringed <b>planet. However</b>, this is now known not to be the case.")), new Rule.PatternRule("Punctuation.COMMA_BEFORE_CC_CLAUSE", "Comma before conjunction between clauses", "Check if a comma is necessary between independent clauses joined by a coordinating conjunction.", "https://palimpsestediting.com/writers-notebook/copyediting/punctuation-notes/when-to-omit-the-comma-before-the-coordinating-conjunction-that-joins-two-independent-clauses", () -> PunctuationRules.commaBeforeCcClause(), new Example("This is a tragic <b>event and</b> that\u2019s all I can say.", "This is a tragic <b>event, and</b> that\u2019s all I can say.")), new Rule.PatternRule("Punctuation.EXCESSIVE_COMMA", "Excessive comma", "Check for unnecessary commas within a clause or before clauses that serve as objects of verbs.", null, () -> NodePattern.or(CommonPatterns.comma.markAs("Comma").andOr(PunctuationRules.excessiveCommaInCorrelativeConjunction(), PunctuationRules.excessiveCommaBeforeConj(), PunctuationRules.excessiveCommaAfterSubj(), PunctuationRules.excessiveCommaBeforeThat(), PunctuationRules.excessiveCommaBeforeEtAl(), PunctuationRules.excessiveCommaBeforeYear()).and(PunctuationRules.removeUnmandatedComma), PunctuationRules.excessiveCommasAroundParticipialClause().and(PunctuationRules.removeSurroundingCommas)), new Example("Cats <b>frolic,</b><i> and</i> purr.", "Cats frolic <b>and</b> purr."), new Example("Do I understand <b>correctly,</b><i> that</i> there\u2019s no simple way to achieve this?", "Do I understand <b>correctly that</b> there\u2019s no simple way to achieve this?"), new Example("The hike was <b>long,</b><i> and</i> challenging.", "The hike was <b>long and</b> challenging."), new Example("The book was <i>not only</i> <b>interesting,</b> <i>but also</i> educational.", "The book was not only <b>interesting</b> but also educational.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.EXCESSIVE_COLON", "Excessive colon", "Check if a colon is superfluous.", "https://medium.com/@Ediket/how-do-you-use-a-colon-1ea08a135d9e", () -> PunctuationRules.excessiveColonAfterSuchAs(), new Example("She had skills of a great litigator, <b>such as:</b> writing ability, perseverance, persuasiveness, and obsessive attention to detail.", "She had skills of a great litigator, <b>such as</b> writing ability, perseverance, persuasiveness, and obsessive attention to detail.")), new Rule.PatternRule("Punctuation.POLITE_COMMA", "'Please' comma", "Checks if a comma before <i>please</i>, <i>thanks</i> or <i>thank you</i> at the end of a sentence is necessary.", "https://dictionary.cambridge.org/grammar/british-grammar/please-and-thank-you", () -> PunctuationRules.commaBeforePoliteWords(), new Example("Leave the door <b>open please</b>.", "Leave the door <b>open, please</b>.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.LIST_COLON", "Colons with lists", "Check that lists of items are introduced with a colon.", "https://www.grammarbook.com/blog/colons/colons/", () -> PunctuationRules.listColon(), new Example("Access them at the following <b>links,</b> Equifax, Experian and Trans Union.", "Access them at the following <b>links:</b> Equifax, Experian and Trans Union.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.SUBORDINATION_COMMA", "Sentence subordination commas", "Subordinate sentences should be comma-separated when they occur before the main sentences.", "https://owl.purdue.edu/owl/general_writing/punctuation/commas/extended_rules_for_commas.html", () -> PunctuationRules.subordination(), new Example("<i>If it does not rain </i><b>heavily</b> we will stay home.", "If it does not rain <b>heavily,</b> we will stay home."), new Example("We will call <b>you,</b><i> when we need you</i>.", "We will call <b>you when</b> we need you.")).honorCrazyParses(), new Rule.PatternRule("Punctuation.MISSING_QUESTION_MARK", "Missing question mark", "Missing question mark at the end of an interrogative sentence.", null, () -> PunctuationRules.missingQuestionMark(), new Example("Did you forget the question <b>mark</b>", "Did you forget the question <b>mark?</b>")).honorCrazyParses(), new Rule.PatternRule("Style.PUNCTUATION_MARKEDNESS", "Punctuation markedness", "Cases where punctuation indicates that some nontypical intonation or meaning is implied. While this may be fine, it often means the punctuation should be adjusted.", "https://en.wikipedia.org/wiki/Markedness", () -> PunctuationRules.markedness(), new Example("<b>Please,</b> go away.", "<b>Please</b> go away.")), new Rule.PatternRule("Punctuation.HYPHEN_VS_DASH", "Hyphen vs. en dash vs. em dash", "Checks that hyphens and dashes are used correctly.", "https://en.wikipedia.org/wiki/Dash", () -> HyphenVsDash.hyphenVsDash(), new Example("<b>\u2013 This</b> is an enumeration item.", "<b>\u2014 This</b> is an enumeration item."), new Example("It\u2019s a <b>German \u2014</b> Czech movie.", "It\u2019s a <b>German-Czech</b> movie.")), new Rule.PatternRule("Punctuation.DIRECT_SPEECH", "Correct punctuation when rendering direct speech", "Direct speech is enclosed within quotation marks, and commas are used to set it apart from the surrounding text.", "https://grammar.collinsdictionary.com/easy-learning/how-do-you-write-direct-speech-in-english", () -> PunctuationRules.directSpeech(), new Example("\u2018There is nothing we can do about <b>it\u2019 said</b> Monica.", "\u2018There is nothing we can do about <b>it,\u2019 said</b> Monica."), new Example("Monica <b>said \u2018There</b> is nothing we can do about it.\u2019", "Monica <b>said, \u2018There</b> is nothing we can do about it.\u2019"), new Example("Monica said, \u2018There is nothing we can do about <b>it\u2019</b>", "Monica said, \u2018There is nothing we can do about <b>it.\u2019</b>", "Monica said, \u2018There is nothing we can do about <b>it!\u2019</b>", "Monica said, \u2018There is nothing we can do about <b>it?\u2019</b>"), new Example("\u2018There is nothing we can do about <b>it\u2019, said</b> Monica.", List.of("\u2018There is nothing we can do about <b>it,\u2019 said</b> Monica."), Map.of(EnglishParameters.VARIANT, "US"))), new Rule.PatternRule("Punctuation.FORMATTING_ISSUES", "Punctuation/whitespace issues", "Check incorrect comma vs. space placement, double punctuation, etc.", null, () -> PunctuationRules.formattingIssues(), new Example("For <b>example,,</b> a dog.", "For <b>example,</b> a dog."), new Example("<b>It \u2019s</b> a nice day today.", "<b>It\u2019s</b> a nice day today."), new Example("I began to involuntarily <b>un-focus</b> my eyes", "I began to involuntarily <b>unfocus</b> my eyes")), new Rule.PatternRule("Punctuation.QUOTE_PUNCTUATION", "Check punctuation relative to closing quotation marks", "Colons and semicolons should be placed outside the quotation marks.\n<p>\nThere should be no double sentence-ending punctuation (periods and question and exclamation marks)\naround the quotation marks: only one of them should be retained.\nIn American English, question and exclamation marks precede closing quotation marks,\nwhile British English only places punctuation inside quotes when it is part of the quoted material.\n", "https://www.transcendwithwords.com/post/separated-by-a-common-language-british-vs-american-english-quotations", () -> PunctuationRules.quotePunctuation(), new Example("What she calls her \u201cOlympic <b>journey:\u201d</b> family support and personal commitment.", "What she calls her \u201cOlympic journey<b>\u201d:</b> family support and personal commitment."), new Example("Did he say, \u201cThis is the <b>way.\u201d?</b>", "Did he say, \u201cThis is the <b>way\u201d?</b>"))}).toList();
    }

    static List<Rule.PatternRule> semanticRules() {
        return List.of(new Rule.PatternRule("Semantics.ABSOLUTE_DATE_ISSUES", "Absolute date issues", "Check that the dates are valid and the weekdays are consistent with the dates.", null, () -> EnglishDateChecker.INSTANCE.absolutePattern(), new Example[0]){

            @Override
            public List<Example> getExamples(RuleClient client) {
                return List.of(EnglishDateChecker.INSTANCE.weekdayExample(DateChecker.YearStrategy.absolute), new Example("An example of an incorrect date is <b>April 31, 2000</b>", new String[0]));
            }
        }, new Rule.PatternRule("Semantics.RELATIVE_DATE_ISSUES", "Relative date issues", "Find various mistakes assuming the text relates to the current date:\n<ul>\n<li>Using a past-tense verb with a future date,\n<li>Suspicious usage of dates from the previous year at the beginning of a new one,\n<li>Dates without no year specified (so likely from the current year) with non-matching week day.\n</ul>\n", null, () -> EnglishDateChecker.INSTANCE.relativePattern(), new Example[0]){

            @Override
            public List<Example> getExamples(RuleClient client) {
                return List.of(new Example("It was in <b>2048</b>.", new String[0]), EnglishDateChecker.INSTANCE.weekdayExample(DateChecker.YearStrategy.current));
            }
        }.honorCrazyParses(), new Rule.PatternRule("Semantics.DANGLING_MODIFIER", "Dangling or misplaced modifier", "A misplaced modifier is a word, phrase, or clause improperly separated from the word it modifies or describes.\nA dangling modifier is a word, phrase, or clause that doesn\u2019t clearly and logically relate to the word it\u2019s intended to modify.\n", "https://webapps.towson.edu/ows/moduleDangling.htm", () -> SemanticRules.danglingModifier(), new Example("<b>Being a rainy day</b>, we had to abandon the match.", new String[0])).honorCrazyParses(), new Rule.PatternRule("Semantics.COMMONLY_CONFUSED_WORDS", "Commonly confused words", "Words with commonly confused meanings.", "https://dictionary.cambridge.org/grammar/british-grammar/easily-confused-words", () -> WordConfusion.commonlyConfusedWords(), new Example("Can you <b>borrow</b> me a shopping bag?", "Can you <b>lend</b> me a shopping bag?")).honorCrazyParses());
    }

    static List<Rule> typographyRules() {
        return StreamEx.of((Object[])new Rule[]{new Rule.PatternRule("Typography.SMART_APOSTROPHE", "Use curly apostrophes", "Curly or \u201csmart\u201d apostrophes are preferred over their straight-shaped counterparts in professional publishing and print materials.", "https://en.wikipedia.org/wiki/Apostrophe#Unicode", () -> TypographyRules.smartApostrophe(), new Example[]{new Example("<b>It's</b> here.", "<b>It\u2019s</b> here.")}){

            @Override
            public boolean isEnabledByDefault(RuleClient client) {
                return client.supportsAutoFixes() && client.suggestCurlyPunctuationByDefault();
            }
        }.coveringLTRules("TYPOGRAPHICAL_APOSTROPHE"), new AsciiApproximations(Language.ENGLISH, "Replace typographic approximations with Unicode characters", "Some Unicode characters are hard to enter on most keyboards,\nand people often enter sequences of plain characters instead.\n", "https://en.wikipedia.org/wiki/Typographic_approximation", "Would you like to insert '%s'?"), new Rule.PatternRule("Typography.IBAN_FORMATTING", "Group the characters in IBAN", "IBANs are traditionally expressed in groups of four characters separated by spaces.", "https://en.wikipedia.org/wiki/International_Bank_Account_Number", () -> FormattingIssues.ibanFormatting("For better readability, split the IBAN by non-breaking spaces after every fourth character"), new Example("IBAN <b>DE89123447624758123400</b>", "IBAN <b>DE89\u00a01234\u00a04762\u00a04758\u00a01234\u00a000</b>")), new Rule.PatternRule("Typography.NUMBER_FORMATTING", "Format large numbers", "To improve readability, use a delimiter to break down large numbers into groups of three digits.", null, () -> TypographyRules.numberFormatting(), new Example("We have <b>10000</b> people (use comma)", List.of("We have <b>10,000</b> people (use comma)"), Map.of(EnglishParameters.NUMBER_FORMATTING, "comma")), new Example("We have <b>10000</b> people (use narrow non-breaking space)", List.of("We have <b>10\u202f000</b> people (use narrow non-breaking space)"), Map.of(EnglishParameters.NUMBER_FORMATTING, "narrowNbsp"))), new Rule.PatternRule("Typography.NUMBERS_WITH_UNITS", "Add a space between number and unit of measurement", "Generally, there should be a space between the number and the unit of measurement.", "https://ukma.org.uk/style-guide/", () -> TreeMigration.revise("try to delete 'tree-en' andNots", FormattingIssues.spacesAfterNumbers(List.of("((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])"), "There should be a space between the number and the unit of measurement", false).noFormCaseSensitive("(\\d\\d)?\\d0s|35S|\\d+cc|3ds").andNot(NodePattern.N.label("PRODUCT|LOCATION").andNot(NodePattern.N.formCaseSensitive("\\d+N").label("PRODUCT"))).andNot(NodePattern.N.form("\\d+s").withDependent("det")).andNot(NodePattern.N.directlyBefore(NodePattern.N.formCaseSensitive("K").andOr(NodePattern.N.withHeadRelation("nummod"), NodePattern.N.beforeHead()))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("[\u00a3$]")).directlyBefore(NodePattern.N.formCaseSensitive("[Km]"))).andNot(NodePattern.N.formCaseSensitive("\\d.+[Km]").withHeadRelation("nummod")).andNot(NodePattern.N.formCaseSensitive("\\d+S").andOr(NodePattern.N.withHead("nmod", NodePattern.N.lemma("coefficient")), NodePattern.N.before(NodePattern.N.lemma("ribosome")))).andNot(NodePattern.N.inFormSequence(1, "Robo", "3", "T")).andNot(NodePattern.N.withHeadRelation("nummod|compound").directlyBefore(NodePattern.N.formCaseSensitive("M").withHeadRelation("compound|nummod"))).andNot(NodePattern.N.formCaseSensitive("\\d+(\\.\\d+)?MM?").directlyAfter(NodePattern.N.form("[$\u00a3\u20ac\u00a5\u20bd]"))).andNot(NodePattern.N.form("\\d+(\\.\\d+)?").directlyAfter(NodePattern.N.form("[$\u00a3\u20ac\u00a5\u20bd]")).directlyBefore(NodePattern.N.formCaseSensitive("MM?"))).andNot(NodePattern.N.formCaseSensitive("\\d\\d?PM")).andNot(NodePattern.or(NodePattern.N.withHead(Semantics.addressWord), CommonPatterns.possiblySkipDown("appos", Semantics.addressWord)))), new Example("In this experiment, <b>2mg</b> of the extract was dissolved in water.", "In this experiment, <b>2\u00a0mg</b> of the extract was dissolved in water.")), new Rule.PatternRule("Typography.VARIANT_QUOTE_PUNCTUATION", "Check period and comma placement relative to closing quotation marks", "In American English, periods and commas precede closing quotation marks,\nwhile British English only places punctuation inside quotes when it is part of the quoted material.\n", "https://www.transcendwithwords.com/post/separated-by-a-common-language-british-vs-american-english-quotations", () -> VariantDifferences.variantQuotePunctuation(), new Example("\u201c<b>Hello\u201d,</b> said the American student.", List.of("\u201c<b>Hello,\u201d</b> said the American student."), Map.of(EnglishParameters.VARIANT, "US")), new Example("\u2018<b>Hello,\u2019</b> said the British student.", List.of("\u2018<b>Hello\u2019,</b> said the British student."), Map.of(EnglishParameters.VARIANT, "GB"))), new Rule.PatternRule("Typography.HYPHEN_TO_DASH", "Use dashes instead of hyphens between phrases", "Hyphens are typically used to join words together; dashes are longer and are used to separate phrases and wrap parenthetical clauses.", "https://en.wikipedia.org/wiki/Dash", () -> HyphenVsDash.hyphenToDash(), new Example("These em dashes without <b>spaces - I</b> like them!", List.of("These em dashes without spaces<b>\u2014I</b> like them!"), Map.of(EnglishParameters.DASH_STYLE, EnglishParameters.DashStyle.emNoSpace.id())), new Example("These em dashes with <b>spaces - I</b> like them!", List.of("These em dashes with spaces<b> \u2014 I</b> like them!"), Map.of(EnglishParameters.DASH_STYLE, EnglishParameters.DashStyle.emSpaced.id())), new Example("These en dashes are always with <b>spaces - I</b> like them!", List.of("These en dashes are always with <b>spaces \u2013 I</b> like them!"), Map.of(EnglishParameters.DASH_STYLE, EnglishParameters.DashStyle.en.id()))).honorCrazyParses().coveringLTRules("DASH_RULE").coveringLTRules(new LTRuleInfo("TWO_HYPHENS", EnglishParameters.DASH_STYLE, "enDash")), new Rule.PatternRule("Typography.LEADING_HYPHEN_TO_DASH", "Hyphen used instead of a dash at the sentence start", "Use an em dash for enumerations or dialogue turns.", "https://en.wikipedia.org/wiki/Dash", () -> CommonPatterns.dashLikeHyphens.and(HyphenVsDash.toEnumerationEmDash), new Example[]{new Example("<b>- First</b>, open the file.", "<b>\u2014 First</b>, open the file.")}){

            @Override
            public boolean isEnabledByDefault(RuleClient client) {
                return client.supportsAutoFixes();
            }
        }, new Rule.PatternRule("Typography.HYPHEN_IN_RANGES", "Use en dashes for ranges", "An en dash is used to show a range or span of numbers, dates, or time.\nIt essentially means <i>to</i> or <i>through</i>.\nThe same applies to scores, where it means <i>to</i>.\n", "https://www.dailywritingtips.com/use-a-dash-for-number-ranges", () -> HyphenVsDash.hyphenInRanges(), new Example[]{new Example("Read chapters <b>7-9</b> before Friday.", "Read chapters <b>7\u20139</b> before Friday."), new Example("She lived there from <b>2001\u20142015</b>.", "She lived there from <b>2001\u20132015</b>."), new Example("The final score was <b>3-1</b>.", "The final score was <b>3\u20131</b>.")}){

            @Override
            public boolean isEnabledByDefault(RuleClient client) {
                return client.supportsAutoFixes();
            }
        }.honorCrazyParses().coveringLTRules("HYPHEN_TO_EN")}).toList();
    }

    static List<Rule> styleRules() {
        return StreamEx.of((Object[])new Rule[]{VariantDifferences.rule(), new Rule.PatternRule("Style.OR_SUBJECT_AGREEMENT", "Check verb agreement with compound 'or' subjects", "When a compound subject is joined by the word \"or\" or alike, the verb usually agrees with the noun closest to it.\nWhen each noun in a compound subject with \"or\" is singular, the verb should be singular too.\nThese rules are followed in formal writing,\nbut the choice between a singular and plural verb often varies in actual use.\n", "https://www.britannica.com/dictionary/eb/qa/Subjects-with-And-and-Or-and-Verb-Agreement", () -> SubjectVerbAgreement.orAgreement(), new Example("Either you or John <b>have</b> to take the lead in this matter.", "Either you or John <b>has</b> to take the lead in this matter.")).disableByDefault().styleFlavor(StyleFlavor.Formality), new Rule.PatternRule("Style.VERY_ABUSE", "Avoid weak adverbs", "Overuse of the adverb <i>very</i> can make writing seem lazy, repetitive, and lacking in precision.\nIt\u2019s generally more effective to use a single, more specific word instead of <i>very</i> plus a less descriptive term.\n", "https://www.losethevery.com/", () -> StyleRules.veryAbuse(), new Example("It\u2019s <b>very fragile</b>.", "It\u2019s <b>feeble</b>.", "It\u2019s <b>frail</b>."), new Example("It\u2019s <b>a very old</b> book.", "It\u2019s <b>an ancient</b> book.")).styleFlavor(StyleFlavor.Readability)}).append(Tautology.rules()).append(Wordiness.rules()).append((Object[])new Rule[]{new Rule.PatternRule("Style.OF_CHAIN", "Avoid prepositional chains that use \u201cof\u201d", "Too many prepositions can make a sentence difficult to follow and understand,\nparticularly when the chain of prepositions is long.\n", null, () -> StyleRules.ofChain(), new Example("This is an example <b>of a long chain of</b> words.", new String[0])).styleFlavor(StyleFlavor.Readability), new Rule.PatternRule("Style.LOOKS_LIKE", "Avoid subject ellipsis", "<i>Looks like</i>, <i>sounds like</i>, and <i>seems like</i>\nare idiomatic expressions often used informally in conversation.\nIn professional writing, it\u2019s generally better to include the subject <i>it</i> for added clarity.\n", null, () -> StyleRules.looksSeemsSounds.and(StyleRules.beforeLike).and(EnglishTreePatterns.withoutSubject).message("Adding 'it' would make the text less colloquial"), new Example("<b>Looks</b> like the password is incorrect", "<b>It</b> looks like the password is incorrect")).styleFlavor(StyleFlavor.Formality), new Rule.PatternRule("Style.PRONOUN_GENDER_BIAS", "Avoid male pronouns in gender-neutral contexts", "People often use gendered pronouns even when they do not know the gender of the person they are talking about.\nThis can perpetuate gender stereotypes, reinforcing commonly held expectations\nabout the gender of people in certain roles.\n", "https://eige.europa.eu/publications-resources/toolkits-guides/gender-sensitive-communication/challenges/stereotypes/avoid-gendered-pronouns-he-or-she-when-persons-gender-unknown", () -> GenderBias.pronounBias(), new Example("When a person is there for a long time, <b>he</b> gets used to it", "When a person is there for a long time, <b>they get</b> used to it", "When a person is there for a long time, <b>she or he</b> gets used to it", "When a person is there for a long time, <b>he or she</b> gets used to it")).styleFlavor(StyleFlavor.Inclusivity).disableByDefault(), new Rule.PatternRule("Style.NOUN_VERB_GENDER_BIAS", "Avoid gender-specific nouns", "English uses gender-specific terms for some jobs and roles,\nlike <i>policeman</i>, <i>fireman</i>, and <i>chairman</i>.\nUse neutral alternatives when gender is not an essential part of the message.\n", "https://www.niu.edu/writingtutorial/style/bias-free-language.shtml", () -> GenderBias.useGenderNeutralMultiWordExpressions(), new Example("My <b>forefathers</b> lived in Italy.", "My <b>ancestors</b> lived in Italy."), new Example("The <b>policeman</b> came by.", "The <b>police officer</b> came by.", "The <b>law enforcement officer</b> came by."), new Example("In the face of danger she behaved <b>like a man</b>", "In the face of danger she behaved <b>resolutely</b>", "In the face of danger she behaved <b>bravely</b>")).styleFlavor(StyleFlavor.Inclusivity).disableByDefault(), new Rule.PatternRule("Style.HONORIFIC", "Use neutral honorifics", "Titles that don\u2019t specify marital status, like <i>Ms.</i> instead of <i>Mrs.</i> and <i>Miss</i>,\nor gender, like <i>Mx.</i> instead of <i>Mr.</i> or <i>Mrs.</i>,\nhelp promote equality and inclusivity.\n", "https://writingcenter.unc.edu/tips-and-tools/gender-inclusive-language/", () -> GenderBias.useNeutralHonorific(), new Example[]{new Example("<b>Miss</b> Elizabeth Smith was nominated for a Nobel Prize.", "<b>Ms.</b> Elizabeth Smith was nominated for a Nobel Prize.", "<b>Mx.</b> Elizabeth Smith was nominated for a Nobel Prize.")}){

            @Override
            public boolean isEnabledByDefault(RuleClient client) {
                return false;
            }
        }.styleFlavor(StyleFlavor.Inclusivity)}).append(Inclusivity.rules()).append((Object)new Rule.PatternRule("Style.ABLEISM", "Ableism", "Avoid ableist language.", "https://www.verywellmind.com/types-of-ableist-language-and-what-to-say-instead-5201561", () -> Ableism.pattern(), new Example("She is <b>anorexic</b>.", "She is <b>thin</b>.", "She is <b>slim</b>."), new Example("Emma\u2019s show has inspired other disabled and <b>able-bodied</b> people in their lives.", "Emma\u2019s show has inspired other disabled and <b>non-disabled</b> people in their lives."), new Example("It\u2019s not as simple as treating <b>addicts</b> as a criminal issue instead of a social one.", "It\u2019s not as simple as treating <b>people with a drug addiction</b> as a criminal issue instead of a social one."), new Example("No <b>amputees</b> here.", "No <b>people with an amputation</b> here.")).disableByDefault()).append((Object[])new Rule[]{new LemmaRepetitionRule(), new SentenceCapitalizationRule("Sentence capitalization consistency", "Sentences should either all begin with an uppercase letter or with a lowercase one (acceptable only in some contexts, for example, chats).", "https://mashable.com/article/disable-auto-caps-lowercase-texting-online-communication", "the first sentence. <i>Th</i>e second sentence", "Inconsistent sentence capitalization", "Start all sentences with an uppercase letter"), new Rule.PatternRule("Style.EG_IE_PUNCTUATION", "Punctuation in 'e.g.' or 'i.e.'", "Latin abbreviations 'e.g.' (for example) and 'i.e.' (that is) should be written with both dots.\nIn American English, they should be followed by a comma, while in British English, they should not.\n", "https://jakubmarian.com/comma-after-i-e-and-e-g/", () -> StyleRules.egIePunctuation(), new Example("US: The CPU (<b>i.e.</b> the processor) of your computer is overheating.", List.of("US: The CPU (<b>i.e.,</b> the processor) of your computer is overheating."), Map.of(EnglishParameters.VARIANT, "US")), new Example("GB: The CPU (<b>i.e.,</b> the processor) of your computer is overheating.", List.of("GB: The CPU (<b>i.e.</b> the processor) of your computer is overheating."), Map.of(EnglishParameters.VARIANT, "GB")), new Example("I like animals, <b>e.g</b> cats", List.of("I like animals, <b>e.g.,</b> cats"), Map.of(EnglishParameters.VARIANT, "US"))).coveringLTRules(new LTRuleInfo("EG_NO_COMMA", EnglishParameters.VARIANT, "US"), new LTRuleInfo("IE_NO_COMMA", EnglishParameters.VARIANT, "US"), new LTRuleInfo("I_E", EnglishParameters.VARIANT, "GB"), new LTRuleInfo("E_G", EnglishParameters.VARIANT, "GB")), new Rule.PatternRule("Style.EXCLAMATION_MARK", "Avoid exclamations", "Exclamation points may seem unprofessional or overly dramatic in formal contexts.", "https://www.sussex.ac.uk/informatics/punctuation/stopsandmarks/exclamation", () -> CommonPatterns.exclamationMark("Avoid using exclamatory sentences in formal writing", NodePattern.or(new NodePattern[0])), new Example("They delivered the mail <b>today!</b>", "They delivered the mail today<b>.</b>")).styleFlavor(StyleFlavor.Formality).disableByDefault(), new Rule.PatternRule("Style.EXPRESSIVE_PUNCTUATION", "Avoid expressive punctuation", "Multiple punctuation marks are typically used in informal or social media content and generally avoided in formal writing.", "https://proofed.co.uk/writing-tips/punctuation-tips-exclamation-marks/", CommonPatterns.expressivePunctuation("Avoid using multiple exclamation marks", "Avoid using multiple question marks", "Avoid using multiple punctuation marks"), new Example("Thank <b>you!!!</b>", "Thank you<b>!</b>"), new Example("How many punctuation marks do you <b>need?!</b>", "How many punctuation marks do you need<b>?</b>")).styleFlavor(StyleFlavor.Formality).disableByDefault(), new Rule.PatternRule("Style.COLLOQUIAL_SPEECH", "Avoid colloquialism", "Formal and professional writing typically calls for a more neutral, standard level of language.\nColloquialisms can come off as unprofessional or too casual in these contexts.\n", "http://facultyweb.ivcc.edu/rrambo/tip_formal_writing_voice.htm", () -> StyleRules.colloquialSpeech(), new Example("Welcome to our annual conference, <b>folks</b>!", new String[0]), new Example("It\u2019s <b>gonna</b> be easy.", "It\u2019s <b>going to</b> be easy."), new Example("Let\u2019s tell <b>'em</b>.", "Let\u2019s tell <b>them</b>.")).disableByDefault().styleFlavor(StyleFlavor.Formality).honorCrazyParses().coveringLTRules("LEMME", "OUTTA", "GOTCHA", "DONTCHA", "WHATCHA", "GIMME", "WANNA", "WANNA_TO", "TRYNA", "GONNA", "GONNA_TEMP", "DUNNO", "Y_ALL", "CAUSE_BECAUSE", "LUV"), new Rule.PatternRule("Style.SUBJECT_PRONOUNS", "Check pronouns in compound subjects", "In compound subjects, pronouns like <i>I</i>, <i>she</i>, and <i>they</i> remain the same\nas they would if they were used alone.\n", "https://editorsmanual.com/articles/you-and-i-or-you-and-me/", () -> PronounForm.pronounInCompoundSubject(), new Example("My friends and <b>me</b> went on holiday to a little town on the south coast.", "My friends and <b>I </b>went on holiday to a little town on the south coast.")).styleFlavor(StyleFlavor.Formality), new Rule.PatternRule("Style.PRONOUN_FIRST_PERSON_SG", "Avoid first-person singular pronouns", "Formal writing often aims to have an objective or impersonal tone,\nrather than focusing on the writer\u2019s personal perspective.\nIn this context, it\u2019s best to avoid pronouns like <i>I</i>, <i>me</i>, and <i>my</i>.\n", "https://www.niu.edu/writingtutorial/style/formal-and-informal-style.shtml", () -> StyleRules.firstPersonSgPronouns(), new Example("<b>I </b>think the author is very convincing.", new String[0])).disableByDefault().styleFlavor(StyleFlavor.Formality), new Rule.PatternRule("Style.PRONOUN_FIRST_PERSON_PL", "Avoid first-person plural pronouns", "Formal or academic writing often requires an objective, impartial tone.\nUsing pronouns like <i>we</i>, <i>us</i>, or <i>our</i>\ncan make the writing seem subjective or opinion-based.\n", "https://www.bachelorprint.eu/academic-writing/first-person-pronouns/", () -> StyleRules.firstPersonPlurPronouns(), new Example("<b>We</b> think the author is very convincing.", new String[0])).disableByDefault().styleFlavor(StyleFlavor.Formality), new Rule.PatternRule("Style.PRONOUN_SECOND_PERSON", "Avoid second-person pronouns", "Formal writing is typically written in third-person perspective to maintain an objective tone.\nPronouns like <i>you</i> and <i>your</i> can come across as informal or conversational.\n", "https://www.niu.edu/writingtutorial/style/formal-and-informal-style.shtml", () -> StyleRules.secondPersonPronouns(), new Example("<b>You</b> should not write in first or second person in formal writing.", new String[0])).disableByDefault().styleFlavor(StyleFlavor.Formality), DoubleNegation.rule(), new Rule.PatternRule("Style.POSITIVE_WRITING", "Positive writing", "Minimize the use of negative expressions, prefer proactive language.\nIn positive writing, the use of affirmative and optimistic words and expressions is encouraged,\nwhile negative or pessimistic words and phrases should be avoided.\nIt\u2019s also important to express ideas and facts in an upbeat, constructive, and solution-focused manner.\n", "https://justpublishingadvice.com/positive-writing/", () -> StyleRules.positiveWriting(), new Example("The description <b>doesn\u2019t</b> add <b>much</b> meaning.", "The description adds <b>little</b> meaning."), new Example("<b>Don\u2019t forget</b> to proofread before you publish anything.", "<b>Remember</b> to proofread before you publish anything."), new Example("I've got <b>a cheap</b> gadget.", "I've got <b>an inexpensive</b> gadget.", "I've got <b>an affordable</b> gadget."), new Example("I\u2019m <b>sorry, but</b> all our help desk operators are busy right now.", "I\u2019m <b>sorry:</b> all our help desk operators are busy right now."), new Example("He <b>said</b> he <b>didn\u2019t steal</b> the car.", "He <b>denied stealing</b> the car.")).honorCrazyParses(), new Rule.PatternRule("Style.SIMPLICITY", "Prefer clear language", "Simple writing uses everyday, understandable words, avoiding jargon, slang, and overly technical terms whenever possible.", "https://www.plainlanguage.gov/guidelines/words/use-simple-words-phrases/", () -> NodePattern.or(StyleRules.simpleNominals(), StyleRules.simpleVerbs(), StyleRules.simpleAdverbs()).andNot(CommonPatterns.insideQuotes).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE)), new Example("Her main <b>objective</b> now is simply to stay in power.", "Her main <b>goal</b> now is simply to stay in power.", "Her main <b>aim</b> now is simply to stay in power."), new Example("The old fire station could be <b>utilized</b> as a theater.", "The old fire station could be <b>used</b> as a theater.")).styleFlavor(StyleFlavor.Readability).coveringLTRules("ACCOMPANY", "ACCOMPLISH", "ACCRUE", "ACCEDE_TO", "ACCELERATE", "ACCENTUATE", "SUFFICIENT", "OBTAIN", "SOLICIT_FOR"), new Rule.PatternRule("Style.INFORMAL_SHORT_FORMS", "Avoid shortened word forms", "Using full word forms contributes to a consistent, formal tone throughout your text.", "https://www.niu.edu/writingtutorial/style/formal-and-informal-style.shtml", () -> StyleRules.informalShortForms(), new Example("Send <b>pics</b>.", "Send <b>pictures.</b>", "Send <b>photographs.</b>")).disableByDefault().styleFlavor(StyleFlavor.Formality).coveringLTRules("PPL"), new Rule.PatternRule("Style.FAULTY_PARALLELISM", "Use consistent verb forms in connected phrases", "To preserve clarity, readability, and balance, sentences with multiple predicates should have similar grammatical constructions.", "https://advice.writing.utoronto.ca/revising/faulty-parallelism/", () -> StyleRules.faultyParallelism(), new Example("These features speed up the development process and <b>tracks</b> changes automatically.", "These features speed up the development process and <b>track</b> changes automatically.")).styleFlavor(StyleFlavor.Readability).honorCrazyParses(), new Rule.PatternRule("Style.SMILEY_OR_EMOJI_USE", "Avoid emoticons and emoji", "Emoticons and emojis are considered a form of expressive punctuation\nand are mostly seen in casual and digital communication.\nIt is best to avoid them in formal writing.\n", "https://www.entrepreneur.com/growing-a-business/5-etiquette-rules-for-using-emojis-at-work/280412", () -> NodePattern.or(CommonPatterns.smileyUse("Consider removing the emoticon to make your tone more formal"), CommonPatterns.emojiUse("Consider removing the emoji to make your tone more formal")), new Example("These features speed up <b>:)</b>", "These features speed <b>up</b>"), new Example("That\u2019s very sweet<b> \ud83d\udc9b</b>", "That\u2019s very <b>sweet</b>")).styleFlavor(StyleFlavor.Formality).disableByDefault(), new Rule.PatternRule("Style.SPELL_OUT_AND_SYMBOLS", "Spell out symbols meaning 'and'", "Replace the ampersand (<i>&</i>) and plus sign (<i>+</i>) with words.", "https://knowadays.com/blog/how-and-when-to-use-an-ampersand/", () -> NodePattern.or(StyleRules.spellOutAmpersand(), StyleRules.spellOutPlus()).and(CommonPatterns.highlightPlusOneChar).spaceBefore().spaceAfter().andNot(CommonPatterns.insideQuotes).andNot(EnglishTreePatterns.inShortCapitalizedSentence), new Example("I want to inform you of our promotions <b>& </b>deals.", "I want to inform you of our promotions <b>and</b> deals."), new Example("There will be two adults <b>+ </b>three children.", "There will be two adults <b>and</b> three children.", "There will be two adults <b>plus</b> three children.")).styleFlavor(StyleFlavor.Formality), new Rule.PatternRule("Style.NON_BREAKING_SPACES", "Stylize names that contain initials", "Non-breaking spaces may be used\nwhen the separation of two adjacent words through line wrapping might result in a loss of meaning or legibility,\ne.g., after proper name initials.", "https://en.wikipedia.org/wiki/Non-breaking_space", () -> FormattingIssues.spacesWithNameInitials(EnglishParameters.SPACES_IN_NAME_INITIALS, "Use a non-breaking space after proper name initials for better legibility", "Use a non-breaking space only between proper name initials and surname", NodePattern.N.form("H\\.M\\.S|R\\.I\\.P")), new Example("We met <b>J.W.Lennon</b> (use spaces)", List.of("We met <b>J.\u00a0W.\u00a0Lennon</b> (use spaces)"), Map.of(EnglishParameters.SPACES_IN_NAME_INITIALS, "useSpaces")), new Example("We met <b>J.W.Lennon</b> (no spaces)", List.of("We met <b>J.W.\u00a0Lennon</b> (no spaces)"), Map.of(EnglishParameters.SPACES_IN_NAME_INITIALS, "noSpaces"))), SerialComma.rule(), new ToggleContraction.ContractionRule(), new Rule.PatternRule("Style.SPELLING_OUT_NUMBERS_SENT_START", "Spell out numbers that start a sentence", "Using words instead of numbers to start a sentence improves readability and clarity.", "https://topcontent.com/for-writers/blog/can-you-start-a-sentence-with-a-number/", () -> SpellingOutNumbers.spellingOutNumbersSentStart(), new Example("<b>7 </b>puppies played with three tennis balls at the dog park.", "<b>Seven</b> puppies played with three tennis balls at the dog park."), new Example("<b>90</b> people waited at the airport.", "<b>Ninety</b> people waited at the airport."), new Example("<b>250</b> babies are born every minute.", "<b>Two hundred fifty</b> babies are born every minute.")).honorCrazyParses().coveringLTRules("SENT_START_NUM"), new Rule.PatternRule("Style.SPELLING_OUT_NUMBERS", EnglishParameters.SPELL_OUT_NUMERALS.displayName(), "In formal and professional writing, numbers from zero to nine are usually spelled out in words.\nNumbers 10 and above are generally written in numerals.\n", "https://www.niu.edu/writingtutorial/grammar/use-of-numbers.shtml", () -> SpellingOutNumbers.generalPattern(), new Example("In <b>4 </b>languages; <b>4th</b> floor; with 4 hundred books (0\u20139 excluding large numerals)", List.of("In <b>four</b> languages; <b>fourth</b> floor; with 4 hundred books (0\u20139 excluding large numerals)"), Map.of(EnglishParameters.SPELL_OUT_NUMERALS, "single")), new Example("In <b>4 </b>languages; <b>4th</b> floor; with <b>4 </b>hundred books (0\u20139 including large numerals)", List.of("In <b>four</b> languages; <b>fourth</b> floor; with <b>four</b> hundred books (0\u20139 including large numerals)"), Map.of(EnglishParameters.SPELL_OUT_NUMERALS, "single+large")), new Example("In <b>4 </b>languages; with <b>4 </b>hundred books; <b>4th</b> floor; in <b>14</b> countries; <b>14th</b> century; for <b>40</b> thousand people (0\u201399 including large numerals)", List.of("In <b>four</b> languages; with <b>four</b> hundred books; <b>fourth</b> floor; in <b>fourteen</b> countries; <b>fourteenth</b> century; for <b>forty</b> thousand people (0\u201399 including large numerals)"), Map.of(EnglishParameters.SPELL_OUT_NUMERALS, "single+double+large"))).honorCrazyParses(), new Rule.PatternRule("Style.SPELLING_OUT_LARGE_NUMBERS", "Spell out large round numbers", "With large round numerals, use words instead of numbers to enhance readability. For large mixed numerals (such as '5,500,000'), use a number-plus-word combination.", "https://engrcomm.che.utexas.edu/faq/what-are-the-rules-for-writing-numbers/", () -> SpellingOutNumbers.spellingOutRoundNumbers(), new Example("It was based on a survey of <b>250,000</b> adults.", "It was based on a survey of <b>250 thousand</b> adults."), new Example("He inherited <b>2,000,000</b> dollars.", "He inherited <b>two million</b> dollars."), new Example("We now have more than <b>5,500,000</b> users worldwide.", "We now have more than <b>5.5 million</b> users worldwide.")), new Rule.PatternRule("Style.LESS_READABLE_PASSIVE", "Prefer active voice for improved readability", "When a passive sentence contains the phrase <i>by X</i>\nand the subject of the preposition (<i>X</i>) is shorter or more important than the passive subject,\nit is usually easier to read when rewritten in active voice.\n", "https://www.ef.co.uk/english-resources/english-grammar/passive-voice/", () -> PassiveToActive.lessReadablePassive(), new Example("The bread <b>is being baked</b> by him.", "He <b>is baking</b> the bread.")).styleFlavor(StyleFlavor.Readability).coveringLTRules("PASSIVE_VOICE_SIMPLE"), new Rule.PatternRule("Style.PASSIVE_VOICE", "Avoid all passive constructions", "Passive voice is generally considered bad for your writing style. Although it is not a mistake, passive voice often hides the performer of the action, making your text feel evasive.\n", "https://www.ef.co.uk/english-resources/english-grammar/passive-voice/", () -> PassiveToActive.anyPassive(), new Example("In my opinion, this problem must <b>be solved</b> by a teacher", "In my opinion, a teacher must <b>solve</b> this problem")).disableByDefault().styleFlavor(StyleFlavor.Readability).coveringLTRules("PASSIVE_VOICE")}).append((Object)PrepositionIssues.styleRule()).append((Object)new Rule("Style.LONG_SENTENCE", "Long sentences", "Shorter sentences are usually easier to read.", "https://www.wyliecomm.com/2023/06/why-use-short-sentences/", new Example[]{new Example("Licenses allow people to use the software on their laptops/PCs for educational tasks, with distribution via a single invitation <b>link (not</b> applicable if students can apply directly for individual student licenses via official university emails, ISIC card or other means of student ID).", "Licenses allow people to use the software on their laptops/PCs for educational tasks, with distribution via a single invitation <b>link.</b> (Not applicable if students can apply directly for individual student licenses via official university emails, ISIC card or other means of student ID.)")}){

            @Override
            public boolean supportsFlatTrees() {
                return true;
            }

            @Override
            @NotNull
            public MatchingResult match(Tree tree) {
                NodeMatch match = LongSentenceRule.checkTree(tree);
                return MatchingResult.from(match == null ? List.of() : List.of(new NodeRuleMatch((Rule)this, match)));
            }
        }.styleFlavor(StyleFlavor.Readability).coveringLTRules("TOO_LONG_SENTENCE")).toList();
    }
}

