create type Person_Name as
(
  Last varchar(26),
  First varchar(26),
  Middle varchar(15)
)
;


create schema Buro


    create table Face
    (
        Face_Id         serial not null primary key,
        Face_Kind       char(1) default 'A' not null,
        Face_Name       varchar(80) default '<unnamed>' not null,
        Face_Name_Alias varchar(80),
        Face_Note       varchar(1000)
    )
    with OIDs

    create table Org
    (
        Org_Legal_Name  varchar(120),
        Org_Legal_Stuff text
    )
    inherits (Face)
    with (fillfactor = 80)

    create table Person
    (
        Name       Person_Name,
        Person_DOB date
    )
    inherits (Face)



    create table Address
        (
        Face_Id            int      not null,
        Ctr_Abb            char(2)  not null
            constraint Address_City_fk references Geo.Country on update cascade on delete restrict,
        Cty_Id             serial   not null,
        Address_Post_Index varchar(8),
        Address_Line_1     varchar(120),
        Address_Line_2     varchar(120),
        constraint Address_fk foreign key (Ctr_Abb, Cty_Id) references Geo.City on update cascade on delete restrict,
        constraint Address_ch check (Address_Line_1 is not null or Address_Line_2 is not null)
        )


    create table Diamond_Face
        (
        Face_id int not null
                  references Org on delete cascade on update cascade
                  references Person on delete cascade on update cascade,
        Special_Note varchar(1000) null
        )

;


create global temporary table Session_Face (Face_Id int not null check(Face_Id > 0));

create global temporary table if not exists Session_Notes (
    Face_Id int not null check(Face_Id > 0),
    Note varchar(2000) null
) on commit preserve rows;


alter table T1 add First char(1) default 'A' not null,
               add Second varchar(2) default 'B' not null,
               add Third varchar(160) null;

alter table T1
    add constraint C1_ch check (C1 between 'A' and 'Z');

alter table T1 drop column C3;


create view V1 as
select *
from dual
where 42 is not null;


drop view V1;