/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.jupyterPython.cell;

import com.intellij.dataWrangler.jupyterPython.cell.DataWranglerJupyterCellTypeProviderKt;
import com.intellij.dataWrangler.jupyterPython.cell.JupyterDataWranglerCellMetadata;
import com.intellij.dataWrangler.jupyterPython.cell.JupyterDataWranglerCellMetadataKt;
import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellConverter;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellConverterTask;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.editor.JupyterEditorInitializationFlagKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/dataWrangler/jupyterPython/cell/JupyterDataWranglerCellConverter;", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellConverter;", "<init>", "()V", "convertCell", "", "task", "Lcom/intellij/jupyter/core/core/impl/actions/NotebookCellConverterTask;", "convertDataWranglerCellToCode", "intellij.dataWrangler.jupyterPython"})
final class JupyterDataWranglerCellConverter
implements NotebookCellConverter {
    public boolean convertCell(@NotNull NotebookCellConverterTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return !JupyterEditorInitializationFlagKt.isJupyterInitialized((Editor)task.getEditor()) ? false : (Intrinsics.areEqual((Object)JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(task.getInterval()), (Object)DataWranglerJupyterCellTypeProviderKt.getJUPYTER_CELL_TYPE_DATA_WRANGLER()) ? (Intrinsics.areEqual((Object)task.getNewType().getJupyterCellType(), (Object)JupyterCellType.Companion.getCODE()) ? this.convertDataWranglerCellToCode(task) : false) : false);
    }

    private final boolean convertDataWranglerCellToCode(NotebookCellConverterTask task) {
        Editor editor = task.getEditor();
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)editor);
        if (jupyterNotebook == null) {
            return false;
        }
        JupyterNotebook notebook = jupyterNotebook;
        JupyterCell cell = notebook.getCell(task.getInterval().getOrdinal());
        Object object = JupyterDataWranglerCellMetadataKt.getDataWranglerMetadata(cell);
        if (object == null || (object = ((JupyterDataWranglerCellMetadata)object).getSource()) == null) {
            object = "";
        }
        cell.setSource((String)object);
        String string = NotebookCellLinesEditHelper.makeCell$default((NotebookCellLinesEditHelper)task.getEditHelper(), (String)cell.getSource(), (CellType)CellType.CODE, null, (int)4, null);
        if (string == null) {
            return false;
        }
        String newCell = string;
        NotebookCellConverter.Companion.replaceCellWithUndoSupport(editor, newCell, task.getInterval(), NotebookCellLines.Companion.get(editor));
        return true;
    }
}

