/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.jupyterPython.operations.custom;

import com.intellij.dataWrangler.jupyterPython.DataWranglerJupyterPyBundle;
import com.intellij.dataWrangler.jupyterPython.operations.UtilKt;
import com.intellij.dataWrangler.jupyterPython.operations.custom.JupyterCustomCommandFactories;
import com.intellij.dataWrangler.jupyterPython.operations.custom.JupyterCustomCommandFactory;
import com.intellij.dataWrangler.jupyterPython.operations.custom.JupyterCustomCommandInfo;
import com.intellij.dataWrangler.jupyterPython.operations.custom.JupyterCustomCommandParser;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ,\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\u0013*\u00060\u0014j\u0002`\u00152\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0018\u0010\u0016\u001a\u00020\u0013*\u00060\u0014j\u0002`\u00152\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\u0013*\u00060\u0014j\u0002`\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b*\u0004\u0018\u00010\u0010H\u0002J \u0010\u001c\u001a\u00020\u0013*\u00060\u0014j\u0002`\u00152\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J \u0010\u001c\u001a\u00020\u0013*\u00060\u0014j\u0002`\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0010H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/dataWrangler/jupyterPython/operations/custom/JupyterCustomCommandProcessor;", "", "<init>", "()V", "updateCustomCommand", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "customCommand", "Lcom/intellij/dataWrangler/jupyterPython/operations/custom/JupyterCustomCommandFactory;", "newInfo", "Lcom/intellij/dataWrangler/jupyterPython/operations/custom/JupyterCustomCommandInfo$FunctionInfo;", "generateCustomCommand", "Lkotlin/Pair;", "Lcom/intellij/dataWrangler/jupyterPython/operations/custom/JupyterCustomCommandInfo;", "fileName", "", "generateFunctionPrefix", "f", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "generateSignature", "generateArgument", "a", "Lcom/intellij/dataWrangler/jupyterPython/operations/custom/JupyterCustomCommandInfo$ArgInfo;", "shouldQuote", "", "generateDocString", "ident", "intellij.dataWrangler.jupyterPython"})
@SourceDebugExtension(value={"SMAP\nJupyterCustomCommandProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCustomCommandProcessor.kt\ncom/intellij/dataWrangler/jupyterPython/operations/custom/JupyterCustomCommandProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 StringFun.kt\ncom/intellij/database/util/common/StringFun\n*L\n1#1,138:1\n1878#2,3:139\n1869#2,2:147\n148#3:142\n148#3:143\n148#3:144\n148#3:145\n148#3:146\n148#3:149\n148#3:150\n*S KotlinDebug\n*F\n+ 1 JupyterCustomCommandProcessor.kt\ncom/intellij/dataWrangler/jupyterPython/operations/custom/JupyterCustomCommandProcessor\n*L\n85#1:139,3\n122#1:147,2\n93#1:142\n110#1:143\n113#1:144\n116#1:145\n119#1:146\n130#1:149\n133#1:150\n*E\n"})
public final class JupyterCustomCommandProcessor {
    @NotNull
    public static final JupyterCustomCommandProcessor INSTANCE = new JupyterCustomCommandProcessor();

    private JupyterCustomCommandProcessor() {
    }

    @Nullable
    public final TextRange updateCustomCommand(@NotNull Project project, @NotNull JupyterCustomCommandFactory customCommand, @NotNull JupyterCustomCommandInfo.FunctionInfo newInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)customCommand, (String)"customCommand");
        Intrinsics.checkNotNullParameter((Object)newInfo, (String)"newInfo");
        JupyterCustomCommandParser.FunctionParsedInfo found = JupyterCustomCommandParser.INSTANCE.findCustomCommands(project, customCommand.getInfo().getFile(), customCommand.getInfo().getFunc().getId());
        if (found == null) {
            return null;
        }
        String prefix = this.generateFunctionPrefix(newInfo);
        WriteCommandAction.writeCommandAction((Project)project).withName(DataWranglerJupyterPyBundle.message("command.name.update.command", new Object[0])).run(() -> JupyterCustomCommandProcessor.updateCustomCommand$lambda$0(customCommand, found, prefix));
        return TextRange.from((int)found.getPrefixRange().getStartOffset(), (int)prefix.length());
    }

    @Nullable
    public final Pair<TextRange, JupyterCustomCommandInfo> generateCustomCommand(@NotNull Project project, @NotNull String fileName, @NotNull JupyterCustomCommandInfo.FunctionInfo newInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)newInfo, (String)"newInfo");
        return (Pair)WriteCommandAction.writeCommandAction((Project)project).withName(DataWranglerJupyterPyBundle.message("command.name.update.command", new Object[0])).compute(() -> JupyterCustomCommandProcessor.generateCustomCommand$lambda$0(fileName, newInfo));
    }

    private final String generateFunctionPrefix(JupyterCustomCommandInfo.FunctionInfo f) {
        StringBuilder stringBuilder;
        StringBuilder $this$generateFunctionPrefix_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        INSTANCE.generateFunctionPrefix($this$generateFunctionPrefix_u24lambda_u240, f);
        return stringBuilder.toString();
    }

    private final void generateFunctionPrefix(StringBuilder $this$generateFunctionPrefix, JupyterCustomCommandInfo.FunctionInfo f) {
        this.generateSignature($this$generateFunctionPrefix, f);
        $this$generateFunctionPrefix.append("    \"\"\"\n");
        this.generateDocString($this$generateFunctionPrefix, f, "    ");
        $this$generateFunctionPrefix.append("    \"\"\"\n");
    }

    /*
     * WARNING - void declaration
     */
    private final void generateSignature(StringBuilder $this$generateSignature, JupyterCustomCommandInfo.FunctionInfo f) {
        $this$generateSignature.append("def ").append(f.getId()).append("(");
        Iterable $this$forEachIndexed$iv = f.getArgs();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void a;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JupyterCustomCommandInfo.ArgInfo argInfo = (JupyterCustomCommandInfo.ArgInfo)item$iv;
            int index = n;
            boolean bl = false;
            if (index != 0) {
                $this$generateSignature.append(", ");
            }
            INSTANCE.generateArgument($this$generateSignature, (JupyterCustomCommandInfo.ArgInfo)a);
        }
        $this$generateSignature.append("):\n");
    }

    private final void generateArgument(StringBuilder $this$generateArgument, JupyterCustomCommandInfo.ArgInfo a) {
        $this$generateArgument.append(a.getId());
        CharSequence $this$isNotNullOrEmpty$iv = a.getDef();
        boolean $i$f$isNotNullOrEmpty = false;
        if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
            $this$generateArgument.append(" = ");
            $this$generateArgument.append(this.shouldQuote(a.getType()) ? UtilKt.getPyStr(a.getDef()) : a.getDef());
        }
    }

    private final boolean shouldQuote(String $this$shouldQuote) {
        return $this$shouldQuote == null ? true : !StringsKt.startsWith((String)$this$shouldQuote, (String)"int", (boolean)true) && !StringsKt.startsWith((String)$this$shouldQuote, (String)"float", (boolean)true) && !StringsKt.startsWith((String)$this$shouldQuote, (String)"list", (boolean)true) && !StringsKt.startsWith((String)$this$shouldQuote, (String)"set", (boolean)true);
    }

    private final void generateDocString(StringBuilder $this$generateDocString, JupyterCustomCommandInfo.FunctionInfo f, String ident) {
        CharSequence $this$isNotNullOrEmpty$iv = f.getDisplayName();
        boolean $i$f$isNotNullOrEmpty = false;
        if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
            $this$generateDocString.append(ident).append(":").append("display-name").append(" ").append(f.getDisplayName()).append("\n");
        }
        $this$isNotNullOrEmpty$iv = f.getDescription();
        $i$f$isNotNullOrEmpty = false;
        if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
            $this$generateDocString.append(ident).append(":").append("description").append(" ").append(f.getDescription()).append("\n");
        }
        $this$isNotNullOrEmpty$iv = f.getLabel();
        $i$f$isNotNullOrEmpty = false;
        if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
            $this$generateDocString.append(ident).append(":").append("label").append(" ").append(f.getLabel()).append("\n");
        }
        $this$isNotNullOrEmpty$iv = f.getDetails();
        $i$f$isNotNullOrEmpty = false;
        if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
            $this$generateDocString.append(ident).append(":").append("details").append(" ").append(f.getDetails()).append("\n");
        }
        Iterable $this$forEach$iv = f.getArgs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JupyterCustomCommandInfo.ArgInfo it = (JupyterCustomCommandInfo.ArgInfo)element$iv;
            boolean bl = false;
            INSTANCE.generateDocString($this$generateDocString, it, ident);
        }
    }

    private final void generateDocString(StringBuilder $this$generateDocString, JupyterCustomCommandInfo.ArgInfo a, String ident) {
        $this$generateDocString.append(ident);
        $this$generateDocString.append(":param ").append(a.getId()).append(":");
        CharSequence $this$isNotNullOrEmpty$iv = a.getDisplayName();
        boolean $i$f$isNotNullOrEmpty = false;
        if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
            $this$generateDocString.append(" :").append("display-name").append(" ").append(a.getDisplayName());
        }
        $this$isNotNullOrEmpty$iv = a.getType();
        $i$f$isNotNullOrEmpty = false;
        if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
            $this$generateDocString.append(" :").append("type").append(" ").append(a.getType());
        }
        $this$generateDocString.append("\n");
    }

    private static final void updateCustomCommand$lambda$0(JupyterCustomCommandFactory $customCommand, JupyterCustomCommandParser.FunctionParsedInfo $found, String $prefix) {
        Document document = FileDocumentManager.getInstance().getDocument($customCommand.getInfo().getFile());
        Intrinsics.checkNotNull((Object)document);
        Document document2 = document;
        document2.replaceString($found.getPrefixRange().getStartOffset(), $found.getPrefixRange().getEndOffset(), (CharSequence)$prefix);
    }

    private static final Pair generateCustomCommand$lambda$0(String $fileName, JupyterCustomCommandInfo.FunctionInfo $newInfo) {
        StringBuilder stringBuilder;
        Path path = JupyterCustomCommandFactories.Companion.getRootPath().resolve($fileName);
        Intrinsics.checkNotNull((Object)path);
        PathKt.createParentDirectories((Path)path);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(path);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(vFile);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        int originalLength = document2.getTextLength();
        StringBuilder $this$generateCustomCommand_u24lambda_u240_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (originalLength != 0) {
            $this$generateCustomCommand_u24lambda_u240_u240.append("\n\n");
        }
        INSTANCE.generateFunctionPrefix($this$generateCustomCommand_u24lambda_u240_u240, $newInfo);
        $this$generateCustomCommand_u24lambda_u240_u240.append("    return #TODO: new data frame\n");
        String toAppend = stringBuilder.toString();
        document2.replaceString(originalLength, originalLength, (CharSequence)toAppend);
        return new Pair((Object)TextRange.from((int)originalLength, (int)toAppend.length()), (Object)new JupyterCustomCommandInfo(vFile, $newInfo));
    }
}

