/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.beforeRun;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.impl.EditConfigurationsDialog;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.HyperlinkListeningExecutionException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.beforeRun.NpmBeforeRunTask;
import com.intellij.lang.javascript.buildTools.npm.beforeRun.NpmBeforeRunTaskDialog;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmBeforeRunTaskProvider
extends BeforeRunTaskProvider<NpmBeforeRunTask> {
    static final Key<NpmBeforeRunTask> PROVIDER_ID = Key.create((String)"NpmBeforeRunTask");

    public Key<NpmBeforeRunTask> getId() {
        return PROVIDER_ID;
    }

    public String getName() {
        return JavaScriptBundle.message((String)"npm.before.run.task", (Object[])new Object[0]);
    }

    @Nullable
    public Icon getIcon() {
        return JavaScriptLanguageIcons.BuildTools.Npm.Npm_16;
    }

    @Nullable
    public Icon getTaskIcon(@NotNull NpmBeforeRunTask task) {
        if (task == null) {
            NpmBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        return JavaScriptLanguageIcons.BuildTools.Npm.Npm_16;
    }

    public String getDescription(@NotNull NpmBeforeRunTask task) {
        String path2;
        if (task == null) {
            NpmBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if ((path2 = task.getSettings().getPackageJsonSystemDependentPath()).isEmpty()) {
            return JavaScriptBundle.message((String)"npm.before.run.task", (Object[])new Object[0]);
        }
        String fileName = PathUtil.getFileName((String)path2);
        String parentPath = PathUtil.getParentPath((String)path2);
        String parentName = PathUtil.getFileName((String)parentPath);
        String folderAndFile = parentName.isEmpty() ? fileName : parentName + File.separator + fileName;
        List<String> scripts = task.getSettings().getScriptNames();
        String presentableTasks = StringUtil.join(scripts, s -> "'" + s + "'", (String)", ");
        return JavaScriptBundle.message((String)"npm.before.run.task.descr", (Object[])new Object[]{scripts.size(), presentableTasks, folderAndFile});
    }

    public boolean isConfigurable() {
        return true;
    }

    @Nullable
    public NpmBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            NpmBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        return new NpmBeforeRunTask();
    }

    public boolean configureTask(@NotNull RunConfiguration runConfiguration, @NotNull NpmBeforeRunTask task) {
        if (runConfiguration == null) {
            NpmBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (task == null) {
            NpmBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        NpmRunSettings oldSettings = task.getSettings();
        NpmBeforeRunTaskDialog dialog = new NpmBeforeRunTaskDialog(runConfiguration.getProject(), oldSettings);
        if (!dialog.showAndGet()) {
            return false;
        }
        NpmRunSettings newSettings = dialog.getSettings();
        if (newSettings.equals(oldSettings)) {
            return false;
        }
        task.setSettings(newSettings);
        return true;
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull NpmBeforeRunTask task) {
        if (configuration == null) {
            NpmBeforeRunTaskProvider.$$$reportNull$$$0(5);
        }
        if (task == null) {
            NpmBeforeRunTaskProvider.$$$reportNull$$$0(6);
        }
        try {
            NpmRunConfigurationUtil.check(configuration.getProject(), task.getSettings());
        }
        catch (RuntimeConfigurationError error) {
            return false;
        }
        return true;
    }

    public boolean executeTask(@NotNull DataContext context2, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment env, @NotNull NpmBeforeRunTask task) {
        if (context2 == null) {
            NpmBeforeRunTaskProvider.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            NpmBeforeRunTaskProvider.$$$reportNull$$$0(8);
        }
        if (env == null) {
            NpmBeforeRunTaskProvider.$$$reportNull$$$0(9);
        }
        if (task == null) {
            NpmBeforeRunTaskProvider.$$$reportNull$$$0(10);
        }
        try {
            NpmRunConfigurationUtil.check(configuration.getProject(), task.getSettings());
        }
        catch (RuntimeConfigurationError e) {
            String message = new HtmlBuilder().append(e.getMessage()).br().appendLink("", JavaScriptBundle.message((String)"buildTools.edit.run.configuration", (Object[])new Object[0])).toString();
            HyperlinkListeningExecutionException exception = new HyperlinkListeningExecutionException(message, () -> {
                RunManager.getInstance((Project)env.getProject()).setSelectedConfiguration(env.getRunnerAndConfigurationSettings());
                new EditConfigurationsDialog(env.getProject()).show();
            });
            ExecutionUtil.handleExecutionError((Project)env.getProject(), (String)"Run", (String)"Npm script before launch", (Throwable)((Object)exception));
            return false;
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)env.getProject()).createConfiguration("", NpmConfigurationType.class);
        NpmRunConfigurationProducer.setupConfigurationFromSettings((NpmRunConfiguration)settings.getConfiguration(), task.getSettings());
        return JsbtUtil.executeBeforeRunTask(env, settings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/beforeRun/NpmBeforeRunTaskProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTaskIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "configureTask";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "canExecuteTask";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

