/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCodeStyleUtil {
    private JSCodeStyleUtil() {
    }

    public static void updateProjectCodeStyle(@NotNull Project project, @NotNull Consumer<? super CodeStyleSettings> consumer) {
        if (project == null) {
            JSCodeStyleUtil.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JSCodeStyleUtil.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            consumer.consume((Object)CodeStyle.getSettings((Project)project));
            return;
        }
        CodeStyleSchemesModel codeStyleSchemesModel = new CodeStyleSchemesModel(project);
        CodeStyleScheme scheme = codeStyleSchemesModel.getSelectedScheme();
        if (!codeStyleSchemesModel.isProjectScheme(scheme)) {
            codeStyleSchemesModel.copyToProject(scheme);
            scheme = codeStyleSchemesModel.getProjectScheme();
        }
        consumer.consume((Object)scheme.getCodeStyleSettings());
        codeStyleSchemesModel.apply();
    }

    public static boolean isLocalDeclarationsAtScopeStart(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSCodeStyleUtil.$$$reportNull$$$0(2);
        }
        return JSCodeStyleUtil.getInspectionTool(element2.getProject(), JSDeclarationsAtScopeStartInspection.SHORT_NAME, LocalInspectionTool.class, element2, true) != null;
    }

    @Nullable
    public static <T> T getInspectionTool(@NotNull Project project, @NotNull String shortName, @NotNull Class<T> toolClass, @Nullable PsiElement context2, boolean checkEnabled) {
        InspectionProfileImpl inspectionProfile;
        LocalInspectionToolWrapper localInspectionToolWrapper;
        if (project == null) {
            JSCodeStyleUtil.$$$reportNull$$$0(3);
        }
        if (shortName == null) {
            JSCodeStyleUtil.$$$reportNull$$$0(4);
        }
        if (toolClass == null) {
            JSCodeStyleUtil.$$$reportNull$$$0(5);
        }
        if ((localInspectionToolWrapper = (LocalInspectionToolWrapper)(inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile()).getInspectionTool(shortName, project)) != null && (!checkEnabled || inspectionProfile.isToolEnabled(HighlightDisplayKey.find((String)shortName), context2))) {
            return toolClass.cast(localInspectionToolWrapper.getTool());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/formatter/JSCodeStyleUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateProjectCodeStyle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isLocalDeclarationsAtScopeStart";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInspectionTool";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

