/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.patterns;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSReferenceExpressionPattern
extends PsiElementPattern<JSReferenceExpression, JSReferenceExpressionPattern> {
    protected JSReferenceExpressionPattern() {
        super(JSReferenceExpression.class);
    }

    public JSReferenceExpressionPattern unqualified() {
        return (JSReferenceExpressionPattern)this.with((PatternCondition)new PatternCondition<JSReferenceExpression>(this, "unqualified"){

            public boolean accepts(@NotNull JSReferenceExpression referenceExpression, ProcessingContext context2) {
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                return referenceExpression.getQualifier() == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern$1", "accepts"));
            }
        });
    }

    public JSReferenceExpressionPattern withQualifiedName(String components) {
        final String[] parts = ArrayUtil.toStringArray((Collection)StringUtil.split((String)components, (String)"."));
        return (JSReferenceExpressionPattern)this.with((PatternCondition)new PatternCondition<JSReferenceExpression>(this, "qualifiedName"){

            public boolean accepts(@NotNull JSReferenceExpression referenceExpression, ProcessingContext context2) {
                if (referenceExpression == null) {
                    2.$$$reportNull$$$0(0);
                }
                return JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)referenceExpression, (String[])parts);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern$2", "accepts"));
            }
        });
    }

    public JSReferenceExpressionPattern withReferenceName(final String name) {
        return (JSReferenceExpressionPattern)this.with((PatternCondition)new PatternCondition<JSReferenceExpression>(this, "referenceName"){

            public boolean accepts(@NotNull JSReferenceExpression referenceExpression, ProcessingContext context2) {
                if (referenceExpression == null) {
                    3.$$$reportNull$$$0(0);
                }
                return StringUtil.equals((CharSequence)referenceExpression.getReferenceName(), (CharSequence)name);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern$3", "accepts"));
            }
        });
    }

    @NotNull
    public JSReferenceExpressionPattern withReferenceNames(final String ... acceptableReferenceNames) {
        if (acceptableReferenceNames == null) {
            JSReferenceExpressionPattern.$$$reportNull$$$0(0);
        }
        JSReferenceExpressionPattern jSReferenceExpressionPattern = (JSReferenceExpressionPattern)this.with((PatternCondition)new PatternCondition<JSReferenceExpression>(this, "referenceNames"){

            public boolean accepts(@NotNull JSReferenceExpression referenceExpression, ProcessingContext context2) {
                if (referenceExpression == null) {
                    4.$$$reportNull$$$0(0);
                }
                return ArrayUtil.contains((String)referenceExpression.getReferenceName(), (String[])acceptableReferenceNames);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern$4", "accepts"));
            }
        });
        if (jSReferenceExpressionPattern == null) {
            JSReferenceExpressionPattern.$$$reportNull$$$0(1);
        }
        return jSReferenceExpressionPattern;
    }

    public JSReferenceExpressionPattern withNameStartingWith(String ... components) {
        final List<String> list = Arrays.asList(components);
        return (JSReferenceExpressionPattern)this.with((PatternCondition)new PatternCondition<JSReferenceExpression>(this, "nameStartingWith"){

            public boolean accepts(@NotNull JSReferenceExpression referenceExpression, ProcessingContext context2) {
                List referenceComponents;
                if (referenceExpression == null) {
                    5.$$$reportNull$$$0(0);
                }
                return (referenceComponents = JSSymbolUtil.getReferenceParts((JSExpression)referenceExpression)) != null && ContainerUtil.startsWith((List)referenceComponents, (List)list);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern$5", "accepts"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableReferenceNames";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/patterns/JSReferenceExpressionPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withReferenceNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withReferenceNames";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

