/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceParameter;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.jsdoc.JSDocBlockTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagDefinition;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class JSParameterInplaceIntroducer
extends JSBaseInplaceIntroducer<JSIntroduceParameterSettings> {
    private static final char G = 'g';
    private static final char O = 'o';
    private final String myInitialInitialValue;
    private final Runnable myCallback;

    public JSParameterInplaceIntroducer(Editor editor, Project project, JSExpression[] occurrences, JSBaseIntroduceHandler<JSElement, JSIntroduceParameterSettings, ? extends JSBaseIntroduceDialog> handler, JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings> context2, Runnable callback) {
        super(project, editor, (JSExpression)context2.expressionDescriptor.first, occurrences, (FileType)JavaScriptFileType.INSTANCE, handler, context2);
        this.myCallback = callback;
        this.myInitialInitialValue = ((JSIntroduceParameterSettings)this.myInitialSettings).getInitialValue();
    }

    @Override
    protected JSIntroduceParameterSettings getInplaceIntroduceSettings(String name) {
        return new JSInplaceIntroduceParameterSettings(name);
    }

    protected JComponent getComponent() {
        JPanel panel = new JPanel();
        panel.setBorder(null);
        panel.setLayout(new BoxLayout(panel, 1));
        JCheckBox addJsDoc = new JCheckBox(JavaScriptBundle.message((String)"javascript.introduce.parameter.generate.jsdoc", (Object[])new Object[0]));
        addJsDoc.setMnemonic('g');
        addJsDoc.setFocusable(false);
        addJsDoc.setSelected(JSIntroduceParameterHandler.isAddJSDoc(this.myProject));
        addJsDoc.addActionListener(e -> this.setAddJsDoc(addJsDoc.isSelected()));
        panel.add(addJsDoc);
        JCheckBox optional = new JCheckBox(JavaScriptBundle.message((String)"javascript.introduce.parameter.optional.parameter", (Object[])new Object[0]));
        optional.setMnemonic('o');
        optional.setFocusable(false);
        optional.setSelected(JSIntroduceParameterHandler.isGenerateOptional(this.myProject));
        optional.addActionListener(e -> this.setGenerateOptional(optional.isSelected()));
        panel.add(optional);
        return panel;
    }

    public void setGenerateOptional(boolean isOptional) {
        JSIntroduceParameterHandler.setGenerateOptional(this.myProject, isOptional);
        this.restartInplaceIntroduceTemplate();
    }

    public void setAddJsDoc(boolean addJsDoc) {
        JSIntroduceParameterHandler.setAddJSDoc(this.myProject, addJsDoc);
        this.restartInplaceIntroduceTemplate();
    }

    protected void deleteTemplateField(JSVariable psiField) {
        JSFunction fun = ((JSIntroduceParameterSettings)this.myInitialSettings).functionForIntroduceParameter();
        if (fun == null) {
            fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)psiField, JSFunction.class);
            assert (fun != null);
            ((JSIntroduceParameterSettings)this.myInitialSettings).setFunctionToIntroduceParameter(fun);
        }
        ((JSIntroduceParameterHandler)this.myIntroduceHandler).removeOptionalParameterInitializer();
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)fun);
        if (comment instanceof JSDocComment) {
            HashSet<Integer> set = new HashSet<Integer>();
            String name = ((JSIntroduceParameterSettings)this.myInitialSettings).getVariableName();
            JSDocTag[] tags = ((JSDocComment)comment).getTags();
            for (int i = 0; i < tags.length; ++i) {
                JSDocTag tag = tags[i];
                if (!tag.is((JSDocTagDefinition)JSDocBlockTags.PARAM) || !StringUtil.equals((CharSequence)name, (CharSequence)tag.getNamepathText())) continue;
                set.add(i);
            }
            JSDocumentationUtils.createOrUpdateTagsInDocComment((PsiElement)fun, null, null, set);
        }
        super.deleteTemplateField((PsiNameIdentifierOwner)psiField);
        this.restoreRangesForSubexpression();
    }

    protected void collectAdditionalElementsToRename(@NotNull List<? super Pair<PsiElement, TextRange>> stringUsages) {
        if (stringUsages == null) {
            JSParameterInplaceIntroducer.$$$reportNull$$$0(0);
        }
        super.collectAdditionalElementsToRename(stringUsages);
        for (JSReferenceExpression occurence : ((JSIntroduceParameterHandler)this.myIntroduceHandler).getParameterReferencesFromOptionalInitializer()) {
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)occurence, (Object)new TextRange(0, occurence.getTextLength())));
        }
    }

    protected void addReferenceAtCaret(Collection<? super PsiReference> refs) {
    }

    protected void performPostIntroduceTasks() {
        super.performPostIntroduceTasks();
        this.myCallback.run();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringUsages", "com/intellij/lang/javascript/refactoring/introduceParameter/JSParameterInplaceIntroducer", "collectAdditionalElementsToRename"));
    }

    private final class JSInplaceIntroduceParameterSettings
    implements JSIntroduceParameterSettings {
        private final String myName;

        private JSInplaceIntroduceParameterSettings(String name) {
            this.myName = name;
        }

        @Override
        public boolean addOptionalParameter() {
            return JSIntroduceParameterHandler.isGenerateOptional(JSParameterInplaceIntroducer.this.myProject);
        }

        @Override
        public boolean addJsDoc() {
            return JSIntroduceParameterHandler.isAddJSDoc(JSParameterInplaceIntroducer.this.myProject);
        }

        @Override
        public String getInitialValue() {
            return JSParameterInplaceIntroducer.this.myInitialInitialValue;
        }

        @Override
        public JSFunction functionForIntroduceParameter() {
            return ((JSIntroduceParameterSettings)JSParameterInplaceIntroducer.this.myInitialSettings).functionForIntroduceParameter();
        }

        @Override
        public void setFunctionToIntroduceParameter(JSFunction function) {
            ((JSIntroduceParameterSettings)JSParameterInplaceIntroducer.this.myInitialSettings).setFunctionToIntroduceParameter(function);
        }

        @Override
        public boolean isReplaceAllOccurrences() {
            return JSParameterInplaceIntroducer.this.isReplaceAllOccurrences();
        }

        @Override
        public String getVariableName() {
            return this.myName;
        }

        @Override
        public String getVariableType() {
            return ((JSIntroduceParameterSettings)JSParameterInplaceIntroducer.this.myInitialSettings).getVariableType();
        }
    }
}

