/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6NamespaceExport;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReservedWordUsedAsNameJSInspection
extends JavaScriptInspection {
    @NonNls
    private static final Set<String> ourJSReserved = new HashSet<String>();
    private static final Set<String> ourASReserved = new HashSet<String>();

    @Override
    @NotNull
    @InspectionMessage
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("reserved.word.used.as.name.error.string", new Object[0]);
        if (string == null) {
            ReservedWordUsedAsNameJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return JSFixFactory.getInstance().renameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ReservedWordAsNameVisitor();
    }

    public static boolean dialectIsES5OrAbove(@NotNull PsiElement context2) {
        if (context2 == null) {
            ReservedWordUsedAsNameJSInspection.$$$reportNull$$$0(1);
        }
        return !DialectDetector.isActionScript((PsiElement)context2);
    }

    static {
        ContainerUtil.addAll(ourJSReserved, (Object[])new String[]{"null", "true", "false", "break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "const", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"});
        ContainerUtil.addAll(ourASReserved, (Object[])new String[]{"as", "break", "case", "catch", "class", "const", "continue", "default", "delete", "do", "else", "extends", "false", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "internal", "is", "native", "new", "null", "package", "private", "protected", "public", "return", "super", "switch", "this", "throw", "to", "true", "try", "typeof", "use", "var", "void", "while", "with", "each", "get", "set", "namespace", "include", "dynamic", "final", "native", "override", "static", "abstract", "boolean", "byte", "cast", "char", "debugger", "double", "enum", "export", "float", "goto", "intrinsic", "long", "prototype", "short", "synchronized", "throws", "to", "transient", "type", "virtual", "volatile"});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/validity/ReservedWordUsedAsNameJSInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/validity/ReservedWordUsedAsNameJSInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dialectIsES5OrAbove";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class ReservedWordAsNameVisitor
    extends BaseInspectionVisitor {
        private ReservedWordAsNameVisitor() {
        }

        public void visitJSElement(@NotNull JSElement node) {
            String name;
            PsiElement nameIdentifier;
            if (node == null) {
                ReservedWordAsNameVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSElement(node);
            DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)node);
            if (node instanceof JSFunctionExpression && ((JSFunctionExpression)node).getOwnNameIdentifier() == null) {
                return;
            }
            if (ReservedWordUsedAsNameJSInspection.dialectIsES5OrAbove((PsiElement)node) && (node instanceof JSProperty || node instanceof JSFunction && (((JSFunction)node).isGetProperty() || ((JSFunction)node).isSetProperty()))) {
                return;
            }
            if (JSClassUtils.isES6ClassImplementation((DialectOptionHolder)dialectOptionHolder) && JSUtils.getMemberContainingClass((PsiElement)node) != null || node instanceof JSDestructuringProperty || node instanceof TypeScriptTypeMember || node instanceof TypeScriptType || node instanceof JSParameter && (ReservedWordAsNameVisitor.isTypeScript(dialectOptionHolder) || dialectOptionHolder != null && dialectOptionHolder.isFlow) && TypeScriptPsiUtil.isThisParameter((JSParameterItem)((JSParameter)node))) {
                return;
            }
            if (node instanceof JSDefinitionExpression) {
                if (ReservedWordAsNameVisitor.isActionScript(dialectOptionHolder)) {
                    return;
                }
                JSExpression expression = ((JSDefinitionExpression)node).getExpression();
                if (expression instanceof JSReferenceExpression) {
                    JSReferenceExpression ref2 = (JSReferenceExpression)expression;
                    if (ref2.getQualifier() != null) {
                        return;
                    }
                    PsiElement resolve2 = ref2.resolve();
                    if (resolve2 != null && !JSResolveUtil.isSameReference((JSReferenceExpression)ref2, (PsiElement)resolve2)) {
                        return;
                    }
                }
            }
            if ((node instanceof ES6ExportSpecifierAlias || node instanceof ES6NamespaceExport || node instanceof ES6ExportedDefaultBinding) && "default".equals(node.getName())) {
                return;
            }
            if (node instanceof JSNamedElement && (nameIdentifier = ((JSNamedElement)node).getNameIdentifier()) != null && ReservedWordAsNameVisitor.isReserved(dialectOptionHolder, name = nameIdentifier.getText())) {
                this.registerError(nameIdentifier);
            }
        }

        private static boolean isTypeScript(@Nullable DialectOptionHolder dialectOptionHolder) {
            return dialectOptionHolder != null && dialectOptionHolder.isTypeScript;
        }

        private static boolean isActionScript(@Nullable DialectOptionHolder dialectOptionHolder) {
            return dialectOptionHolder != null && dialectOptionHolder.isECMA4;
        }

        private static boolean isReserved(@Nullable DialectOptionHolder dialectOptionHolder, String name) {
            return ReservedWordAsNameVisitor.isActionScript(dialectOptionHolder) ? ourASReserved.contains(name) : ourJSReserved.contains(name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/sixrr/inspectjs/validity/ReservedWordUsedAsNameJSInspection$ReservedWordAsNameVisitor", "visitJSElement"));
        }
    }
}

