/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.reworked;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.block.reworked.MutableTerminalOutputModelImpl;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlockFinishedEvent;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlockRemovedEvent;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlockStartedEvent;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalBlocksModelEvent;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOffset;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelKt;
import org.jetbrains.plugins.terminal.session.TerminalBlocksModelState;
import org.jetbrains.plugins.terminal.session.TerminalOutputBlock;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\tH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020#H\u0016J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u001dH\u0002J\b\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModelImpl;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModel;", "outputModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;Lcom/intellij/openapi/Disposable;)V", "blockIdCounter", "", "getBlockIdCounter", "()I", "setBlockIdCounter", "(I)V", "blocks", "", "Lorg/jetbrains/plugins/terminal/session/TerminalOutputBlock;", "getBlocks", "()Ljava/util/List;", "mutableEventsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModelEvent;", "events", "Lkotlinx/coroutines/flow/SharedFlow;", "getEvents", "()Lkotlinx/coroutines/flow/SharedFlow;", "promptStarted", "", "offset", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOffset;", "promptFinished", "commandStarted", "commandFinished", "exitCode", "dumpState", "Lorg/jetbrains/plugins/terminal/session/TerminalBlocksModelState;", "restoreFromState", "state", "trimBlocksBefore", "trimBlocksAfter", "createNewBlock", "startOffset", "toString", "", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalBlocksModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalBlocksModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModelImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1#2:188\n360#3,7:189\n360#3,7:196\n*S KotlinDebug\n*F\n+ 1 TerminalBlocksModelImpl.kt\norg/jetbrains/plugins/terminal/block/reworked/TerminalBlocksModelImpl\n*L\n110#1:189,7\n147#1:196,7\n*E\n"})
public final class TerminalBlocksModelImpl
implements TerminalBlocksModel {
    @NotNull
    private final TerminalOutputModel outputModel;
    @VisibleForTesting
    private int blockIdCounter;
    @NotNull
    private final List<TerminalOutputBlock> blocks;
    @NotNull
    private final MutableSharedFlow<TerminalBlocksModelEvent> mutableEventsFlow;
    @NotNull
    private final SharedFlow<TerminalBlocksModelEvent> events;

    public TerminalBlocksModelImpl(@NotNull TerminalOutputModel outputModel, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.outputModel = outputModel;
        this.blocks = new ArrayList();
        this.mutableEventsFlow = SharedFlowKt.MutableSharedFlow$default((int)Integer.MAX_VALUE, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.events = FlowKt.asSharedFlow(this.mutableEventsFlow);
        TerminalOutputModel terminalOutputModel = this.outputModel;
        Intrinsics.checkNotNull((Object)terminalOutputModel, (String)"null cannot be cast to non-null type org.jetbrains.plugins.terminal.block.reworked.MutableTerminalOutputModelImpl");
        ((MutableTerminalOutputModelImpl)terminalOutputModel).getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.trimBlocksBefore(((MutableTerminalOutputModelImpl)outputModel).getStartOffset());
                this.trimBlocksAfter(TerminalOutputModelKt.getEndOffset(outputModel));
                if (event.getOffset() > 0 || event.getNewLength() > 0) {
                    this.trimBlocksAfter(((MutableTerminalOutputModelImpl)outputModel).getStartOffset().plus(event.getOffset()));
                }
            }
        }, parentDisposable);
        TerminalOutputBlock newBlock = this.createNewBlock(((MutableTerminalOutputModelImpl)this.outputModel).getStartOffset());
        this.getBlocks().add(newBlock);
        this.mutableEventsFlow.tryEmit((Object)new TerminalBlockStartedEvent(newBlock));
    }

    public final int getBlockIdCounter() {
        return this.blockIdCounter;
    }

    public final void setBlockIdCounter(int n) {
        this.blockIdCounter = n;
    }

    @Override
    @NotNull
    public List<TerminalOutputBlock> getBlocks() {
        return this.blocks;
    }

    @Override
    @NotNull
    public SharedFlow<TerminalBlocksModelEvent> getEvents() {
        return this.events;
    }

    @Override
    public void promptStarted(@NotNull TerminalOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        TerminalOutputBlock lastBlock = (TerminalOutputBlock)CollectionsKt.last(this.getBlocks());
        if (Intrinsics.areEqual((Object)offset, (Object)lastBlock.getStartOffset())) {
            this.getBlocks().removeLast();
            v0 = this.mutableEventsFlow.tryEmit((Object)new TerminalBlockRemovedEvent(lastBlock));
        } else {
            TerminalOutputBlock updatedBlock = TerminalOutputBlock.copy$default(lastBlock, 0, null, null, null, offset, null, 47, null);
            this.getBlocks().set(CollectionsKt.getLastIndex(this.getBlocks()), updatedBlock);
            v0 = this.mutableEventsFlow.tryEmit((Object)new TerminalBlockFinishedEvent(updatedBlock));
        }
        TerminalOutputBlock newBlock = this.createNewBlock(offset);
        this.getBlocks().add(newBlock);
        this.mutableEventsFlow.tryEmit((Object)new TerminalBlockStartedEvent(newBlock));
    }

    @Override
    public void promptFinished(@NotNull TerminalOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        TerminalOutputBlock curBlock = (TerminalOutputBlock)CollectionsKt.last(this.getBlocks());
        this.getBlocks().set(CollectionsKt.getLastIndex(this.getBlocks()), TerminalOutputBlock.copy$default(curBlock, 0, null, offset, null, null, null, 59, null));
    }

    @Override
    public void commandStarted(@NotNull TerminalOffset offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        TerminalOutputBlock curBlock = (TerminalOutputBlock)CollectionsKt.last(this.getBlocks());
        this.getBlocks().set(CollectionsKt.getLastIndex(this.getBlocks()), TerminalOutputBlock.copy$default(curBlock, 0, null, null, offset, null, null, 55, null));
    }

    @Override
    public void commandFinished(int exitCode) {
        TerminalOutputBlock curBlock = (TerminalOutputBlock)CollectionsKt.last(this.getBlocks());
        this.getBlocks().set(CollectionsKt.getLastIndex(this.getBlocks()), TerminalOutputBlock.copy$default(curBlock, 0, null, null, null, null, exitCode, 31, null));
    }

    @Override
    @NotNull
    public TerminalBlocksModelState dumpState() {
        return new TerminalBlocksModelState(CollectionsKt.toList((Iterable)this.getBlocks()), this.blockIdCounter);
    }

    @Override
    public void restoreFromState(@NotNull TerminalBlocksModelState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(!((Collection)state.getBlocks()).isEmpty())) {
            boolean bl = false;
            String string = "There should be always at least one block in the blocks model state";
            throw new IllegalStateException(string.toString());
        }
        this.blockIdCounter = state.getBlockIdCounter();
        for (TerminalOutputBlock terminalOutputBlock : this.getBlocks()) {
            this.mutableEventsFlow.tryEmit((Object)new TerminalBlockRemovedEvent(terminalOutputBlock));
        }
        this.getBlocks().clear();
        List<TerminalOutputBlock> finishedBlocks = state.getBlocks().subList(0, state.getBlocks().size() - 1);
        for (TerminalOutputBlock block : finishedBlocks) {
            this.getBlocks().add(block);
            this.mutableEventsFlow.tryEmit((Object)new TerminalBlockStartedEvent(block));
            this.mutableEventsFlow.tryEmit((Object)new TerminalBlockFinishedEvent(block));
        }
        TerminalOutputBlock terminalOutputBlock = (TerminalOutputBlock)CollectionsKt.last(state.getBlocks());
        this.getBlocks().add(terminalOutputBlock);
        this.mutableEventsFlow.tryEmit((Object)new TerminalBlockStartedEvent(terminalOutputBlock));
    }

    private final void trimBlocksBefore(TerminalOffset offset) {
        int firstNotRemovedBlockIndex;
        block7: {
            int n;
            List<TerminalOutputBlock> $this$indexOfFirst$iv = this.getBlocks();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<TerminalOutputBlock> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                TerminalOutputBlock item$iv;
                TerminalOutputBlock it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getEndOffset().compareTo(offset) > 0 || Intrinsics.areEqual((Object)it.getStartOffset(), (Object)it.getEndOffset()) && Intrinsics.areEqual((Object)it.getEndOffset(), (Object)offset)) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = firstNotRemovedBlockIndex = -1;
        }
        if (firstNotRemovedBlockIndex != -1) {
            TerminalOutputBlock block;
            int $this$indexOfFirst$iv = 0;
            while ($this$indexOfFirst$iv < firstNotRemovedBlockIndex) {
                int it = $this$indexOfFirst$iv++;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)this.getBlocks().removeFirst(), (String)"removeFirst(...)");
                this.mutableEventsFlow.tryEmit((Object)new TerminalBlockRemovedEvent(block));
            }
            TerminalOffset newMinimumOffset = this.outputModel.getStartOffset();
            int n = ((Collection)this.getBlocks()).size();
            for (int ind = 0; ind < n; ++ind) {
                block = this.getBlocks().get(ind);
                TerminalOffset terminalOffset = block.getCommandStartOffset();
                TerminalOffset terminalOffset2 = block.getOutputStartOffset();
                this.getBlocks().set(ind, new TerminalOutputBlock(block.getId(), (TerminalOffset)RangesKt.coerceAtLeast((Comparable)block.getStartOffset(), (Comparable)newMinimumOffset), terminalOffset != null ? (TerminalOffset)RangesKt.coerceAtLeast((Comparable)terminalOffset, (Comparable)newMinimumOffset) : null, terminalOffset2 != null ? (TerminalOffset)RangesKt.coerceAtLeast((Comparable)terminalOffset2, (Comparable)newMinimumOffset) : null, (TerminalOffset)RangesKt.coerceAtLeast((Comparable)block.getEndOffset(), (Comparable)newMinimumOffset), block.getExitCode()));
            }
        } else {
            for (TerminalOutputBlock block : this.getBlocks()) {
                this.mutableEventsFlow.tryEmit((Object)new TerminalBlockRemovedEvent(block));
            }
            this.getBlocks().clear();
            TerminalOutputBlock newBlock = this.createNewBlock(this.outputModel.getStartOffset());
            this.getBlocks().add(newBlock);
            this.mutableEventsFlow.tryEmit((Object)new TerminalBlockStartedEvent(newBlock));
        }
    }

    private final void trimBlocksAfter(TerminalOffset offset) {
        int firstBlockToRemoveIndex;
        block4: {
            int n;
            List<TerminalOutputBlock> $this$indexOfFirst$iv = this.getBlocks();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<TerminalOutputBlock> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                TerminalOutputBlock item$iv;
                TerminalOutputBlock it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getStartOffset().compareTo(offset) > 0) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = firstBlockToRemoveIndex = -1;
        }
        if (firstBlockToRemoveIndex != -1) {
            int $this$indexOfFirst$iv = this.getBlocks().size() - firstBlockToRemoveIndex;
            int n = 0;
            while (n < $this$indexOfFirst$iv) {
                TerminalOutputBlock block;
                int it = n++;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)this.getBlocks().removeLast(), (String)"removeLast(...)");
                this.mutableEventsFlow.tryEmit((Object)new TerminalBlockRemovedEvent(block));
            }
        }
        TerminalOutputBlock lastBlock = (TerminalOutputBlock)CollectionsKt.last(this.getBlocks());
        this.getBlocks().set(CollectionsKt.getLastIndex(this.getBlocks()), TerminalOutputBlock.copy$default(lastBlock, 0, null, null, null, TerminalOutputModelKt.getEndOffset(this.outputModel), null, 47, null));
    }

    private final TerminalOutputBlock createNewBlock(TerminalOffset startOffset) {
        int n = this.blockIdCounter;
        this.blockIdCounter = n + 1;
        return new TerminalOutputBlock(n, startOffset, null, null, TerminalOutputModelKt.getEndOffset(this.outputModel), null);
    }

    @NotNull
    public String toString() {
        return "TerminalBlocksModelImpl(blocks=" + this.getBlocks() + ")";
    }
}

