/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.base;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapterBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SqlLexer
extends LookAheadLexer {
    private final NullableFunction<String, IElementType> myTokenProvider;
    private final NullableFunction<String, IElementType> myReservedProvider;
    private final Class myTokenClass;

    public SqlLexer(@NotNull SqlLanguageDialectBase dialect, @NotNull FlexLexer flexLexer) {
        if (dialect == null) {
            SqlLexer.$$$reportNull$$$0(0);
        }
        if (flexLexer == null) {
            SqlLexer.$$$reportNull$$$0(1);
        }
        this(dialect.getTokensHelper(), flexLexer);
    }

    public SqlLexer(@NotNull TokensHelper tokensHelper, @NotNull FlexLexer flexLexer) {
        if (tokensHelper == null) {
            SqlLexer.$$$reportNull$$$0(2);
        }
        if (flexLexer == null) {
            SqlLexer.$$$reportNull$$$0(3);
        }
        super((Lexer)new MergingLexerAdapterBase((Lexer)new FlexAdapter(flexLexer)){
            final MergeFunction myFunction = SqlLexer::mergeComments;

            public MergeFunction getMergeFunction() {
                return this.myFunction;
            }
        });
        this.myTokenProvider = tokensHelper.getAllTokens();
        this.myReservedProvider = tokensHelper.getReservedTokens();
        this.myTokenClass = tokensHelper.getClasses().all;
    }

    public NullableFunction<String, IElementType> getTokenProvider() {
        return this.myTokenProvider;
    }

    @TestOnly
    public Class getTokenClass() {
        return this.myTokenClass;
    }

    protected void lookAhead(@NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            SqlLexer.$$$reportNull$$$0(4);
        }
        this.lookSqlKeyword(baseLexer);
    }

    protected void lookSqlKeyword(Lexer baseLexer) {
        this.advanceAs(baseLexer, this.getSqlTokenType(baseLexer));
    }

    @Nullable
    protected IElementType getSqlTokenType(@NotNull Lexer lexer) {
        String text;
        IElementType keyword;
        IElementType tokenType;
        if (lexer == null) {
            SqlLexer.$$$reportNull$$$0(5);
        }
        if ((tokenType = lexer.getTokenType()) == SqlTokens.SQL_IDENT && lexer.getState() != 4 && (keyword = (IElementType)this.myTokenProvider.fun((Object)(text = lexer.getTokenText()))) != null) {
            if (lexer.getState() == 10 && this.myReservedProvider.fun((Object)text) != null) {
                return TokenType.BAD_CHARACTER;
            }
            return keyword;
        }
        return tokenType;
    }

    protected boolean processCustomQuotation(Lexer baseLexer, String ident, int stringStart) {
        int identLen = ident.length();
        while (baseLexer.getTokenType() != null) {
            int textStart;
            int tokenEnd = baseLexer.getTokenEnd();
            String text = tokenEnd > (textStart = Math.max(stringStart, baseLexer.getTokenStart() - identLen + 1)) ? baseLexer.getBufferSequence().subSequence(textStart, tokenEnd).toString() : "";
            int idx = text.indexOf(ident);
            if (idx > -1) {
                this.addToken(stringStart, (IElementType)SqlTokens.SQL_CUSTOM_LQUOTE);
                int stringTokenEnd = textStart + idx;
                if (stringTokenEnd != stringStart) {
                    this.addToken(stringTokenEnd, (IElementType)SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN);
                }
                this.addToken(stringTokenEnd + identLen, (IElementType)SqlTokens.SQL_CUSTOM_RQUOTE);
                baseLexer.start(baseLexer.getBufferSequence(), stringTokenEnd + identLen, baseLexer.getBufferEnd(), 0);
                return true;
            }
            baseLexer.advance();
        }
        this.addToken(stringStart, (IElementType)SqlTokens.SQL_CUSTOM_LQUOTE);
        this.addToken((IElementType)SqlTokens.SQL_UNCLOSED_TOKEN);
        return true;
    }

    protected boolean lookAheadRangeOperator(Lexer baseLexer) {
        if (baseLexer.getTokenType() == SqlTokens.SQL_INTEGER_TOKEN) {
            IElementType type;
            this.advanceLexer(baseLexer);
            while ((type = baseLexer.getTokenType()) != null && SqlTokens.WS_OR_COMMENTS.contains(type)) {
                this.advanceLexer(baseLexer);
            }
            if (type == SqlTokens.SQL_PERIOD) {
                baseLexer.advance();
                if (baseLexer.getTokenType() == SqlTokens.SQL_PERIOD) {
                    this.advanceAs(baseLexer, (IElementType)SqlTokens.SQL_OP_RANGE);
                } else {
                    this.addToken(baseLexer.getTokenStart(), (IElementType)SqlTokens.SQL_PERIOD);
                }
            }
            return true;
        }
        int tokenStart = baseLexer.getTokenStart();
        int state = baseLexer.getState();
        int pos = this.getFirstDotPosition(baseLexer);
        if (pos > -1) {
            int bufferEnd = baseLexer.getBufferEnd();
            CharSequence bufferSequence = baseLexer.getBufferSequence();
            baseLexer.start(bufferSequence, tokenStart, tokenStart + pos, state);
            this.lookAhead(baseLexer);
            this.addToken(tokenStart + pos + 2, (IElementType)SqlTokens.SQL_OP_RANGE);
            baseLexer.start(bufferSequence, tokenStart + pos + 2, bufferEnd, state);
            this.lookAhead(baseLexer);
            return true;
        }
        return false;
    }

    protected boolean lookAheadQuotedIdentifierPath(Lexer lexer, SqlTokenType startQuote, SqlTokenType endQuote) {
        int end;
        int start;
        IElementType type = lexer.getTokenType();
        if (type != SqlTokens.SQL_IDENT_DELIMITED) {
            return false;
        }
        CharSequence buf = lexer.getBufferSequence();
        int i = StringUtil.indexOf((CharSequence)buf, (char)'.', (int)((start = lexer.getTokenStart()) + 2), (int)((end = lexer.getTokenEnd()) - 2));
        if (i == -1) {
            return false;
        }
        this.addToken(start + 1, (IElementType)startQuote);
        do {
            this.addToken(i, (IElementType)SqlTokens.SQL_IDENT);
            this.addToken(i + 1, (IElementType)SqlTokens.SQL_PERIOD);
        } while ((i = StringUtil.indexOf((CharSequence)buf, (char)'.', (int)(i + 2), (int)(end - 2))) != -1);
        this.addToken(end - 1, (IElementType)SqlTokens.SQL_IDENT);
        this.advanceAs(lexer, (IElementType)endQuote);
        return true;
    }

    private int getFirstDotPosition(Lexer baseLexer) {
        IElementType tokenType = baseLexer.getTokenType();
        if (tokenType == SqlTokens.BAD_CHARACTER) {
            return baseLexer.getTokenText().indexOf("..");
        }
        if (tokenType == SqlTokens.SQL_FLOAT_TOKEN && baseLexer.getTokenText().endsWith(".")) {
            int tokenEnd = baseLexer.getTokenEnd();
            int pos = tokenEnd - baseLexer.getTokenStart() - 1;
            baseLexer.advance();
            if (baseLexer.getTokenType() == SqlTokens.BAD_CHARACTER && StringUtil.startsWith((CharSequence)baseLexer.getBufferSequence(), (int)tokenEnd, (CharSequence)".") || baseLexer.getTokenType() == SqlTokens.SQL_PERIOD) {
                return pos;
            }
            this.addToken(tokenEnd, (IElementType)SqlTokens.SQL_FLOAT_TOKEN);
            return -1;
        }
        return -1;
    }

    private void skipCommentsAndWhitespaces(Lexer baseLexer) {
        IElementType type;
        while (SqlTokens.WS_OR_COMMENTS.contains(type = this.getSqlTokenType(baseLexer))) {
            this.advanceAs(baseLexer, type);
        }
    }

    protected IElementType skipCommentsAndGet(Lexer baseLexer) {
        this.skipCommentsAndWhitespaces(baseLexer);
        return this.getSqlTokenType(baseLexer);
    }

    protected boolean lookAheadCustomQuotation(Lexer baseLexer) {
        String ident = this.getDollarQuotingIdent(baseLexer);
        if (ident == null) {
            return false;
        }
        int identLen = ident.length();
        int stringStart = baseLexer.getTokenStart() + identLen;
        baseLexer.advance();
        return this.processCustomQuotation(baseLexer, ident, stringStart);
    }

    protected static boolean isStatementSeparator(IElementType type) {
        return SqlTokens.STATEMENT_SEPARATORS.contains(type);
    }

    @Nullable
    private static IElementType mergeComments(@Nullable IElementType firstTokenType, @NotNull Lexer baseLexer) {
        IElementType type;
        if (baseLexer == null) {
            SqlLexer.$$$reportNull$$$0(6);
        }
        if (!SqlTokens.COMMENT_TOKENS.contains(type = SqlLexer.mergeMultilineComments(firstTokenType, baseLexer)) || type == SqlTokens.SQL_BLOCK_COMMENT) {
            return type;
        }
        while (baseLexer.getTokenType() == type) {
            baseLexer.advance();
        }
        return type;
    }

    @Nullable
    private static IElementType mergeMultilineComments(@Nullable IElementType firstTokenType, @NotNull Lexer baseLexer) {
        if (baseLexer == null) {
            SqlLexer.$$$reportNull$$$0(7);
        }
        if (firstTokenType == SqlTokens.MULTI_LINE_COMMENT_START) {
            IElementType nextTokenType;
            while ((nextTokenType = baseLexer.getTokenType()) != null) {
                if (nextTokenType == SqlTokens.MULTI_LINE_COMMENT_END) {
                    baseLexer.advance();
                    break;
                }
                baseLexer.advance();
                assert (nextTokenType == SqlTokens.MULTI_LINE_COMMENT_BODY) : nextTokenType;
            }
            return SqlTokens.SQL_BLOCK_COMMENT;
        }
        return firstTokenType;
    }

    @Nullable
    protected String getDollarQuotingIdent(Lexer baseLexer) {
        if (baseLexer.getTokenType() != SqlTokens.SQL_IDENT_DELIMITED) {
            return null;
        }
        String identText = baseLexer.getTokenText();
        return "$$".equals(identText) ? identText : null;
    }

    public static boolean isValidRawCopyToken(@NotNull CharSequence text) {
        if (text == null) {
            SqlLexer.$$$reportNull$$$0(8);
        }
        if (text.isEmpty()) {
            return false;
        }
        if (Character.isWhitespace(text.charAt(0))) {
            return false;
        }
        return !Pattern.compile("(?:^|[\\n\\r])\\\\\\.(?:$|[\\n\\r])").matcher(text).find();
    }

    static {
        SqlTokenRegistry.initTypeMap(SqlTokens.class, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flexLexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokensHelper";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLexer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/base/SqlLexer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lookAhead";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSqlTokenType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeComments";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeMultilineComments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidRawCopyToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class CopyHelper {
        private int myCopyState;

        public void start(int copyState) {
            this.myCopyState = copyState;
        }

        public int getState() {
            return this.myCopyState;
        }

        public void onAdvance() {
            if (this.myCopyState == 3 && SqlLexer.this.getTokenType() == SqlTokens.SQL_RAW_INPUT) {
                this.myCopyState = 0;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void lookaheadCopy(Lexer baseLexer, IElementType type) {
            if (this.myCopyState == 0) {
                if (CopyHelper.isStatementPredecessor(type)) {
                    SqlLexer.this.advanceAs(baseLexer, type);
                    SqlLexer.this.skipCommentsAndWhitespaces(baseLexer);
                    type = SqlLexer.this.getSqlTokenType(baseLexer);
                    if (type != SqlTokens.SQL_COPY) return;
                    this.myCopyState = 1;
                } else if (type == SqlTokens.SQL_COPY) {
                    this.myCopyState = 1;
                }
            } else if (this.myCopyState == 1) {
                if (type == SqlTokens.SQL_FROM) {
                    SqlLexer.this.advanceAs(baseLexer, type);
                    SqlLexer.this.skipCommentsAndWhitespaces(baseLexer);
                    type = SqlLexer.this.getSqlTokenType(baseLexer);
                    if (type != SqlTokens.SQL_STDIN) return;
                    this.myCopyState = 2;
                }
            } else if (this.myCopyState == 2 && SqlLexer.isStatementSeparator(type)) {
                SqlLexer.this.advanceAs(baseLexer, type);
                int start = baseLexer.getTokenStart();
                SqlLexer.this.skipCommentsAndWhitespaces(baseLexer);
                int newLines = StringUtil.countChars((CharSequence)baseLexer.getBufferSequence(), (char)'\n', (int)start, (int)baseLexer.getTokenEnd(), (boolean)false);
                if (newLines < 2) {
                    this.createInputToken(baseLexer);
                    this.myCopyState = 3;
                    return;
                } else {
                    this.myCopyState = 0;
                }
                return;
            }
            if (this.myCopyState < 2 && SqlLexer.isStatementSeparator(type)) {
                this.myCopyState = 0;
            }
            SqlLexer.this.advanceAs(baseLexer, type);
        }

        private void createInputToken(Lexer baseLexer) {
            int end;
            CharSequence buf = baseLexer.getBufferSequence();
            int start = baseLexer.getTokenStart();
            if (start == (end = baseLexer.getBufferEnd())) {
                return;
            }
            int term = CopyHelper.findInputTerminator(buf, start, end);
            SqlLexer.this.addToken(term, (IElementType)SqlTokens.SQL_RAW_INPUT);
            if (term != start) {
                baseLexer.start(buf, term, end, baseLexer.getState());
            }
            SqlLexer.this.skipCommentsAndWhitespaces(baseLexer);
            int s = baseLexer.getTokenStart();
            if (s + 1 < end && buf.charAt(s) == '\\' && buf.charAt(s + 1) == '.') {
                SqlLexer.this.addToken(s + 2, (IElementType)SqlTokens.PG_COPY_TERMINATOR);
                baseLexer.start(buf, s + 2, end, baseLexer.getState());
            }
        }

        private static int findInputTerminator(@NotNull CharSequence text, int start, int end) {
            if (text == null) {
                CopyHelper.$$$reportNull$$$0(0);
            }
            int i;
            while ((i = StringUtil.indexOf((CharSequence)text, (CharSequence)"\\.", (int)start, (int)end)) != -1) {
                int prev;
                int pi = i - 1;
                int n = prev = pi < start ? 13 : (int)text.charAt(pi);
                if (pi < start) {
                    pi = start;
                }
                if (prev == 10 && pi > start && text.charAt(pi - 1) == '\r') {
                    --pi;
                }
                if (prev == 10 || prev == 13) {
                    int next;
                    int ni = i + 2;
                    int n2 = next = ni < end ? (int)text.charAt(ni) : 13;
                    if (next == 10 || next == 13) {
                        return pi;
                    }
                }
                start = i + 1;
            }
            return end;
        }

        private static boolean isStatementPredecessor(IElementType type) {
            return SqlLexer.isStatementSeparator(type) || type == SqlTokens.SQL_BEGIN;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/dialects/base/SqlLexer$CopyHelper", "findInputTerminator"));
        }
    }

    protected abstract class LookAheadHelper {
        private int myCachePos = 0;
        private Lexer myLexer;

        protected LookAheadHelper() {
        }

        @Nullable
        private IElementType nextCached() {
            int cs = SqlLexer.this.getCacheSize();
            if (this.myCachePos > cs) {
                return null;
            }
            if (this.myCachePos == cs) {
                this.superLookAhead(this.myLexer);
                if (cs == SqlLexer.this.getCacheSize()) {
                    ++this.myCachePos;
                    return null;
                }
            }
            return SqlLexer.this.getCachedType(this.myCachePos++);
        }

        protected abstract void superLookAhead(Lexer var1);

        public void restart(Lexer lexer) {
            this.myCachePos = 0;
            this.myLexer = lexer;
        }

        public IElementType getNextToken() {
            IElementType res;
            while (SqlTokens.WS_OR_COMMENTS.contains(res = this.nextCached())) {
            }
            return res;
        }

        public int getOffset(int i) {
            return i < 0 ? SqlLexer.this.getTokenStart() : SqlLexer.this.getCachedOffset(i);
        }

        public CharSequence getTokenText(int i) {
            return SqlLexer.this.getBufferSequence().subSequence(this.getOffset(i - 1), this.getOffset(i));
        }

        public int getPos() {
            return this.myCachePos - 1;
        }

        public void replaceToken(int i, IElementType type) {
            SqlLexer.this.replaceCachedType(i, type);
        }

        public IElementType getToken(int pos) {
            return SqlLexer.this.getCachedType(pos);
        }
    }
}

