/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.patterns;

import ai.grazie.nlp.patterns.Pattern;
import ai.grazie.text.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0013\b\u0016\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lai/grazie/nlp/patterns/RegexPattern;", "Lai/grazie/nlp/patterns/Pattern;", "regex", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/text/Regex;)V", "pattern", "", "(Ljava/lang/String;)V", "getRegex", "()Lkotlin/text/Regex;", "find", "", "Lai/grazie/text/TextRange;", "text", "", "matches", "", "nlp-patterns"})
public class RegexPattern
implements Pattern {
    @NotNull
    private final Regex regex;

    public RegexPattern(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        this.regex = regex;
    }

    @NotNull
    protected final Regex getRegex() {
        return this.regex;
    }

    public RegexPattern(@Language(value="RegExp") @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this(new Regex(pattern));
    }

    @Override
    @NotNull
    public List<TextRange> find(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)this.regex, (CharSequence)text2, (int)0, (int)2, null), RegexPattern::find$lambda$0));
    }

    @Override
    public boolean matches(@NotNull CharSequence text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        MatchResult matchResult = this.regex.matchAt(text2, 0);
        return Intrinsics.areEqual((Object)(matchResult != null ? matchResult.getRange() : null), (Object)StringsKt.getIndices((CharSequence)text2));
    }

    private static final TextRange find$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TextRange.Companion.invoke(it.getRange());
    }
}

