/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.base.BaseGridHelper;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.mongo.js.JSElementTypes;
import com.intellij.sql.dialects.mongo.js.MongoJSCodeFragment;
import com.intellij.sql.dialects.mongo.js.MongoJSParser;
import com.intellij.sql.dialects.mongo.js.MongoJSParserDefinition;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016JJ\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016J\u001c\u0010\u0017\u001a\u00020\u00102\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0016J8\u0010\u0018\u001a\u00020\u00102\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J8\u0010\u0019\u001a\u00020\u00102\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002J,\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u0010\u001e\u001a\u00020\u00102\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u0016\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dialects/mongo/MongoGridHelper;", "Lcom/intellij/database/dialects/base/BaseGridHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "getCellLanguage", "Lcom/intellij/lang/Language;", "grid", "Lcom/intellij/database/datagrid/CoreGrid;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "column", "isModifyColumnAcrossCollection", "", "createCellCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "text", "", "project", "Lcom/intellij/openapi/project/Project;", "canMutateColumns", "isObjectCell", "isArrayCell", "setFilterText", "", "caretPosition", "", "isMixedTypeColumns", "intellij.database.dialects.mongo"})
public final class MongoGridHelper
extends BaseGridHelper {
    public MongoGridHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    @Nullable
    public Language getCellLanguage(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.isArrayCell(grid, row, column) || this.isObjectCell(grid, row, column) ? (Language)MongoJSLanguage.INSTANCE : null;
    }

    public boolean isModifyColumnAcrossCollection() {
        return true;
    }

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String text, @NotNull Project project, @NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        PsiCodeFragment psiCodeFragment;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (this.isObjectCell(grid, row, column)) {
            JSElementTypes.JSElType jSElType = JSElementTypes.OBJECT_LITERAL_EXPRESSION;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)jSElType), (String)"OBJECT_LITERAL_EXPRESSION");
            psiCodeFragment = MongoJSCodeFragment.Companion.create$default(MongoJSCodeFragment.Companion, jSElType, project, "dummy.js", text, true, null, 32, null);
        } else {
            psiCodeFragment = null;
        }
        return psiCodeFragment;
    }

    public boolean canMutateColumns(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return true;
    }

    private final boolean isObjectCell(CoreGrid<GridRow, GridColumn> grid, ModelIndex<GridRow> row, ModelIndex<GridColumn> column) {
        return StringUtil.equalsIgnoreCase((CharSequence)GridCellEditorsUtil.guessTypeNameForEditing(grid, row, column), (CharSequence)"Object");
    }

    private final boolean isArrayCell(CoreGrid<GridRow, GridColumn> grid, ModelIndex<GridRow> row, ModelIndex<GridColumn> column) {
        return StringUtil.equalsIgnoreCase((CharSequence)GridCellEditorsUtil.guessTypeNameForEditing(grid, row, column), (CharSequence)"Array");
    }

    public void setFilterText(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull String text, int caretPosition) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        MongoJSParserDefinition parserDefinition = new MongoJSParserDefinition();
        Project project = grid.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String string = grid.getFilterText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFilterText(...)");
        String currentText = string;
        PsiBuilderImpl builder = new PsiBuilderImpl(project2, null, (ParserDefinition)parserDefinition, parserDefinition.createLexer(project2), null, (CharSequence)currentText, null, null);
        new MongoJSParser((PsiBuilder)builder).parseJS(JSElementTypes.ARGUMENT_LIST);
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.lightTraverser((PsiBuilder)((PsiBuilder)builder));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"lightTraverser(...)");
        SyntaxTraverser traverser = syntaxTraverser;
        List list = traverser.children(traverser.getRoot()).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List children = list;
        SyntaxTraverser.Api api = traverser.api;
        if (children.size() == 3 && Intrinsics.areEqual((Object)api.typeOf(children.get(0)), (Object)((Object)JSElementTypes.OBJECT_LITERAL_EXPRESSION)) && Intrinsics.areEqual((Object)api.typeOf(children.get(1)), (Object)JSElementTypes.COMMA) && Intrinsics.areEqual((Object)api.typeOf(children.get(2)), (Object)((Object)JSElementTypes.OBJECT_LITERAL_EXPRESSION))) {
            String string2 = currentText.substring(api.rangeOf(children.get(0)).getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            grid.setFilterText(text + string2, caretPosition);
        } else {
            grid.setFilterText(text, caretPosition);
        }
    }

    public boolean isMixedTypeColumns(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return true;
    }
}

