/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.reflect.full.KTypes;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.annotations.Interpretable;
import org.jetbrains.kotlinx.dataframe.annotations.Refine;
import org.jetbrains.kotlinx.dataframe.api.RenameKt;
import org.jetbrains.kotlinx.dataframe.api.SchemaKt;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.TypeSuggestion;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.api.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J2\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u001e\u0010\t\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0002\b\u00030\u000bj\u0002`\f0\n\"\u0006\u0012\u0002\b\u00030\u000bH\u0086\u0002\u00a2\u0006\u0002\u0010\rJ#\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\u000bj\u0002`\f0\u000eH\u0086\u0002J*\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0016\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\n\"\u0004\u0018\u00010\u0001H\u0087\u0002\u00a2\u0006\u0002\u0010\u0010J!\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\b2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eH\u0001\u00a2\u0006\u0002\b\u0012J\u001d\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0014H\u0086\u0002J&\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\b2\u001a\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0002\b\u00030\u000bj\u0002`\f0\u0017J4\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\"\u0006\b\u0000\u0010\u0018\u0018\u00012\u001a\b\u0004\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180\u000e0\u0017H\u0086\n\u00f8\u0001\u0000J*\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\b\"\u0006\b\u0000\u0010\u001b\u0018\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u0002H\u001bH\u0086\b\u00a2\u0006\u0002\u0010\u001fJ\"\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\u0010 \u001a\n\u0012\u0002\b\u00030\bj\u0002`!J\u001d\u0010\"\u001a\u0006\u0012\u0002\b\u00030\b\"\u0006\b\u0000\u0010\u001b\u0018\u00012\u0006\u0010\u001c\u001a\u00020\u001dH\u0086\bJ<\u0010#\u001a\u0006\u0012\u0002\b\u00030\b\"\u0006\b\u0000\u0010\u001b\u0018\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u001a\b\u0004\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u001b0%H\u0086\b\u00f8\u0001\u0000J6\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\b\"\u0006\b\u0000\u0010\u001b\u0018\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0014\b\u0004\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u001b0\u0017H\u0086\b\u00f8\u0001\u0000J7\u0010&\u001a\u0006\u0012\u0002\b\u00030\b\"\n\b\u0000\u0010\u001b\u0018\u0001*\u00020\u00012\u0006\u0010\u001c\u001a\u00020\u001d2\u0014\b\u0004\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u001b0\u0017H\u0082\bJ\u0012\u0010'\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010'\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)J\u0012\u0010*\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010*\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020,0+J\u0012\u0010-\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010.\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010.\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020/0+J\u0012\u00100\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u001c\u001a\u00020\u001dR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlinx/dataframe/api/DataFrameBuilder;", "", "header", "", "", "<init>", "(Ljava/util/List;)V", "invoke", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "columns", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "([Lorg/jetbrains/kotlinx/dataframe/DataColumn;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "", "values", "([Ljava/lang/Object;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "withValues", "invoke1", "args", "Lkotlin/sequences/Sequence;", "withColumns", "columnBuilder", "Lkotlin/Function1;", "T", "valuesBuilder", "fill", "C", "nrow", "", "value", "(ILjava/lang/Object;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "dataFrame", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "nulls", "fillIndexed", "init", "Lkotlin/Function2;", "fillNotNull", "randomInt", "range", "Lkotlin/ranges/IntRange;", "randomDouble", "Lkotlin/ranges/ClosedRange;", "", "randomFloat", "randomLong", "", "randomBoolean", "core"})
@SourceDebugExtension(value={"SMAP\nconstructors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 constructors.kt\norg/jetbrains/kotlinx/dataframe/api/DataFrameBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,457:1\n352#1,7:474\n388#1,7:481\n388#1,7:488\n388#1,7:495\n388#1,7:502\n388#1,7:509\n388#1,7:516\n388#1,7:523\n388#1,7:530\n1#2:458\n1567#3:459\n1598#3,4:460\n1557#3:464\n1628#3,3:465\n1557#3:470\n1628#3,3:471\n37#4,2:468\n*S KotlinDebug\n*F\n+ 1 constructors.kt\norg/jetbrains/kotlinx/dataframe/api/DataFrameBuilder\n*L\n369#1:474,7\n396#1:481,7\n398#1:488,7\n400#1:495,7\n403#1:502,7\n405#1:509,7\n407#1:516,7\n410#1:523,7\n412#1:530,7\n320#1:459\n320#1:460,4\n331#1:464\n331#1:465,3\n339#1:470\n339#1:471,3\n335#1:468,2\n*E\n"})
public final class DataFrameBuilder {
    @NotNull
    private final List<String> header;

    public DataFrameBuilder(@NotNull List<String> header) {
        Intrinsics.checkNotNullParameter(header, (String)"header");
        this.header = header;
    }

    @NotNull
    public final DataFrame<?> invoke(DataColumn<?> ... columns2) {
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        return this.invoke(ArraysKt.asIterable((Object[])columns2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame<?> invoke(@NotNull Iterable<? extends DataColumn<?>> columns2) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        List<DataColumn<?>> cols = UtilsKt.asList(columns2);
        if (!(cols.size() == this.header.size())) {
            boolean $i$a$-require-DataFrameBuilder$invoke$22 = false;
            String $i$a$-require-DataFrameBuilder$invoke$22 = "Number of columns differs from number of column names";
            throw new IllegalArgumentException($i$a$-require-DataFrameBuilder$invoke$22.toString());
        }
        Iterable $this$mapIndexed$iv = cols;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void col;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(col.rename(this.header.get((int)i)));
        }
        return ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv);
    }

    @Refine
    @Interpretable(interpreter="DataFrameBuilderInvoke0")
    @NotNull
    public final DataFrame<?> invoke(Object ... values) {
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return this.invoke1(ArraysKt.asIterable((Object[])values));
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="invoke1")
    @NotNull
    public final DataFrame<?> invoke1(@NotNull Iterable<? extends Object> values) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Iterable $this$map$iv = ConstructorsKt.withValuesImpl(this.header, UtilsKt.asList(values));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String name = (String)pair.component1();
            List values2 = (List)pair.component2();
            collection.add(DataColumn.Companion.createByInference$default(DataColumn.Companion, name, values2, null, null, 12, null));
        }
        return ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv);
    }

    @NotNull
    public final DataFrame<?> invoke(@NotNull Sequence<? extends Object> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Collection $this$toTypedArray$iv = SequencesKt.toList(args);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        return this.invoke(Arrays.copyOf(objectArray, objectArray.length));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DataFrame<?> withColumns(@NotNull Function1<? super String, ? extends DataColumn<?>> columnBuilder) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(columnBuilder, (String)"columnBuilder");
        Iterable $this$map$iv = this.header;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((DataColumn)RenameKt.named((ColumnReference)columnBuilder.invoke((Object)it), (String)it));
        }
        return ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv);
    }

    public final /* synthetic */ <T> DataFrame<?> invoke(Function1<? super String, ? extends Iterable<? extends T>> valuesBuilder) {
        Intrinsics.checkNotNullParameter(valuesBuilder, (String)"valuesBuilder");
        boolean $i$f$invoke = false;
        Intrinsics.needClassReification();
        return this.withColumns((Function1)new Function1<String, DataColumn<?>>(valuesBuilder){
            final /* synthetic */ Function1<String, Iterable<T>> $valuesBuilder;
            {
                this.$valuesBuilder = $valuesBuilder;
            }

            public final DataColumn<?> invoke(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                List<T> list = UtilsKt.asList((Iterable)this.$valuesBuilder.invoke((Object)name));
                Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                return DataColumn.Companion.createByInference$default(DataColumn.Companion, name, list, new TypeSuggestion.InferWithUpperbound(null), null, 8, null);
            }
        });
    }

    public final /* synthetic */ <C> DataFrame<?> fill(int nrow, C value) {
        boolean $i$f$fill = false;
        Intrinsics.needClassReification();
        return this.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, value){
            final /* synthetic */ int $nrow;
            final /* synthetic */ C $value;
            {
                this.$nrow = $nrow;
                this.$value = $value;
            }

            public final DataColumn<?> invoke(String name) {
                ArrayList<C> arrayList;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                C c = this.$value;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<C> arrayList2 = new ArrayList<C>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    arrayList = arrayList2;
                    boolean bl = false;
                    arrayList.add(c);
                }
                arrayList = arrayList2;
                Intrinsics.reifiedOperationMarker((int)6, (String)"C");
                return DataColumn.Companion.createValueColumn$default(companion, string, arrayList, KTypes.withNullability(null, (this.$value == null ? 1 : 0) != 0), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> fill(int nrow, @NotNull DataFrame<?> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        return this.withColumns(arg_0 -> DataFrameBuilder.fill$lambda$6(nrow, dataFrame, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <C> DataFrame<?> nulls(int nrow) {
        void this_$iv;
        boolean $i$f$nulls = false;
        DataFrameBuilder dataFrameBuilder = this;
        Object value$iv = null;
        boolean $i$f$fill = false;
        Intrinsics.needClassReification();
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, value$iv){
            final /* synthetic */ int $nrow;
            final /* synthetic */ Object $value;
            {
                this.$nrow = $nrow;
                this.$value = $value;
            }

            public final DataColumn<?> invoke(String name) {
                ArrayList<Object> arrayList;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                Object object = this.$value;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    arrayList = arrayList2;
                    boolean bl = false;
                    arrayList.add(object);
                }
                arrayList = arrayList2;
                Intrinsics.reifiedOperationMarker((int)6, (String)"C?");
                return DataColumn.Companion.createValueColumn$default(companion, string, arrayList, KTypes.withNullability(null, (this.$value == null ? 1 : 0) != 0), null, null, 24, null);
            }
        });
    }

    public final /* synthetic */ <C> DataFrame<?> fillIndexed(int nrow, Function2<? super Integer, ? super String, ? extends C> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        boolean $i$f$fillIndexed = false;
        Intrinsics.needClassReification();
        return this.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, init){
            final /* synthetic */ int $nrow;
            final /* synthetic */ Function2<Integer, String, C> $init;
            {
                this.$nrow = $nrow;
                this.$init = $init;
            }

            /*
             * WARNING - void declaration
             */
            public final DataColumn<?> invoke(String name) {
                ArrayList<Object> arrayList;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                Function2<Integer, String, C> function2 = this.$init;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Object> arrayList2 = new ArrayList<Object>(n);
                int n2 = 0;
                while (n2 < n) {
                    void it;
                    int n3;
                    int n4 = n3 = n2++;
                    arrayList = arrayList2;
                    boolean bl = false;
                    arrayList.add(function2.invoke((Object)((int)it), (Object)name));
                }
                arrayList = arrayList2;
                return DataColumn.Companion.createByInference$default(companion, string, arrayList, null, null, 12, null);
            }
        });
    }

    public final /* synthetic */ <C> DataFrame<?> fill(int nrow, Function1<? super Integer, ? extends C> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        boolean $i$f$fill = false;
        return this.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, init){
            final /* synthetic */ int $nrow;
            final /* synthetic */ Function1<Integer, C> $init;
            {
                this.$nrow = $nrow;
                this.$init = $init;
            }

            public final DataColumn<?> invoke(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                Function1<Integer, C> function1 = this.$init;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3 = n2++;
                    arrayList.add(function1.invoke((Object)n3));
                }
                List list = arrayList;
                return DataColumn.Companion.createByInference$default(companion, string, list, null, null, 12, null);
            }
        });
    }

    private final /* synthetic */ <C> DataFrame<?> fillNotNull(int nrow, Function1<? super Integer, ? extends C> init) {
        boolean $i$f$fillNotNull = false;
        Intrinsics.needClassReification();
        return this.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, init){
            final /* synthetic */ int $nrow;
            final /* synthetic */ Function1<Integer, C> $init;
            {
                this.$nrow = $nrow;
                this.$init = $init;
            }

            public final DataColumn<?> invoke(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                Function1<Integer, C> function1 = this.$init;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Object> arrayList = new ArrayList<Object>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3 = n2++;
                    arrayList.add(function1.invoke((Object)n3));
                }
                List list = arrayList;
                Intrinsics.reifiedOperationMarker((int)6, (String)"C");
                return DataColumn.Companion.createValueColumn$default(companion, string, list, null, null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomInt(int nrow) {
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow){
            final /* synthetic */ int $nrow;
            {
                this.$nrow = $nrow;
            }

            public final DataColumn<?> invoke(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Integer> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Random.Default.nextInt());
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Integer.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomInt(int nrow, @NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, range){
            final /* synthetic */ int $nrow;
            final /* synthetic */ IntRange $range$inlined;
            {
                this.$nrow = $nrow;
                this.$range$inlined = intRange;
            }

            public final DataColumn<?> invoke(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Integer> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(RandomKt.nextInt((Random)((Random)Random.Default), (IntRange)this.$range$inlined));
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Integer.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomDouble(int nrow) {
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow){
            final /* synthetic */ int $nrow;
            {
                this.$nrow = $nrow;
            }

            public final DataColumn<?> invoke(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Double> arrayList = new ArrayList<Double>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Double> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Random.Default.nextDouble());
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Double.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomDouble(int nrow, @NotNull ClosedRange<Double> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, range){
            final /* synthetic */ int $nrow;
            final /* synthetic */ ClosedRange $range$inlined;
            {
                this.$nrow = $nrow;
                this.$range$inlined = closedRange;
            }

            public final DataColumn<?> invoke(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Double> arrayList = new ArrayList<Double>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Double> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Random.Default.nextDouble(((Number)((Object)this.$range$inlined.getStart())).doubleValue(), ((Number)((Object)this.$range$inlined.getEndInclusive())).doubleValue()));
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Double.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomFloat(int nrow) {
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow){
            final /* synthetic */ int $nrow;
            {
                this.$nrow = $nrow;
            }

            public final DataColumn<?> invoke(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Float> arrayList = new ArrayList<Float>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Float> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Float.valueOf(Random.Default.nextFloat()));
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Float.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomLong(int nrow) {
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow){
            final /* synthetic */ int $nrow;
            {
                this.$nrow = $nrow;
            }

            public final DataColumn<?> invoke(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Long> arrayList = new ArrayList<Long>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Long> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Random.Default.nextLong());
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Long.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomLong(int nrow, @NotNull ClosedRange<Long> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow, range){
            final /* synthetic */ int $nrow;
            final /* synthetic */ ClosedRange $range$inlined;
            {
                this.$nrow = $nrow;
                this.$range$inlined = closedRange;
            }

            public final DataColumn<?> invoke(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Long> arrayList = new ArrayList<Long>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Long> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Random.Default.nextLong(((Number)((Object)this.$range$inlined.getStart())).longValue(), ((Number)((Object)this.$range$inlined.getEndInclusive())).longValue()));
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Long.TYPE), null, null, 24, null);
            }
        });
    }

    @NotNull
    public final DataFrame<?> randomBoolean(int nrow) {
        DataFrameBuilder this_$iv = this;
        boolean $i$f$fillNotNull = false;
        return this_$iv.withColumns((Function1)new Function1<String, DataColumn<?>>(nrow){
            final /* synthetic */ int $nrow;
            {
                this.$nrow = $nrow;
            }

            public final DataColumn<?> invoke(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                int n = this.$nrow;
                String string = name;
                DataColumn.Companion companion = DataColumn.Companion;
                ArrayList<Boolean> arrayList = new ArrayList<Boolean>(n);
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4 = n3 = n2++;
                    ArrayList<Boolean> arrayList2 = arrayList;
                    boolean bl = false;
                    arrayList2.add(Random.Default.nextBoolean());
                }
                List list = arrayList;
                return DataColumn.Companion.createValueColumn$default(companion, string, list, Reflection.typeOf(Boolean.TYPE), null, null, 24, null);
            }
        });
    }

    private static final DataFrameSchema fill$lambda$6$lambda$5(DataFrame $dataFrame) {
        return SchemaKt.schema($dataFrame);
    }

    private static final DataColumn fill$lambda$6(int $nrow, DataFrame $dataFrame, String name) {
        ArrayList<DataFrame> arrayList;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name;
        DataColumn.Companion companion = DataColumn.Companion;
        ArrayList<DataFrame> arrayList2 = new ArrayList<DataFrame>($nrow);
        int n = 0;
        while (n < $nrow) {
            int n2;
            int n3 = n2 = n++;
            arrayList = arrayList2;
            boolean bl = false;
            arrayList.add($dataFrame);
        }
        arrayList = arrayList2;
        return companion.createFrameColumn(string, arrayList, (Lazy<? extends DataFrameSchema>)LazyKt.lazy(() -> DataFrameBuilder.fill$lambda$6$lambda$5($dataFrame)));
    }
}

