/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.api;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.KTypesJvm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataColumnKt;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.AddDataRow;
import org.jetbrains.kotlinx.dataframe.api.AllKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnReferenceApiKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.ConcatKt;
import org.jetbrains.kotlinx.dataframe.api.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.api.ConvertKt;
import org.jetbrains.kotlinx.dataframe.api.ConvertSchemaDsl;
import org.jetbrains.kotlinx.dataframe.api.ConverterScope;
import org.jetbrains.kotlinx.dataframe.api.DataColumnTypeKt;
import org.jetbrains.kotlinx.dataframe.api.ExcessiveColumns;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.api.IsEmptyKt;
import org.jetbrains.kotlinx.dataframe.api.MapKt;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.api.UpdateKt;
import org.jetbrains.kotlinx.dataframe.codeGen.Marker;
import org.jetbrains.kotlinx.dataframe.codeGen.MarkersExtractor;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.ColumnKind;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.FrameColumn;
import org.jetbrains.kotlinx.dataframe.columns.UnresolvedColumnsPolicy;
import org.jetbrains.kotlinx.dataframe.exceptions.ExcessiveColumnsException;
import org.jetbrains.kotlinx.dataframe.exceptions.TypeConversionException;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.api.ConvertSchemaDslImpl;
import org.jetbrains.kotlinx.dataframe.impl.api.Converter;
import org.jetbrains.kotlinx.dataframe.impl.api.Filler;
import org.jetbrains.kotlinx.dataframe.impl.api.InsertKt;
import org.jetbrains.kotlinx.dataframe.impl.schema.DataFrameSchemaImplKt;
import org.jetbrains.kotlinx.dataframe.schema.ColumnSchema;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001aU\u0010\u0002\u001a\n\u0012\u0002\b\u00030\u0003j\u0002`\u0004*\n\u0012\u0002\b\u00030\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u001f\b\u0002\u0010\u000b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0002\b\u0010H\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"logger", "Lio/github/oshai/kotlinlogging/KLogger;", "convertToImpl", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "type", "Lkotlin/reflect/KType;", "allowConversion", "", "excessiveColumns", "Lorg/jetbrains/kotlinx/dataframe/api/ExcessiveColumns;", "body", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/dataframe/api/ConvertSchemaDsl;", "", "", "Lkotlin/ExtensionFunctionType;", "core"})
@SourceDebugExtension(value={"SMAP\nconvertTo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 convertTo.kt\norg/jetbrains/kotlinx/dataframe/impl/api/ConvertToKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 add.kt\norg/jetbrains/kotlinx/dataframe/api/AddKt\n+ 4 map.kt\norg/jetbrains/kotlinx/dataframe/api/MapKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,322:1\n1863#2:323\n3193#2,10:324\n1797#2,2:334\n1799#2:340\n1864#2:341\n1557#2:342\n1628#2,3:343\n1734#2,3:346\n1611#2,9:349\n1863#2:358\n1557#2:360\n1628#2,3:361\n1557#2:364\n1628#2,3:365\n1557#2:368\n1628#2,3:369\n1864#2:373\n1620#2:374\n151#3:336\n152#3,2:338\n72#4:337\n1#5:359\n1#5:372\n216#6,2:375\n*S KotlinDebug\n*F\n+ 1 convertTo.kt\norg/jetbrains/kotlinx/dataframe/impl/api/ConvertToKt\n*L\n291#1:323\n296#1:324,10\n302#1:334,2\n302#1:340\n291#1:341\n315#1:342\n315#1:343,3\n225#1:346,3\n114#1:349,9\n114#1:358\n230#1:360\n230#1:361,3\n240#1:364\n240#1:365,3\n244#1:368\n244#1:369,3\n114#1:373\n114#1:374\n303#1:336\n303#1:338,2\n303#1:337\n114#1:372\n261#1:375,2\n*E\n"})
public final class ConvertToKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(ConvertToKt::logger$lambda$0);

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    @NotNull
    public static final DataFrame<?> convertToImpl(@NotNull DataFrame<?> $this$convertToImpl, @NotNull KType type, boolean allowConversion, @NotNull ExcessiveColumns excessiveColumns, @NotNull Function1<? super ConvertSchemaDsl<Object>, Unit> body) {
        List<String> newPaths;
        Intrinsics.checkNotNullParameter($this$convertToImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)excessiveColumns), (String)"excessiveColumns");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        ConvertSchemaDslImpl<Object> dsl = new ConvertSchemaDslImpl<Object>();
        body.invoke(dsl);
        Set missingPaths = new LinkedHashSet();
        KClass clazz = KTypesJvm.getJvmErasure((KType)type);
        Marker marker = MarkersExtractor.get$default(MarkersExtractor.INSTANCE, clazz, false, 2, null);
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = ConvertToKt.convertToImpl$convertToSchema($this$convertToImpl, excessiveColumns, allowConversion, dsl, missingPaths, marker.getSchema(), UtilsKt.emptyPath());
        Iterable $this$forEach$iv = dsl.getFillers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$fold$iv;
            void initial$iv;
            Filler filler = (Filler)element$iv;
            boolean bl = false;
            Set paths = CollectionsKt.toSet((Iterable)UtilsKt.getColumnPaths((DataFrame)result.element, UnresolvedColumnsPolicy.Create, filler.getColumns()));
            Iterable $this$partition$iv = paths;
            boolean $i$f$partition = false;
            Iterable<Object> first$iv = new ArrayList();
            Object second$iv = new ArrayList();
            for (Object element$iv2 : $this$partition$iv) {
                ColumnPath it = (ColumnPath)element$iv2;
                boolean bl2 = false;
                if (missingPaths.contains(it)) {
                    first$iv.add(element$iv2);
                    continue;
                }
                ((ArrayList)second$iv).add(element$iv2);
            }
            Pair pair = new Pair(first$iv, second$iv);
            newPaths = (List)pair.component1();
            List existingPaths = (List)pair.component2();
            result.element = UpdateKt.with(UpdateKt.update((DataFrame)result.element, (arg_0, arg_1) -> ConvertToKt.convertToImpl$lambda$21$lambda$17(existingPaths, arg_0, arg_1)), (arg_0, arg_1) -> ConvertToKt.convertToImpl$lambda$21$lambda$18(filler, arg_0, arg_1));
            first$iv = newPaths;
            second$iv = result.element;
            Ref.ObjectRef objectRef = result;
            boolean $i$f$fold = false;
            DataFrame accumulator$iv = initial$iv;
            for (Object element$iv3 : $this$fold$iv) {
                void infer$iv;
                void $this$mapToColumn$iv$iv;
                void newPath;
                void $this$add$iv;
                ColumnPath columnPath = (ColumnPath)element$iv3;
                DataFrame df2 = accumulator$iv;
                boolean bl3 = false;
                DataFrame dataFrame = df2;
                Infer infer = Infer.Type;
                Function2 expression$iv = (arg_0, arg_1) -> ConvertToKt.convertToImpl$lambda$21$lambda$20$lambda$19(filler, arg_0, arg_1);
                boolean $i$f$add = false;
                ColumnsContainer columnsContainer = (ColumnsContainer)$this$add$iv;
                String name$iv$iv = newPath.name();
                boolean $i$f$mapToColumn = false;
                DataColumn col$iv = MapKt.mapToColumn($this$mapToColumn$iv$iv, name$iv$iv, Reflection.nullableTypeOf(Object.class), (Infer)infer$iv, expression$iv);
                accumulator$iv = newPath.size() == 1 ? $this$add$iv.plus(col$iv) : InsertKt.insertImpl($this$add$iv, (ColumnPath)newPath, col$iv);
            }
            objectRef.element = accumulator$iv;
            CollectionsKt.removeAll((Collection)missingPaths, (Iterable)paths);
        }
        if (!((Collection)missingPaths).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$forEach$iv = missingPaths;
            StringBuilder stringBuilder = new StringBuilder().append("The following columns were not found in DataFrame: ");
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                newPaths = (ColumnPath)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ColumnPath.joinToString$default((ColumnPath)it, null, 1, null));
            }
            String string = stringBuilder.append((List)destination$iv$iv).append(", and their type was not nullable. Use `fill` to initialize these columns").toString();
            throw new IllegalArgumentException(string);
        }
        return (DataFrame)result.element;
    }

    public static /* synthetic */ DataFrame convertToImpl$default(DataFrame dataFrame, KType kType, boolean bl, ExcessiveColumns excessiveColumns, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = ConvertToKt::convertToImpl$lambda$1;
        }
        return ConvertToKt.convertToImpl(dataFrame, kType, bl, excessiveColumns, (Function1<? super ConvertSchemaDsl<Object>, Unit>)function1);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit convertToImpl$lambda$1(ConvertSchemaDsl convertSchemaDsl) {
        Intrinsics.checkNotNullParameter((Object)convertSchemaDsl, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final Object convertToImpl$convertToSchema$lambda$13$lambda$2(Converter $converter, KType $from, ColumnSchema $targetSchema, boolean $nullsAllowed, KType $to, DataColumn $originalColumn, Object it) {
        Object result;
        Object object = result = it != null || !$converter.getSkipNulls() ? $converter.getTransform().invoke((Object)new ConverterScope($from, $targetSchema), it) : it;
        if (!$nullsAllowed && result == null) {
            throw new TypeConversionException(it, $from, $to, $originalColumn.path());
        }
        return result;
    }

    private static final boolean convertToImpl$convertToSchema$lambda$13$lambda$3(Object it) {
        return it instanceof DataRow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean convertToImpl$convertToSchema$lambda$13$lambda$7(Object it) {
        Object t;
        if (it == null) return true;
        if (it instanceof DataFrame) return true;
        if (!(it instanceof List)) return false;
        Iterable $this$all$iv = (Iterable)it;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            Object it2 = element$iv = iterator2.next();
            boolean bl = false;
            t = it2;
        } while (t == null ? true : t instanceof DataRow);
        return false;
    }

    private static final DataFrameSchema convertToImpl$convertToSchema$lambda$13$lambda$12(DataFrameSchema $frameSchema) {
        return $frameSchema;
    }

    private static final Object convertToImpl$convertToSchema$lambda$15$lambda$14() {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private static final DataFrame<?> convertToImpl$convertToSchema(DataFrame<?> $this$convertToImpl_u24convertToSchema, ExcessiveColumns $excessiveColumns, boolean $allowConversion, ConvertSchemaDslImpl<Object> dsl, Set<ColumnPath> missingPaths, DataFrameSchema schema, ColumnPath path) {
        void $this$mapNotNullTo$iv$iv;
        if (IsEmptyKt.isEmpty($this$convertToImpl_u24convertToSchema)) {
            return org.jetbrains.kotlinx.dataframe.impl.schema.UtilsKt.createEmptyDataFrame(schema);
        }
        Set visited = new LinkedHashSet();
        Iterable $this$mapNotNull$iv = $this$convertToImpl_u24convertToSchema.columns();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            BaseColumn baseColumn;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            DataColumn originalColumn = (DataColumn)element$iv$iv;
            boolean bl2 = false;
            ColumnSchema targetSchema = schema.getColumns().get(originalColumn.name());
            if (targetSchema == null) {
                DataColumn dataColumn;
                switch (WhenMappings.$EnumSwitchMapping$0[$excessiveColumns.ordinal()]) {
                    case 1: {
                        throw new ExcessiveColumnsException(CollectionsKt.listOf((Object)ColumnReferenceApiKt.getName(originalColumn)));
                    }
                    case 2: {
                        dataColumn = originalColumn;
                        break;
                    }
                    case 3: {
                        dataColumn = null;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                baseColumn = dataColumn;
            } else {
                visited.add(originalColumn.name());
                ColumnSchema currentSchema = org.jetbrains.kotlinx.dataframe.impl.schema.UtilsKt.extractSchema(originalColumn);
                if (Intrinsics.areEqual((Object)targetSchema, (Object)currentSchema)) {
                    baseColumn = originalColumn;
                } else {
                    DataColumn dataColumn;
                    if (!$allowConversion) {
                        String originalSchema = DataFrameSchemaImplKt.render(MapsKt.mapOf((Pair)TuplesKt.to((Object)ColumnReferenceApiKt.getName(originalColumn), (Object)currentSchema)), 0, new StringBuilder(), "\t");
                        String targetSchema2 = DataFrameSchemaImplKt.render(MapsKt.mapOf((Pair)TuplesKt.to((Object)ColumnReferenceApiKt.getName(originalColumn), (Object)targetSchema)), 0, new StringBuilder(), "\t");
                        throw new IllegalArgumentException("Column has schema:\n " + originalSchema + "\n that differs from target schema:\n " + targetSchema2);
                    }
                    ColumnPath columnPath = path.plus(ColumnReferenceApiKt.getName(originalColumn));
                    KType from = originalColumn.type();
                    KType to = targetSchema.getType();
                    Converter converter = dsl.getConverter(from, targetSchema);
                    if (converter != null) {
                        boolean nullsAllowed = to.isMarkedNullable();
                        dataColumn = MapKt.map(originalColumn, to, Infer.Nulls, arg_0 -> ConvertToKt.convertToImpl$convertToSchema$lambda$13$lambda$2(converter, from, targetSchema, nullsAllowed, to, originalColumn, arg_0));
                    } else {
                        dataColumn = null;
                    }
                    DataColumn convertedColumn = dataColumn;
                    switch (WhenMappings.$EnumSwitchMapping$1[targetSchema.getKind().ordinal()]) {
                        case 2: {
                            DataColumn dataColumn2 = convertedColumn;
                            if (dataColumn2 == null) {
                                dataColumn2 = ConvertKt.convertTo(originalColumn, to);
                            }
                            baseColumn = dataColumn2;
                            break;
                        }
                        case 3: {
                            DataColumn column;
                            Object object;
                            DataColumn dataColumn3 = convertedColumn;
                            if (dataColumn3 == null) {
                                if (DataColumnKt.getKind(originalColumn) == ColumnKind.Value && AllKt.all(originalColumn, ConvertToKt::convertToImpl$convertToSchema$lambda$13$lambda$3)) {
                                    void it;
                                    Iterable iterable2 = originalColumn.values();
                                    String string = ColumnReferenceApiKt.getName(originalColumn);
                                    object = DataColumn.Companion;
                                    boolean bl3 = false;
                                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.Iterable<org.jetbrains.kotlinx.dataframe.DataRow<*>>");
                                    void var34_39 = it;
                                    ColumnGroup columnGroup = ((DataColumn.Companion)object).createColumnGroup(string, ToDataFrameKt.toDataFrameT(var34_39));
                                    Intrinsics.checkNotNull(columnGroup, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.DataColumn<*>");
                                    dataColumn3 = (DataColumn)((Object)columnGroup);
                                } else if (DataColumnKt.getKind(originalColumn) == ColumnKind.Value && AllKt.allNulls(originalColumn)) {
                                    ColumnGroup<?> columnGroup = DataColumn.Companion.createColumnGroup(ColumnReferenceApiKt.getName(originalColumn), DataFrame.Companion.empty(DataColumnKt.getSize(originalColumn)));
                                    Intrinsics.checkNotNull(columnGroup, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.DataColumn<*>");
                                    dataColumn3 = (DataColumn)((Object)columnGroup);
                                } else {
                                    dataColumn3 = originalColumn;
                                }
                            }
                            if (!DataColumnTypeKt.isColumnGroup(column = dataColumn3)) {
                                boolean $i$a$-require-ConvertToKt$convertToImpl$convertToSchema$newColumns$1$22 = false;
                                String $i$a$-require-ConvertToKt$convertToImpl$convertToSchema$newColumns$1$22 = "Column `" + ColumnReferenceApiKt.getName(column) + "` is " + (Object)((Object)DataColumnKt.getKind(column)) + " and can not be converted to `ColumnGroup`";
                                throw new IllegalArgumentException($i$a$-require-ConvertToKt$convertToImpl$convertToSchema$newColumns$1$22.toString());
                            }
                            baseColumn = DataColumn.Companion.createColumnGroup(((ColumnGroup)((Object)column)).name(), ConvertToKt.convertToImpl$convertToSchema((DataFrame)((Object)column), $excessiveColumns, $allowConversion, dsl, missingPaths, ((ColumnSchema.Group)targetSchema).getSchema(), columnPath));
                            break;
                        }
                        case 1: {
                            void $this$mapTo$iv$iv;
                            Iterable frames;
                            Object item$iv$iv2;
                            Iterable iterable3;
                            Object object;
                            DataColumn dataColumn4 = convertedColumn;
                            if (dataColumn4 == null) {
                                dataColumn4 = originalColumn;
                            }
                            DataColumn column = dataColumn4;
                            DataFrameSchema frameSchema = ((ColumnSchema.Frame)targetSchema).getSchema();
                            switch (WhenMappings.$EnumSwitchMapping$1[DataColumnKt.getKind(column).ordinal()]) {
                                case 1: {
                                    Intrinsics.checkNotNull(column, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.columns.FrameColumn<*>");
                                    iterable3 = ((FrameColumn)column).values();
                                    break;
                                }
                                case 2: {
                                    Iterable $this$mapTo$iv$iv2;
                                    if (!AllKt.all(column, ConvertToKt::convertToImpl$convertToSchema$lambda$13$lambda$7)) {
                                        boolean $i$a$-require-ConvertToKt$convertToImpl$convertToSchema$newColumns$1$frames$32 = false;
                                        String $i$a$-require-ConvertToKt$convertToImpl$convertToSchema$newColumns$1$frames$32 = "Column `" + ColumnReferenceApiKt.getName(column) + "` is ValueColumn and contains objects that can not be converted into `DataFrame`";
                                        throw new IllegalArgumentException($i$a$-require-ConvertToKt$convertToImpl$convertToSchema$newColumns$1$frames$32.toString());
                                    }
                                    Iterable $this$map$iv = column.values();
                                    boolean $i$f$map = false;
                                    Iterable iterable4 = $this$map$iv;
                                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    Iterator iterator3 = $this$mapTo$iv$iv2.iterator();
                                    while (iterator3.hasNext()) {
                                        DataFrame dataFrame;
                                        void it;
                                        Object t = item$iv$iv2 = iterator3.next();
                                        object = destination$iv$iv2;
                                        boolean bl4 = false;
                                        void var47_66 = it;
                                        if (var47_66 == null) {
                                            dataFrame = ConstructorsKt.emptyDataFrame();
                                        } else if (var47_66 instanceof DataFrame) {
                                            dataFrame = (DataFrame)it;
                                        } else {
                                            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.kotlinx.dataframe.DataRow<*>?>");
                                            dataFrame = ConcatKt.concatRows((List)it);
                                        }
                                        object.add(dataFrame);
                                    }
                                    iterable3 = (List)destination$iv$iv2;
                                    break;
                                }
                                case 3: {
                                    Intrinsics.checkNotNull(column, (String)"null cannot be cast to non-null type org.jetbrains.kotlinx.dataframe.columns.ColumnGroup<*>");
                                    Iterable $this$map$iv = ((ColumnGroup)((Object)column)).values();
                                    boolean $i$f$map2 = false;
                                    Iterable $this$mapTo$iv$iv2 = $this$map$iv;
                                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                                        DataRow it = (DataRow)item$iv$iv2;
                                        object = destination$iv$iv3;
                                        boolean bl5 = false;
                                        object.add(TypeConversionsKt.toDataFrame(it));
                                    }
                                    iterable3 = (List)destination$iv$iv3;
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            Iterable $this$map$iv = frames = iterable3;
                            boolean $i$f$map = false;
                            Iterable $i$f$map2 = $this$map$iv;
                            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
                                void it;
                                item$iv$iv2 = (DataFrame)item$iv$iv3;
                                object = destination$iv$iv4;
                                boolean bl6 = false;
                                object.add(ConvertToKt.convertToImpl$convertToSchema(it, $excessiveColumns, $allowConversion, dsl, missingPaths, frameSchema, columnPath));
                            }
                            List convertedFrames = (List)destination$iv$iv4;
                            baseColumn = DataColumn.Companion.createFrameColumn(column.name(), convertedFrames, (Lazy<? extends DataFrameSchema>)LazyKt.lazy(() -> ConvertToKt.convertToImpl$convertToSchema$lambda$13$lambda$12(frameSchema)));
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
            }
            if (baseColumn == null) continue;
            BaseColumn it$iv$iv = baseColumn;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List newColumns = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        int size = DataFrameKt.getSize($this$convertToImpl_u24convertToSchema).getNrow();
        Map<String, ColumnSchema> $this$forEach$iv = schema.getColumns();
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<String, ColumnSchema>> iterator4 = $this$forEach$iv.entrySet().iterator();
        while (iterator4.hasNext()) {
            Map.Entry<String, ColumnSchema> element$iv;
            Map.Entry<String, ColumnSchema> entry = element$iv = iterator4.next();
            boolean bl = false;
            String name = entry.getKey();
            ColumnSchema targetColumn = entry.getValue();
            if (visited.contains(name)) continue;
            try {
                ((Collection)newColumns).add(org.jetbrains.kotlinx.dataframe.impl.schema.UtilsKt.createNullFilledColumn(targetColumn, name, size));
            }
            catch (IllegalStateException e) {
                logger.debug((Throwable)e, ConvertToKt::convertToImpl$convertToSchema$lambda$15$lambda$14);
                missingPaths.add(path.plus(name));
            }
        }
        return ToDataFrameKt.toDataFrameAnyColumn(newColumns);
    }

    private static final ColumnsResolver convertToImpl$lambda$21$lambda$17(List $existingPaths, ColumnsSelectionDsl $this$update, ColumnsSelectionDsl it) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return org.jetbrains.kotlinx.dataframe.columns.ConstructorsKt.toColumnSetColumnPath($existingPaths);
    }

    private static final Object convertToImpl$lambda$21$lambda$18(Filler $filler, AddDataRow $this$with, Object it) {
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"$this$with");
        return $filler.getExpr().invoke((Object)$this$with, (Object)$this$with);
    }

    private static final Object convertToImpl$lambda$21$lambda$20$lambda$19(Filler $filler, AddDataRow $this$add, AddDataRow it) {
        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $filler.getExpr().invoke((Object)$this$add, (Object)$this$add);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ExcessiveColumns.values().length];
            try {
                nArray[ExcessiveColumns.Fail.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExcessiveColumns.Keep.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExcessiveColumns.Remove.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ColumnKind.values().length];
            try {
                nArray[ColumnKind.Frame.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnKind.Value.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColumnKind.Group.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

