/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.actions;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.actions.NewFileActionWithCategory;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.actions.CreateNotebookKt;
import com.intellij.jupyter.core.jupyter.editor.actions.JupyterActionPresentationModifier;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterKernelSpec;
import com.intellij.jupyter.py.actions.JupyterKernelSpecGuesserKt;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0014J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/py/actions/NewJupyterNotebookAction;", "Lcom/intellij/ide/actions/CreateFileFromTemplateAction;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/ide/actions/NewFileActionWithCategory;", "<init>", "()V", "getCategory", "", "buildDialog", "", "project", "Lcom/intellij/openapi/project/Project;", "directory", "Lcom/intellij/psi/PsiDirectory;", "builder", "Lcom/intellij/ide/actions/CreateFileFromTemplateDialog$Builder;", "getActionName", "newName", "templateName", "createFileFromTemplate", "Lcom/intellij/psi/PsiFile;", "name", "template", "Lcom/intellij/ide/fileTemplates/FileTemplate;", "dir", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nNewJupyterNotebookAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewJupyterNotebookAction.kt\ncom/intellij/jupyter/py/actions/NewJupyterNotebookAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n13#2:68\n*S KotlinDebug\n*F\n+ 1 NewJupyterNotebookAction.kt\ncom/intellij/jupyter/py/actions/NewJupyterNotebookAction\n*L\n44#1:68\n*E\n"})
public final class NewJupyterNotebookAction
extends CreateFileFromTemplateAction
implements DumbAware,
NewFileActionWithCategory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String VAR_KERNEL_SPEC_DISPLAY_NAME = "KERNEL_SPEC_DISPLAY_NAME";
    @NotNull
    private static final String VAR_KERNEL_SPEC_LANGUAGE = "KERNEL_SPEC_LANGUAGE";
    @NotNull
    private static final String VAR_KERNEL_SPEC_NAME = "KERNEL_SPEC_NAME";

    @NotNull
    public String getCategory() {
        return "Python";
    }

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.setTitle(JupyterBundle.message((String)"Jupyter.action.create.notebook.dialog.title", (Object[])new Object[0])).addKind(JupyterBundle.message((String)"Jupyter.action.create.notebook.dialog.kind", (Object[])new Object[0]), JupyterFileType.INSTANCE.getIcon(), "Jupyter Notebook");
    }

    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName, @NotNull String templateName) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        Object[] objectArray = new Object[]{templateName};
        return JupyterBundle.message((String)"Jupyter.action.create.notebook.name", (Object[])objectArray);
    }

    @Nullable
    public PsiFile createFileFromTemplate(@NotNull String name, @NotNull FileTemplate template, @NotNull PsiDirectory dir) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Map<String, String> templateValues = Companion.createTemplateValues(dir);
        return CreateNotebookKt.createFileFromTemplateWithProperties$default((String)name, (FileTemplate)template, (PsiDirectory)dir, (String)this.getDefaultTemplateProperty(), templateValues, (Logger)LOG, (boolean)false, (int)64, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        JupyterActionPresentationModifier.Companion.modifyPresentationIfRequired((AnAction)this, e);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NewJupyterNotebookAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/py/actions/NewJupyterNotebookAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "VAR_KERNEL_SPEC_DISPLAY_NAME", "", "VAR_KERNEL_SPEC_LANGUAGE", "VAR_KERNEL_SPEC_NAME", "createTemplateValues", "", "dir", "Lcom/intellij/psi/PsiDirectory;", "getKernelSpec", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterKernelSpec;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> createTemplateValues(@Nullable PsiDirectory dir) {
            JupyterKernelSpec jupyterKernelSpec = this.getKernelSpec(dir);
            if (jupyterKernelSpec == null) {
                jupyterKernelSpec = JupyterKernelSpecGuesserKt.getPython3KernelSpec();
            }
            JupyterKernelSpec kernelSpec = jupyterKernelSpec;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)NewJupyterNotebookAction.VAR_KERNEL_SPEC_DISPLAY_NAME, (Object)kernelSpec.getDisplayName()), TuplesKt.to((Object)NewJupyterNotebookAction.VAR_KERNEL_SPEC_LANGUAGE, (Object)kernelSpec.getLanguage()), TuplesKt.to((Object)NewJupyterNotebookAction.VAR_KERNEL_SPEC_NAME, (Object)kernelSpec.getName())};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        private final JupyterKernelSpec getKernelSpec(PsiDirectory dir) {
            PsiDirectory psiDirectory = dir;
            if (psiDirectory == null || (psiDirectory = psiDirectory.getVirtualFile()) == null) {
                return null;
            }
            PsiDirectory virtualFile = psiDirectory;
            BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked((VirtualFile)virtualFile);
            if (backedNotebookVirtualFile == null) {
                return null;
            }
            BackedNotebookVirtualFile notebookVirtualFile = backedNotebookVirtualFile;
            Project project = dir.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return JupyterKernelSpecGuesserKt.getMostSuitableKernelSpec(notebookVirtualFile, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

