/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.history.ActivityId;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesPreprocess;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooser;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.vcs.VcsActivity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class RevertCommittedStuffAbstractAction
extends AnAction
implements DumbAware {
    private final boolean myReverse;

    protected RevertCommittedStuffAbstractAction(boolean reverse) {
        this.myReverse = reverse;
    }

    protected abstract Change @Nullable [] getChanges(@NotNull AnActionEvent var1, boolean var2);

    public void actionPerformed(@NotNull AnActionEvent e) {
        LocalChangeList targetList;
        Project project;
        if (e == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        final VirtualFile baseDir = Objects.requireNonNull(project.getBaseDir());
        Change[] changes = this.getChanges(e, false);
        if (changes == null || changes.length == 0) {
            return;
        }
        final ArrayList changesList = new ArrayList();
        Collections.addAll(changesList, changes);
        FileDocumentManager.getInstance().saveAllDocuments();
        ChangeList[] changeLists2 = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        final String title = VcsBundle.message((String)"changes.progress.title.choice.revert.apply.changes", (Object[])new Object[]{this.myReverse ? 0 : 1});
        final String errorPrefix = VcsBundle.message((String)"changes.dialog.message.failed.to.revert.apply.changes", (Object[])new Object[]{this.myReverse ? 0 : 1});
        if (ChangeListManager.getInstance((Project)project).areChangeListsEnabled()) {
            MyChangeListChooser chooser = new MyChangeListChooser(project, VcsBundle.message((String)"revert.changes.changelist.chooser.title", (Object[])new Object[0]));
            if (changeLists2 != null && changeLists2.length > 0) {
                String defaultName = VcsBundle.message((String)"changes.revert.apply.change.list.name", (Object[])new Object[]{this.myReverse ? 0 : 1, changeLists2[0].getName()});
                chooser.setSuggestedName(defaultName);
            }
            if (!chooser.showAndGet()) {
                return;
            }
            targetList = chooser.getSelectedList();
        } else {
            targetList = null;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    List<Change> preprocessed = ChangesPreprocess.preprocessChangesRemoveDeletedForDuplicateMoved(changesList);
                    List<FilePatch> patches = IdeaTextPatchBuilder.buildPatch(project, preprocessed, baseDir.toNioPath(), RevertCommittedStuffAbstractAction.this.myReverse, false);
                    String activityName = RevertCommittedStuffAbstractAction.this.myReverse ? VcsBundle.message((String)"activity.name.rollback", (Object[])new Object[0]) : VcsBundle.message((String)"activity.name.apply.patch", (Object[])new Object[0]);
                    ActivityId activityId = RevertCommittedStuffAbstractAction.this.myReverse ? VcsActivity.Rollback : VcsActivity.ApplyPatch;
                    new PatchApplier(project, baseDir, new ArrayList<FilePatch>(patches), targetList, null, false, null, null, activityName, activityId).execute();
                }
                catch (VcsException ex) {
                    WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)project, (String)(errorPrefix + ex.getMessage()), (String)title), null, (Project)project);
                    indicator.cancel();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/actions/RevertCommittedStuffAbstractAction$1", "run"));
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(this.isEnabled(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (e == null) {
            RevertCommittedStuffAbstractAction.$$$reportNull$$$0(3);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Change[] changes = this.getChanges(e, true);
        return project != null && changes != null && changes.length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/RevertCommittedStuffAbstractAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/RevertCommittedStuffAbstractAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class MyChangeListChooser
    extends ChangeListChooser {
        MyChangeListChooser(@NotNull Project project, @NlsContexts.DialogTitle String title) {
            if (project == null) {
                MyChangeListChooser.$$$reportNull$$$0(0);
            }
            super(project, title);
        }

        @Override
        @NotNull
        protected final String getHelpId() {
            return "reference.dialogs.vcs.undo.commit";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/RevertCommittedStuffAbstractAction$MyChangeListChooser", "<init>"));
        }
    }
}

