/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.de.StyleRules;
import ai.grazie.rules.de.WordSeparation;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.List;
import java.util.Locale;
import org.languagetool.tools.StringTools;

class RecommendedSpelling {
    static final NodePattern embeddedEnglishInGerman = GermanTreePatterns.englishWord.noPos().andOr(NodePattern.N.directlyBefore(CommonPatterns.skipForward(NodePattern.PUNCT, GermanTreePatterns.englishWord.noPos())), NodePattern.N.directlyAfter(CommonPatterns.skipBack(NodePattern.PUNCT, GermanTreePatterns.englishWord.noPos())));
    private static final NodePattern graphWords = NodePattern.N.form("(un)?((fluoreszenz)?angio|.*bi(bli)?o|(bau|geb\u00e4ude|infrarot)?thermo|(bio|human|wirtschafts)?geo|(kampf|tanz)?choreo|(computer|koh\u00e4renz|kernspin|magnetresonanz|positronenemissions|volumen)?tomo|demo|disko|(doppler|duplex|endo|mamma)?sono|echokardio|elasto|elektro(enzephalo|kardio|myo|neuro|thermo)|ethno|(farb|foto|chromo|stereo)?litho|(gaschro|[kc]ine|chro)mato|.*porno|hagio|historio|holo|hydro|ikono|kalli|kardio(toko)?|karto|(knochen|myokard|schilddr\u00fcsen|skelett)?szinti|kosmo|kristallo|(quanten)?krypto|(landes)?topo|lexiko|(lo|mam|fil)mo|medio|metallo|(mikro)?typo|(werk)?mono|(morse)?tele|ortho|ozeano|pa(l\u00e4o|ra)|phlebo|poly(somno)?|psycho|radio|repro|se(ismo|ri)|sozio(demo)?|ste(ga)?no|stiefo|strati|szeno|video|xero|(foto)?zinko)graph(en|ie.*|in(nen)?|isch(e[srmn]?)?)?");
    private static final NodePattern phonWords = NodePattern.N.form("(a(dia)?|(ae|quad)ro|(ang|xy)lo|audi|anti|(bab|pol)y|dikta|echo|(i|ra)dio|(g|ster)eo|homo|kathodo|marimba|mega|merzi|.*mikro|mono|ortho|oto|.*saxo|sousa|vibra)phon.*");
    private static final NodePattern photoWords = NodePattern.N.form("Photo(chemi(e|grafi(e|sch)|sch)|element|effekt|elektr(isch|on|izit\u00e4t)|gramm(etri(e|sch))?|lyse|mechanisch|met(er|ri(e|sch))|(bio|physio)logi(e|sch)|kopie(ren)?|rezeptor|ph(il|ob(ie)?)|psie|periodismus|chrom|trop(isch|ie|ismus)?|satz|sensibilisierung|sph\u00e4re|synthe(se(leistung|rate)?|tisch)|ta(ktisch|xis)|therapie|typie|zelle|zinkografie).*");
    static final NodePattern handvoll = NodePattern.N.inFormSequence(0, "Hand", "voll").andOr(NodePattern.N.withDependent("appos|nmod", NodePattern.N.markAs("Nmod")), NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("obl").withDependent("case").markAs("Nmod")), NodePattern.N.withNeighbor(1, NodePattern.N.withHead("amod", NodePattern.N.markAs("Nmod"))).withNeighbor(2, NodePattern.N.alreadyMarkedAs("Nmod")), NodePattern.N.withNeighbor(1, NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case").markAs("Nmod")))).andOr(NodePattern.or(NodePattern.N.withDependent("det", NodePattern.N.pos("ART:IND.*SIN.*")), NodePattern.N.withDependent("nummod")).andOr(NodePattern.N.withHead(NodePattern.not(NodePattern.N.lemma("geben|haben|strecken"))), NodePattern.markedNodeMatches("Nmod", SemanticRules.animate)), NodePattern.N.withDependent("amod|det", NodePattern.or(NodePattern.N.lemma("wenig|viel|mehrer"), NodePattern.N.form("paar")))).noDependents("det(:poss)?", NodePattern.N.pos("(ART:DEF|PRO:POS).*"));
    static final NodePattern hierzulande = NodePattern.N.inFormSequence(0, "hier", "zu", "Lande");

    RecommendedSpelling() {
    }

    static Rule.PatternRule rule() {
        return new Rule.PatternRule("Style.RECOMMENDED_SPELLING", "Empfohlene Schreibweisen", "Verwenden Sie die vom Duden empfohlene Schreibweise.", "https://www.duden.de/sprachwissen/sprachratgeber/beispiele-zur-neuen-rechtschreibung", () -> NodePattern.or(RecommendedSpelling.separation(), RecommendedSpelling.closedCompoundWords(), RecommendedSpelling.phToF(), RecommendedSpelling.oxydToOxid(), RecommendedSpelling.tToZ()), new Example("<b>Sowas</b> kann doch jedem passieren", "<b>So was</b> kann doch jedem passieren"), new Example("Wilhelm besch\u00e4ftigt sich mit der <b>Radiographie</b>", "Wilhelm besch\u00e4ftigt sich mit der <b>Radiografie</b>"), new Example("Eine nat\u00fcrliche Form der <b>Phototherapie</b> wird bei einer Kur am Toten Meer angewandt", "Eine nat\u00fcrliche Form der <b>Fototherapie</b> wird bei einer Kur am Toten Meer angewandt"));
    }

    private static NodePattern phToF() {
        return NodePattern.or(NodePattern.N.form(".*(ph|f)otogra(ph|f).*").noForm(".*(fotograf|photograph).*"), graphWords, phonWords, photoWords, NodePattern.N.form(".*delfin.*").andNot(NodePattern.N.inFormSequence(2, "(in|ad)", "usum", "Delphini")), NodePattern.N.form(".*(Phantasie.*|Phantast(in(nen)?|en|(erei|ik)(en)?|isch(e[rsmn]?)?)?)"), NodePattern.N.form(".*graph(olog.*|i[kt]).*").andNot(NodePattern.N.inFormSequence(0, "Graphik", "Novels?")).andNot(NodePattern.N.formCaseSensitive("graphit").withHead(NodePattern.or(NodePattern.N.noPos(), GermanTreePatterns.englishWord)))).noLabel("ORGANIZATION").andNot(NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation)).and((node, match) -> {
            String form = node.form();
            String newWord = form.matches("\\p{Lu}+") ? form.replaceFirst("PH", "F") : (form.startsWith("Ph") ? form.replaceFirst("Ph", "F") : form.replaceFirst("ph", "f"));
            List<String> candidates = List.of(newWord, StringTools.uppercaseFirstChar((String)newWord), newWord.toLowerCase(Locale.ROOT));
            for (String variant : candidates) {
                if (!node.tree().treeSupport().isAcceptedBySpellchecker(variant)) continue;
                return match.withCorrector(NodeCorrector.replace(node, newWord)).withMessage("Die Schreibung \u201e" + newWord + "\u201c wird empfohlen");
            }
            return null;
        });
    }

    private static NodePattern oxydToOxid() {
        return NodePattern.N.form(".*oxyd.*").message("Die empfohlene Schreibweise ist mit \u201e-id\u201c").correct(NodeCorrector.regexReplace("(.*)xyd(.*)", "$1xid$2"));
    }

    private static NodePattern tToZ() {
        return NodePattern.or(NodePattern.N.form(".*((sequ|(a|de)m|refer|ess|pot|prud|exist|depend|differ|provid|pr\u00e4fer)en|substan|justi)tiell(e[rnsm]?)?").message("Die empfohlene Schreibweise ist mit \u201e-ziell\u201c").correct(NodeCorrector.regexReplace("(.*)tiell(.*)", "$1ziell$2")), NodePattern.or(NodePattern.or(NodePattern.N.form("(.*essen|existen|(un)?substan|.*differen|.*poten)tial(e[rnsm]?)?").andNot(NodePattern.N.withHead(NodePattern.N.withDependent("punct", GermanTreePatterns.openingQuotation))).andNot(NodePattern.or(NodePattern.N.directlyAfter(NodePattern.N.form("the|a|full|your|high|low")), embeddedEnglishInGerman)), NodePattern.N.form("essentiali(en|smus|stisch(e[rnsm]?)?)")).message("Die empfohlene Schreibweise ist mit \u201e-zial\u201c"), NodePattern.N.form("(Justi|P(\u00f6|oe)niten)tiar(in(innen)?|s|en?|iat(e?s|en?)?)?").message("Die empfohlene Schreibweise ist mit \u201e-ziar\u201c"), NodePattern.N.form("Differentiat(or(s|en)?|ion(en)?|[se])?").message("Die empfohlene Schreibweise ist mit \u201e-ziat\u201c")).correct(NodeCorrector.regexReplace("(.*)tia(.*)", "$1zia$2"))).andNot(NodePattern.N.directlyAfterHead().withHead("flat", GermanTreePatterns.englishWord.noPos()));
    }

    private static NodePattern separation() {
        return NodePattern.or(NodePattern.N.form("sowas").correct(NodeCorrector.replace("so was")), NodePattern.N.form("zuhause").andOr(NodePattern.N.withOnlyDependents(NodePattern.N.withHeadRelation("case").noForm("von|i[nm]").andNot(StyleRules.mergedPreposition)), NodePattern.ROOT.noDependents("amod|det(:poss)?")).andNot(CommonPatterns.capitalized.withHead(NodePattern.N.lemma("nennen|bezeichnen"))).noLabel("MISC").correct(NodeCorrector.replace("zu Hause")), NodePattern.N.form("neubekehrt").correct(NodeCorrector.regexReplace("neu(.*)", "neu $1")), NodePattern.or(NodePattern.N.lemma("hilfe(bring|such)end"), NodePattern.N.lemma("tief((h\u00e4ng|sitz|blick|dring)end|ge(f\u00fchlt|kr\u00e4nkt)|ersch\u00fcttert|betr\u00fcbt|bewegt)"), NodePattern.N.lemma("hoch(kompliziert|ver(zinst|schuldet)|angesehen|spannend|besteuert)"), NodePattern.N.lemma("viel(ge(kauft|braucht|lobt|r\u00fchmt|nannt)|besch\u00e4ftigt|zitiert)"), NodePattern.N.lemma("frischgebacken"), NodePattern.N.lemma("freistehend")).andOr(NodePattern.N.withHeadRelation("a(dv)?mod"), NodePattern.ROOT.withDependent("cop")).and((node, match) -> {
            String form = node.form();
            String prefix = form.startsWith("hilfe") ? "Hilfe" : form.substring(0, form.startsWith("frisch") ? 6 : 4);
            return match.withCorrector(NodeCorrector.replace(node, prefix + " " + node.form().substring(prefix.length())));
        }), NodePattern.N.lemma("nichtrostend").correct(NodeCorrector.regexReplace("nicht(.*)", "nicht $1")), NodePattern.N.inFormSequence(0, "nicht", "-", "rostend(e[mnsr]?)?").reportEverythingTouched().correct(NodeCorrector.replace(NodePointer.neighbor(1), " ")), RecommendedSpelling.rotLackiert(), NodePattern.N.lemma("verlorenge[hb]en|fertigkochen|bekannt(geben|werden|machen)").noHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").noDependents("case").and((node, match) -> {
            String form = node.form();
            String prefix = form.startsWith("verloren") ? form.substring(0, 8) : (form.startsWith("bekannt") ? form.substring(0, 7) : form.substring(0, 6));
            String tail = node.form().substring(prefix.length());
            String replacement = node.hasPos("VER:EIZ.*") ? " zu " + tail.substring(2) : " " + tail;
            return match.withCorrector(NodeCorrector.replace(node, prefix + replacement));
        })).message("Die Getrenntschreibung wird empfohlen");
    }

    private static NodePattern rotLackiert() {
        return NodePattern.N.form("((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern).+t(e[smnr]?)").and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("amod"))).and((node, match) -> {
            for (int i = 1; i <= node.form().length(); ++i) {
                String prefix = node.lowForm().substring(0, i);
                if (!node.tree().treeSupport().tagToken(prefix).hasPos("ADJ:PRD:GRU") || !"((dunkel|hell)?(beige|blau|(kupfer)?(braun|rot)|gelb|grau|gr(\u00fc|ue)n|lila|orange|rosa)|(kohl|tief)?schwarz|wei(\u00df|ss)|golden|silbern)".contains(prefix)) continue;
                String tail = node.lowForm().substring(prefix.length());
                if (!node.tree().treeSupport().tagToken(tail).hasPos("PA2.*VER")) {
                    return null;
                }
                return match.withCorrector(NodeCorrector.replace(node, prefix + " " + tail));
            }
            return null;
        });
    }

    private static NodePattern closedCompoundWords() {
        return NodePattern.or(NodePattern.or(NodePattern.or(NodePattern.N.inFormSequence(1, "mit", "Hilfe"), NodePattern.N.inFormSequence(1, "von", "Seiten")).withDependent("nmod"), NodePattern.or(NodePattern.N.inFormSequence(1, "in", "Frage|Stand"), NodePattern.N.inFormSequence(1, "im", "Stande"), NodePattern.N.inFormSequence(1, "zu", "Rande|Stande|Rate")).withHeadRelation("obl|root").andNot(NodePattern.N.withDependent("flat|appos|n(um)?mod")), NodePattern.N.inFormSequence(1, "zu", "Schulden").withHead(NodePattern.N.lemma("kommen").withHead(NodePattern.N.lemma("lassen"))), NodePattern.N.inFormSequence(1, "zu", "Grunde").andOr(NodePattern.N.withOnlyDependents(NodePattern.N.withHeadRelation("case")), NodePattern.N.withHead(NodePattern.N.withHeadRelation("amod")))).and(NodePattern.N.withNeighbor(-1, WordSeparation.joinWithNextNode())), NodePattern.or(handvoll, NodePattern.N.inFormSequence(0, "so", "dass").withHead(NodePattern.N.markAs("Head")).withNeighbor(1, NodePattern.N.withHead(NodePattern.N.alreadyMarkedAs("Head")))).and(WordSeparation.joinWithNextNode()), hierzulande.and(WordSeparation.joinThreeNodes())).message("Die Zusammenschreibung wird empfohlen");
    }
}

