/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.common.ChangeLemma;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.KnownPhrases;
import ai.grazie.rules.common.PhraseReplacement;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.Commas;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.NegativePhrases;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.SemCompatibility;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.en.TenseAdverbials;
import ai.grazie.rules.en.VerbInflectionNumber;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.TextRange;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Pair;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class StyleRules {
    private static final String OF_CHAIN_MESSAGE = "Chained 'of' phrases might be hard to read";
    static final String LOOKS_LIKE_MESSAGE = "Adding 'it' would make the text less colloquial";
    static final String EXCLAMATION_MARK = "Avoid using exclamatory sentences in formal writing";
    static final String MULTI_EXCLAMATION = "Avoid using multiple exclamation marks";
    static final String MULTI_PUNCTUATION = "Avoid using multiple punctuation marks";
    private static final String INFORMAL_CONTRACTION_MSG = "Use a standard form instead of the colloquial one";
    private static final String INFORMAL_EXPRESSION_MSG = "Avoid using informal expressions";
    private static final String FIRST_PERSON_PRONOUN_MSG = "The use of a first-person pronoun can be considered informal";
    private static final String SECOND_PERSON_PRONOUN_MSG = "The use of a second-person pronoun can be considered informal";
    private static final String INFORMAL_SHORT_FORMS_MSG = "Avoid using short forms in formal style";
    static final String SMILEY_USE_MSG = "Consider removing the emoticon to make your tone more formal";
    static final String EMOJI_USE_MSG = "Consider removing the emoji to make your tone more formal";
    static final String NBSP_PROPER_NAME = "Use a non-breaking space after proper name initials for better legibility";
    static final String NO_NBSP_PROPER_NAME = "Use a non-breaking space only between proper name initials and surname";
    private static final String SIMPLE_WRITING_MSG = "Consider replacing '$_' with a simpler word to make your text clearer and easier to understand";
    private static final String AMPERSAND_MSG = "Consider replacing '&' with 'and'";
    private static final String PLUS_SIGN_MSG = "Consider using 'and' or 'plus' instead of '+'";
    static final NodePattern looksSeemsSounds = NodePattern.N.form("looks|seems|sounds").withDependent("ccomp|advcl|csubj", NodePattern.N.afterHead().markAs("Comp")).andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.not(NodePattern.N.alreadyMarkedAs("Comp"))))).includeIntoReport().and(EnglishTreePatterns.ensureWordBefore("it"));
    static final NodePattern beforeLike = CommonPatterns.firstWord.directlyBefore(NodePattern.N.form("like"));
    static final NodePattern wanna = NodePattern.N.form("wanna");
    static final NodePattern incompleteEgIe = NodePattern.N.formCaseSensitive("[eE]\\.?g|[Ii]\\.?e").andNot(Commas.egIeLastDotSeparated);
    static final NodePattern numOutOfNum = NodePattern.N.inFormSequence(3, "\\d+", "out", "of", "\\d+");
    private static final String AVOID_NEGATION = "Avoid negation";
    private static final String USE_MORE_POSITIVE_WORD = "Use a more positive word?";
    private static final String SORRY_BUT_MESSAGE = "With a 'but' clause, the apology is retracted or negated";
    private static final String USE_LESS_NEGATIVE_WORDING = "Could this be phrased more positively?";
    static final NodePattern luv = NodePattern.N.form("luvs?").correct(NodeCorrector.regexReplace("luv", "love")).message("Avoid using informal expressions");
    static final NodePattern whatcha = NodePattern.N.form("wh?[au]tchy?a|wha['\u2019`\u2018]cha|whaddya").markAs("Whatcha");
    static final NodePattern informalAddressing = WordSet.loadResource((String)"en/words/informal_addressing.txt").formPattern;

    StyleRules() {
    }

    static NodePattern positiveWriting() {
        NodeCorrector.Relative removeNegation = EnglishTreePatterns.removeNegation(NodePointer.marked("Not"));
        NodePattern muchMany = NodePattern.N.form("much|many");
        NodePattern loneMuchMany = muchMany.noDependents(NodePattern.N.beforeHead()).markAs("Quantifier");
        NodePattern negateMuchMany = NodePattern.or(NodePattern.N.form("many").correct(NodeCorrector.replace("few").join(removeNegation)), NodePattern.N.form("much").correct(NodeCorrector.replace("little").join(removeNegation))).includeIntoReport();
        NodePattern negateMuchManyObj = NodePattern.N.withHead(NodePattern.N.withDependent("obj", NodePattern.or(loneMuchMany.andOr(NodePattern.N.withDependent("acl|nmod|obl"), NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("obl"))), NodePattern.N.withDependent("amod", loneMuchMany.noDependents().andNot(NodePattern.N.directlyAfter(NodePattern.N.form("that"))))))).andOr(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.lemma("do|will|be|have"), NodePattern.N.lemma("can").markAs("Can").withHead(NodePattern.N.noDependents("cop|aux|aux:pass", NodePattern.not(NodePattern.N.alreadyMarkedAs("Can"))))).includeIntoReport()), NegativePhrases.singleTokenCannot.markAs("Can").withHead(NodePattern.N.noDependents("cop|aux|aux:pass", NodePattern.not(NodePattern.N.alreadyMarkedAs("Can"))))).includeIntoReport().and(NodePattern.markedNodeMatches("Quantifier", negateMuchMany));
        NodePattern dontForget = NodePattern.N.directlyAfter(NodePattern.N.form("do")).directlyBeforeHead().withHead(NodePattern.N.form("forget").andNot(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl")))).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1), "remember"));
        Map<String, List<String>> adjMap = WordSet.multiValueMap(WordSet.loadLines("en/words/negative_adjectives.txt"));
        NodePattern hopelesslyNegative = NodePattern.N.lemma("tumou?r");
        NodePattern negativeAdjectives = NodePattern.N.form(adjMap.keySet()).and(CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withHead("amod", NodePattern.N.markAs("Noun")), NodePattern.N.withDependent("cop").withOptionalDependent("nsubj", NodePattern.N.markAs("Noun"))))).andNot(NodePattern.N.lemma("cheap").andOr(NodePattern.markedNodeMatches("Noun", NodePattern.N.lemma("laugh|trick|labou?r|force|shot")), NodePattern.N.withDependent("advmod", NodePattern.N.form("computationally")), NodePattern.N.inFormSequence(1, "as", "cheap", "as"))).andNot(CommonPatterns.insideQuotes).andNot(NodePattern.markedNodeMatches("Noun", hopelesslyNegative)).noDependents("advmod", EnglishTreePatterns.negation).and((node, match) -> {
            List replacements = (List)adjMap.get(node.lowForm());
            Node noun = match.findMarkedNode("Noun");
            List correctors = ((StreamEx)StreamEx.of((Collection)replacements).filter(r -> noun == null || !StyleRules.areTooSimilar(r, noun.lowForm()))).map(r -> NodeCorrector.replace(node, r).join(Articles.fixArticle(node, r))).toList();
            if (correctors.isEmpty()) {
                return null;
            }
            return match.withCorrectors(correctors);
        });
        NodePattern notUnlike = NodePattern.N.form("unlike").andOr(NodePattern.or(NodePattern.N.withHeadRelation("case"), NodePattern.ROOT.withDependent("obl", NodePattern.N.afterHead())).correct(NodeCorrector.replace("similar to", "like").join(removeNegation)), NodePattern.N.withDependent("cop").correct(NodeCorrector.replace("similar", "alike").join(removeNegation)));
        NodePattern notMuchMany = muchMany.andOr(NodePattern.N.withHead("amod", NodePattern.N.pos("NNS")), NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?")).and(negateMuchMany);
        NodePattern notOften = CommonPatterns.skipForward(NodePattern.N.form("very"), NodePattern.N.form("often").andOr(NodePattern.N.andOr(NodePattern.N.withDependent("cop"), NodePattern.N.withHeadRelation("amod"), NodePattern.N.withHead("advmod", NodePattern.N.lemma("be"))).correct(NodeCorrector.replaceNodes(NodePointer.neighbor("Not", 1), NodePointer.anchor(), "seldom", "rare").join(removeNegation)), NodePattern.N.markAs("Often").withHeadRelation("advmod").correct(NodeCorrector.replaceNodes(NodePointer.neighbor("Not", 1), NodePointer.anchor(), "seldom", "rarely").join(removeNegation))));
        NodePattern notSame = CommonPatterns.skipForward(NodePattern.N.form("the"), NodePattern.N.form("same").andOr(NodePattern.N.withHead("amod", NodePattern.N.withDependent("acl:relcl")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor("Not", 1), NodePointer.anchor(), "different from the").join(removeNegation)), NodePattern.N.directlyBefore(NodePattern.N.form("as").correct(NodeCorrector.replaceNodes(NodePointer.neighbor("Not", 1), NodePointer.anchor(), "different from").join(removeNegation))), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.neighbor("Not", 1), NodePointer.anchor(), "different").join(removeNegation))));
        NodePattern negatedFirstAux = NodePattern.N.directlyBefore(EnglishTreePatterns.negation).markAs("Aux").withHead("aux", NodePattern.N.pos("VB").noDependents("cop|aux|aux:pass", NodePattern.not(NodePattern.N.alreadyMarkedAs("Aux"))));
        NodePattern withVulgarOrOffensive = NodePattern.N.inSentenceWith(NodePattern.N.lemma(String.join((CharSequence)"|", WordSet.loadLines("dictionary/vulgar_or_offensive.txt"))));
        return NodePattern.or(NodePattern.or(NodePattern.or(EnglishTreePatterns.negation, NegativePhrases.singleTokenCannot).markAs("Not").andOr(NodePattern.or(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("cop|aux|aux:pass")), NegativePhrases.singleTokenCannot.withHeadRelation("cop|aux|aux:pass")).andOr(negateMuchManyObj, dontForget), NodePattern.N.directlyBefore(NodePattern.or(notUnlike, notMuchMany, notOften, notSame))).message(AVOID_NEGATION), NodePattern.N.form("did|does").and(negatedFirstAux).directlyBefore(NodePattern.N.reportRangeTo("Aux")).directlyAfter(NodePattern.N.form("s?he").markAs("Subj2")).withNeighbor(-1, CommonPatterns.afterSkipping(NodePattern.N.form("that"), Semantics.saySynonym.markAs("Say").includeIntoReport().withDependent("nsubj", NodePattern.N.sameWordAs("Subj2")))).withHead(NodePattern.N.noLemma("think|decide|plan|consider|understand|believe|remember|know|realize|feel|miss|dream|fear|enjoy|hope|ensure|agree|disagree|determine|recognize|approve|want|care").markAs("Action").includeIntoReport()).message(USE_LESS_NEGATIVE_WORDING).and((node, match) -> {
            Node say = match.getMarkedNode("Say");
            Node action = match.getMarkedNode("Action");
            return match.withCorrector(ChangeLemma.to("deny").corrector(say).join(NodeCorrector.replaceNodes(say.neighbor(1), node.neighbor(1), "")).join(NodeCorrector.inflect(action, "VB", "VBG")));
        })), NodePattern.or(negativeAdjectives.message("The word '$_' can convey negative associations"), NodePattern.N.form("sorry|apologi[sz]e[sd]?").and(EnglishTreePatterns.clause).and(CommonPatterns.beforeSkipping(CommonPatterns.comma, NodePattern.N.form("but").markAs("But").withHead("cc", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl")))).reportRangeTo("But").and((sorry, m) -> m.withCorrector(NodeCorrector.rawReplace(sorry.endOffset(), m.getMarkedNode("But").endOffset(), ":"))).message(SORRY_BUT_MESSAGE), NodePattern.N.form("do|does").and(negatedFirstAux).directlyBefore(NodePattern.N.directlyBeforeHead()).withHead(NodePattern.ROOT.form("have").markAs("Have").withDependent("obj", NodePattern.N.withDependent("amod", NodePattern.N.form("enough").markAs("Enough"))).and(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj", NodePattern.N.markAs("Subj")))).and(NodePattern.markedNodeMatches("Subj", NodePattern.N.pos("PRP"))).noDependents("mark").noDependents("advmod", NodePattern.N.between("Subj", "Aux"))).message(USE_MORE_POSITIVE_WORD).and((aux, match) -> {
            Node have = match.getMarkedNode("Have");
            return match.withCorrector(NodeCorrector.replaceNodes(aux, aux.neighbor(1), "").join(NodeCorrector.replace(have, aux.hasForm("does") ? "needs" : "need")).join(NodeCorrector.replace(match.getMarkedNode("Enough"), "more")));
        })).andNot(withVulgarOrOffensive));
    }

    static NodePattern veryAbuse() {
        Map<String, List<String>> map = WordSet.multiValueMap(WordSet.loadLines("en/words/very_abuse.txt"));
        Set<String> noToComplementAllowed = Set.of("flexible", "transparent", "outgoing", "prevalent", "widespread", "ubiquitous", "perilous");
        Set<String> noInfComplementAllowed = Set.of("receptive", "amenable");
        Set<String> requiresInfinitiveComplement = Set.of("eager", "willing");
        NodePattern plainNegatedClause = NodePattern.N.withDependent("advmod", EnglishTreePatterns.negation);
        NodePattern veryNegatingHead = NodePattern.or(NodePattern.or(NodePattern.N.lemma("seem|hope"), Semantics.toHaveOpinion, NodePattern.N.withDependent("cop")).and(plainNegatedClause), NodePattern.N.lemma("doubt|unlikely"));
        NodePattern negatedVery = NodePattern.or(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form("not"), NodePattern.N.inFormSequence(1, "not", "a"), NegativePhrases.negativeAdverb)), NodePattern.N.withHead("advmod", NodePattern.or(NodePattern.or(EnglishTreePatterns.clause.markAs("Clause"), NodePattern.N.withHead("amod", NodePattern.N.withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", EnglishTreePatterns.clause.markAs("Clause")))).and(NodePattern.markedNodeMatches("Clause", NodePattern.or(plainNegatedClause, NodePattern.N.withHead("[xc]comp|acl", veryNegatingHead)))), NodePattern.N.withHead("amod", NodePattern.or(NodePattern.N.withDependent("case", NodePattern.N.form("except")), NodePattern.N.withHead("nmod", NodePattern.N.lemma("exception")))), NodePattern.N.withHead("xcomp", NegativePhrases.negativeClause))));
        return NodePattern.N.form("very").directlyBeforeHead().andNot(CommonPatterns.capitalizedMiddle).andNot(CommonPatterns.afterSkipping(CommonPatterns.comma, NodePattern.N.form("very"))).withHead("advmod", NodePattern.N.pos("JJ").markAs("Adj").andNot(NodePattern.N.withDependent("det").withDependent("cop")).andNot(NodePattern.N.withHead("amod", NodePattern.N.noPotentialPos("NN.*"))).andNot(NodePattern.N.form("fast").withHeadRelation("xcomp")).andOptionally(NodePattern.or(NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("to")).markAs("ToObl")), NodePattern.N.withDependent("advcl", EnglishTreePatterns.withToMark.markAs("ToInfinitive"))))).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.quotations).withNeighbor(2, EnglishTreePatterns.quotations)).message("A more specific word could be used instead of 'very $Adj'").and((very, match) -> {
            Node adj = match.getMarkedNode("Adj");
            List suggestions = (List)map.get(adj.lowForm());
            if (suggestions == null) {
                return null;
            }
            boolean withToOblComplement = match.findMarkedNode("ToObl") != null;
            boolean withInfComplement = match.findMarkedNode("ToInfinitive") != null;
            Node noun = adj.hasHeadRelation("amod") ? adj.head() : adj.findSingleDependent("nsubj");
            List correctors = ((StreamEx)((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Collection)suggestions).filter(s -> noun == null || SemCompatibility.forSubject(adj.copyWithForm((String)s), noun) != SemCompatibility.Unlikely)).filter(s -> !withToOblComplement && !withInfComplement || !noToComplementAllowed.contains(s))).filter(s -> !requiresInfinitiveComplement.contains(s) || withInfComplement)).filter(s -> !noInfComplementAllowed.contains(s) || !withInfComplement)).map(s -> NodeCorrector.replaceNodes(very, adj, s).join(Articles.fixArticle(very, s))).toList();
            if (correctors.isEmpty()) {
                return null;
            }
            return match.withCorrectors(correctors);
        }).andNot(negatedVery);
    }

    static NodePattern ofChain() {
        NodePattern longTimeUnit = NodePattern.N.lemma("century|year|decade|month|week|day|hour");
        NodePattern quantity = NodePattern.or(NodePattern.N.form("one|most|some|part"), longTimeUnit, NodePattern.N.pos("CD"), Semantics.possiblyNumberDelegatingGroup, Semantics.numberDelegatingGroup, Semantics.uomPattern.withDependent("nummod", NodePattern.N), NodePattern.N.form("\\d+((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])"), NodePattern.N.lemma("dozen|hundred|thousand|million|billion|(ga)?zillion"), Number.moreLess);
        NodePattern fixedOfPhrase = NodePattern.or(NodePattern.N.inFormSequence(0, "moments?", "of", "mass|inertia"), NodePattern.N.inFormSequence(0, "word", "of", "mouth"), NodePattern.N.inFormSequence(0, "lines", "of", "code"), Semantics.maidOfHonor, NodePattern.N.inFormSequence(0, "works?|pieces?", "of", "art"), NodePattern.N.inFormSequence(0, "points?", "of", "view"), NodePattern.N.form("freedom"));
        NodePattern adjAmbiguity = NodePattern.N.potentialPos("JJ.*|VBG");
        NodePattern suitableCompoundHead = NodePattern.N.noLemma("effect|source|choice|law|elaboration|rest|sum").andNot(EnglishTreePatterns.typeSynonyms).andNot(adjAmbiguity);
        NodePattern suitableCompoundNonHead = NodePattern.N.noForm("life").andNot(adjAmbiguity);
        NodePattern outerNoun = NodePattern.not(quantity).andNot(fixedOfPhrase);
        NodePattern middleNoun = NodePattern.N.withDependent("case", NodePattern.N.form("of").markAs("FirstOf")).andNot(quantity).andNot(fixedOfPhrase).andNot(Semantics.educationalInstitution).and(NodePattern.N.withHead("nmod", outerNoun));
        NodePattern nameOfName = NodePattern.or(CommonPatterns.capitalized, NodePattern.N.withDependent("compound", CommonPatterns.capitalized)).withHead("nmod", NodePattern.or(CommonPatterns.capitalized, NodePattern.N.form("town|city|university")));
        NodePattern innerNoun = NodePattern.N.withHead("nmod", middleNoun).andNot(nameOfName).andNot(NodePattern.N.inFormSequence(1, "of", "interest|scale|conduct")).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("conj|nmod|acl")));
        return NodePattern.N.form("of").withHead("case", innerNoun).andNot(NodePattern.N.directlyAfter(CommonPatterns.comma)).suggestActions(ActionSuggestion.REPHRASE).message(OF_CHAIN_MESSAGE).markAs("Of").andOr(NodePattern.N.withHead(NodePattern.N.pos("NN").and(Semantics.Animacy.inanimate.pattern).and(suitableCompoundNonHead).withOnlyDependents(NodePattern.N.alreadyMarkedAs("Of")).withHead(suitableCompoundHead.noDependents(NodePattern.N.beforeHead().after("FirstOf").noHeadRelation("det"))).andNot(NodePattern.N.withNextSibling(NodePattern.N)).and((inner, match) -> {
            Node middle = Objects.requireNonNull(inner.head());
            return match.withCorrector(NodeCorrector.replaceNodes(match.getMarkedNode("Of"), inner, "").join(Articles.fixArticle(middle, inner.lowForm())).join(NodeCorrector.insertBefore(middle, inner.form() + " ")));
        })).reportRangeTo("FirstOf", ReportingKind.Hover), NodePattern.N.reportRangeTo("FirstOf"));
    }

    static NodePattern replaceNounFixGrammar(List<String> newLemmas) {
        return NodePattern.custom((node, match) -> EnglishTreePatterns.replaceNominalPhrase(node, node, match, PhraseReplacement.MatchStrategy.Lemma, newLemmas));
    }

    static NodePattern replaceFixArticle(List<String> newLemmas) {
        return NodePattern.custom((word, match) -> {
            List correctors = StreamEx.of((Collection)newLemmas).map(r -> NodeCorrector.replace(word, r).join(Articles.fixArticle(word, r))).toList();
            return match.withCorrectors(correctors);
        });
    }

    private static NodePattern replaceAndForceThe(String replacement) {
        NodePattern allowForcingThe = NodePattern.or(Articles.nounWithoutDeterminer, NodePattern.N.withDependent("det", NodePattern.N.form("an?")));
        return NodePattern.custom((node, match) -> {
            Node noun = match.getMarkedNode("Noun");
            Pair<NodeCorrector, TextRange> the = allowForcingThe.matches(noun) ? Articles.forceArticle("the", noun) : null;
            return match.withCorrector(NodeCorrector.replace(node, replacement).join(the != null ? (NodeCorrector)the.getFirst() : null));
        });
    }

    static NodePattern simpleNominals() {
        Map<String, List<PhraseReplacement>> entries = PhraseReplacement.parseLines(WordSet.loadLines("en/words/simple_wording_nominals.txt"));
        Set<String> keys = entries.keySet();
        NodePattern nominalsFromFile = NodePattern.or(NodePattern.N.lemma(keys), NodePattern.N.form(keys)).and((node, match) -> {
            for (PhraseReplacement.MatchStrategy strategy : List.of(PhraseReplacement.MatchStrategy.Form, PhraseReplacement.MatchStrategy.Lemma)) {
                PhraseReplacement phrase = strategy.findRule(node, entries);
                if (phrase == null) continue;
                return EnglishTreePatterns.replaceNominalPhrase(node, match, phrase, strategy);
            }
            return null;
        });
        NodePattern humanRelatedWords = NodePattern.or(NodePattern.N.lemma("gender|identity|masculinity|femininity|society|perception|education|university|school|diploma|faculty|department|(post|under)graduate|profession|career|employment|income|salary"), NodePattern.N.lemma("degree").withDependent("nmod:poss|compound"));
        NodePattern humanRelatedContext = NodePattern.or(NodePattern.N.inPhrase(NodePattern.ROOT.withPhraseStart(NodePattern.N.markAs("SentStart")).withPhraseEnd(NodePattern.N.markAs("SentEnd"))).andOr(NodePattern.N.anyMatchUntil("SentStart", humanRelatedWords), NodePattern.N.anyMatchUntil("SentEnd", humanRelatedWords)), CommonPatterns.skipConjUp(NodePattern.or(NodePattern.N.withDependent("amod|compound", NodePattern.or(Semantics.humanSpecificAgeRelatedAdjectives, Semantics.maritalStatus, NodePattern.N.form("human|indigenous|black|white|(un)?attractive"), NodePattern.N.label("NATIONALITY_OR_GROUP"))), NodePattern.or(NodePattern.N.withHeadRelation("nsubj"), NodePattern.N.withDependent("case", NodePattern.N.form("than"))).withHead(CommonPatterns.possiblySkipUp("obj", NodePattern.or(SemCompatibility.needsHumanSubject, NodePattern.N.lemma("have").withDependent("obj", NodePattern.N.lemma("experience|right|problem")), NodePattern.N.lemma("perform")))), NodePattern.N.withHead("appos", Semantics.Animacy.humanLike.pattern), NodePattern.N.withDependent("acl:relcl", NodePattern.N.withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.or(NodePattern.N.form("whom?"), NodePattern.N.withDependent("nmod:poss", NodePattern.N.form("whose"))))), NodePattern.N.withHead("nsubj:pass", NodePattern.N.pos("VBN").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("as")))))));
        NodePattern malesFemales = NodePattern.or(NodePattern.N.form("females").andOr(NodePattern.N.directlyAfter(NodePattern.N.form("adolescent|teenage")).correct(NodeCorrector.replace("girls")), NodePattern.N.correct(NodeCorrector.replace("women"))), NodePattern.N.form("males").andOr(NodePattern.N.directlyAfter(NodePattern.N.form("adolescent|teenage")).correct(NodeCorrector.replace("boys")), NodePattern.N.correct(NodeCorrector.replace("men")))).and(humanRelatedContext);
        NodePattern withCaseOf = NodePattern.N.withDependent("case", NodePattern.N.form("of"));
        NodePattern withMoreMost = NodePattern.N.withDependent("advmod", NodePattern.N.form("most|more"));
        NodePattern nominalsGeneral = NodePattern.or(NodePattern.N.lemma("capability").andOr(NodePattern.N.pos("NN").withDependent("acl", EnglishTreePatterns.withToMark), CommonPatterns.skipConjUp(NodePattern.N.noDependents("compound|amod").noDependents("case", NodePattern.N.form("within")).withDependent("nmod:poss", Semantics.Animacy.humanLike.pattern))).and(StyleRules.replaceNounFixGrammar(List.of("ability"))), NodePattern.N.lemma("caveat").andOr(NodePattern.or(NodePattern.N.withDependent("amod"), NodePattern.N.withHead(NodePattern.N.withDependent("expl", EnglishTreePatterns.tHere))).and(StyleRules.replaceNounFixGrammar(List.of("issue", "limitation", "concern"))), StyleRules.replaceNounFixGrammar(List.of("warning", "note of caution"))), NodePattern.N.lemma("component").andOr(NodePattern.N.withDependent("amod", NodePattern.N.lemma("key|essential|crucial|necessary|vital|important|critical|main")), NodePattern.N.noDependents("compound|amod", CommonPatterns.capitalizedMiddle).withDependent("nummod")).and(StyleRules.replaceNounFixGrammar(List.of("part"))), NodePattern.N.form("expiration").markAs("Noun").withDependent("nmod", withCaseOf.and(Semantics.timeUnits)).noHeadRelation("obj").and(StyleRules.replaceAndForceThe("end")), NodePattern.N.lemma("indication").withDependent("det|amod").andOr(NodePattern.N.withDependent("acl", NodePattern.N.withDependent("mark", NodePattern.N.form("that"))).andOr(NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.or(NodePattern.N.withDependent("cop"), NodePattern.N.lemma("be")).noDependents("expl")), NodePattern.N.form("indications")), NodePattern.N.withDependent("nmod", withCaseOf.noPotentialPos("VB.*").noDependents("nmod:poss"))).andNot(NodePattern.N.inSentenceWith(NodePattern.N.form("sign"))).and(StyleRules.replaceNounFixGrammar(List.of("sign"))), NodePattern.N.form("magnitude").andOr(NodePattern.N.withDependent("nmod", withCaseOf.noLemma("(earth)?quake")), withCaseOf.withHead("nmod", NodePattern.not(Semantics.orderOfMagnitude))).and(StyleRules.replaceNounFixGrammar(List.of("size", "scale", "importance"))), NodePattern.N.lemma("remuneration").andNot(CommonPatterns.possiblySkipDown("amod", NodePattern.N.withDependent("compound|obl.*", NodePattern.N.form("strata")))).and(StyleRules.replaceNounFixGrammar(List.of("pay", "payment"))), NodePattern.N.form("selection").andOr(NodePattern.N.withHead("obj", NodePattern.N.lemma("make")).correct(NodeCorrector.replace("choice")), NodePattern.N.withDependent("amod", NodePattern.N.lemma("wide|good|large|big|limited|small")).withDependent("nmod", withCaseOf).correct(NodeCorrector.replace("range", "set", "collection"))), NodePattern.or(NodePattern.N.form("evident"), NodePattern.N.form("apparent").andNot(NodePattern.N.inFormSequence(0, "apparent", "magnitude|winds?")).andNot(NodePattern.N.inFormSequence(1, "more", "apparent", "than", "real"))).andOptionally(NodePattern.not(withMoreMost).and(StyleRules.replaceFixArticle(List.of("clear")))).and(StyleRules.replaceFixArticle(List.of("visible", "noticeable"))).andOptionally(NodePattern.N.form("apparent").withHeadRelation("amod").and(StyleRules.replaceFixArticle(List.of("seeming")))), NodePattern.N.lemma("objective").withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").noLabel(".*").andNot(NodePattern.N.inSentenceWith(NodePattern.or(Semantics.opticalDevice, Semantics.opticsRelatedWords, NodePattern.N.lemma("optimi[sz]ation|optimi[sz]e|optimal|algorithm")))).and(StyleRules.replaceNounFixGrammar(List.of("goal", "aim"))), NodePattern.N.form("numerous").withHead("amod", NodePattern.N.pos("NNS").noDependents("amod", NodePattern.N.lemma("several|many|few")).noDependents("det|nmod:poss")).correct(NodeCorrector.replace("many", "a lot of", "lots of")), NodePattern.N.form("insufficient").andOr(EnglishTreePatterns.adjInPredicativePosition, NodePattern.N.withHead("amod", NodePattern.N.withDependent("acl", EnglishTreePatterns.withToMark))).noDependents("advmod").correct(NodeCorrector.replace("not enough")), NodePattern.N.form("feasible").andNot(NodePattern.N.directlyBefore(NodePattern.N.lemma("region|possibility"))).correct(NodeCorrector.replace("possible", "doable", "reasonable", "practical")), NodePattern.N.form("subsequent").andOr(NodePattern.N.withHead("amod", NodePattern.N.pos("NNS").markAs("Noun").withDependent("nummod", NodePattern.N.beforeHead())).correct(NodeCorrector.replace("").join(NodeCorrector.insertAfter(NodePointer.marked("Noun"), " in a row"))), NodePattern.N.correct(NodeCorrector.replace("later", "further")).andNot(CommonPatterns.firstWord).andOptionally(CommonPatterns.skipConjUp(NodePattern.N.withHead("amod", NodePattern.N.pos("NN.*").markAs("Noun"))).and(StyleRules.replaceAndForceThe("following")))), NodePattern.N.form("sufficient").andOr(NodePattern.N.inFormSequence(0, "sufficient", "number|amount", "of").andOr(NodePattern.N.directlyAfter(NodePattern.N.form("a").markAs("PhraseStart")), NodePattern.N.markAs("PhraseStart")).andNot(NodePattern.N.withHead("amod", NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.or(NodePattern.N.pos("VBZ"), NodePattern.N.withDependent("aux", NodePattern.N.pos("VBZ")))))).correct(NodeCorrector.replaceNodes(NodePointer.marked("PhraseStart"), NodePointer.neighbor(2), "enough")), NodePattern.or(EnglishTreePatterns.adjInPredicativePosition.correct(NodeCorrector.replace("enough")), NodePattern.N.withHead("amod", NodePattern.or(NodePattern.N.withDependent("acl", EnglishTreePatterns.withToMark), NodePattern.N.withNextSibling(EnglishTreePatterns.withToMark.withHeadRelation("advcl")), NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.withDependent("expl")))).andOr(NodePattern.N.directlyAfter(NodePattern.N.form("a").markAs("PhraseStart")), NodePattern.N.markAs("PhraseStart")).correct(NodeCorrector.replaceNodes(NodePointer.marked("PhraseStart"), NodePointer.anchor(), "enough"))).andNot(NodePattern.N.withNeighbor(1, NodePattern.N.form("enough")))));
        return NodePattern.or(NodePattern.or(nominalsGeneral, nominalsFromFile.noHeadRelation("compound").andNot(NodePattern.N.withHead(CommonPatterns.capitalized)).andOptionally(NodePattern.not(withMoreMost).form("appreciable|substantial").and(StyleRules.replaceFixArticle(List.of("large")))).andNot(withMoreMost.form("expeditious"))).message(SIMPLE_WRITING_MSG), malesFemales.message("Consider using a simpler word instead of '$_' unless it refers to animals"));
    }

    static NodePattern simpleVerbs() {
        return NodePattern.or(NodePattern.N.lemma("accede").withDependent("obl", NodePattern.N.noLemma("throne").withDependent("case", NodePattern.N.form("to").markAs("To"))).correct(EnglishTreePatterns.changeVerbLemma("agree")).correct(EnglishTreePatterns.changeVerbLemma("accept").join(NodeCorrector.replace(NodePointer.marked("To"), ""))).correct(EnglishTreePatterns.changeVerbLemma("give").join(NodeCorrector.insertBefore(NodePointer.marked("To"), "in "))), NodePattern.N.lemma("accelerate").andOr(NodePattern.N.form("accelerated").withHeadRelation("amod").correct(NodeCorrector.replace("faster")), NodePattern.N.correct(EnglishTreePatterns.changeVerbLemma("speed").join(NodeCorrector.insertAfter(" up")))).noDependents("compound|obl:npmod", NodePattern.N.beforeHead()).andNot(NodePattern.N.form("accelerated").withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.form("hardware").directlyBeforeHead())).andNot(NodePattern.N.inPhrase(NodePattern.N.lemma("speed|velocity"))), NodePattern.N.lemma("accentuate").andOr(EnglishParameters.VARIANT.withValue("GB|AU").correct(EnglishTreePatterns.changeVerbLemma("emphasise")), NodePattern.N.correct(EnglishTreePatterns.changeVerbLemma("emphasize"))).correct(EnglishTreePatterns.changeVerbLemma("highlight")), NodePattern.N.lemma("accompany").noPos("JJ").withDependent("obj", NodePattern.or(NodePattern.N.pos(".+"), NodePattern.N.label(".+")).markAs("Obj").withPhraseStart(NodePattern.N.markAs("ObjStart"))).andOr(NodePattern.or(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", Semantics.Animacy.humanLike.pattern), EnglishTreePatterns.withToMark.withHead("xcomp", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|obj", Semantics.Animacy.humanLike.pattern)), NodePattern.N.withHeadRelation("acl(:relcl)?")).correct(EnglishTreePatterns.changeVerbLemma("go").join(NodeCorrector.insertBefore(NodePointer.marked("ObjStart"), "with "))).correct(EnglishTreePatterns.changeVerbLemma("come").join(NodeCorrector.insertBefore(NodePointer.marked("ObjStart"), "with "))).correct(EnglishTreePatterns.changeVerbLemma("follow")), NodePattern.N.withDependent("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|obl", NodePattern.N.after("Obj")).correct(EnglishTreePatterns.changeVerbLemma("help"))), NodePattern.N.lemma("accomplish").andOr(NodePattern.N.form("accomplished").andOr(NodePattern.N.withHeadRelation("amod"), NodePattern.N.withDependent("cop").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", Semantics.Animacy.humanLike.pattern)).correct(NodeCorrector.replace("successful", "talented", "skillful")), NodePattern.N.andOptionally(NodePattern.or(NodePattern.N.noPos("VB"), CommonPatterns.possiblyConj(EnglishTreePatterns.withToMark), CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?"))).correct(EnglishTreePatterns.changeVerbLemma("achieve"))).andOr(NodePattern.N.withDependent("obj|nsubj:pass", NodePattern.N.form("goal|aim|objective|result")).correct(EnglishTreePatterns.changeVerbLemma("reach")), NodePattern.N.correct(EnglishTreePatterns.changeVerbLemma("do")).correct(EnglishTreePatterns.changeVerbLemma("carry").join(NodeCorrector.insertAfter(" out"))).correct(EnglishTreePatterns.changeVerbLemma("complete")))), NodePattern.N.lemma("accrue").noHeadRelation("amod").noDependents("obj").noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("to|from"))).correct(EnglishTreePatterns.changeVerbLemma("grow")).correct(EnglishTreePatterns.changeVerbLemma("increase")), NodePattern.N.form("adaptat(e|es|ed|ing)").correct(NodeCorrector.regexReplace("adaptat(ed|ing)", "adapt$1")).correct(NodeCorrector.regexReplace("adaptate(s)?\\b", "adapt$1")), NodePattern.N.lemma("aggravate").andOr(NodePattern.N.pos("VBG").withDependent("csubj").withDependent("expl").correct(EnglishTreePatterns.changeVerbLemma("annoy")).correct(EnglishTreePatterns.changeVerbLemma("frustrate")).correct(EnglishTreePatterns.changeVerbLemma("discourage")), NodePattern.N.withDependent("obj", Semantics.Animacy.humanLike.pattern).correct(EnglishTreePatterns.changeVerbLemma("annoy")).correct(EnglishTreePatterns.changeVerbLemma("bother")).correct(EnglishTreePatterns.changeVerbLemma("irritate")), NodePattern.N.withDependent("obj", NodePattern.N.withPhraseEnd(NodePattern.N.markAs("ObjEnd"))).correct(EnglishTreePatterns.changeVerbLemma("worsen")).andOptionally(NodePattern.N.noDependents("advmod", NodePattern.N.form("further")).correct(EnglishTreePatterns.changeVerbLemma("make").join(NodeCorrector.insertAfter(NodePointer.marked("ObjEnd"), " worse"))))), NodePattern.N.lemma("anticipate").noDependents("xcomp", NodePattern.N.pos("VBG")).noDependents("obj", NodePattern.N.lemma("need")).correct(EnglishTreePatterns.changeVerbLemma("expect")).andOptionally(NodePattern.N.form("anticipated").andOr(NodePattern.N.withHeadRelation("amod").noDependents("advmod", NodePattern.N.beforeHead()).correct(NodeCorrector.replace("upcoming")), NodePattern.N.withDependent("cop|aux|aux:pass").correct(NodeCorrector.replace("predicted")))), NodePattern.N.lemma("ascertain").andOptionally(NodePattern.or(NodePattern.N.withDependent("ccomp"), NodePattern.N.withDependent("obj", Questions.misparsedWhCcomp)).correct(EnglishTreePatterns.changeVerbLemma("tell"))).correct(EnglishTreePatterns.changeVerbLemma("figure").join(NodeCorrector.insertAfter(" out"))).correct(EnglishTreePatterns.changeVerbLemma("find").join(NodeCorrector.insertAfter(" out"))), NodePattern.N.lemma("assist").noPos("NN.*").andNot(NodePattern.N.form("assisted").withHeadRelation("amod")).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("typing"))).noDependents("advcl", NodePattern.N.withDependent("mark", NodePattern.N.form("in"))).correct(EnglishTreePatterns.changeVerbLemma("help")).andOptionally(NodePattern.N.withDependent("obj").correct(EnglishTreePatterns.changeVerbLemma("support"))), NodePattern.N.lemma("attain").andOptionally(NodePattern.N.noDependents("obj|nsubj:pass", NodePattern.N.form("power")).correct(EnglishTreePatterns.changeVerbLemma("reach"))).andOptionally(NodePattern.N.noDependents("obj|nsubj:pass", NodePattern.N.lemma("goal|aim|objective")).correct(EnglishTreePatterns.changeVerbLemma("gain"))).correct(EnglishTreePatterns.changeVerbLemma("achieve")), NodePattern.N.lemma("commence").correct(EnglishTreePatterns.changeVerbLemma("begin")).correct(EnglishTreePatterns.changeVerbLemma("start")), NodePattern.N.lemma("depart").andOr(NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("for"))), NodePattern.N.withDependent("obj")).correct(EnglishTreePatterns.changeVerbLemma("leave")), NodePattern.N.lemma("eliminate").withDependent("obj", Semantics.Animacy.inanimate.pattern.directlyAfterHead()).correct(EnglishTreePatterns.changeVerbLemma("remove")).correct(EnglishTreePatterns.changeVerbLemma("avoid")).correct(EnglishTreePatterns.changeVerbLemma("exclude")).correct(EnglishTreePatterns.changeVerbLemma("prevent")), NodePattern.N.lemma("employ").andOr(NodePattern.N.pos("VBN").withDependent("aux:pass").withDependent("obl|advcl", NodePattern.N.pos("VBG").withDependent("case|mark", NodePattern.N.form("in").markAs("In"))).andOr(NodePattern.N.withDependent("nsubj:pass", Semantics.Animacy.humanLike.pattern).correct(NodeCorrector.replace("busy").join(NodeCorrector.replace(NodePointer.marked("In"), ""))).correct(NodeCorrector.replace("").join(NodeCorrector.replace(NodePointer.marked("In"), ""))), NodePattern.N.withDependent("nsubj:pass", Semantics.Animacy.inanimate.pattern).correct(NodeCorrector.replace("busy").join(NodeCorrector.replace(NodePointer.marked("In"), "with"))).correct(EnglishTreePatterns.changeVerbLemma("fill").join(NodeCorrector.replace(NodePointer.marked("In"), "with")))), NodePattern.or(NodePattern.N.withHead("acl(:relcl)?", Semantics.Animacy.inanimate.pattern.noForm("capital").noDependents("obj")), NodePattern.N.withDependent("nsubj:pass|obj", Semantics.Animacy.inanimate.pattern.noDependents("case", NodePattern.N.form("in"))).noDependents("obl", EnglishTreePatterns.byPP)).correct(EnglishTreePatterns.changeVerbLemma("use"))), NodePattern.N.lemma("enumerate").withDependent("obj", NodePattern.N.noLemma("(data)?type|value|set")).correct(EnglishTreePatterns.changeVerbLemma("list")), NodePattern.N.lemma("necessitate").withDependent("obj|xcomp|ccomp").correct(EnglishTreePatterns.changeVerbLemma("require")).andOptionally(EnglishTreePatterns.negated.correct(EnglishTreePatterns.changeVerbLemma("mean"))), NodePattern.N.lemma("obtain").andOr(NodePattern.N.withDependent("obj", NodePattern.N.markAs("Obj")), NodePattern.N.withHead("acl:relcl", NodePattern.N.markAs("Obj")).noDependents("nsubj:pass")).andOptionally(NodePattern.markedNodeMatches("Obj", Semantics.dataSynonyms).correct(EnglishTreePatterns.changeVerbLemma("collect")).correct(EnglishTreePatterns.changeVerbLemma("gather"))).correct(EnglishTreePatterns.changeVerbLemma("get")), NodePattern.N.lemma("solicit").noDependents("obj").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("for").markAs("For"))).correct(EnglishTreePatterns.changeVerbLemma("ask")).andOptionally(NodePattern.N.noDependents("nsubj:pass").correct(EnglishTreePatterns.changeVerbLemma("seek").join(NodeCorrector.replace(NodePointer.marked("For"), "")))), NodePattern.N.lemma("utili[zs]e").correct(EnglishTreePatterns.changeVerbLemma("use"))).message(SIMPLE_WRITING_MSG);
    }

    static NodePattern simpleAdverbs() {
        return NodePattern.or(NodePattern.N.form("sufficiently").markAs("Adv").withHead("advmod", NodePattern.N.pos("JJ").correct(NodeCorrector.insertAfter(" enough").join(NodeCorrector.replace(NodePointer.marked("Adv"), ""))).andOptionally(NodePattern.N.withHeadRelation("amod").correct(NodeCorrector.replace(NodePointer.marked("Adv"), "fairly", "rather")))), NodePattern.N.form("insufficiently").markAs("Adv").withHead("advmod", NodePattern.or(NodePattern.N.onlyPos("VBN").correct(NodeCorrector.replace(NodePointer.marked("Adv"), "poorly")), NodePattern.N.onlyPos("JJ").correct(NodeCorrector.replace(NodePointer.marked("Adv"), "not").join(NodeCorrector.insertAfter(" enough")))))).message(SIMPLE_WRITING_MSG);
    }

    private static String egIeVarietyAwareMessagePart(Node node) {
        String canonical = node.lowForm().startsWith("e") ? "e.g." : "i.e.";
        Setting.Value varObj = Objects.requireNonNull(EnglishParameters.VARIANT.getValueObject(node.tree()));
        return "'" + canonical + "' in " + EnglishParameters.Variant.countryAdj(varObj) + " English";
    }

    static NodePattern egIePunctuation() {
        NodePattern needsComma = Commas.egIeCommaVariant.and(TreeMigration.revise("one of this options might become redundant after tokenization changes", NodePattern.or(Commas.egIeLastDotSeparated.withNeighbor(1, NodePattern.N.markAs("InsertComma")).withNeighbor(2, NodePattern.not(NodePattern.PUNCT)), Commas.egIeOneToken.andNot(NodePattern.N.directlyBefore(NodePattern.PUNCT)).markAs("InsertComma"), incompleteEgIe.andNot(CommonPatterns.beforeSkipping(CommonPatterns.dot, NodePattern.PUNCT).markAs("InsertComma")))));
        NodePattern trailingComma = Commas.egIe.andOr(EnglishParameters.VARIANT.withValue("GB.*").and(CommonPatterns.beforeSkipping(CommonPatterns.dot, PunctuationRules.removeUnmandatedComma)).and(NodePattern.custom((node, match) -> match.withMessage("Don\u2019t put commas after " + StyleRules.egIeVarietyAwareMessagePart(node)))).suggestActions(EnglishParameters.VARIANT.changeTo("US")), needsComma.correct(NodeCorrector.insertAfter(NodePointer.marked("InsertComma"), ",")).and(NodePattern.custom((node, match) -> match.withMessage("Put commas after " + StyleRules.egIeVarietyAwareMessagePart(node)))).suggestActions(EnglishParameters.VARIANT.changeTo("GB")));
        NodePattern missingDots = incompleteEgIe.and((node, match) -> {
            String canonical = node.lowForm().startsWith("e") ? "e.g." : "i.e.";
            Node end = NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.dot).matches(node) ? node.neighbor(1) : node;
            return match.withCorrector(NodeCorrector.replaceNodes(node, end, new String[]{needsComma.match(node, match) != null ? canonical + "," : canonical})).withMessage("The abbreviation '" + canonical + "' is used with dots");
        });
        return NodePattern.or(trailingComma, missingDots);
    }

    static NodePattern colloquialSpeech() {
        return NodePattern.or(StyleRules.informalExpressions(), StyleRules.informalContractions());
    }

    private static NodePattern informalExpressions() {
        NodePattern addressingWords = informalAddressing.andOr(NodePattern.N.withOnlyDependents(NodePattern.or(NodePattern.N.form("you"), NodePattern.PUNCT, NodePattern.N.withHeadRelation("discourse"))), NodePattern.ROOT).noHeadRelation("amod").andOr(CommonPatterns.firstWord.directlyBefore(CommonPatterns.comma), CommonPatterns.lastWord.directlyAfter(NodePattern.PUNCT), NodePattern.N.withHeadRelation("vocative|discourse"), NodePattern.N.withPrevSibling(NodePattern.or(NodePattern.N.withHeadRelation("discourse"), NodePattern.N.pos("UH"))), NodePattern.N.withHead(NodePattern.N.pos("UH")), NodePattern.N.pos("NNS").directlyAfter(NodePattern.N.form("you"))).andNot(CommonPatterns.insideQuotes).message(INFORMAL_EXPRESSION_MSG);
        NodePattern farewells = NodePattern.or(NodePattern.N.inFormSequence(0, "bye", "-", "bye").andOr(CommonPatterns.firstWord, NodePattern.N.directlyAfter(CommonPatterns.comma)).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "good")), NodePattern.or(NodePattern.N.inFormSequence(0, "bye", "-", "bye").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "good")), NodePattern.N.inFormSequence(0, "(catch|see)", "(ya|you)").withOnlyDependents(NodePattern.N.withHeadRelation("obj|advmod|vocative|discourse|punct")).andOr(NodePattern.N.withNeighbor(2, NodePattern.N.form("around|later|again|there|soon")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "goodbye")), NodePattern.N.noDependents("advmod").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "goodbye"))).andNot(CommonPatterns.severalDependents("advmod")), NodePattern.N.inFormSequence(0, "peace", "out").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "goodbye"))).reportEverythingTouched().andOr(CommonPatterns.firstWord, NodePattern.N.directlyAfter(CommonPatterns.comma)), NodePattern.N.form("bye|toodles|cheers|ciao|adios|laters").andOr(CommonPatterns.firstWord, CommonPatterns.lastWord, NodePattern.N.directlyAfter(CommonPatterns.comma)).correct(NodeCorrector.replace("goodbye"))).message(INFORMAL_EXPRESSION_MSG);
        NodePattern greetings = NodePattern.or(NodePattern.N.form("yo").andOr(CommonPatterns.firstWord, CommonPatterns.lastWord).correct(NodeCorrector.replace("")), NodePattern.N.form("heya?|hiya|howdy|hi").andOr(CommonPatterns.firstWord, CommonPatterns.lastWord).correct(NodeCorrector.replace("hello")), CommonPatterns.firstWord.form("morning|evening").directlyBefore(NodePattern.or(CommonPatterns.comma, NodePattern.N.form("!"))).correct(NodeCorrector.insertBefore("good ")), NodePattern.N.inFormSequence(0, "what", EnglishTreePatterns.apostropheS.getFormRegex(), "up").reportEverythingTouched().correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "how are you"))).message(INFORMAL_EXPRESSION_MSG);
        NodePattern likeBetterBest = NodePattern.N.lemma("like").includeIntoReport(ReportingKind.Hover).andOr(NodePattern.N.withDependent("i?obj"), NodePattern.N.withHead("acl:relcl", Questions.whWord)).withDependent("advmod", NodePattern.N.afterHead().andOr(NodePattern.N.form("better").correct(NodeCorrector.replace("more")), NodePattern.N.form("best").correct(NodeCorrector.replace("most"))).message("'To like $_' might sound informal; consider using another adverb"));
        return NodePattern.or(addressingWords, farewells, greetings, likeBetterBest, luv);
    }

    private static NodePattern informalContractions() {
        NodePattern wannaNoSubject = NodePattern.or(CommonPatterns.withQuestionMark.andOr(NodePattern.or(NodePattern.N.pos("NN"), NodePattern.N.withDependent("obj", NodePattern.N.pos("NN"))).correct(NodeCorrector.replace(NodePointer.marked("Wanna"), "do you want a")).andOptionally(NodePattern.N.potentialPos("VB").noDependents(NodePattern.N.beforeHead().andNot(NodePattern.N.alreadyMarkedAs("Wanna"))).correct(NodeCorrector.replace(NodePointer.marked("Wanna"), "do you want to"))), CommonPatterns.possiblySkipDown("xcomp", NodePattern.N.withDependent("obj", NodePattern.N.directlyAfterHead())).correct(NodeCorrector.replace(NodePointer.marked("Wanna"), "do you want to"))), NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Wanna"), "I want to")));
        return NodePattern.not(CommonPatterns.capitalizedMiddle).andOr(NodePattern.N.formCaseSensitive("u").withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").andNot(NodePattern.N.withHead(CommonPatterns.possiblySkipDown("cop", NodePattern.N.pos("VBZ")))).and(CommonPatterns.highlightPlusOneChar).correct(NodeCorrector.replace("you")), NodePattern.N.form("cuppa").andOr(NodePattern.N.withHead("compound", NodePattern.N.withHeadRelation("obj").pos("NN")).correct(NodeCorrector.replace("cup of")), NodePattern.N.correct(NodeCorrector.replace("cup of tea"))), wanna.markAs("Wanna").andOr(NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").andOr(NodePattern.N.withHead("discourse|amod|aux|dep|advmod|det", NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").and(wannaNoSubject)), NodePattern.ROOT.and(wannaNoSubject)), NodePattern.N.directlyAfter(NodePattern.N.pos("VB").and((n, match) -> match.withCorrector(NodeCorrector.replace(n.neighbor(1), "").join(NodeCorrector.regexReplace(n, "(.+)", "want to $1"))))), NodePattern.N.withDependent("obj", NodePattern.N.afterHead().andOptionally(NodePattern.N.potentialPos("VB").noDependents(NodePattern.N.beforeHead()).correct(NodeCorrector.replace(NodePointer.marked("Wanna"), "want to"))).andOr(NodePattern.N.pos("NNP?").noDependents("nmod(:poss)?|det|nummod|acl(:relcl)?|compound|amod|case").correct(NodeCorrector.replace(NodePointer.marked("Wanna"), "want a")), NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Wanna"), "want")))), CommonPatterns.skipUp("aux", NodePattern.N.withDependent("nsubj", NodePattern.N.pos("NNP?|PRP_S3S.*"))).andOr(NodePattern.N.withDependent("xcomp", EnglishTreePatterns.withToMark).correct(NodeCorrector.replace("wants")), NodePattern.N.correct(NodeCorrector.replace("wants to"))), NodePattern.N.noDependents("obj", NodePattern.N.afterHead()).andOr(NodePattern.N.withDependent("xcomp", EnglishTreePatterns.withToMark).correct(NodeCorrector.replace("want")), NodePattern.N.correct(NodeCorrector.replace("want to")).andOptionally(NodePattern.N.withDependent("xcomp", NodePattern.N.pos("NNP?").noDependents().noForm("know")).correct(NodeCorrector.replace(NodePointer.marked("Wanna"), "want a"))))), NodePattern.N.form("dunno").markAs("Dunno").andNot(CommonPatterns.capitalized.label(".*")).andOr(NodePattern.or(CommonPatterns.firstWord, CommonPatterns.skipUp(".*", NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.before("Dunno")))).correct(NodeCorrector.replace("I don\u2019t know")), NodePattern.N.correct(NodeCorrector.replace("don\u2019t know"))), NodePattern.N.form("betcha").andOr(NodePattern.not(NodePattern.N.markAs("Betcha").withHead(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.before("Betcha")))).correct(NodeCorrector.replace("I bet you")), NodePattern.N.correct(NodeCorrector.replace("bet you")), NodePattern.N.directlyAfter(NodePattern.N.form("you")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "yes"))), whatcha.andOr(NodePattern.N.directlyBefore(NodePattern.N.form("been").andOr(CommonPatterns.skipUp("cop", CommonPatterns.withQuestionMark).correct(NodeCorrector.replace(NodePointer.marked("Whatcha"), "what have you")), NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Whatcha"), "what you have")))), NodePattern.N.withHead("nsubj|obj|discourse", NodePattern.or(NodePattern.N.pos("VBG").andOr(CommonPatterns.withQuestionMark.correct(NodeCorrector.replace(NodePointer.marked("Whatcha"), "what are you")), NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Whatcha"), "what you are"))), NodePattern.N.pos("VBP?").andOr(CommonPatterns.withQuestionMark.correct(NodeCorrector.replace(NodePointer.marked("Whatcha"), "what do you")), NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Whatcha"), "what you")))))), WordSet.replaceByForm("en/words/informal_contractions.txt"), NodePattern.N.form("(do|did|are|wo)n['\u2019`\u2018]tcha").correct(NodeCorrector.regexReplace("(.+n['\u2019`\u2018]t)cha", "$1 you")), NodePattern.N.form("try['\u2019`\u2018]na").correct(NodeCorrector.replace("trying to")), NodePattern.N.form("['\u2019`\u2018]em").correct(NodeCorrector.replace("them")), NodePattern.N.inFormSequence(0, "['\u2019`\u2018]", "em").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "them")), NodePattern.N.form("['\u2019`\u2018]till?").correct(NodeCorrector.replace("until")), NodePattern.N.form("['\u2019`\u2018]cept").correct(NodeCorrector.replace("except")), NodePattern.N.inFormSequence(0, "['\u2019`\u2018]", "(cos|cause|cuz)").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "because")), NodePattern.N.form("['\u2019`\u2018](cos|cause|cuz)").correct(NodeCorrector.replace("because")), NodePattern.N.form("['\u2019`\u2018]gainst").correct(NodeCorrector.replace("against")), NodePattern.N.form("['\u2019`\u2018]round").correct(NodeCorrector.replace("around")), NodePattern.N.form("['\u2019`\u2018]neath").correct(NodeCorrector.replace("beneath")), NodePattern.N.form("['\u2019`\u2018]tween").correct(NodeCorrector.replace("between")), NodePattern.N.form("['\u2019`\u2018]thout").correct(NodeCorrector.replace("without")), NodePattern.N.form("['\u2019`\u2018]tis").correct(NodeCorrector.replace("it is")), NodePattern.N.form("['\u2019`\u2018]twas").correct(NodeCorrector.replace("it was")), NodePattern.N.form("['\u2019`\u2018]twere").correct(NodeCorrector.replace("it were")), NodePattern.N.form("['\u2019`\u2018]sup").correct(NodeCorrector.replace("how are you")), NodePattern.N.form("cap['\u2019`\u2018]n").correct(NodeCorrector.replace("captain")), NodePattern.N.form("p['\u2019`\u2018]raps").correct(NodeCorrector.replace("perhaps")), NodePattern.N.form("g['\u2019`\u2018]day").correct(NodeCorrector.replace("good day")), NodePattern.N.form("a['\u2019`\u2018]ight").correct(NodeCorrector.replace("all right")), NodePattern.N.form("d['\u2019`\u2018](you|ya|ye)").correct(NodeCorrector.replace("do you")), NodePattern.N.form("an['\u2019`\u2018]").correct(NodeCorrector.replace("and")), NodePattern.N.form(".+in['\u2019`\u2018]").correct(NodeCorrector.regexReplace("(.+)['\u2019`\u2018]", "$1g")), EnglishTreePatterns.onlyApos.directlyAfter(NodePattern.N.form(".+in").noPos().noSpaceAfter()).correct(NodeCorrector.replace("g")).reportEverythingTouched(), NodePattern.N.form("cause").withHeadRelation("mark").correct(NodeCorrector.replace("because")).andNot(NodePattern.N.inFormSequence(1, "root", "cause")), NodePattern.N.form("y['\u2019`\u2018]know").correct(NodeCorrector.replace("you know")), NodePattern.N.inFormSequence(2, "all", "of", "y['\u2019`\u2018]all").correct(NodeCorrector.replace("you")), NodePattern.N.form("y['\u2019`\u2018]all").correct(NodeCorrector.replace("you all", "all of you")), NodePattern.N.inFormSequence(1, ",", "init", "\\?").correct(NodeCorrector.replace("isn\u2019t it")), NodePattern.N.inFormSequence(0, "y['\u2019`\u2018]", "all").noSpaceAfter().andOr(NodePattern.N.inFormSequence(2, "all", "of", "y['\u2019`\u2018]").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "you")), NodePattern.N.correct(NodeCorrector.replace("you ")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "all of you"))), NodePattern.N.inFormSequence(0, "ai", EnglishTreePatterns.contractedNot.getFormRegex()), NodePattern.N.inFormSequence(0, "am", EnglishTreePatterns.contractedNot.getFormRegex()).correct(NodeCorrector.replace(NodePointer.neighbor(1), " not")), NodePattern.N.inFormSequence(0, "gon", "na").andOr(NodePattern.N.withDependent("cop|aux|aux:pass").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "going to")), CommonPatterns.withQuestionMark.andOr(NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "are you going to")), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.pos("WP")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "is going to"))), NodePattern.N.noDependents("cop|aux|aux:pass").directlyAfter(NodePattern.N.form("you|u")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), " are going to")), NodePattern.N.noDependents("cop|aux|aux:pass|nsubj(:pass|:outer)?|csubj(:pass)?").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "I am going to"))), NodePattern.N.form("gonna").markAs("Gonna").andOr(NodePattern.or(NodePattern.N.withDependent("cop|aux|aux:pass"), NodePattern.N.withHead("aux", NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.not(NodePattern.N.alreadyMarkedAs("Gonna"))))).correct(NodeCorrector.replace("going to")), CommonPatterns.skipUp("aux", CommonPatterns.withQuestionMark).andOr(CommonPatterns.skipUp("aux", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.pos("WP"))).correct(NodeCorrector.replace("is going to")), NodePattern.N.correct(NodeCorrector.replace("are you going to"))), NodePattern.N.noDependents("cop|aux|aux:pass").directlyAfter(NodePattern.N.form("you|u")).correct(NodeCorrector.replace("are going to")), NodePattern.N.noDependents("cop|aux|aux:pass|nsubj(:pass|:outer)?|csubj(:pass)?").andNot(NodePattern.N.withHead("aux", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?"))).correct(NodeCorrector.replace("I am going to"))), NodePattern.N.inFormSequence(0, "got", "ta").markAs("Gotta").andOr(NodePattern.N.withDependent("obj").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "got a")), NodePattern.N.withDependent("expl").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "got to")), NodePattern.custom((node, match) -> {
            Node subj = node.findSingleDependent("nsubj(:pass|:outer)?|csubj(:pass)?");
            String replacement = subj == null ? "I have to" : VerbInflectionNumber.from(node, subj).past(false).inflectHave() + " to";
            boolean decontract = EnglishTreePatterns.startsWithApostrophe.matches(node.prevNode());
            Node start = decontract ? node.prevNode() : node;
            return match.withCorrector(NodeCorrector.replaceNodes(start, node.neighbor(1), (decontract ? " " : "") + replacement));
        })), NodePattern.N.form("gotta").markAs("Gotta").andOr(NodePattern.N.withDependent("obj").correct(NodeCorrector.replace("got a")), NodePattern.N.withDependent("expl").correct(NodeCorrector.replace("got to")), NodePattern.custom((node, match) -> {
            Node subj = node.findSingleDependent("nsubj(:pass|:outer)?|csubj(:pass)?");
            if (node.hasHeadRelation("aux")) {
                subj = Objects.requireNonNull(node.head()).findSingleDependent("nsubj(:pass|:outer)?|csubj(:pass)?");
            }
            String replacement = subj == null ? "I have to" : VerbInflectionNumber.from(node, subj).past(false).inflectHave() + " to";
            boolean decontract = EnglishTreePatterns.startsWithApostrophe.matches(node.prevNode());
            Node start = decontract ? node.prevNode() : node;
            return match.withCorrector(NodeCorrector.replaceNodes(start, node, (decontract ? " " : "") + replacement));
        }))).noHeadRelation("goeswith").andNot(CommonPatterns.capitalized.directlyAfter(NodePattern.N.noPos())).andNot(EnglishTreePatterns.onlyApos.withNeighbor(2, EnglishTreePatterns.onlyApos.noSpaceBefore())).message(INFORMAL_CONTRACTION_MSG);
    }

    static NodePattern spellOutAmpersand() {
        NodePattern noProperNounOrDigit = NodePattern.not(CommonPatterns.withNumberLikeForm).andNot(CommonPatterns.capitalized).anyPos().noLabel(".*");
        return NodePattern.N.form("&").markAs("Ampersand").directlyAfter(noProperNounOrDigit.noDependents("cc", NodePattern.N.form("and|&"))).directlyBefore(noProperNounOrDigit).andNot(NodePattern.N.inFormSequence(1, "rock", "&", "roll")).andNot(NodePattern.N.withHead("cc", NodePattern.N.withHeadRelation("conj").and(CommonPatterns.beforeSkipping(CommonPatterns.comma, NodePattern.N.form("and|&"))))).andNot(NodePattern.N.inPhrase(NodePattern.ROOT.withDependent("conj", NodePattern.N.withDependent("cc", NodePattern.not(NodePattern.N.alreadyMarkedAs("Ampersand")).form("and|&"))))).correct(NodeCorrector.replace("and")).message(AMPERSAND_MSG);
    }

    static NodePattern spellOutPlus() {
        NodePattern commonKeys = NodePattern.N.form("ctrl|control|shift|alt|opt(ion)?|meta|command|enter|cmd|win(dows)?|super");
        NodePattern shortcuts = NodePattern.or(NodePattern.N.directlyAfter(commonKeys), NodePattern.N.withHead(commonKeys));
        return NodePattern.N.form("\\+").markAs("Plus").directlyAfter(CommonPatterns.letterWord.pos(".*")).directlyBefore(CommonPatterns.letterWord).correct(NodeCorrector.replace("and", "plus")).andOr(NodePattern.N.withHead("cc", NodePattern.N.anyPos().noPos("NNP").withHead("conj", NodePattern.N.markAs("FirstConjunct")).noDependents("conj").noDependents("cc", NodePattern.N.form("and|or"))), NodePattern.N.withHead("advmod", CommonPatterns.skipUp("nmod(:poss)?|det|nummod|acl(:relcl)?|compound|amod|case", NodePattern.N.withHead("appos", NodePattern.N.markAs("FirstConjunct").directlyBefore("Plus"))))).andNot(NodePattern.markedNodeMatches("FirstConjunct", NodePattern.or(CommonPatterns.severalDependents("conj"), CommonPatterns.skipUp("nmod(:poss)?|det|nummod|acl(:relcl)?|compound|amod|case", NodePattern.N.withDependent("cc", NodePattern.N.form("and|or")))))).andNot(shortcuts).message(PLUS_SIGN_MSG);
    }

    static NodePattern firstPersonSgPronouns() {
        return NodePattern.or(NodePattern.N.formCaseSensitive("I").and(CommonPatterns.skipUp("conj", NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?"))).andNot(NodePattern.N.directlyBefore(CommonPatterns.dot)).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.quotations).directlyBefore(EnglishTreePatterns.quotations)).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.letterWord)).and(CommonPatterns.highlightPlusOneChar), NodePattern.N.form("me").andNot(CommonPatterns.capitalizedMiddle), NodePattern.N.form("mine|my(self)?")).message(FIRST_PERSON_PRONOUN_MSG);
    }

    static NodePattern firstPersonPlurPronouns() {
        return NodePattern.or(NodePattern.N.form("we").withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?"), NodePattern.N.form("our(s|selves)?").andNot(NodePattern.N.inFormSequence(1, "-", "our").noSpaceBefore().trace("-our suffix")), NodePattern.N.form("us").noDependents("det").noPos("NNP")).message(FIRST_PERSON_PRONOUN_MSG);
    }

    static NodePattern secondPersonPronouns() {
        return NodePattern.or(NodePattern.N.form("you(r|rself|rselves)?"), NodePattern.N.form("yours").noDependents("advmod").andNot(CommonPatterns.firstWord)).message(SECOND_PERSON_PRONOUN_MSG);
    }

    static NodePattern informalShortForms() {
        NodePattern properNameOrAbbreviation = NodePattern.N.formCaseSensitive("MIC|AD|Nix");
        return NodePattern.or(WordSet.replaceByForm("en/words/informal_short_forms.txt"), NodePattern.N.lemma("pic").andNot(NodePattern.N.inPhrase(NodePattern.N.lemma("reach|aim|achieve|strive")).trace("pic/peak confusion")).correct(ChangeLemma.to("picture")).correct(ChangeLemma.to("photograph")), NodePattern.N.form("tech").noDependents("amod", NodePattern.N.form("high")).andNot(NodePattern.N.withHead("amod|compound", NodePattern.N.form("documentation"))).correct(NodeCorrector.replace("technology")), NodePattern.N.form("ad").noLabel(".*").and(node -> !KnownPhrases.forLanguage(Language.ENGLISH).isPartOfValidPhrase((Node)node)).correct(NodeCorrector.replace("advertisement")), NodePattern.N.lemma("nix").noLabel(".*").andOr(NodePattern.N.pos("VB.*").withDependent("obj|nsubj:pass").correct(EnglishTreePatterns.changeVerbLemma("reject")).correct(EnglishTreePatterns.changeVerbLemma("dismiss")), NodePattern.N.withHead(Semantics.saySynonym).andOr(NodePattern.N.directlyBefore(NodePattern.N.form("on").withHeadRelation("case")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "no to")), NodePattern.N.correct(NodeCorrector.replace("no"))), NodePattern.N.noPos("VB").correct(NodeCorrector.replace("nothing"))), NodePattern.N.form("props").withHead("obj", NodePattern.N.lemma("give")).correct(NodeCorrector.replace("due respect")), NodePattern.N.form("tha?nx+|thx+").correct(NodeCorrector.replace("thanks", "thank you"))).andNot(properNameOrAbbreviation).andNot(CommonPatterns.insideQuotes).message(INFORMAL_SHORT_FORMS_MSG);
    }

    @NotNull
    private static String getVerbPos(List<String> posTags) {
        return posTags.stream().filter(posTag -> posTag.matches("V.*")).toList().getFirst();
    }

    static NodePattern faultyParallelism() {
        NodePattern hasAnotherPotentialCoordinationClause = NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(NodePattern.N.inPhrase(EnglishTreePatterns.clause.andNot(NodePattern.ROOT))));
        NodePattern clauseNPAmbiguity = NodePattern.N.withDependent("obj", NodePattern.N.pos("NN.*").directlyAfterHead()).withPrevSibling(NodePattern.N.afterHead().withHeadRelation("i?obj|obl.*")).andOr(NodePattern.N.pos("VB[GN]"), NodePattern.N.potentialPos("NN"));
        NodePattern misparsedCompoundConjunction = NodePattern.N.potentialPos("NNS?").withDependent("advmod", NodePattern.N.onlyPos("NN").directlyBeforeHead());
        NodePattern possibleAgreementIssue = CommonPatterns.skipConjUp(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.markAs("Subj"))).andOr(NodePattern.custom((predicate, match) -> {
            Number verbNumber = Number.verbNumber(predicate);
            Number subjectNumber = SubjectVerbAgreement.subjectNumber(match.getMarkedNode("Subj"), predicate);
            if (subjectNumber.conflictsWith(verbNumber) || subjectNumber == Number.ambiguous && verbNumber == Number.plural) {
                return match;
            }
            return null;
        }), NodePattern.N.pos("VBP").and(NodePattern.markedNodeMatches("Subj", NodePattern.N.form("he|she|it"))), NodePattern.N.pos("VBZ").and(NodePattern.markedNodeMatches("Subj", NodePattern.N.lemmaCaseSensitive("I|you|we|they"))));
        NodePattern baseFormUnlikely = NodePattern.or(NodePattern.N.form("found"), possibleAgreementIssue);
        return NodePattern.ROOT.pos("V.*").noDependents("cop|aux|aux:pass|xcomp").andNot(Semantics.directSpeech.withDependent("ccomp")).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.not(SubjectVerbAgreement.hasClauseCompoundAmbiguity)).noDependents("obl.*", Semantics.timePoints).and(CommonPatterns.possiblySkipDown("advmod", NodePattern.N.withDependent("conj", NodePattern.N.onlyPos("V.*").noForm("have|has|willing|seems?").markAs("CONJ").afterHead().withDependent("cc", NodePattern.N.form("and|or|but").markAs("CC").beforeHead()).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl").noDependents("obj", NodePattern.N.pos("WP").withDependent("acl:relcl")).noDependents("obl", TenseAdverbials.inYear).noDependents("aux|cop|aux:pass|mark|nmod(:poss)?|det|nummod|acl(:relcl)?|compound|amod|case").noDependents("advmod", NodePattern.or(Semantics.timePoints, NodePattern.N.form("still"))).noDependents("advmod", CommonPatterns.capitalizedMiddle.form(".+ly")).andNot(NodePattern.N.pos("VBG").andOr(NodePattern.N.withHead(NodePattern.N.withDependent("csubj", NodePattern.N.pos("VBG"))), NodePattern.N.withPrevSibling(NodePattern.N.afterHead().andOr(NodePattern.N.withHeadRelation("i?obj|obl.*"), NodePattern.N.pos("VBG"))))).andNot(clauseNPAmbiguity).andNot(misparsedCompoundConjunction).andNot(CommonPatterns.capitalizedMiddle).andNot(EnglishTreePatterns.imperativePossible).andNot(hasAnotherPotentialCoordinationClause).andNot(NodePattern.N.withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", CommonPatterns.possiblySkipDown("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|nmod:npmod", NodePattern.or(NodePattern.N.form("(my|your|him|her|it)self|(our|your|them)selves"), NodePattern.N.form("own").withDependent("nmod:poss")))))))).andNot(NodePattern.N.potentialPos("NN.*").withPhraseStart(CommonPatterns.skipForward(NodePattern.PUNCT, EnglishTreePatterns.possiblyImperativeVB))).andNot(NodePattern.markedNodeMatches("CONJ", NodePattern.N.pos("VBD")).potentialPos("VBD").noDependents("cop|aux|aux:pass")).andNot(NodePattern.markedNodeMatches("CONJ", NodePattern.N.pos("VBN")).potentialPos("VBN").noDependents("cop|aux|aux:pass")).and((node, match) -> {
            Node conj = match.getMarkedNode("CONJ");
            if (CommonPatterns.haveSamePos(node, conj) || CommonPatterns.haveSameLemma(node, conj)) {
                return null;
            }
            List<String> rootPos = node.posReadings();
            List<String> conjPos = conj.posReadings();
            if (rootPos.contains("VB") && rootPos.contains("VBD")) {
                if (baseFormUnlikely.matches(node)) {
                    return match.withCorrector(NodeCorrector.inflect(conj, StyleRules.getVerbPos(conjPos), "VBD"));
                }
                if (possibleAgreementIssue.matches(conj)) {
                    return match.withCorrectors(List.of(NodeCorrector.inflect(conj, StyleRules.getVerbPos(conjPos), "VBD"), NodeCorrector.inflect(conj, StyleRules.getVerbPos(conjPos), "VB")));
                }
                return null;
            }
            if (possibleAgreementIssue.matches(node)) {
                return null;
            }
            return match.withCorrector(NodeCorrector.inflect(conj, StyleRules.getVerbPos(conjPos), StyleRules.getVerbPos(rootPos)));
        }).message("Verbs joined by '$CC' should have the same form");
    }

    private static boolean areTooSimilar(String word1, String word2) {
        return Strings.commonPrefix((CharSequence)word1, (CharSequence)word2).length() > Math.max(5, word1.length() * 2 / 3);
    }
}

