/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.actions.CloseSessionAction;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002$%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\u000e0\r2\u0006\u0010\b\u001a\u00020\tH\u0002J@\u0010\u0011\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\u000e0\u00122\u001e\u0010\u0013\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\u000e0\rH\u0002J=\u0010\u0014\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\u000e0\r2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019JP\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001b0\r\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\r2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\r2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001c\u0012\u0004\u0012\u00020\u000b0 H\u0002J(\u0010!\u001a\u00020\"2\u001e\u0010#\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\r0\u000e0\rH\u0002\u00a8\u0006&"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider;", "Lcom/intellij/ide/DeleteProvider;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "deleteElement", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "canDeleteElement", "", "getPreprocessedSelection", "", "Lkotlin/Pair;", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "", "removeChildrenIfParentHere", "", "groups", "groupByRemoveHelpers", "selectedItems", "", "project", "Lcom/intellij/openapi/project/Project;", "([Ljava/lang/Object;Lcom/intellij/openapi/project/Project;)Ljava/util/List;", "filterChildren", "C", "P", "children", "parents", "condition", "Lkotlin/Function2;", "getPresentation", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$DialogPresentation;", "elements", "DialogPresentation", "RemoveHelper", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDatabaseServiceViewDeleteElementProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseServiceViewDeleteElementProvider.kt\ncom/intellij/database/console/DatabaseServiceViewDeleteElementProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n12970#2,2:211\n11561#2:213\n11896#2,3:214\n774#3:217\n865#3:218\n2746#3,3:219\n866#3:222\n*S KotlinDebug\n*F\n+ 1 DatabaseServiceViewDeleteElementProvider.kt\ncom/intellij/database/console/DatabaseServiceViewDeleteElementProvider\n*L\n48#1:211,2\n70#1:213\n70#1:214,3\n81#1:217\n81#1:218\n81#1:219,3\n81#1:222\n*E\n"})
public final class DatabaseServiceViewDeleteElementProvider
implements DeleteProvider {
    @NotNull
    public static final DatabaseServiceViewDeleteElementProvider INSTANCE = new DatabaseServiceViewDeleteElementProvider();

    private DatabaseServiceViewDeleteElementProvider() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        Project project2 = project;
        List<Pair<RemoveHelper, List<Object>>> selection = this.getPreprocessedSelection(dataContext);
        if (selection.isEmpty()) {
            return;
        }
        DialogPresentation presentation = this.getPresentation(selection);
        int result2 = Messages.showYesNoDialog((Project)project2, (String)presentation.getText(), (String)presentation.getTitle(), (String)presentation.getYesText(), (String)presentation.getNoText(), (Icon)Messages.getWarningIcon());
        if (result2 != 0) {
            return;
        }
        for (Pair<RemoveHelper, List<Object>> pair : selection) {
            RemoveHelper helper = (RemoveHelper)((Object)pair.getFirst());
            for (Object element : (List)pair.getSecond()) {
                if (!helper.canRemove(project2, element)) continue;
                helper.remove(project2, element);
            }
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return !((Collection)this.getPreprocessedSelection(dataContext)).isEmpty();
    }

    private final List<Pair<RemoveHelper, List<Object>>> getPreprocessedSelection(DataContext dataContext) {
        Object[] selectedItems;
        Project project;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    Project project2 = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
                    if (project2 == null) {
                        return CollectionsKt.emptyList();
                    }
                    project = project2;
                    Object[] objectArray = (Object[])PlatformCoreDataKeys.SELECTED_ITEMS.getData(dataContext);
                    if (objectArray == null) {
                        return CollectionsKt.emptyList();
                    }
                    selectedItems = objectArray;
                    if (selectedItems.length == 0) break block7;
                    Object[] $this$any$iv = selectedItems;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Object element$iv;
                        Object it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!(RemoveHelper.Companion.forNode(it) == null)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
                if (!bl) break block8;
            }
            return CollectionsKt.emptyList();
        }
        List<Pair<RemoveHelper, List<Object>>> groups = this.groupByRemoveHelpers(selectedItems, project);
        return this.removeChildrenIfParentHere(groups);
    }

    private final List<Pair<RemoveHelper, List<Object>>> removeChildrenIfParentHere(List<? extends Pair<? extends RemoveHelper, ? extends List<? extends Object>>> groups) {
        List compact = new ArrayList();
        for (int i = groups.size() - 1; 0 < i; --i) {
            Pair<? extends RemoveHelper, ? extends List<? extends Object>> prev2 = groups.get(i - 1);
            Pair<? extends RemoveHelper, ? extends List<? extends Object>> cur = groups.get(i);
            RemoveHelper helper = (RemoveHelper)((Object)cur.getFirst());
            List filtered = this.filterChildren((List)cur.getSecond(), (List)prev2.getSecond(), (arg_0, arg_1) -> DatabaseServiceViewDeleteElementProvider.removeChildrenIfParentHere$lambda$0(helper, arg_0, arg_1));
            if (!(!((Collection)filtered).isEmpty())) continue;
            ((Collection)compact).add(new Pair((Object)helper, filtered));
        }
        Pair firstGroup = (Pair)CollectionsKt.first(groups);
        if (!((Collection)firstGroup.getSecond()).isEmpty()) {
            ((Collection)compact).add(firstGroup);
        }
        return compact;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<RemoveHelper, List<Object>>> groupByRemoveHelpers(Object[] selectedItems, Project project) {
        void $this$mapTo$iv$iv;
        RemoveHelper[] $this$map$iv = RemoveHelper.values();
        boolean $i$f$map = false;
        RemoveHelper[] removeHelperArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void helper;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List filteredItems = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])selectedItems), arg_0 -> DatabaseServiceViewDeleteElementProvider.groupByRemoveHelpers$lambda$0$0((RemoveHelper)helper, arg_0)), arg_0 -> DatabaseServiceViewDeleteElementProvider.groupByRemoveHelpers$lambda$0$1((RemoveHelper)helper, arg_0)), arg_0 -> DatabaseServiceViewDeleteElementProvider.groupByRemoveHelpers$lambda$0$2((RemoveHelper)helper, project, arg_0)));
            collection.add(new Pair((Object)helper, (Object)filteredItems));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final <C, P> List<C> filterChildren(List<? extends C> children, List<? extends P> parents, Function2<? super C, ? super P, Boolean> condition) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = children;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object element$iv$iv;
            block4: {
                Object child = element$iv$iv = iterator.next();
                boolean bl2 = false;
                Iterable $this$none$iv = parents;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$none$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv;
                        Object parent = element$iv = iterator2.next();
                        boolean bl3 = false;
                        if (!((Boolean)condition.invoke(child, parent)).booleanValue()) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final DialogPresentation getPresentation(List<? extends Pair<? extends RemoveHelper, ? extends List<? extends Object>>> elements) {
        Pair pair = (Pair)CollectionsKt.singleOrNull(elements);
        if (pair == null) {
            return DialogPresentation.Companion.default(elements);
        }
        Pair singleGroup = pair;
        List singleGroupElements = (List)singleGroup.getSecond();
        Object singleElement = CollectionsKt.singleOrNull((List)singleGroupElements);
        RemoveHelper helper = (RemoveHelper)((Object)singleGroup.getFirst());
        Object object = singleElement;
        String title = object == null ? helper.getTitle(singleGroupElements) : helper.getTitle(object);
        Object object2 = singleElement;
        String text = object2 == null ? helper.getText(singleGroupElements) : helper.getText(object2);
        Object object3 = singleElement;
        String yes = object3 == null ? helper.getYesText(singleGroupElements) : helper.getYesText(object3);
        Object object4 = singleElement;
        String no = object4 == null ? helper.getNoText(singleGroupElements) : helper.getNoText(object4);
        return new DialogPresentation(title, text, yes, no);
    }

    private static final boolean removeChildrenIfParentHere$lambda$0(RemoveHelper $helper, Object child, Object parent) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return $helper.checkIsParent(child, parent);
    }

    private static final boolean groupByRemoveHelpers$lambda$0$0(RemoveHelper $helper, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $helper.isSuitableForNode(it);
    }

    private static final Object groupByRemoveHelpers$lambda$0$1(RemoveHelper $helper, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $helper.unwrapNode(it);
    }

    private static final boolean groupByRemoveHelpers$lambda$0$2(RemoveHelper $helper, Project $project, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $helper.canRemove($project, it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B/\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u00032\b\b\u0003\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$DialogPresentation;", "", "title", "", "text", "yesText", "noText", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getTitle", "()Ljava/lang/String;", "getText", "getYesText", "getNoText", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.database.impl"})
    private static final class DialogPresentation {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String title;
        @NotNull
        private final String text;
        @NotNull
        private final String yesText;
        @NotNull
        private final String noText;

        public DialogPresentation(@NlsContexts.DialogTitle @NotNull String title, @NlsActions.ActionText @NotNull String text, @NlsActions.ActionText @NotNull String yesText, @NlsActions.ActionText @NotNull String noText) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)yesText, (String)"yesText");
            Intrinsics.checkNotNullParameter((Object)noText, (String)"noText");
            this.title = title;
            this.text = text;
            this.yesText = yesText;
            this.noText = noText;
        }

        public /* synthetic */ DialogPresentation(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                String string5 = Messages.getYesButton();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getYesButton(...)");
                string3 = string5;
            }
            if ((n & 8) != 0) {
                String string6 = Messages.getNoButton();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getNoButton(...)");
                string4 = string6;
            }
            this(string, string2, string3, string4);
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getYesText() {
            return this.yesText;
        }

        @NotNull
        public final String getNoText() {
            return this.noText;
        }

        @NotNull
        public final String component1() {
            return this.title;
        }

        @NotNull
        public final String component2() {
            return this.text;
        }

        @NotNull
        public final String component3() {
            return this.yesText;
        }

        @NotNull
        public final String component4() {
            return this.noText;
        }

        @NotNull
        public final DialogPresentation copy(@NlsContexts.DialogTitle @NotNull String title, @NlsActions.ActionText @NotNull String text, @NlsActions.ActionText @NotNull String yesText, @NlsActions.ActionText @NotNull String noText) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)yesText, (String)"yesText");
            Intrinsics.checkNotNullParameter((Object)noText, (String)"noText");
            return new DialogPresentation(title, text, yesText, noText);
        }

        public static /* synthetic */ DialogPresentation copy$default(DialogPresentation dialogPresentation, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = dialogPresentation.title;
            }
            if ((n & 2) != 0) {
                string2 = dialogPresentation.text;
            }
            if ((n & 4) != 0) {
                string3 = dialogPresentation.yesText;
            }
            if ((n & 8) != 0) {
                string4 = dialogPresentation.noText;
            }
            return dialogPresentation.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "DialogPresentation(title=" + this.title + ", text=" + this.text + ", yesText=" + this.yesText + ", noText=" + this.noText + ")";
        }

        public int hashCode() {
            int result2 = this.title.hashCode();
            result2 = result2 * 31 + this.text.hashCode();
            result2 = result2 * 31 + this.yesText.hashCode();
            result2 = result2 * 31 + this.noText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DialogPresentation)) {
                return false;
            }
            DialogPresentation dialogPresentation = (DialogPresentation)other;
            if (!Intrinsics.areEqual((Object)this.title, (Object)dialogPresentation.title)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.text, (Object)dialogPresentation.text)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.yesText, (Object)dialogPresentation.yesText)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.noText, (Object)dialogPresentation.noText);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u001e\u0010\u0006\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\b0\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$DialogPresentation$Companion;", "", "<init>", "()V", "default", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$DialogPresentation;", "elements", "", "Lkotlin/Pair;", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "intellij.database.impl"})
        @SourceDebugExtension(value={"SMAP\nDatabaseServiceViewDeleteElementProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseServiceViewDeleteElementProvider.kt\ncom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$DialogPresentation$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1563#2:211\n1634#2,3:212\n*S KotlinDebug\n*F\n+ 1 DatabaseServiceViewDeleteElementProvider.kt\ncom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$DialogPresentation$Companion\n*L\n108#1:211\n108#1:212,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final DialogPresentation default(@NotNull List<? extends Pair<? extends RemoveHelper, ? extends List<? extends Object>>> elements) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Iterable $this$map$iv = elements;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((List)it.getSecond());
                }
                int size = CollectionsKt.flatten((Iterable)((List)destination$iv$iv)).size();
                String string = DatabaseBundle.message((String)"dialog.title.remove", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                Object[] objectArray = new Object[]{size};
                String string2 = DatabaseBundle.message((String)"action.remove.items.text", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                return new DialogPresentation(string, string2, null, null, 12, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH&J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH&J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H'J\u0016\u0010\u0011\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H'J\u0016\u0010\u0012\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H'J\u0016\u0010\u0013\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0014H'J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH&J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH&j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "", "<init>", "(Ljava/lang/String;I)V", "DATA_SOURCE", "SESSION", "CLIENT", "isSuitableForNode", "", "any", "", "unwrapNode", "checkIsParent", "child", "parent", "getTitle", "", "getText", "getYesText", "getNoText", "", "canRemove", "project", "Lcom/intellij/openapi/project/Project;", "remove", "", "Companion", "intellij.database.impl"})
    public static final abstract class RemoveHelper
    extends Enum<RemoveHelper> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ RemoveHelper DATA_SOURCE;
        public static final /* enum */ RemoveHelper SESSION;
        public static final /* enum */ RemoveHelper CLIENT;
        private static final /* synthetic */ RemoveHelper[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private RemoveHelper() {
        }

        public abstract boolean isSuitableForNode(@NotNull Object var1);

        @NotNull
        public abstract Object unwrapNode(@NotNull Object var1);

        public abstract boolean checkIsParent(@NotNull Object var1, @NotNull Object var2);

        @NlsContexts.DialogTitle
        @NotNull
        public String getTitle(@NotNull Object any) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            return this.getTitle(CollectionsKt.listOf((Object)any));
        }

        @NlsActions.ActionText
        @NotNull
        public String getText(@NotNull Object any) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            return this.getText(CollectionsKt.listOf((Object)any));
        }

        @NlsActions.ActionText
        @NotNull
        public String getYesText(@NotNull Object any) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            return this.getYesText(CollectionsKt.listOf((Object)any));
        }

        @NlsActions.ActionText
        @NotNull
        public String getNoText(@NotNull Object any) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            return this.getNoText(CollectionsKt.listOf((Object)any));
        }

        @NlsContexts.DialogTitle
        @NotNull
        public abstract String getTitle(@NotNull List<? extends Object> var1);

        @NlsActions.ActionText
        @NotNull
        public abstract String getText(@NotNull List<? extends Object> var1);

        @NlsActions.ActionText
        @NotNull
        public abstract String getYesText(@NotNull List<? extends Object> var1);

        @NlsActions.ActionText
        @NotNull
        public abstract String getNoText(@NotNull List<? extends Object> var1);

        public abstract boolean canRemove(@NotNull Project var1, @NotNull Object var2);

        public abstract void remove(@NotNull Project var1, @NotNull Object var2);

        public static RemoveHelper[] values() {
            return (RemoveHelper[])$VALUES.clone();
        }

        public static RemoveHelper valueOf(String value) {
            return Enum.valueOf(RemoveHelper.class, value);
        }

        @NotNull
        public static EnumEntries<RemoveHelper> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ RemoveHelper(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            DATA_SOURCE = new DATA_SOURCE("DATA_SOURCE", 0);
            SESSION = new SESSION("SESSION", 1);
            CLIENT = new CLIENT("CLIENT", 2);
            $VALUES = removeHelperArray = new RemoveHelper[]{RemoveHelper.DATA_SOURCE, RemoveHelper.SESSION, RemoveHelper.CLIENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u000e\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0016\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0002\u00a8\u0006\u0017"}, d2={"com/intellij/database/console/DatabaseServiceViewDeleteElementProvider.RemoveHelper.CLIENT", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "isSuitableForNode", "", "any", "", "unwrapNode", "checkIsParent", "child", "parent", "getTitle", "", "", "getText", "getYesText", "getNoText", "canRemove", "project", "Lcom/intellij/openapi/project/Project;", "remove", "", "singleSession", "Lcom/intellij/database/console/session/DatabaseSession;", "intellij.database.impl"})
        static final class CLIENT
        extends RemoveHelper {
            /*
             * WARNING - void declaration
             */
            CLIENT() {
                void var1_1;
            }

            @Override
            public boolean isSuitableForNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return any instanceof DatabaseSessionClientWithFile;
            }

            @Override
            @NotNull
            public Object unwrapNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return (DatabaseSessionClientWithFile)any;
            }

            @Override
            public boolean checkIsParent(@NotNull Object child, @NotNull Object parent) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                return Intrinsics.areEqual((Object)parent, (Object)((DatabaseSessionClientWithFile)child).getSession());
            }

            @Override
            @NotNull
            public String getTitle(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message((String)"dialog.title.detach.from.session", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                DatabaseSession singleSession = this.singleSession(any);
                Object[] objectArray = new Object[3];
                objectArray[0] = any.size();
                Object object = singleSession;
                if (object == null || (object = object.getTitle()) == null) {
                    object = "";
                }
                objectArray[1] = object;
                objectArray[2] = singleSession == null ? 0 : 1;
                String string = DatabaseBundle.message((String)"action.detach.clients.from.choice.sessions.session.text", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getText(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                DatabaseSessionClientWithFile cfr_ignored_0 = (DatabaseSessionClientWithFile)any;
                Object[] objectArray = new Object[]{((DatabaseSessionClientWithFile)any).getTitle(), ((DatabaseSession)((DatabaseSessionClientWithFile)any).getSession()).getTitle()};
                String string = DatabaseBundle.message((String)"action.detach.from.session.text", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getYesText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = Messages.getYesButton();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getYesButton(...)");
                return string;
            }

            @Override
            @NotNull
            public String getNoText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = Messages.getNoButton();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNoButton(...)");
                return string;
            }

            @Override
            public boolean canRemove(@NotNull Project project, @NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return SessionsUtil.canDetach((VisibleDatabaseSessionClient)((VisibleDatabaseSessionClient)((DatabaseSessionClientWithFile)any)));
            }

            @Override
            public void remove(@NotNull Project project, @NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                SessionsUtil.detach((VisibleDatabaseSessionClient)((VisibleDatabaseSessionClient)((DatabaseSessionClientWithFile)any)));
            }

            private final DatabaseSession singleSession(List<? extends Object> any) {
                return (DatabaseSession)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)any), CLIENT::singleSession$lambda$0)));
            }

            private static final DatabaseSession singleSession$lambda$0(Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (DatabaseSession)((DatabaseSessionClientWithFile)it).getSession();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper$Companion;", "", "<init>", "()V", "forNode", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "any", "intellij.database.impl"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final RemoveHelper forNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                for (RemoveHelper value : RemoveHelper.values()) {
                    if (!value.isSuitableForNode(any)) continue;
                    return value;
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u000e\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0016\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0015"}, d2={"com/intellij/database/console/DatabaseServiceViewDeleteElementProvider.RemoveHelper.DATA_SOURCE", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "isSuitableForNode", "", "any", "", "unwrapNode", "checkIsParent", "child", "parent", "getTitle", "", "", "getText", "getYesText", "getNoText", "canRemove", "project", "Lcom/intellij/openapi/project/Project;", "remove", "", "intellij.database.impl"})
        static final class DATA_SOURCE
        extends RemoveHelper {
            /*
             * WARNING - void declaration
             */
            DATA_SOURCE() {
                void var1_1;
            }

            @Override
            public boolean isSuitableForNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return any instanceof DbDataSource;
            }

            @Override
            @NotNull
            public Object unwrapNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return (DbDataSource)any;
            }

            @Override
            public boolean checkIsParent(@NotNull Object child, @NotNull Object parent) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                return false;
            }

            @Override
            @NotNull
            public String getTitle(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message((String)"dialog.title.close.sessions", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                Object[] objectArray = new Object[]{any.size()};
                String string = DatabaseBundle.message((String)"action.close.all.sessions.for.data.sources.text", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getText(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                Object[] objectArray = new Object[]{((DbDataSource)any).getName()};
                String string = DatabaseBundle.message((String)"action.close.all.sessions.for.data.source.text", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getYesText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message((String)"dialog.title.close.sessions", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getNoText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message((String)"action.keep.open.text", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            public boolean canRemove(@NotNull Project project, @NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)((DbDataSource)any)));
                return localDataSource != null && CloseSessionAction.CloseAll.canCloseAll(project, localDataSource);
            }

            @Override
            public void remove(@NotNull Project project, @NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                LocalDataSource localDataSource = DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DasDataSource)((DbDataSource)any)));
                if (localDataSource != null) {
                    CloseSessionAction.CloseAll.closeAll(project, localDataSource);
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u000e\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0015"}, d2={"com/intellij/database/console/DatabaseServiceViewDeleteElementProvider.RemoveHelper.SESSION", "Lcom/intellij/database/console/DatabaseServiceViewDeleteElementProvider$RemoveHelper;", "isSuitableForNode", "", "any", "", "unwrapNode", "checkIsParent", "child", "parent", "getTitle", "", "", "getText", "getYesText", "getNoText", "canRemove", "project", "Lcom/intellij/openapi/project/Project;", "remove", "", "intellij.database.impl"})
        static final class SESSION
        extends RemoveHelper {
            /*
             * WARNING - void declaration
             */
            SESSION() {
                void var1_1;
            }

            @Override
            public boolean isSuitableForNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return any instanceof DatabaseSession;
            }

            @Override
            @NotNull
            public Object unwrapNode(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return (DatabaseSession)any;
            }

            @Override
            public boolean checkIsParent(@NotNull Object child, @NotNull Object parent) {
                Intrinsics.checkNotNullParameter((Object)child, (String)"child");
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                return Intrinsics.areEqual((Object)parent, (Object)((DatabaseSession)child).getTarget());
            }

            @Override
            @NotNull
            public String getTitle(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message((String)"dialog.title.close.sessions", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getTitle(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                String string = DatabaseBundle.message((String)"dialog.title.close.session", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                Object[] objectArray = new Object[]{any.size()};
                String string = DatabaseBundle.message((String)"action.close.sessions.text", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getText(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                Object[] objectArray = new Object[]{((DatabaseSession)any).getTitle()};
                String string = DatabaseBundle.message((String)"action.close.session.text", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getYesText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message((String)"dialog.title.close.sessions", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getYesText(@NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                String string = DatabaseBundle.message((String)"action.Session.Close.text", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            @NotNull
            public String getNoText(@NotNull List<? extends Object> any) {
                Intrinsics.checkNotNullParameter(any, (String)"any");
                String string = DatabaseBundle.message((String)"action.keep.open.text", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            @Override
            public boolean canRemove(@NotNull Project project, @NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                return CloseSessionAction.canClose((DatabaseSession)any);
            }

            @Override
            public void remove(@NotNull Project project, @NotNull Object any) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)any, (String)"any");
                CloseSessionAction.close((DatabaseSession)any);
            }
        }
    }
}

