/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceFacade;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverClasspathManager;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverUtils;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.DataInterchangeCore;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.ParamEditor;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.MutableParametersHolder;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.url.template.UrlEditorModelBase;
import com.intellij.database.dataSource.url.ui.DatabaseAuthPanel;
import com.intellij.database.dataSource.url.ui.DatabaseUIUtils;
import com.intellij.database.dataSource.url.ui.UniformLookSettingsProvider;
import com.intellij.database.dataSource.url.ui.UrlEditorInspector;
import com.intellij.database.dataSource.url.ui.UrlPropertiesPanel;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.Version;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.JBColor;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DynamicJdbcUrlEditor
implements UrlEditorModelBase.StateChangeListener {
    private final JComponent myPanel;
    private DatabaseDriver myDriver;
    private DatabaseDriver myActualDriver;
    private final List<UrlPropertiesPanel> myUrlPropertiesPanels;
    private final EditorTextField myUrlField;
    private final Runnable myChangedCallback;
    private final MyLink myPanelsSwitcher;
    private final DataSourceConfigurable myConfigurable;
    private final MyInspectionConsumer myInspectionsPane;
    private final DatabaseAuthPanel myAuthPanel;
    private final MyLink myDriverLink;
    private final JBLabel myDriverSupportLbl;
    private final ActionLink myMoreOptions;
    private final Map<String, String> myInterchangeProperties;
    private final Set<String> myPersistentProperties;
    private int myCurrentPropPanel;
    private boolean myPersistentPropertyChanged;
    private final JComponent myConstructorPanel;
    private UrlEditorModel myModel;
    private boolean myUpdating;
    private Collection<UrlEditorInspector> myInspectors;
    private final JBLabel myUnderLabel;

    public DynamicJdbcUrlEditor(@NotNull DataSourceConfigurable configurable, @NotNull Runnable changedCallback) {
        if (configurable == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(0);
        }
        if (changedCallback == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(1);
        }
        this.myUrlPropertiesPanels = new ArrayList<UrlPropertiesPanel>();
        this.myInterchangeProperties = new LinkedHashMap<String, String>();
        this.myPersistentProperties = new LinkedHashSet<String>();
        this.myConfigurable = configurable;
        this.myPanel = new JPanel((LayoutManager)new GridLayoutManager(4, 6));
        this.myChangedCallback = changedCallback;
        this.myDriver = null;
        this.myActualDriver = null;
        this.myModel = this.createModelForDriver(null);
        this.myAuthPanel = new DatabaseAuthPanel(this.myConfigurable.getProject(), (DatabaseConnectionConfig)this.myConfigurable.getDataSource(), this.myConfigurable.getSecretService());
        this.myAuthPanel.addListeners(this.delayed(() -> {
            if (this.myUpdating) {
                return;
            }
            this.removeCredentialsFromActiveParser();
            this.myModel.commit((Object)true);
        }), this);
        this.myDriverLink = new MyLink(this::onDriverLinkClicked);
        this.myDriverSupportLbl = new JBLabel(UIUtil.ComponentStyle.SMALL);
        this.myDriverSupportLbl.setForeground(JBUI.CurrentTheme.ContextHelp.FOREGROUND);
        this.myMoreOptions = new ActionLink(DatabaseBundle.message((String)"more.options", (Object[])new Object[0]), this::onMoreOptions);
        this.myMoreOptions.setDropDownLinkIcon();
        this.myPanelsSwitcher = new MyLink(() -> {
            final UrlEditorModel model = this.myModel;
            List items = JBIterable.generate((Object)0, i -> i + 1).take(model.getGroupsCount()).toList();
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<Integer>(this, null, items){

                @NotNull
                @NlsSafe
                public String getTextFor(Integer value) {
                    String string = model.getGroupName(value.intValue());
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                public boolean isSpeedSearchEnabled() {
                    return true;
                }

                @Nullable
                public PopupStep<?> onChosen(Integer selectedValue, boolean finalChoice) {
                    if (selectedValue != null) {
                        model.selectGroup(Math.max(0, selectedValue));
                        model.commit((Object)true);
                    }
                    return FINAL_CHOICE;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$1", "getTextFor"));
                }
            }).showUnderneathOf((Component)this.getPanelSwitcher());
        });
        this.myConstructorPanel = new JPanel();
        this.myConstructorPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)DynamicJdbcUrlEditor.getVSpacing()));
        this.myPanel.add((Component)this.createConstructorPreface(), DatabaseUIUtils.createSimpleConstraints(0, 0, 6));
        this.myPanel.add((Component)this.myConstructorPanel, DatabaseUIUtils.createRowConstraints(1));
        this.myUrlField = new EditorTextField("", this.myConfigurable.getProject(), (FileType)FileTypes.PLAIN_TEXT);
        new ExpandableEditorSupport(this, this.myUrlField){

            protected void initPopupEditor(@NotNull EditorEx editor2, Color background) {
                if (editor2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.initPopupEditor(editor2, background);
                editor2.getSettings().setUseSoftWraps(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$2", "initPopupEditor"));
            }
        };
        this.myUrlField.addSettingsProvider((EditorSettingsProvider)new UniformLookSettingsProvider());
        this.myUrlField.setDisposedWith((Disposable)this.myConfigurable);
        this.myUrlField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (DynamicJdbcUrlEditor.this.myUpdating) {
                    return;
                }
                DynamicJdbcUrlEditor.this.myModel.setUrl(DynamicJdbcUrlEditor.this.myUrlField.getText());
                DynamicJdbcUrlEditor.this.myModel.commit((Object)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$3", "documentChanged"));
            }
        });
        TextComponentEditorAction trimPaster = new TextComponentEditorAction(this, (EditorActionHandler)new BasePasteHandler(this){

            protected Transferable getContentsToPaste(Editor editor2, DataContext dataContext) {
                Transferable contents = super.getContentsToPaste(editor2, dataContext);
                SelectionModel sel = editor2.getSelectionModel();
                if (sel.getSelectionStart() != 0 || sel.getSelectionEnd() != editor2.getDocument().getTextLength()) {
                    return contents;
                }
                if (contents == null || !contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    return contents;
                }
                try {
                    String data = (String)contents.getTransferData(DataFlavor.stringFlavor);
                    return new TextTransferable(data.trim());
                }
                catch (Exception e) {
                    return contents;
                }
            }
        }){};
        ActionUtil.copyFrom((AnAction)trimPaster, (String)"EditorPaste");
        trimPaster.registerCustomShortcutSet((JComponent)this.myUrlField, null);
        trimPaster.registerCustomShortcutSet(this.myUrlField.getComponent(), null);
        this.myInspectionsPane = new MyInspectionConsumer();
        GridLayoutManager urlLayout = new GridLayoutManager(2, 6);
        urlLayout.setVGap(0);
        JPanel urlPanel = new JPanel((LayoutManager)urlLayout);
        JBLabel urlLabel = new JBLabel(DatabaseBundle.message((String)"data.source.editor.url.label", (Object[])new Object[0]));
        urlLabel.setLabelFor((Component)this.myUrlField);
        urlPanel.add((Component)urlLabel, DatabaseUIUtils.createLabelConstraints(0, 0, urlLabel.getPreferredSize().getWidth()));
        urlPanel.add((Component)this.myUrlField, DatabaseUIUtils.createSimpleConstraints(0, 1, 5));
        JBBox underUrl = new JBBox(1);
        this.myUnderLabel = new JBLabel(" " + DatabaseBundle.message((String)"data.source.editor.url.ad", (Object[])new Object[0]), UIUtil.ComponentStyle.MINI);
        underUrl.add((Component)this.myUnderLabel);
        underUrl.add(Box.createVerticalStrut(4));
        this.myUnderLabel.setAlignmentX(0.0f);
        urlPanel.add((Component)underUrl, DatabaseUIUtils.createConstraints(1, 1, 5, 9, 1, -1, false));
        this.myPanel.add((Component)urlPanel, DatabaseUIUtils.createRowConstraints(2));
        GridConstraints c2 = DatabaseUIUtils.createRowConstraints(3);
        JPanel inspections = new JPanel(new BorderLayout());
        inspections.add((Component)this.myInspectionsPane, "East");
        this.myPanel.add((Component)inspections, c2);
        UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        this.myInspectionsPane.updateVisibility(panel2 == null ? null : panel2.getDataInterchange());
    }

    private void onMoreOptions(ActionEvent event) {
        DefaultActionGroup actions = this.myConfigurable.getMoreOptionsAction();
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actions, DataManager.getInstance().getDataContext((Component)this.myPanel), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).showUnderneathOf((Component)this.myMoreOptions);
    }

    @NotNull
    public JComponent createConstructorPreface() {
        JBLabel typeLbl = new JBLabel(DatabaseBundle.message((String)"data.source.editor.connection.type.label", (Object[])new Object[0]));
        JBLabel driverLbl = new JBLabel(DatabaseBundle.message((String)"data.source.editor.driver.label", (Object[])new Object[0]));
        JBBox box = new JBBox(0);
        Font small = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
        Arrays.asList(new JComponent[]{typeLbl, this.myPanelsSwitcher, driverLbl, this.myDriverLink, this.myMoreOptions}).forEach(c2 -> c2.setFont(small));
        box.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)DynamicJdbcUrlEditor.getVSpacing(), (int)0));
        box.add((Component)typeLbl);
        box.add(Box.createHorizontalStrut(5));
        box.add((Component)((Object)this.myPanelsSwitcher));
        box.add(Box.createHorizontalStrut(20));
        box.add((Component)driverLbl);
        box.add(Box.createHorizontalStrut(5));
        box.add((Component)((Object)this.myDriverLink));
        box.add(Box.createHorizontalStrut(5));
        box.add((Component)this.myDriverSupportLbl);
        box.add(Box.createHorizontalGlue());
        box.add((Component)this.myMoreOptions);
        JBBox jBBox = box;
        if (jBBox == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(2);
        }
        return jBBox;
    }

    private JComponent getPanelSwitcher() {
        return this.myPanelsSwitcher;
    }

    @NotNull
    private UrlEditorModel createModelForDriver(@Nullable DatabaseDriver driver) {
        UrlEditorModel model = new UrlEditorModel((Collection)(driver == null ? Collections.emptyList() : driver.getJDBCUrlParsers()));
        model.addListener((UrlEditorModelBase.StateChangeListener)this, (Disposable)this.myConfigurable);
        UrlEditorModel urlEditorModel = model;
        if (urlEditorModel == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(3);
        }
        return urlEditorModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(@Nullable Object arg) {
        if (this.myUpdating || arg == Boolean.FALSE) {
            return;
        }
        this.myUpdating = true;
        try {
            DatabaseAuthProvider.AuthWidget widget;
            if (!this.myUrlField.getText().equals(this.myModel.getUrl())) {
                this.myUrlField.setText(this.myModel.getUrl());
                this.myUrlField.setCaretPosition(0);
            }
            this.setCurrentTag(this.myModel.getActiveGroupId());
            UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
            if (panel2 != null) {
                panel2.getDataInterchange().putProperties(putter -> {
                    for (String param : this.myModel.getParameterNames()) {
                        putter.consume((Object)param, (Object)StringUtil.nullize((String)this.myModel.getParameter(param)));
                    }
                });
            }
            if ((widget = this.myAuthPanel.getAuthWidget()) != null) {
                widget.updateFromUrl((ParametersHolder)this.myModel);
            }
            this.updateUrlFieldState();
            this.myChangedCallback.run();
        }
        finally {
            this.myUpdating = false;
        }
        this.inspect();
    }

    private void inspect() {
        if (this.myDriver == null || this.myInspectionsPane.isUpdating()) {
            return;
        }
        this.myInspectionsPane.clear();
        for (UrlEditorInspector inspector : this.getInspectors()) {
            inspector.runInspection(new UrlEditorInspector.Context(this.myDriver, this.myModel){

                public String getFieldName(@NotNull String param) {
                    UrlPropertiesPanel panel2;
                    if (param == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    ParamEditor field = (panel2 = DynamicJdbcUrlEditor.this.getPropertyPanel(DynamicJdbcUrlEditor.this.myCurrentPropPanel)) == null ? null : panel2.getFields().get(param);
                    String caption = field == null ? null : field.getCaption();
                    return caption == null ? param : StringUtil.trimEnd((String)caption, (String)":");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$6", "getFieldName"));
                }
            }, (UrlEditorInspector.InspectionConsumer)this.myInspectionsPane);
        }
        UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        this.myInspectionsPane.updateVisibility(panel2 == null ? null : panel2.getDataInterchange());
    }

    @NotNull
    private Collection<UrlEditorInspector> getInspectors() {
        if (this.myInspectors == null) {
            this.myInspectors = UrlEditorInspector.inspectorsFor((DatabaseDriver)this.myDriver);
        }
        Collection<UrlEditorInspector> collection = this.myInspectors;
        if (collection == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(4);
        }
        return collection;
    }

    public void onActivity() {
        UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        if (panel2 != null) {
            panel2.getDataInterchange().fireUserDataChanged(DataInterchange.ACTIVITY);
        }
    }

    @NotNull
    public DatabaseAuthPanel getAuthPanel() {
        DatabaseAuthPanel databaseAuthPanel = this.myAuthPanel;
        if (databaseAuthPanel == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(5);
        }
        return databaseAuthPanel;
    }

    public void addMoreActions(DefaultActionGroup actions) {
        final UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        if (panel2 == null) {
            return;
        }
        for (Map.Entry<String, ParamEditor> entry : panel2.getFields().entrySet()) {
            final String param = entry.getKey();
            if (!panel2.isExtra(param)) continue;
            final ParamEditor editor2 = entry.getValue();
            actions.add((AnAction)new ToggleAction(StringUtil.trimEnd((String)editor2.getCaption(), (String)":")){

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                    if (actionUpdateThread == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return actionUpdateThread;
                }

                public boolean isSelected(@NotNull AnActionEvent e) {
                    if (e == null) {
                        7.$$$reportNull$$$0(1);
                    }
                    return editor2.getComponent().isShowing();
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    if (e == null) {
                        7.$$$reportNull$$$0(2);
                    }
                    if (!state) {
                        panel2.getDataInterchange().putProperty(param, null);
                        panel2.resetVisibility();
                    } else {
                        panel2.getDataInterchange().putProperty(param, param);
                        ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.getInstance((Project)DynamicJdbcUrlEditor.this.myConfigurable.getProject()).requestFocus((Component)editor2.getEditorComponent(), false));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1, 2 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$7";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$7";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "isSelected";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "setSelected";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 1, 2 -> new IllegalArgumentException(string);
                    };
                }
            });
        }
    }

    private static int getVSpacing() {
        return 12;
    }

    public boolean isUrlOnly() {
        return this.myModel.isUrlOnly();
    }

    public void requestUrlFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myUrlField, true));
    }

    public String getAnonymizedUrl(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(6);
        }
        return this.myModel.getAnonymizedUrl();
    }

    public String getUrl() {
        return this.myUrlField.getText();
    }

    @NotNull
    public String getIdentifier() {
        return DynamicJdbcUrlEditor.getIdentifier(this.myModel, this.myDriver, (RawConnectionConfig)this.myConfigurable.getDataSource(), this.getUrl());
    }

    @NotNull
    public String generateNameFromParameters() {
        return DynamicJdbcUrlEditor.getNameFromParameters(this.myModel, this.myDriver, this.myActualDriver, (RawConnectionConfig)this.myConfigurable.getDataSource(), this.getUrl());
    }

    @NotNull
    public static String getIdentifier(@NotNull UrlEditorModel model, @Nullable DatabaseDriver driver, @NotNull RawConnectionConfig config, @NotNull String url) {
        JdbcUrlParser parser;
        StatelessJdbcUrlParser sparser;
        if (model == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(7);
        }
        if (config == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(8);
        }
        if (url == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(9);
        }
        if ((sparser = model.getMeaningfulParser()) == null && driver == null) {
            sparser = JdbcUrlParserUtil.select((RawConnectionConfig)config, (String)url);
        }
        JdbcUrlParser jdbcUrlParser = parser = sparser == null ? null : sparser.createStateful();
        if (parser != null) {
            parser.setUrlText(url);
        }
        if (parser == null || !parser.isValid()) {
            return "";
        }
        EnumSet locations = sparser.getPossibleLocations();
        StringBuilder identifier = new StringBuilder();
        if (locations.contains(StatelessJdbcUrlParser.LocationType.REMOTE)) {
            String databaseName = parser.getParameter("database");
            String hostName = parser.getParameter("host");
            if (!StringUtil.isEmpty((String)databaseName)) {
                identifier.append(new File(databaseName).getName());
            }
            if (!StringUtil.isEmpty((String)hostName)) {
                identifier.append("@").append(hostName);
            }
        } else if (locations.contains(StatelessJdbcUrlParser.LocationType.FILE)) {
            String file = StringUtil.notNullize((String)parser.getParameter("file"));
            identifier.append(new File(file).getName());
        } else if (locations.contains(StatelessJdbcUrlParser.LocationType.DIRECTORY)) {
            String path = StringUtil.notNullize((String)parser.getParameter("path"));
            identifier.append(new File(path).getName());
        } else {
            String parameter = parser.getParameter("database");
            if (parameter == null) {
                parameter = parser.getParameter("path");
            }
            if (parameter == null) {
                parameter = parser.getParameter("file");
            }
            identifier.append(StringUtil.notNullize((String)parameter));
        }
        String string = identifier.toString();
        if (string == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String getNameFromParameters(@NotNull UrlEditorModel model, @Nullable DatabaseDriver driver, @Nullable DatabaseDriver actualDriver, @NotNull RawConnectionConfig config, @NotNull String url) {
        if (model == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(11);
        }
        if (config == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(12);
        }
        if (url == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(13);
        }
        String identifier = DynamicJdbcUrlEditor.getIdentifier(model, driver, config, url);
        if (actualDriver == null || actualDriver.isPredefined() && StringUtil.isNotEmpty((String)identifier)) {
            String string = identifier;
            if (string == null) {
                DynamicJdbcUrlEditor.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = actualDriver.getName().replaceAll("Driver", "Data Source") + (String)(StringUtil.isEmpty((String)identifier) ? "" : " - " + identifier);
        if (string == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(16);
        }
        return jComponent;
    }

    public void updateDriverLink() {
        boolean openEnd;
        DatabaseDriverClasspathManager artifactManager = DatabaseDriverClasspathManager.Companion.getInstance(this.myConfigurable.getProject());
        LocalDataSource dataSource = (LocalDataSource)this.myConfigurable.getDataSource();
        DatabaseDriver driver = dataSource.getDatabaseDriver();
        DatabaseArtifactContext context = DatabaseArtifactContext.Companion.getInstance(this.myConfigurable.getProject(), dataSource);
        List cp = new ArrayList();
        if (driver != null) {
            cp = artifactManager.getClasspathElements(driver, context);
        }
        LocalDataSource tempDataSource = this.myConfigurable.getTempDataSource();
        DatabaseDriver tempDriver = tempDataSource.getDatabaseDriver();
        DatabaseArtifactContext tempContext = DatabaseArtifactContext.Companion.getInstance(this.myConfigurable.getProject(), tempDataSource);
        List actualCp = new ArrayList();
        if (tempDriver != null) {
            actualCp = artifactManager.getClasspathElements(tempDriver, tempContext);
        }
        boolean noJars = cp.isEmpty() || this.myActualDriver == null || cp != actualCp;
        String s2 = this.myActualDriver == null ? DatabaseBundle.message((String)"no.driver", (Object[])new Object[0]) : this.myActualDriver.getName();
        this.myDriverLink.setText(DatabaseBundle.message((String)"0.1.choice.0.1.and.custom.jars", (Object[])new Object[]{s2, noJars ? 0 : 1}));
        DatabaseArtifactList artifacts = DatabaseArtifactManager.getArtifacts();
        Couple range = DatabaseDriverUtils.getSupportedRange((DatabaseArtifactList)artifacts, (DatabaseDriver)this.myActualDriver, (Dbms)((LocalDataSource)this.myConfigurable.getDataSource()).getDbms());
        boolean openStart = range.first == Version.ZERO;
        boolean bl = openEnd = range.second == Version.INFINITY;
        if (openStart && openEnd) {
            this.myDriverSupportLbl.setText("");
        } else {
            Version start = (Version)range.first;
            Version end = (Version)range.second;
            this.myDriverSupportLbl.setText(openStart ? DatabaseBundle.message((String)"label.supports.up.to", (Object[])new Object[]{end}) : (openEnd ? DatabaseBundle.message((String)"label.supports.since", (Object[])new Object[]{start}) : DatabaseBundle.message((String)"label.supports.to", (Object[])new Object[]{start, end})));
        }
    }

    private void onDriverLinkClicked() {
        Collection drivers;
        Function driverProvider = (Function)this.myConfigurable.getController().getUserData(DataSourceConfigurable.DRIVER_VARIANTS_PROVIDER);
        Collection collection = drivers = driverProvider == null ? null : (Collection)driverProvider.fun((Object)this.myConfigurable.getTempDataSource());
        if (drivers == null || drivers.size() < 2) {
            this.myConfigurable.getController().navigateTo((Object)this.myDriver, false);
            return;
        }
        DumbAwareAction goToDriver = new DumbAwareAction(DatabaseBundle.message((String)"data.source.editor.go.to.driver", (Object[])new Object[0]), null, AllIcons.General.Settings){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                DynamicJdbcUrlEditor.this.myConfigurable.getController().navigateTo((Object)DynamicJdbcUrlEditor.this.myDriver, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$8", "actionPerformed"));
            }
        };
        List actions = JBIterable.of((Object)goToDriver).append((Object)Separator.getInstance()).append((Iterable)JBIterable.from((Iterable)drivers).filterMap(arg_0 -> ((DatabaseConfigEditor)this.myConfigurable.getController()).getTempTargetOrTarget(arg_0)).map(o -> new DumbAwareAction(o.getName(), null, o.getIcon(0), (DatabaseDriver)o){
            final /* synthetic */ DatabaseDriver val$o;
            {
                this.val$o = databaseDriver;
                super(arg0, arg1, arg2);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                DynamicJdbcUrlEditor.this.myConfigurable.setDriver(this.val$o);
                DynamicJdbcUrlEditor.this.myDriverLink.fireStateChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$9", "actionPerformed"));
            }
        })).toList();
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup("", (ActionGroup)new DefaultActionGroup(actions), DataManager.getInstance().getDataContext((Component)this.myPanel), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null);
        popup2.showUnderneathOf((Component)((Object)this.myDriverLink));
    }

    private void panelPropertiesChanged(@Nullable UrlPropertiesPanel panel2) {
        if (!this.storeProperties(panel2)) {
            return;
        }
        this.myChangedCallback.run();
    }

    public void setExtraProperty(String name, String value) {
        UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        if (panel2 != null) {
            panel2.getDataInterchange().putProperty(name, value);
        }
        DbImplUtilCore.putOrRemove(this.myInterchangeProperties, (Object)name, (Object)value);
        this.myPersistentProperties.add(name);
        this.myConfigurable.getController().clearModifiedCache();
    }

    private boolean storeProperties(@Nullable UrlPropertiesPanel panel2) {
        if (panel2 != this.getPropertyPanel(this.myCurrentPropPanel) || panel2 == null) {
            return false;
        }
        this.myInterchangeProperties.clear();
        for (String prop : JBIterable.from((Iterable)panel2.getDataInterchange().getPersistentProperties()).append(this.myPersistentProperties)) {
            String val = panel2.getDataInterchange().getProperty(prop);
            if (val == null) continue;
            this.myInterchangeProperties.put(prop, val);
        }
        return true;
    }

    public void saveSettings(@NotNull LocalDataSource dataSource, boolean copyCredentials, boolean actual) {
        if (dataSource == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(17);
        }
        if (actual && this.myDriver != null) {
            dataSource.setDatabaseDriver((DatabaseDriver)this.myConfigurable.getController().getTempTargetOrTarget((Object)this.myDriver));
        } else if (this.myDriver != null) {
            dataSource.setDatabaseDriver(this.myDriver);
        }
        dataSource.setAdditionalProperties(this.myInterchangeProperties);
        this.myAuthPanel.save((DatabaseConnectionConfig)dataSource, copyCredentials);
        dataSource.setUrl(this.getAnonymizedUrl(dataSource));
        dataSource.setConfiguredByUrl(this.isUrlOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(@NotNull LocalDataSource dataSource, boolean resetCredentials) {
        if (dataSource == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(18);
        }
        this.myInterchangeProperties.clear();
        for (String name : dataSource.getAdditionalPropertiesNames()) {
            String property = dataSource.getAdditionalProperty(name);
            if (property == null) continue;
            this.myInterchangeProperties.put(name, property);
        }
        this.myPersistentProperties.clear();
        this.myPersistentProperties.addAll(dataSource.getAdditionalPropertiesNames());
        String url = StringUtil.notNullize((String)dataSource.getUrl());
        this.myUpdating = true;
        try {
            this.myAuthPanel.reset((DatabaseConnectionConfig)dataSource, resetCredentials);
        }
        finally {
            this.myUpdating = false;
        }
        this.setDriver(dataSource.getDatabaseDriver(), url, dataSource.isConfiguredByUrl());
        this.updateDriverLink();
    }

    public void setUrl(@NotNull String url, boolean isUrlOnly) {
        if (url == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(19);
        }
        this.myModel.setUrl(url);
        this.myModel.setUrlOnly(isUrlOnly);
        this.myModel.commit((Object)true);
    }

    @Nullable
    private UrlPropertiesPanel getPropertyPanel(int idx) {
        return idx >= 0 && idx < this.myUrlPropertiesPanels.size() ? this.myUrlPropertiesPanels.get(idx) : null;
    }

    private void setCurrentTag(int idx) {
        if (idx == this.myCurrentPropPanel) {
            return;
        }
        UrlPropertiesPanel curPanel = this.getPropertyPanel(idx);
        this.myCurrentPropPanel = idx;
        this.myConstructorPanel.removeAll();
        JComponent head = curPanel == null ? null : curPanel.getHeadComponent();
        JComponent tail = curPanel == null ? null : curPanel.getTailComponent();
        ArrayList<JComponent> panels = new ArrayList<JComponent>(5);
        if (head != null || tail != null) {
            if (head != null) {
                panels.add(head);
            }
            if (this.myAuthPanel.isNeeded()) {
                panels.add(this.myAuthPanel.getComponent());
            }
            if (tail != null) {
                panels.add(tail);
            }
        } else {
            panels.add(this.myAuthPanel.getComponent());
        }
        GridLayoutManager layout = new GridLayoutManager(panels.size(), 6);
        this.myConstructorPanel.setLayout((LayoutManager)layout);
        for (int i = 0; i < panels.size(); ++i) {
            ((JComponent)panels.get(i)).setBorder((Border)JBUI.Borders.emptyTop((int)(i == 0 ? 0 : DynamicJdbcUrlEditor.getVSpacing())));
            this.myConstructorPanel.add((Component)panels.get(i), DatabaseUIUtils.createRowConstraints(i));
        }
        this.myConstructorPanel.repaint();
        this.updatePanelSwitcher();
        this.storeProperties(this.getPropertyPanel(this.myCurrentPropPanel));
        this.myAuthPanel.getComponent().revalidate();
        this.myUrlField.getParent().revalidate();
    }

    @NotNull
    private static TextAttributes getErrorAttributes(boolean insert) {
        return new TextAttributes(null, null, (Color)JBColor.RED, insert ? EffectType.BOXED : EffectType.WAVE_UNDERSCORE, 0);
    }

    private static TextAttributes getCurrentParamAttributes(@NotNull Color fg) {
        if (fg == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(20);
        }
        return new TextAttributes(null, null, fg, EffectType.LINE_UNDERSCORE, 0);
    }

    private void updateUrlFieldState() {
        UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        Editor editor2 = this.myUrlField.getEditor();
        if (panel2 != null) {
            if (editor2 != null) {
                TextAttributes errorAttributes = DynamicJdbcUrlEditor.getErrorAttributes(false);
                TextAttributes insertErrorAttributes = DynamicJdbcUrlEditor.getErrorAttributes(true);
                editor2.getMarkupModel().removeAllHighlighters();
                for (TextRange range : this.myModel.getInvalidRanges()) {
                    int s = range.getStartOffset();
                    int e = range.getEndOffset();
                    editor2.getMarkupModel().addRangeHighlighter(s, e, 100, s == e ? insertErrorAttributes : errorAttributes, HighlighterTargetArea.EXACT_RANGE);
                }
                String activeParam = panel2.getActiveParameter();
                TextAttributes currentParamAttributes = DynamicJdbcUrlEditor.getCurrentParamAttributes(this.myUrlField.getForeground());
                for (String param : this.myModel.getParameterNames()) {
                    TextRange range = this.myModel.getParameterRange(param);
                    if (range == null) continue;
                    editor2.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 101, null, HighlighterTargetArea.EXACT_RANGE);
                    if (!param.equals(activeParam)) continue;
                    editor2.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 101, currentParamAttributes, HighlighterTargetArea.EXACT_RANGE);
                }
            }
        } else if (editor2 != null) {
            editor2.getMarkupModel().removeAllHighlighters();
        }
    }

    private void removeCredentialsFromActiveParser() {
        DatabaseAuthProvider.AuthWidget widget;
        UrlPropertiesPanel panel2 = this.getPropertyPanel(this.myCurrentPropPanel);
        if (panel2 != null && this.myModel.isParserValid() && (widget = this.myAuthPanel.getAuthWidget()) != null) {
            widget.updateUrl((MutableParametersHolder)this.myModel);
        }
    }

    public void setDriver(@Nullable DatabaseDriver driver, @NotNull String url, boolean isUrlOnly) {
        if (url == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(21);
        }
        this.myInspectors = null;
        this.myDriver = driver;
        DatabaseDriver prevDriver = this.myActualDriver;
        DatabaseDriver databaseDriver = this.myActualDriver = this.myDriver == null ? null : (DatabaseDriver)this.myConfigurable.getController().getTempTargetOrTarget((Object)this.myDriver);
        if (prevDriver == null || !((DatabaseDriverImpl)prevDriver).equalConfiguration((DatabaseDriverImpl)this.myActualDriver)) {
            UrlEditorModel newModel = this.createModelForDriver(this.myActualDriver);
            if (this.myModel.getUrl().equals(url)) {
                newModel.assign(this.myModel);
            } else {
                newModel.setUrl(url);
            }
            newModel.setUrlOnly(isUrlOnly);
            this.myModel = newModel;
            newModel.commit((Object)false);
        } else {
            this.myModel.setUrl(url);
            this.myModel.setUrlOnly(isUrlOnly);
            this.myModel.commit((Object)false);
        }
        this.createPanels();
        this.updateDriverLink();
        this.myConfigurable.getController().clearModifiedCache();
        this.myAuthPanel.validateAuthTypes((DatabaseConnectionConfig)this.myConfigurable.getTempDataSource(), null);
        this.stateChanged(true);
    }

    private void createPanels() {
        for (UrlPropertiesPanel panel2 : this.myUrlPropertiesPanels) {
            Disposer.dispose((Disposable)panel2);
        }
        this.myUrlPropertiesPanels.clear();
        Runnable focusCallback = this::updateUrlFieldState;
        for (int i = 0; i < this.myModel.getGroupsCount(); ++i) {
            DataInterchange interchange = new DataInterchange((DataSourceFacade)this.myConfigurable);
            for (Map.Entry<String, String> entry : this.myInterchangeProperties.entrySet()) {
                interchange.putProperty(entry.getKey(), entry.getValue());
            }
            final StatelessParametersHolder group = this.myModel.getGroup(i);
            final UrlPropertiesPanel panel3 = new UrlPropertiesPanel(group, interchange, focusCallback);
            Disposer.register((Disposable)this.myConfigurable, (Disposable)panel3);
            panel3.getDataInterchange().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(@NotNull PropertyChangeEvent evt) {
                    if (evt == null) {
                        10.$$$reportNull$$$0(0);
                    }
                    if (panel3 != DynamicJdbcUrlEditor.this.getPropertyPanel(DynamicJdbcUrlEditor.this.myCurrentPropPanel) || DynamicJdbcUrlEditor.this.myUpdating) {
                        return;
                    }
                    DynamicJdbcUrlEditor.this.myPersistentPropertyChanged = DynamicJdbcUrlEditor.this.myPersistentPropertyChanged | (panel3 == DynamicJdbcUrlEditor.this.getPropertyPanel(DynamicJdbcUrlEditor.this.myCurrentPropPanel) && panel3.getDataInterchange().getPersistentProperties().contains(evt.getPropertyName()) || DynamicJdbcUrlEditor.this.myPersistentProperties.contains(evt.getPropertyName()));
                    if (group.getParameterNames().contains(evt.getPropertyName())) {
                        DynamicJdbcUrlEditor.this.myModel.setParameter(evt.getPropertyName(), StringUtil.notNullize((String)((String)ObjectUtils.tryCast((Object)evt.getNewValue(), String.class))));
                    }
                    DynamicJdbcUrlEditor.this.panelPropertiesChanged(panel3);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$10", "propertyChange"));
                }
            }, (Disposable)panel3);
            panel3.getDataInterchange().addGroupedChangeListener(this.delayed(new DataInterchange.NestedChangeListener(){

                public void nestedChange(int depth) {
                    if (DynamicJdbcUrlEditor.this.myUpdating || depth != 0) {
                        return;
                    }
                    if (DynamicJdbcUrlEditor.this.myPersistentPropertyChanged) {
                        DynamicJdbcUrlEditor.this.panelPropertiesChanged(DynamicJdbcUrlEditor.this.getPropertyPanel(DynamicJdbcUrlEditor.this.myCurrentPropPanel));
                        DynamicJdbcUrlEditor.this.myPersistentPropertyChanged = false;
                    }
                    if (DynamicJdbcUrlEditor.this.myModel.getState() != UrlEditorModelBase.State.VALID) {
                        DynamicJdbcUrlEditor.this.removeCredentialsFromActiveParser();
                    }
                    DynamicJdbcUrlEditor.this.myModel.commit((Object)true);
                }
            }), (Disposable)panel3);
            this.myUrlPropertiesPanels.add(panel3);
        }
        this.updatePanelSwitcher();
        this.myCurrentPropPanel = -1;
    }

    private void updatePanelSwitcher() {
        int id = this.myModel.getActiveGroupId();
        this.myPanelsSwitcher.setText(id >= 0 && id < this.myModel.getGroupsCount() ? this.myModel.getGroupName(id) : "<none>");
        this.myUnderLabel.setVisible(!this.myModel.isUrlOnly());
    }

    @Nullable
    public DatabaseDriver getActualDriver() {
        return this.myActualDriver;
    }

    @Nullable
    public DatabaseDriver getDriver() {
        return this.myDriver;
    }

    @NotNull
    public UrlEditorModel getEditorModel() {
        UrlEditorModel urlEditorModel = this.myModel;
        if (urlEditorModel == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(22);
        }
        return urlEditorModel;
    }

    private Runnable delayed(@NotNull Runnable l) {
        if (l == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(23);
        }
        return () -> {
            if (this.myUpdating) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(l, this.myConfigurable.getController().getModalityState());
        };
    }

    private DataInterchange.NestedChangeListener delayed(final @NotNull DataInterchange.NestedChangeListener l) {
        if (l == null) {
            DynamicJdbcUrlEditor.$$$reportNull$$$0(24);
        }
        return new DataInterchange.NestedChangeListener(){

            public void nestedChange(int depth) {
                if (DynamicJdbcUrlEditor.this.myUpdating || depth != 0) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> l.nestedChange(depth), DynamicJdbcUrlEditor.this.myConfigurable.getController().getModalityState());
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 10, 14, 15, 16, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedCallback";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor";
                break;
            }
            case 6: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 9: 
            case 13: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fg";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructorPreface";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createModelForDriver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentifier";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameFromParameters";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 22: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymizedUrl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifier";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromParameters";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentParamAttributes";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setDriver";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "delayed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 10, 14, 15, 16, 22 -> new IllegalStateException(string);
        };
    }

    static class MyLink
    extends LinkLabel<Void>
    implements UserActivityProviderComponent {
        private final EventDispatcher<ChangeListener> myDispatcher = EventDispatcher.create(ChangeListener.class);

        MyLink(Runnable callback) {
            super(null, null, (aSource, aLinkData) -> callback.run());
            this.setFocusable(true);
        }

        public void addChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyLink.$$$reportNull$$$0(0);
            }
            this.myDispatcher.addListener((EventListener)changeListener);
        }

        public void removeChangeListener(@NotNull ChangeListener changeListener) {
            if (changeListener == null) {
                MyLink.$$$reportNull$$$0(1);
            }
            this.myDispatcher.removeListener((EventListener)changeListener);
        }

        private void fireStateChanged() {
            ChangeEvent event = new ChangeEvent((Object)this);
            ((ChangeListener)this.myDispatcher.getMulticaster()).stateChanged(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "changeListener";
            objectArray2[1] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$MyLink";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChangeListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeChangeListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyInspectionConsumer
    extends JPanel
    implements UrlEditorInspector.InspectionConsumer {
        private final List<Warning> myWarnings = new ArrayList<Warning>();
        private final JBLabel myLabel = new JBLabel();
        private final ActionLink myMore = new ActionLink(DatabaseBundle.message((String)"link.label.more", (Object[])new Object[0]), e -> this.onMore());
        private final JComponent myFixesPanel = new JBBox(0);
        private boolean myUpdating = false;

        MyInspectionConsumer() {
            super(new BorderLayout(10, 0));
            Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
            this.myLabel.setFont(font);
            this.myMore.setFont(font);
            this.add((Component)this.myLabel, "West");
            this.add((Component)this.myFixesPanel, "East");
            this.myLabel.setIcon(AllIcons.General.Warning);
        }

        private void onMore() {
            @NlsContexts.NotificationContent StringBuilder sb = new StringBuilder();
            for (Warning warning : this.myWarnings) {
                sb.append(warning.content).append("\n\n");
            }
            Messages.showInfoMessage((String)sb.toString(), (String)DatabaseBundle.message((String)"dialog.title.warnings", (Object[])new Object[0]));
        }

        public void warning(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @Nullable String more, Pair<String, Consumer<DataInterchangeCore>> ... fixes) {
            if (title == null) {
                MyInspectionConsumer.$$$reportNull$$$0(0);
            }
            if (fixes == null) {
                MyInspectionConsumer.$$$reportNull$$$0(1);
            }
            this.myWarnings.add(new Warning(title, more, Arrays.asList(fixes)));
        }

        public void clear() {
            this.myWarnings.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateVisibility(@Nullable DataInterchange active) {
            this.myUpdating = true;
            try {
                if (this.myWarnings.isEmpty()) {
                    this.setVisible(false);
                } else {
                    this.setVisible(true);
                    boolean hasMore = this.myWarnings.size() > 1;
                    for (Warning warning : this.myWarnings) {
                        hasMore |= warning.content != null;
                    }
                    Warning warning = this.myWarnings.get(0);
                    this.myLabel.setText("<html>" + StringUtil.escapeXmlEntities((String)warning.title) + "</html>");
                    this.revalidate();
                    this.repaint();
                    this.myFixesPanel.removeAll();
                    if (hasMore) {
                        this.myFixesPanel.add((Component)this.myMore);
                    }
                    for (Pair<String, Consumer<DataInterchangeCore>> fix : warning.fixes) {
                        ActionLink label = new ActionLink((String)fix.first, e -> {
                            if (active != null) {
                                ((Consumer)fix.second).consume((Object)active);
                            }
                        });
                        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)label);
                        this.myFixesPanel.add(Box.createHorizontalStrut(10));
                        this.myFixesPanel.add((Component)label);
                    }
                }
            }
            finally {
                this.myUpdating = false;
            }
        }

        public boolean isUpdating() {
            return this.myUpdating;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dataSource/url/ui/DynamicJdbcUrlEditor$MyInspectionConsumer";
            objectArray[2] = "warning";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private record Warning(@NlsContexts.NotificationTitle String title, @NlsContexts.NotificationContent String content, List<Pair<@NlsActions.ActionText String, Consumer<DataInterchangeCore>>> fixes) {
    }
}

