/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DdlCodeFileIface;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DatabaseDefinitionHelper;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ExceptionUtil;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0016\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\u0016\u0010\u0018\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\u0016\u0010\u0019\u001a\u00020\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\u001b\u0010\u001b\u001a\u0015\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u000e0\u000e0\u001c\u00a2\u0006\u0002\b\u001eH\u0002J\u001b\u0010\u001f\u001a\u0004\u0018\u00010\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010!J\u0006\u0010\"\u001a\u00020\u0013J\b\u0010#\u001a\u00020\u0013H\u0002J\u0006\u0010$\u001a\u00020\u0013J\b\u0010%\u001a\u00020\u0013H\u0002J\b\u0010&\u001a\u00020\u0013H\u0002J\b\u0010'\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/database/editor/DdlEditorContentLoader;", "", "project", "Lcom/intellij/openapi/project/Project;", "codeFile", "Lcom/intellij/database/editor/DdlCodeFileIface;", "keepUserModifications", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/editor/DdlCodeFileIface;ZLcom/intellij/openapi/diagnostic/Logger;)V", "completed", "Lorg/jetbrains/concurrency/AsyncPromise;", "Ljava/lang/Void;", "getCompleted", "()Lorg/jetbrains/concurrency/AsyncPromise;", "fnStart", "Lkotlin/Function0;", "", "fnLoad", "fnFinish", "setStartFn", "fn", "setLoadFn", "setFinishFn", "maybeCancel", "cancel", "Lorg/jetbrains/concurrency/Promise;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "catching", "runnable", "(Lkotlin/jvm/functions/Function0;)Lkotlin/Unit;", "run", "doStart", "onStorageReady", "loadContent", "finish", "doFinish", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDdlEditorContentLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DdlEditorContentLoader.kt\ncom/intellij/database/editor/DdlEditorContentLoader\n+ 2 AsyncPromise.kt\norg/jetbrains/concurrency/AsyncPromiseKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n231#2,6:257\n739#3,9:263\n37#4,2:272\n1#5:274\n*S KotlinDebug\n*F\n+ 1 DdlEditorContentLoader.kt\ncom/intellij/database/editor/DdlEditorContentLoader\n*L\n70#1:257,6\n133#1:263,9\n133#1:272,2\n*E\n"})
public final class DdlEditorContentLoader {
    @NotNull
    private final Project project;
    @NotNull
    private final DdlCodeFileIface codeFile;
    private final boolean keepUserModifications;
    @NotNull
    private final Logger log;
    @NotNull
    private final AsyncPromise<Void> completed;
    @NotNull
    private Function0<Unit> fnStart;
    @NotNull
    private Function0<Unit> fnLoad;
    @NotNull
    private Function0<Unit> fnFinish;

    public DdlEditorContentLoader(@NotNull Project project, @NotNull DdlCodeFileIface codeFile, boolean keepUserModifications, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)codeFile, (String)"codeFile");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.project = project;
        this.codeFile = codeFile;
        this.keepUserModifications = keepUserModifications;
        this.log = log;
        this.completed = new AsyncPromise();
        this.fnStart = (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                DdlEditorContentLoader.access$doStart((DdlEditorContentLoader)this.receiver);
            }
        };
        this.fnLoad = (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                DdlEditorContentLoader.access$loadContent((DdlEditorContentLoader)this.receiver);
            }
        };
        this.fnFinish = (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                DdlEditorContentLoader.access$doFinish((DdlEditorContentLoader)this.receiver);
            }
        };
    }

    @NotNull
    public final AsyncPromise<Void> getCompleted() {
        return this.completed;
    }

    @TestOnly
    public final void setStartFn(@NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        this.fnStart = fn;
    }

    @TestOnly
    public final void setLoadFn(@NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        this.fnLoad = fn;
    }

    @TestOnly
    public final void setFinishFn(@NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        this.fnFinish = fn;
    }

    private final boolean maybeCancel() {
        boolean bl;
        if (this.project.isDisposed() || !this.codeFile.isValid()) {
            this.cancel();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final Promise<Void> cancel() {
        Promise promise = Promises.cancelledPromise().processed((Promise)this.completed);
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"processed(...)");
        return promise;
    }

    @Nullable
    public final Unit catching(@NotNull Function0<Unit> runnable) {
        Object object;
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        AsyncPromise<Void> $this$catchError$iv = this.completed;
        boolean $i$f$catchError = false;
        try {
            object = runnable.invoke();
        }
        catch (Throwable e$iv) {
            $this$catchError$iv.setError(e$iv);
            object = null;
        }
        return (Unit)object;
    }

    public final void run() {
        this.codeFile.setBusy(true);
        this.completed.onError(arg_0 -> DdlEditorContentLoader.run$lambda$1(arg_0 -> DdlEditorContentLoader.run$lambda$0(this, arg_0), arg_0));
        this.completed.onSuccess(arg_0 -> DdlEditorContentLoader.run$lambda$3(arg_0 -> DdlEditorContentLoader.run$lambda$2(this, arg_0), arg_0));
        this.catching((Function0<Unit>)((Function0)() -> DdlEditorContentLoader.run$lambda$4(this)));
    }

    private final void doStart() {
        DataSourceStorage.getProjectStorage((Project)this.project).doWhenInitialized(() -> DdlEditorContentLoader.doStart$lambda$0(this));
    }

    public final void onStorageReady() {
        if (this.maybeCancel()) {
            return;
        }
        this.codeFile.setVisualProgress(true);
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> DdlEditorContentLoader.onStorageReady$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"executeOnPooledThread(...)");
        Future loadFuture = future;
        loadFuture.get();
        if (Promises.isRejected((Promise)((Promise)this.completed))) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> DdlEditorContentLoader.onStorageReady$lambda$1(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void loadContent() {
        if (this.maybeCancel()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        int objectHash = 0;
        try {
            DbElement element = this.codeFile.getDbElement();
            if (element == null) {
                sb.append("-- invalid target");
            } else {
                objectHash = DatabaseEditorHelper.computeObjectHashCode(element);
                Dbms dbms = DbImplUtilCore.getDbms((DbElement)element);
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                Dbms dbms2 = dbms;
                if (!DBIntrospectorFactory.hasNativeIntrospector((Dbms)dbms2) && DatabaseDefinitionHelper.isRawDefinitionAvailable((DbElement)element)) {
                    v1 = DatabaseEditorHelper.loadOrGenerateDefinition(element, sb);
                } else {
                    sb.append("-- auto-generated definition\n");
                    v1 = DatabaseDefinitionHelper.generateDefinition((DbElement)element, (StringBuilder)sb);
                }
                if (((CharSequence)sb).length() == 0) {
                    sb.append("-- definition is not available or empty");
                }
            }
        }
        catch (Exception e) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            String string = ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)this.log);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUserStackTrace(...)");
            String trace = string;
            Object object = trace;
            Regex regex = new Regex("\n");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            for (String s : thisCollection$iv.toArray(new String[0])) {
                sb.append("-- ").append(s).append("\n");
            }
        }
        finally {
            String string = StringUtil.convertLineSeparators((String)sb.toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
            String content = string;
            if (!this.codeFile.isModifiedByUser() || !this.keepUserModifications || Intrinsics.areEqual((Object)content, (Object)this.codeFile.getContent())) {
                this.codeFile.setContent(content, objectHash);
            }
        }
    }

    private final void finish() {
        if (this.maybeCancel()) {
            return;
        }
        this.codeFile.setVisualProgress(false);
        this.fnFinish.invoke();
    }

    private final void doFinish() {
        Document document = this.codeFile.getDocument();
        if (document == null) {
            this.cancel();
            return;
        }
        WriteCommandAction.writeCommandAction((Project)this.project).run(() -> DdlEditorContentLoader.doFinish$lambda$0(this, document));
    }

    private static final Unit run$lambda$0(DdlEditorContentLoader this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.codeFile.setBusy(false);
        return Unit.INSTANCE;
    }

    private static final void run$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit run$lambda$2(DdlEditorContentLoader this$0, Void it) {
        this$0.codeFile.setBusy(false);
        return Unit.INSTANCE;
    }

    private static final void run$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit run$lambda$4(DdlEditorContentLoader this$0) {
        this$0.fnStart.invoke();
        return Unit.INSTANCE;
    }

    private static final void doStart$lambda$0(DdlEditorContentLoader this$0) {
        this$0.catching((Function0<Unit>)((Function0)new Function0<Unit>((Object)this$0){

            public final void invoke() {
                ((DdlEditorContentLoader)this.receiver).onStorageReady();
            }
        }));
    }

    private static final void onStorageReady$lambda$0(DdlEditorContentLoader this$0) {
        this$0.fnLoad.invoke();
    }

    private static final void onStorageReady$lambda$1(DdlEditorContentLoader this$0) {
        this$0.catching((Function0<Unit>)((Function0)new Function0<Unit>((Object)this$0){

            public final void invoke() {
                DdlEditorContentLoader.access$finish((DdlEditorContentLoader)this.receiver);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doFinish$lambda$0(DdlEditorContentLoader this$0, Document $document) {
        boolean writable = this$0.codeFile.isWritable();
        try {
            DasNamespace dasNamespace;
            this$0.codeFile.setWritableInner(true);
            $document.setReadOnly(false);
            if ($document.getTextLength() == 0) {
                DocumentReference documentReference = DocumentReferenceManager.getInstance().create($document);
                Intrinsics.checkNotNullExpressionValue((Object)documentReference, (String)"create(...)");
                DocumentReference reference = documentReference;
                UndoManager.getInstance((Project)this$0.project).nonundoableActionPerformed(reference, false);
            }
            PsiFile file = PsiDocumentManager.getInstance((Project)this$0.project).getPsiFile($document);
            DbElement dbElement = this$0.codeFile.getDbElement();
            if (dbElement != null) {
                DbElement it = dbElement;
                boolean bl = false;
                dasNamespace = DbImplUtilCore.getSearchPathObject((DbElement)it);
            } else {
                dasNamespace = null;
            }
            DasNamespace searchPathObject = dasNamespace;
            DatabaseDataKeysCore.SEARCH_PATH_KEY.set((UserDataHolder)file, (Object)ObjectPaths.searchPathOf((DasObject)((DasObject)searchPathObject)));
            FileDocumentManager.getInstance().reloadFromDisk($document, this$0.project);
            boolean reformatOnPaste = CodeInsightSettings.getInstance().REFORMAT_ON_PASTE == 4;
            PsiDocumentManager.getInstance((Project)this$0.project).commitDocument($document);
            if (file != null && reformatOnPaste) {
                CodeStyleManager.getInstance((Project)this$0.project).reformat((PsiElement)file);
            }
            this$0.codeFile.setWritableInner(writable);
            $document.setReadOnly(!writable);
        }
        catch (Throwable throwable) {
            this$0.codeFile.setWritableInner(writable);
            $document.setReadOnly(!writable);
            this$0.completed.setResult(null);
            throw throwable;
        }
        this$0.completed.setResult(null);
    }

    public static final /* synthetic */ void access$finish(DdlEditorContentLoader $this) {
        $this.finish();
    }

    public static final /* synthetic */ void access$doStart(DdlEditorContentLoader $this) {
        $this.doStart();
    }

    public static final /* synthetic */ void access$loadContent(DdlEditorContentLoader $this) {
        $this.loadContent();
    }

    public static final /* synthetic */ void access$doFinish(DdlEditorContentLoader $this) {
        $this.doFinish();
    }
}

