/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.client.ScriptingSessionClient;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.client.VisibleSessionClient;
import com.intellij.database.console.session.DatabaseInEditorResults;
import com.intellij.database.console.session.DatabaseLogView;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DbGridDataHookUpUtil;
import com.intellij.database.datagrid.DelegatingDataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.actions.NotebookGridPatcher;
import com.intellij.database.run.actions.NotebookGridPatcherKt;
import com.intellij.database.run.session.LogView;
import com.intellij.database.run.session.VisibleSession;
import com.intellij.database.run.ui.FloatingPagingManager;
import com.intellij.database.run.ui.TableResultPanel;
import com.intellij.database.run.ui.grid.GridMainPanel;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.GridTablesModel;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorEmbeddedComponentManager;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.JBDimension;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class ScriptingClientDataConsumer
implements DataConsumer {
    private static final String ID_RESULT = "ResultTab";
    private static final String DEFAULT_TITLE = "Result";
    private static final Key<GridInfo> GRID_INFO_KEY = Key.create((String)"GRID_INFO_KEY");
    private static final Key<DataType> QUERY_DATA_TYPE = Key.create((String)"QUERY_DATA_TYPE");
    private final Alarm myAlarm;
    private final PlaceInGrid myPlace;
    private final Supplier<VirtualFile> myFileSupplier;
    private final ResultsPlaceChooser myChooser;
    private final Function<Disposable, GridDataHookUp<GridRow, GridColumn>> myHookUpFactory;
    private final Project myProject;
    private final VisibleSessionClient<?> myClient;
    private int myMajorRequestCount;
    private int myMinorRequestCount;
    private UiContent myCurrentContent;
    private boolean preferredSizeInvalidated;
    private final MultiMap<GridDataRequest, UiContent> myPreparedContentMap;

    private ScriptingClientDataConsumer(@NotNull Project project, @NotNull VisibleSessionClient<?> client, @NotNull PlaceInGrid place, @NotNull Supplier<VirtualFile> fileSupplier, @NotNull Function<Disposable, GridDataHookUp<GridRow, GridColumn>> hookUpFactory, @NotNull ResultsPlaceChooser chooser) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(0);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(1);
        }
        if (place == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(2);
        }
        if (fileSupplier == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(3);
        }
        if (hookUpFactory == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(4);
        }
        if (chooser == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(5);
        }
        this.preferredSizeInvalidated = true;
        this.myPreparedContentMap = MultiMap.createWeakKey();
        this.myProject = project;
        this.myClient = client;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, client);
        this.myPlace = place;
        this.myChooser = chooser;
        this.myFileSupplier = fileSupplier;
        this.myHookUpFactory = hookUpFactory;
        client.getMessageBus().addAuditor((DataAuditor)new MyAuditor());
    }

    @NotNull
    public Collection<? extends DatabaseInEditorResults.Result> getEmbeddedResults(@NotNull Editor editor2) {
        if (editor2 == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(6);
        }
        Collection<? extends DatabaseInEditorResults.Result> collection = this.myChooser.getEmbeddedResults(editor2);
        if (collection == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public Collection<RunnerLayoutUi> getUis() {
        Collection<RunnerLayoutUi> collection = this.myChooser.getAllUis();
        if (collection == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public static ScriptingClientDataConsumer install(@NotNull Project project, @NotNull ScriptingSessionClient client, @NotNull LogView<?> view) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(9);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(10);
        }
        if (view == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(11);
        }
        PlaceInGrid place = client.getResultsPlaceInView();
        Supplier<VirtualFile> vfSupplier = () -> ((ScriptingSessionClient)client).getVirtualFile();
        Function huFun = arg_0 -> ((ScriptingSessionClient)client).createGridDataHookUp(arg_0);
        ToolWindowAlways chooser = new ToolWindowAlways(view);
        ScriptingClientDataConsumer consumer = new ScriptingClientDataConsumer(project, (VisibleSessionClient<?>)client, place, vfSupplier, (Function<Disposable, GridDataHookUp<GridRow, GridColumn>>)huFun, chooser);
        client.getMessageBus().addConsumer(DataGridUtil.createEDTSafeWrapper(consumer, (Disposable)client));
        ScriptingClientDataConsumer scriptingClientDataConsumer = consumer;
        if (scriptingClientDataConsumer == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(12);
        }
        return scriptingClientDataConsumer;
    }

    @NotNull
    public static ScriptingClientDataConsumer install(@NotNull Project project, final @NotNull JdbcConsole client, @NotNull ResultsPlaceChooser chooser) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(13);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(14);
        }
        if (chooser == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(15);
        }
        Function hookUpFactory = client::createGridDataHookUp;
        PlaceInGrid place = client.getResultsPlaceInView();
        Supplier<VirtualFile> vFileGetter = client::getVirtualFile;
        ScriptingClientDataConsumer consumer = new ScriptingClientDataConsumer(project, (VisibleSessionClient)client, place, vFileGetter, hookUpFactory, chooser){

            @Override
            protected boolean isClientValid() {
                return client.isValid();
            }
        };
        client.getMessageBus().addConsumer((DataConsumer)new PreventingExtraResultsConsumer(DataGridUtil.createEDTSafeWrapper(consumer, (Disposable)client)));
        ScriptingClientDataConsumer scriptingClientDataConsumer = consumer;
        if (scriptingClientDataConsumer == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(16);
        }
        return scriptingClientDataConsumer;
    }

    @NotNull
    public static ScriptingClientDataConsumer install(@NotNull Project project, final @NotNull VisibleDatabaseSessionClient client) {
        if (project == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(17);
        }
        if (client == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(18);
        }
        LogView view = DatabaseSessionViewService.getInstance().getView((DatabaseSession)client.getSession());
        ToolWindowAlways chooser = new ToolWindowAlways(view);
        ScriptingClientDataConsumer consumer = new ScriptingClientDataConsumer(project, (VisibleSessionClient)client, PlaceInGrid.center, () -> null, d -> {
            DatabaseSession session = (DatabaseSession)client.getSession();
            return DbGridDataHookUpUtil.createReadOnlyDatabaseHookUp(project, d, "", client.getDepartment(), session);
        }, chooser){

            @Override
            protected boolean isClientValid() {
                return client.isValid();
            }
        };
        client.getMessageBus().addConsumer((DataConsumer)new PreventingExtraResultsConsumer(DataGridUtil.createEDTSafeWrapper(consumer, (Disposable)client)));
        ScriptingClientDataConsumer scriptingClientDataConsumer = consumer;
        if (scriptingClientDataConsumer == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(19);
        }
        return scriptingClientDataConsumer;
    }

    public void afterLastRowAdded(@NotNull GridDataRequest.Context context, int total) {
        Content content;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(20);
        }
        if ((content = this.getValidCurrentContent()) == null) {
            return;
        }
        this.myCurrentContent = null;
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content);
        ScriptingClientDataConsumer.consumerFor(dataGrid).afterLastRowAdded(context, total);
    }

    public void resetOutputTabCounter() {
        this.myMajorRequestCount = 0;
        this.myMinorRequestCount = 0;
    }

    public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, GridColumn @NotNull [] columns, int firstRowNum) {
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(21);
        }
        if (columns == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(22);
        }
        this.preferredSizeInvalidated = true;
        DataRequest.Context c2 = (DataRequest.Context)context;
        if (!this.isClientValid() || !((VisibleSession)this.myClient.getSession()).isValid()) {
            return;
        }
        ResultsProducer.ReferenceInfo referenceInfo = (ResultsProducer.ReferenceInfo)c2.getUserData(JdbcEngine.REFERENCE_INFO_KEY);
        UiContent content = this.myCurrentContent = this.getPreparedContentInfoFor((DataRequest.Context)c2, (int)subQueryIndex, (int)resultSetIndex, (GridColumn[])columns, (ResultsProducer.ReferenceInfo)referenceInfo, (boolean)false).content;
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content.content);
        content.ui.setBouncing(content.content, true);
        dataGrid.resetFilters();
        ScriptingClientDataConsumer.consumerFor(dataGrid).setColumns(context, subQueryIndex, resultSetIndex, columns, firstRowNum);
    }

    public void setInReference(@NotNull GridDataRequest.Context context, @NotNull Object reference) {
        DataGrid dataGrid;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(23);
        }
        if (reference == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(24);
        }
        DataGrid dataGrid2 = dataGrid = this.myCurrentContent == null ? null : ScriptingClientDataConsumer.getDataGrid(this.myCurrentContent.content);
        if (dataGrid == null) {
            return;
        }
        GridUtil.IN_REFERENCE.set((UserDataHolder)this.myCurrentContent.content, reference);
        GridUtil.IS_REFERENCED.set((UserDataHolder)dataGrid, (Object)true);
        ScriptingClientDataConsumer.consumerFor(dataGrid).setInReference(context, reference);
    }

    public void updateColumns(@NotNull GridDataRequest.Context context, GridColumn @NotNull [] columns) {
        DataGrid dataGrid;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(25);
        }
        if (columns == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(26);
        }
        DataGrid dataGrid2 = dataGrid = this.myCurrentContent == null ? null : ScriptingClientDataConsumer.getDataGrid(this.myCurrentContent.content);
        if (dataGrid == null) {
            return;
        }
        ScriptingClientDataConsumer.consumerFor(dataGrid).updateColumns(context, columns);
    }

    public void setOutReferences(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull GridDataRequest.Context context, @NotNull Set<Object> references) {
        DataGrid dataGrid;
        if (references == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(27);
        }
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(28);
        }
        DataGrid dataGrid2 = dataGrid = this.myCurrentContent == null ? null : ScriptingClientDataConsumer.getDataGrid(this.myCurrentContent.content);
        if (dataGrid == null) {
            return;
        }
        GridUtil.OUT_REFERENCES.set((UserDataHolder)this.myCurrentContent.content, references);
        ScriptingClientDataConsumer.consumerFor(dataGrid).setInReference(context, references);
    }

    public void addRows(@NotNull GridDataRequest.Context context, @NotNull List<? extends GridRow> rows) {
        NotebookGridPatcher patcher;
        Content content;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(29);
        }
        if (rows == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(30);
        }
        if ((content = this.getValidCurrentContent()) == null) {
            return;
        }
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content);
        ScriptingClientDataConsumer.consumerFor(dataGrid).addRows(context, rows);
        if (this.preferredSizeInvalidated && (patcher = (NotebookGridPatcher)dataGrid.getUserData(NotebookGridPatcherKt.RESULTS_PATCHER)) != null) {
            patcher.updateHeight();
            patcher.updateBorders();
        }
        this.preferredSizeInvalidated = false;
    }

    @NotNull
    private PlaceInGrid getPlaceInGrid() {
        PlaceInGrid placeInGrid = this.myPlace;
        if (placeInGrid == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(31);
        }
        return placeInGrid;
    }

    @NlsSafe
    private String getNextTitle(int resultSetIndex) {
        StringBuilder title = new StringBuilder(DEFAULT_TITLE).append(" ").append(this.myMajorRequestCount);
        if (this.myMinorRequestCount > 1 || resultSetIndex > 1) {
            title.append("-").append(this.myMinorRequestCount);
        }
        if (resultSetIndex > 1) {
            title.append("-").append(resultSetIndex);
        }
        return title.toString();
    }

    protected boolean isClientValid() {
        return true;
    }

    private static boolean isGeneratedName(@NotNull Content content) {
        GridInfo info2;
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(32);
        }
        return (info2 = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)content)) != null && content.getDisplayName().startsWith(info2.originalTitle);
    }

    private void onRequestTakesTimeEDT(@NotNull DataRequest.Context context) {
        ConsoleDataRequest.ResultSetSubQuery resultSetSubQuery;
        SqlTableType type;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(33);
        }
        SqlTableType sqlTableType = type = (resultSetSubQuery = ScriptingClientDataConsumer.getConsoleResultSetSubQuery(context, 1)) == null ? null : resultSetSubQuery.resultType;
        if (type == null || !((VisibleSession)this.myClient.getSession()).isValid() || !this.getResultsPlace(resultSetSubQuery).showImmediate()) {
            return;
        }
        ContentInfo info2 = this.getPreparedContentInfoFor(context, 1, 1, null, null, true);
        if (!info2.isNew) {
            return;
        }
        UiContent content = info2.content;
        this.updateContentTitle(content, context, 1, null);
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content.content);
        DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(dataGrid);
        List columns = DbSqlUtil.createColumnsFromType((Project)this.myProject, (DatabaseDialectEx)dialect, (SqlTableType)type, (String)"", (String)"", (String)"");
        ScriptingClientDataConsumer.consumerFor(dataGrid).setColumns((GridDataRequest.Context)context, 1, 1, (GridColumn[])ContainerUtil.toArray((Collection)columns, DataConsumer.Column[]::new), 1);
    }

    private void onRequestStartedEDT(@NotNull DataRequest.Context context) {
        int queryIndex;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(34);
        }
        if (!((VisibleSession)this.myClient.getSession()).isValid()) {
            return;
        }
        if (!(context.request instanceof DataRequest.QueryRequest) && !(context.request instanceof DataRequest.CallRequest)) {
            return;
        }
        int n = queryIndex = context.request instanceof ConsoleDataRequest ? ((ConsoleDataRequest)context.request).queryIndex : 0;
        if (queryIndex == 0) {
            ++this.myMajorRequestCount;
            this.myMinorRequestCount = 1;
        } else {
            ++this.myMinorRequestCount;
        }
    }

    private void onRequestFinishedEDT(@NotNull DataRequest.Context context) {
        Collection contents;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(35);
        }
        if ((contents = this.myPreparedContentMap.remove((Object)context.request)) == null) {
            return;
        }
        for (UiContent content : contents) {
            if (!content.content.isValid()) continue;
            DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content.content);
            DataGridUtil.setProgressMessage(dataGrid, null);
        }
    }

    @Nullable
    private Content getValidCurrentContent() {
        return ((VisibleSession)this.myClient.getSession()).isValid() && this.myCurrentContent != null && this.myCurrentContent.content.isValid() ? this.myCurrentContent.content : null;
    }

    @NotNull
    private ContentInfo getPreparedContentInfoFor(@NotNull DataRequest.Context context, int subQueryIndex, int resultSetIndex, GridColumn @Nullable [] columns, @Nullable ResultsProducer.ReferenceInfo referenceInfo, boolean fake) {
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(36);
        }
        UiContent preparedContent = resultSetIndex == 1 ? (UiContent)ContainerUtil.getFirstItem((Collection)this.myPreparedContentMap.get((Object)context.request)) : null;
        ContentInfo contentInfo = preparedContent != null && preparedContent.content.isValid() ? new ContentInfo(preparedContent, false) : this.reuseOrCreateContent(context, subQueryIndex, resultSetIndex);
        UiContent content = contentInfo.content;
        this.myPreparedContentMap.putValue((Object)context.request, (Object)content);
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content.content);
        DataGridUtil.setProgressMessage(dataGrid, "");
        if (fake && !contentInfo.isNew) {
            this.updateContent(content, context, subQueryIndex, null, null, true);
            ContentInfo contentInfo2 = contentInfo;
            if (contentInfo2 == null) {
                ScriptingClientDataConsumer.$$$reportNull$$$0(37);
            }
            return contentInfo2;
        }
        String title = this.getNextTitle(resultSetIndex);
        content.content.setDisplayName(title);
        content.content.setDescription(StringUtil.escapeXmlEntities((String)context.getQuery()));
        if (referenceInfo != null) {
            this.updateContent(content, context, subQueryIndex, c2 -> ScriptingClientDataConsumer.setContentTitle(c2, referenceInfo.getColumnName()), DatabaseIcons.TableMapping, referenceInfo.isUnwrapping());
            ContentInfo contentInfo3 = contentInfo;
            if (contentInfo3 == null) {
                ScriptingClientDataConsumer.$$$reportNull$$$0(38);
            }
            return contentInfo3;
        }
        this.updateContent(content, context, subQueryIndex, c2 -> this.updateContentTitle((UiContent)c2, context, subQueryIndex, columns), DatabaseIcons.Table, true);
        ContentInfo contentInfo4 = contentInfo;
        if (contentInfo4 == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(39);
        }
        return contentInfo4;
    }

    @NotNull
    private ContentInfo reuseOrCreateContent(@NotNull DataRequest.Context context, int subQueryIndex, int resultSetIndex) {
        DataRequest dataRequest;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(40);
        }
        ConsoleDataRequest.ResultSetSubQuery resultSetSubQuery = ScriptingClientDataConsumer.getConsoleResultSetSubQuery(context, subQueryIndex);
        ResultsPlace place = this.getResultsPlace(resultSetSubQuery);
        boolean newTab = !(context.request instanceof ConsoleDataRequest) || ((ConsoleDataRequest)context.request).newTab;
        UiContent oldContent = this.findContentToReuse(place, newTab);
        UiContent resultContent = oldContent == null ? this.createNewContent(place, context.request, resultSetIndex) : oldContent;
        GridInfo gridInfo = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)resultContent.content);
        DataType dataType = null;
        Component topComponent = gridInfo.grid.getPanel().getTopComponent();
        if (topComponent instanceof JPanel) {
            JPanel header = (JPanel)topComponent;
            DatabaseEditorHelper.configureEditorHeader(this.myProject, this.myFileSupplier.get(), header);
        }
        if ((dataRequest = context.request) instanceof ConsoleDataRequest) {
            SqlTableType resultType;
            ConsoleDataRequest consoleDataRequest = (ConsoleDataRequest)dataRequest;
            ConsoleDataRequest.ResultSetSubQuery mainSubquery = consoleDataRequest.getResultSetSubquery(1);
            SqlTableType sqlTableType = resultType = mainSubquery != null ? mainSubquery.resultType : null;
            if (resultType != null) {
                dataType = resultType.toDataType();
            }
        }
        DataType oldDataType = (DataType)gridInfo.grid.getUserData(QUERY_DATA_TYPE);
        gridInfo.grid.putUserData(QUERY_DATA_TYPE, dataType);
        if (!Objects.equals(dataType, oldDataType)) {
            gridInfo.grid.adaptForNewQuery();
        }
        gridInfo.grid.getDataHookup().getPageModel().setPageSize(DbImplUtilCore.getPageSize((Dbms)DataGridUtil.getDbms(gridInfo.grid)));
        gridInfo.originalTitle = DEFAULT_TITLE;
        gridInfo.major = this.myMajorRequestCount;
        gridInfo.minor = this.myMinorRequestCount;
        GridUtil.IS_REFERENCED.set((UserDataHolder)gridInfo.grid, null);
        return new ContentInfo(resultContent, oldContent == null);
    }

    @Nullable
    private UiContent findContentToReuse(@NotNull ResultsPlace place, boolean newTab) {
        if (place == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(41);
        }
        RunnerLayoutUi ui = place.getOrCreateUi();
        Content[] contents = ui.getContents();
        Content resultContent = null;
        if (!newTab) {
            GridInfo curInfo = null;
            for (Content content : contents) {
                DataGrid dataGrid = ScriptingClientDataConsumer.getDataGrid(content);
                if (dataGrid == null || content.isPinned() || !ScriptingClientDataConsumer.isGeneratedName(content)) continue;
                GridInfo info2 = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)content);
                if (info2.major == this.myMajorRequestCount || curInfo != null && curInfo.major <= info2.major && (curInfo.major != info2.major || curInfo.minor <= info2.minor)) continue;
                resultContent = content;
                curInfo = info2;
            }
        }
        if (resultContent == null) {
            return null;
        }
        GridUtil.IN_REFERENCE.set(resultContent, null);
        GridUtil.OUT_REFERENCES.set(resultContent, null);
        return new UiContent(ui, resultContent);
    }

    @NotNull
    private UiContent createNewContent(final @NotNull ResultsPlace place, @NotNull DataRequest request, int resultSetIndex) {
        if (place == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(42);
        }
        if (request == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(43);
        }
        RunnerLayoutUi ui = place.getOrCreateUi();
        final DataGrid dataGrid = this.createTableResultPanel(ui, place.isUseConsoleFonts(), place::configure);
        new DumbAwareAction(this, DatabaseBundle.messagePointer((String)"action.ScriptingClientDataConsumer.escape.text", (Object[])new Object[0])){

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    3.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(1);
                }
                place.moveFocusToEditor(e);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(2);
                }
                e.getPresentation().setEnabledAndVisible(!dataGrid.isEditing());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ScriptingClientDataConsumer$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        }.registerCustomShortcutSet(27, 0, dataGrid.getResultView().getComponent());
        Content content = this.addContent(ui, dataGrid, place, request, resultSetIndex);
        place.readyToShow(content);
        ScriptingClientDataConsumer.setMinimumSizeForParent(content);
        GRID_INFO_KEY.set((UserDataHolder)content, (Object)new GridInfo(dataGrid));
        Disposer.register((Disposable)content, (Disposable)dataGrid);
        return new UiContent(ui, content);
    }

    private void updateContent(@NotNull UiContent content, @NotNull DataRequest.Context context, int subQueryIndex, @Nullable Consumer<UiContent> updateTitle, @Nullable Icon icon, boolean select) {
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(44);
        }
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(45);
        }
        if (updateTitle != null) {
            updateTitle.accept(content);
        }
        if (icon != null) {
            content.content.setIcon(icon);
        }
        if (select) {
            ConsoleDataRequest.ResultSetSubQuery resultSetSubQuery = ScriptingClientDataConsumer.getConsoleResultSetSubQuery(context, subQueryIndex);
            this.getResultsPlace(resultSetSubQuery).showIfNeeded(context.request.owner).onSuccess(__ -> DbImplUtilCore.invokeLaterIfNeeded(() -> {
                ContentManager manager;
                if (content.content.isValid() && (manager = content.content.getManager()) != null) {
                    manager.setSelectedContent(content.content, false, false);
                }
            }));
        }
    }

    private void updateContentTitle(@NotNull UiContent content, @NotNull DataRequest.Context context, int subQueryIndex, GridColumn @Nullable [] columns) {
        VisibleSessionClient<?> visibleSessionClient;
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(46);
        }
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(47);
        }
        DataGrid dataGrid = ScriptingClientDataConsumer.getNotNullDataGrid(content.content);
        if (context.request instanceof ConsoleDataRequest && (visibleSessionClient = this.myClient) instanceof JdbcConsole) {
            String name;
            GridTablesModel gridTablesModel;
            JdbcConsole console = (JdbcConsole)visibleSessionClient;
            Language language = console.getLanguage();
            if (!(language instanceof SqlLanguageDialect)) {
                SqlDialects.ensureSqlDialectsLoaded();
                language = DbSqlUtil.getLanguage((Dbms)console.getDataSource().getDbms());
            }
            if (!console.isValid()) {
                return;
            }
            ConsoleDataRequest.ResultSetSubQuery subQuery = ScriptingClientDataConsumer.getConsoleResultSetSubQuery(context, subQueryIndex);
            String query = subQuery == null ? null : subQuery.query;
            String title = subQuery == null ? null : subQuery.title;
            SqlTableType resultType = subQuery == null ? null : subQuery.resultType;
            try (AccessToken ignored = SlowOperations.knownIssue((String)"DBE-21860");){
                gridTablesModel = DbSqlUtil.getGridTablesModel((Project)this.myProject, (Language)language, (DbDataSource)DbSqlUtilCore.getDbDataSource((Project)this.myProject, (DasDataSource)console.getDataSource()), (SearchPath)console.getSearchPath(), (String)query, (SqlTableType)resultType, columns == null ? Collections.emptyList() : Arrays.asList(columns));
            }
            Objects.requireNonNull(DataGridUtil.getDatabaseHookUp((CoreGrid<GridRow, GridColumn>)dataGrid)).setGridTablesModel(gridTablesModel);
            DatabaseEditorHelper.configureEditorHeader(this.myProject, this.myFileSupplier.get(), (JComponent)ObjectUtils.tryCast((Object)dataGrid.getPanel().getTopComponent(), EditorHeaderComponent.class));
            if (content.content.isPinned()) {
                return;
            }
            if (title != null) {
                name = title;
            } else if (gridTablesModel != null && gridTablesModel.hasSingleTable()) {
                name = QNameUtil.getQualifiedName((DasObject)gridTablesModel.getFirstTable());
            } else if (resultType != null && resultType.getColumnCount() == 1) {
                name = resultType.getDescription();
                if (name.startsWith("(") && name.endsWith(")")) {
                    name = name.substring(1, name.length() - 1);
                }
            } else {
                name = null;
            }
            ScriptingClientDataConsumer.setContentTitle(content, name);
        }
    }

    private static void setContentTitle(@NotNull UiContent content, @NlsSafe @Nullable String title) {
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(48);
        }
        if (title == null) {
            return;
        }
        String adjustedTitle = StringUtil.firstLast((String)title, (int)40);
        String uniqueTitle = new UniqueNameGenerator(Arrays.asList(content.ui.getContents()), c2 -> StringUtil.notNullize((String)(content.content == c2 ? null : c2.getDisplayName()))).generateUniqueName(adjustedTitle, "", "", " ", "");
        content.content.setDisplayName(uniqueTitle);
        ((GridInfo)ScriptingClientDataConsumer.GRID_INFO_KEY.get((UserDataHolder)content.content)).originalTitle = content.content.getDisplayName();
    }

    @NotNull
    protected DataGrid createTableResultPanel(final @NotNull RunnerLayoutUi ui, boolean useConsoleFonts, @NotNull BiConsumer<DataGrid, DataGridAppearance> configure) {
        if (ui == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(49);
        }
        if (configure == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(50);
        }
        Disposable hookUpParent = Disposer.newDisposable();
        final GridDataHookUp hookUp = (GridDataHookUp)this.myHookUpFactory.fun((Object)hookUpParent);
        ActionGroup popupGroup = DataGridUtil.getGridDatabasePopupActions();
        ActionGroup columnHeaderPopupGroup = GridUtil.getGridColumnHeaderPopupActions();
        TableResultPanel grid = new TableResultPanel(this.myProject, hookUp, popupGroup, null, columnHeaderPopupGroup, ActionGroup.EMPTY_GROUP, useConsoleFonts, ((BiConsumer<DataGrid, DataGridAppearance>)DataGridUtil::configure).andThen(configure)){

            @NotNull
            public String getDisplayName() {
                GridMainPanel component = this.getPanel();
                Content content = ui.getContentManager().getContent((JComponent)component);
                String string = content == null ? "" : content.getTabName();
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            protected void uiDataSnapshot(@NotNull DataSink sink) {
                if (sink == null) {
                    4.$$$reportNull$$$0(1);
                }
                super.uiDataSnapshot(sink);
                DataGridUtil.uiDataSnapshot(sink, (DataGrid)this);
                sink.set(PlatformCoreDataKeys.FILE_EDITOR, (Object)ScriptingClientDataConsumer.this.getOrCreateEditorWrapper(ui, (DataGrid)this));
                sink.set(DatabaseDataKeys.DATA_GRID_CONTENT_KEY, (Object)ScriptingClientDataConsumer.this.findContent(ui, (DataGrid)this));
                sink.set(DatabaseDataKeys.DATA_GRID_RUNNER_LAYOUT_UI_KEY, (Object)ui);
            }

            public boolean isReady() {
                return super.isReady() && this.isHookUpValid((GridDataHookUp<GridRow, GridColumn>)this.getDataHookup());
            }

            private boolean isHookUpValid(@NotNull GridDataHookUp<GridRow, GridColumn> hookup) {
                if (hookup == null) {
                    4.$$$reportNull$$$0(2);
                }
                return !(hookUp instanceof ConsoleGridDataHookUp) || ((ConsoleGridDataHookUp)hookup).isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ScriptingClientDataConsumer$4";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sink";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "hookup";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDisplayName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "uiDataSnapshot";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isHookUpValid";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
        Disposer.register((Disposable)grid, (Disposable)hookUpParent);
        DataGridUtil.setupProgressIndicatingAuditor((DataGrid)grid);
        TableResultPanel tableResultPanel = grid;
        if (tableResultPanel == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(51);
        }
        return tableResultPanel;
    }

    private FileEditor getOrCreateEditorWrapper(@NotNull RunnerLayoutUi ui, @NotNull DataGrid resultPanel) {
        if (ui == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(52);
        }
        if (resultPanel == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(53);
        }
        return GridUtil.getOrCreateEditorWrapper((DataGrid)resultPanel, (Project)this.myProject, () -> {
            Content content = this.findContent(ui, resultPanel);
            return content == null ? null : content.getTabName();
        });
    }

    @Nullable
    private Content findContent(@NotNull RunnerLayoutUi ui, @NotNull DataGrid resultPanel) {
        if (ui == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(54);
        }
        if (resultPanel == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(55);
        }
        if (!((VisibleSession)this.myClient.getSession()).isValid()) {
            return null;
        }
        for (Content content : ui.getContents()) {
            if (ScriptingClientDataConsumer.getDataGrid(content) != resultPanel) continue;
            return content;
        }
        return null;
    }

    private Content addContent(@NotNull RunnerLayoutUi ui, @NotNull DataGrid dataGrid, @NotNull ResultsPlace place, @NotNull DataRequest request, int resultSetIndex) {
        if (ui == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(56);
        }
        if (dataGrid == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(57);
        }
        if (place == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(58);
        }
        if (request == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(59);
        }
        String contentId = "ResultTab#" + Integer.toHexString(request.hashCode()) + "@" + this.myMajorRequestCount + "." + this.myMinorRequestCount + "." + resultSetIndex;
        Content content = ui.createContent(contentId, (ComponentWithActions)new ComponentWithActions.Impl((JComponent)dataGrid.getPanel().getComponent()), "", DatabaseIcons.Table, dataGrid.getPreferredFocusedComponent());
        content.setCloseable(true);
        content.setPinnable(true);
        JComponent header = place.addHeader(dataGrid);
        DatabaseEditorHelper.configureEditorHeader(dataGrid.getProject(), this.myFileSupplier.get(), header);
        dataGrid.getProject().getMessageBus().connect((Disposable)dataGrid).subscribe(DatabaseColorManager.COLOR_CHANGE_TOPIC, () -> DatabaseEditorHelper.configureEditorHeader(this.myProject, this.myFileSupplier.get(), header));
        ui.addContent(content, -1, this.getPlaceInGrid(), false);
        return content;
    }

    private static void setMinimumSizeForParent(Content content) {
        for (Container parent = content.getComponent().getParent(); parent != null && parent.getParent() != null; parent = parent.getParent()) {
            if (!(parent instanceof EditorEmbeddedComponentManager.FullEditorWidthRenderer)) continue;
            parent.setMinimumSize((Dimension)new JBDimension(200, 15));
            return;
        }
    }

    @NotNull
    private static DataGrid getNotNullDataGrid(@NotNull Content content) {
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(60);
        }
        DataGrid dataGrid = ScriptingClientDataConsumer.getDataGrid(content);
        if (dataGrid == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(61);
        }
        return dataGrid;
    }

    @Nullable
    public static DataGrid getDataGrid(@NotNull Content content) {
        GridInfo info2;
        if (content == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(62);
        }
        return (info2 = (GridInfo)GRID_INFO_KEY.get((UserDataHolder)content)) != null ? info2.grid : null;
    }

    @NotNull
    private static DataConsumer consumerFor(@NotNull DataGrid dataGrid) {
        if (dataGrid == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(63);
        }
        DataBusGridDataHookUp.DataBusLoader dataBusLoader = Objects.requireNonNull(DataGridUtil.getDataBusHookUp(dataGrid)).getLoader();
        if (dataBusLoader == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(64);
        }
        return dataBusLoader;
    }

    @Nullable
    private static ConsoleDataRequest.ResultSetSubQuery getConsoleResultSetSubQuery(@NotNull DataRequest.Context context, int subQueryIndex) {
        ConsoleDataRequest request;
        if (context == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(65);
        }
        return (request = (ConsoleDataRequest)ObjectUtils.tryCast((Object)context.request, ConsoleDataRequest.class)) == null ? null : request.getResultSetSubquery(subQueryIndex);
    }

    @NotNull
    private ResultsPlace getResultsPlace(@Nullable ConsoleDataRequest.ResultSetSubQuery subQuery) {
        ResultsPlace resultsPlace = this.myChooser.getResultsPlace(subQuery);
        if (resultsPlace == null) {
            ScriptingClientDataConsumer.$$$reportNull$$$0(66);
        }
        return resultsPlace;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 12, 16, 19, 31, 37, 38, 39, 51, 61, 64, 66 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 2: 
            case 41: 
            case 42: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSupplier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUpFactory";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chooser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 51: 
            case 61: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ScriptingClientDataConsumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 45: 
            case 47: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 32: 
            case 44: 
            case 46: 
            case 48: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 43: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 49: 
            case 52: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configure";
                break;
            }
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 57: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmbeddedResults";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUis";
                break;
            }
            case 12: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "install";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceInGrid";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreparedContentInfoFor";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableResultPanel";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullDataGrid";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "consumerFor";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEmbeddedResults";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 31: 
            case 37: 
            case 38: 
            case 39: 
            case 51: 
            case 61: 
            case 64: 
            case 66: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "afterLastRowAdded";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setColumns";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setInReference";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updateColumns";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setOutReferences";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addRows";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "onRequestTakesTimeEDT";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "onRequestStartedEDT";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "onRequestFinishedEDT";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPreparedContentInfoFor";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "reuseOrCreateContent";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findContentToReuse";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createNewContent";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "updateContent";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "updateContentTitle";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "setContentTitle";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createTableResultPanel";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateEditorWrapper";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findContent";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addContent";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullDataGrid";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getDataGrid";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "consumerFor";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleResultSetSubQuery";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 12, 16, 19, 31, 37, 38, 39, 51, 61, 64, 66 -> new IllegalStateException(string);
        };
    }

    public static interface ResultsPlaceChooser {
        public void requestStarted(@NotNull GridDataRequest.Context var1);

        public void requestFinished(@NotNull GridDataRequest.Context var1);

        @NotNull
        public ResultsPlace getResultsPlace(@Nullable ConsoleDataRequest.ResultSetSubQuery var1);

        @NotNull
        public Collection<RunnerLayoutUi> getAllUis();

        @NotNull
        public Collection<? extends DatabaseInEditorResults.Result> getEmbeddedResults(@NotNull Editor var1);
    }

    private class MyAuditor
    implements DataAuditor {
        private final Set<GridDataRequest> myPendingRequests = ConcurrentCollectionFactory.createConcurrentSet();

        private MyAuditor() {
        }

        public void requestStarted(@NotNull DataRequest.Context context) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(0);
            }
            ScriptingClientDataConsumer.this.myChooser.requestStarted((GridDataRequest.Context)context);
            if (ScriptingClientDataConsumer.this.myAlarm.isDisposed()) {
                return;
            }
            this.myPendingRequests.add((GridDataRequest)context.request);
            DbImplUtilCore.invokeLaterIfNeeded(() -> {
                if (ScriptingClientDataConsumer.this.myAlarm.isDisposed()) {
                    return;
                }
                ScriptingClientDataConsumer.this.onRequestStartedEDT(context);
                ScriptingClientDataConsumer.this.myAlarm.addRequest(() -> {
                    if (ScriptingClientDataConsumer.this.myAlarm.isDisposed() || !this.myPendingRequests.contains(context.request)) {
                        return;
                    }
                    ScriptingClientDataConsumer.this.onRequestTakesTimeEDT(context);
                }, 1000L, ModalityState.any());
            });
        }

        public void fetchStarted(@NotNull DataRequest.Context context, int index) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(1);
            }
            this.myPendingRequests.remove(context.request);
            ScriptingClientDataConsumer.this.myAlarm.cancelAllRequests();
        }

        public void error(@NotNull DataRequest.Context context, @NotNull ErrorInfo errorInfo) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(2);
            }
            if (errorInfo == null) {
                MyAuditor.$$$reportNull$$$0(3);
            }
            this.myPendingRequests.remove(context.request);
        }

        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                MyAuditor.$$$reportNull$$$0(4);
            }
            this.myPendingRequests.remove(context.request);
            ScriptingClientDataConsumer.this.myAlarm.cancelAllRequests();
            DbImplUtilCore.invokeLaterIfNeeded(() -> {
                ScriptingClientDataConsumer.this.myChooser.requestFinished((GridDataRequest.Context)context);
                if (!((VisibleSession)ScriptingClientDataConsumer.this.myClient.getSession()).isValid()) {
                    return;
                }
                ScriptingClientDataConsumer.this.onRequestFinishedEDT(context);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$MyAuditor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fetchStarted";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requestFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ToolWindowAlways
    implements ResultsPlaceChooser {
        private final ResultsPlace myPlace;
        private final LogView<?> myView;

        ToolWindowAlways(@NotNull LogView<?> view) {
            if (view == null) {
                ToolWindowAlways.$$$reportNull$$$0(0);
            }
            this.myPlace = new LogViewResultsPlace(view);
            this.myView = view;
        }

        @Override
        public void requestStarted(// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull GridDataRequest.Context context) {
            if (context == null) {
                ToolWindowAlways.$$$reportNull$$$0(1);
            }
        }

        @Override
        public void requestFinished(// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull GridDataRequest.Context context) {
            if (context == null) {
                ToolWindowAlways.$$$reportNull$$$0(2);
            }
            this.myPlace.requestFinished();
        }

        @Override
        @NotNull
        public ResultsPlace getResultsPlace(@Nullable ConsoleDataRequest.ResultSetSubQuery resultSetSubQuery) {
            ResultsPlace resultsPlace = this.myPlace;
            if (resultsPlace == null) {
                ToolWindowAlways.$$$reportNull$$$0(3);
            }
            return resultsPlace;
        }

        @Override
        @NotNull
        public Collection<RunnerLayoutUi> getAllUis() {
            List<RunnerLayoutUi> list = Collections.singletonList(this.myView.getUi());
            if (list == null) {
                ToolWindowAlways.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        public Collection<DatabaseInEditorResults.Result> getEmbeddedResults(@NotNull Editor editor2) {
            if (editor2 == null) {
                ToolWindowAlways.$$$reportNull$$$0(5);
            }
            List<DatabaseInEditorResults.Result> list = Collections.emptyList();
            if (list == null) {
                ToolWindowAlways.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ScriptingClientDataConsumer$ToolWindowAlways";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$ToolWindowAlways";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultsPlace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllUis";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmbeddedResults";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "requestStarted";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "requestFinished";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getEmbeddedResults";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class PreventingExtraResultsConsumer
    extends DelegatingDataConsumer {
        PreventingExtraResultsConsumer(@NotNull DataConsumer dataConsumer) {
            if (dataConsumer == null) {
                PreventingExtraResultsConsumer.$$$reportNull$$$0(0);
            }
            super(dataConsumer);
        }

        public boolean accepts(DataRequest.Owner owner) {
            return !(owner instanceof ConsoleGridDataHookUp);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataConsumer", "com/intellij/database/run/ScriptingClientDataConsumer$PreventingExtraResultsConsumer", "<init>"));
        }
    }

    private static final class UiContent {
        final RunnerLayoutUi ui;
        final Content content;

        private UiContent(@NotNull RunnerLayoutUi ui, @NotNull Content content) {
            if (ui == null) {
                UiContent.$$$reportNull$$$0(0);
            }
            if (content == null) {
                UiContent.$$$reportNull$$$0(1);
            }
            this.ui = ui;
            this.content = content;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ui";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ScriptingClientDataConsumer$UiContent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ContentInfo {
        final UiContent content;
        final boolean isNew;

        ContentInfo(@NotNull UiContent content, boolean aNew) {
            if (content == null) {
                ContentInfo.$$$reportNull$$$0(0);
            }
            this.content = content;
            this.isNew = aNew;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/database/run/ScriptingClientDataConsumer$ContentInfo", "<init>"));
        }
    }

    private static class GridInfo {
        final DataGrid grid;
        String originalTitle;
        int major;
        int minor;

        GridInfo(@NotNull DataGrid grid) {
            if (grid == null) {
                GridInfo.$$$reportNull$$$0(0);
            }
            this.grid = grid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ScriptingClientDataConsumer$GridInfo", "<init>"));
        }
    }

    public static interface ResultsPlace {
        @NotNull
        public RunnerLayoutUi getOrCreateUi();

        @NotNull
        public Promise<Void> showIfNeeded(@NotNull DataRequest.Owner var1);

        public void readyToShow(@NotNull Content var1);

        public boolean showImmediate();

        public void requestFinished();

        public void moveFocusToEditor(AnActionEvent var1);

        public void configure(@NotNull DataGrid var1, @NotNull DataGridAppearance var2);

        public boolean isUseConsoleFonts();

        public JComponent addHeader(@NotNull DataGrid var1);
    }

    public static class LogViewResultsPlace
    implements ResultsPlace {
        private final LogView<?> myView;

        public LogViewResultsPlace(@NotNull LogView<?> view) {
            if (view == null) {
                LogViewResultsPlace.$$$reportNull$$$0(0);
            }
            this.myView = view;
        }

        @Override
        @NotNull
        public RunnerLayoutUi getOrCreateUi() {
            RunnerLayoutUi runnerLayoutUi = this.myView.getUi();
            if (runnerLayoutUi == null) {
                LogViewResultsPlace.$$$reportNull$$$0(1);
            }
            return runnerLayoutUi;
        }

        @Override
        @NotNull
        public Promise<Void> showIfNeeded(@NotNull DataRequest.Owner owner) {
            if (owner == null) {
                LogViewResultsPlace.$$$reportNull$$$0(2);
            }
            if (!(this.myView instanceof DatabaseLogView) || ((DatabaseLogView)this.myView).shouldActivateForResult(owner)) {
                Promise promise = this.myView.show(true, false, LogView.OutputType.RESULT_SET);
                if (promise == null) {
                    LogViewResultsPlace.$$$reportNull$$$0(3);
                }
                return promise;
            }
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                LogViewResultsPlace.$$$reportNull$$$0(4);
            }
            return promise;
        }

        @Override
        public void readyToShow(@NotNull Content content) {
            if (content == null) {
                LogViewResultsPlace.$$$reportNull$$$0(5);
            }
        }

        @Override
        public boolean showImmediate() {
            return true;
        }

        @Override
        public void requestFinished() {
        }

        @Override
        public void moveFocusToEditor(AnActionEvent e) {
            Project project = e.getProject();
            if (project != null) {
                ToolWindowManager.getInstance((Project)project).activateEditorComponent();
            }
        }

        @Override
        public void configure(@NotNull DataGrid grid, @NotNull DataGridAppearance appearance) {
            if (grid == null) {
                LogViewResultsPlace.$$$reportNull$$$0(6);
            }
            if (appearance == null) {
                LogViewResultsPlace.$$$reportNull$$$0(7);
            }
            GridUtil.configureFullSizeTable((DataGrid)grid, (DataGridAppearance)appearance);
            grid.putUserData(FloatingPagingManager.AVAILABLE_FOR_GRID_TYPE, (Object)true);
        }

        @Override
        public boolean isUseConsoleFonts() {
            return true;
        }

        @Override
        public JComponent addHeader(@NotNull DataGrid grid) {
            if (grid == null) {
                LogViewResultsPlace.$$$reportNull$$$0(8);
            }
            return GridUtil.addGridHeaderComponent((DataGrid)grid, (boolean)false, (String)"Console.TableResult.Group", (String)"Console.TableResult.Group.Secondary");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ScriptingClientDataConsumer$LogViewResultsPlace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "appearance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ScriptingClientDataConsumer$LogViewResultsPlace";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateUi";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showIfNeeded";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "showIfNeeded";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "readyToShow";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "configure";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addHeader";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

